'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: scriptorganizer_tools.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:08:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test scripting-organizers / document-attached scripts
'*
'*******************************************************************************
'**
' #1 hCreateScriptingObject ' creates a new library or script
' #1 hRenameScriptingObject ' renames a library or script
' #1 hDeleteScript   ' deletes a script or library
' #1 hOpenScriptOrganizer ' Open the scriptorganizers (Beanshell or Javascript)
' #1 hCloseScriptOrganizer ' close the scriptorganizer (Beanshell or JavaScript)
'**
'\******************************************************************************

function hCreateScriptingObject( cName as string ) as boolean

    const CFN = "hNewScriptingObject::"
    dim brc as boolean

    if ( cName = "" ) then
        warnlog( CFN & "Empty Name for scripting object passed to function" )
        hCreateScriptingObject() = false
        exit function
    endif
    
    Kontext "ScriptOrganizer"
    if ( not PBCreate.exists() ) then
        warnlog( CFN & "Create-button does not exist" )
        hCreateScriptingObject() = false
        exit function        
    endif    
    
    if ( PBCreate.isEnabled() ) then
             
        PBCreate.click()
        
        Kontext "ScriptNameDlg"
        if ( ScriptNameDlg.exists() ) then        
            
            EFObjectName.setText( cName )
            ScriptNameDlg.OK()  
            brc = true
            
        endif

    else
        printlog( CFN & "Button is disabled" )
        brc = false
    endif
    
    kontext "ScriptOrganizer"
    if ( not ScriptOrganizer.exists() ) then
        warnlog( CFN & "Could not return to ScriptOrganizer" )
        brc = false
    endif    
    
   hCreateScriptingObject() = brc

end function

'*******************************************************************************

function hRenameScriptingObject( cName as string ) as boolean

    const CFN = "hRenameScriptingObject::"
    dim cMessage as string
    dim brc as boolean
    
    brc = true
    
    if ( cName = "" ) then
        warnlog( CFN & "Empty Name for scripting object passed to function" )
        hRenameScriptingObject() = false
        exit function
    endif    
    
    
    Kontext "ScriptOrganizer"
    if ( not PBRename.exists() ) then
        warnlog( CFN & "Rename button does not exist, aborting" )
        hRenameScriptingObject() = false
        exit function
    endif
    
    if ( PBRename.isEnabled ) then
    
        PBRename.click()
        
        Kontext "ScriptNameDlg"
        if ( ScriptNameDlg.exists() ) then
        
            EFObjectName.setText( cName )
            ScriptNameDlg.OK()
            
            kontext "active"
            if ( active.exists() ) then
                cMessage = hRemoveLineBreaks( active.getText )
                printlog( CFN & cMessage )
                brc = false
                active.OK()
            endif
            
        endif
        
    endif
    
    kontext "ScriptOrganizer"
    if ( not ScriptOrganizer.exists() ) then
        warnlog( CFN & "Could not return to ScriptOrganizer" )
        brc = false
    endif
    
    hRenameScriptingObject() = brc
    
end function

'*******************************************************************************

function hDeleteScript( cName as string , bSuccess as boolean ) as boolean

    const CFN = "hDeleteScript::"
    dim iPos as integer
    dim cMessage as string
    
    kontext "ScriptOrganizer"
      
    if ( PBDelete.isEnabled() and bSuccess ) then
    
        PBDelete.click()
        kontext "active"
        cMessage = active.getText()
        cMessage = hRemoveLineBreaks( cMessage )
        printlog( CFN & cMessage ) 
        active.yes()

        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            qaerrorlog( CFN & "Message: Failed to delete object: " & cName )
            printlog( CFN & cMessage )
            active.ok()
        endif
        hDeleteScript() = true
        
    elseif ( ( not PBDelete.isEnabled() ) and ( not bSuccess ) ) then
    
        printlog( CFN & "Delete-Button disabled for non-deletable object: " & cName )
        hDeleteScript() = true
        
    elseif ( PBDelete.isEnabled() and ( not bSuccess ) ) then
    
        PBDelete.click()
        sleep( 1 )
        
        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            printlog( CFN & "Delete-Button enabled for non deletable object" )
            printlog( CFN & cMessage )
            active.yes()
            sleep( 2 )
        endif
        
        kontext "active"
        if ( active.exists() ) then
            cMessage = active.getText()
            cMessage = hRemoveLineBreaks( cMessage )
            printlog( CFN & "Message: Failed to delete object" )
            printlog( CFN & cMessage )
            active.ok()
        endif
        hDeleteScript() = false
        
    elseif ( ( not PBDelete.isEnabled() ) and bSuccess ) then
    
        printlog( CFN & "Delete-Button disabled for deletable object" )
        hDeleteScript() = false
        
    else
    
        warnlog( CFN & "Unknown condition in if-statement" )
        hDeleteScript() = false
        
    endif
   
end function                
            
'*******************************************************************************

function hOpenScriptOrganizer( iDialog as integer ) as boolean

    const CFN = "hOpenScriptOrganizer::"

    '///<h3>Open the ScriptOrganizers and verify that they are open</h3>
    '///<ul>

    '///<li>Verif function parameter (must be 1 or 2) </li>
    if ( ( iDialog < 1 ) or ( iDialog > 2 ) ) then
        warnlog( CFN & "Invalid parameter passed to function:" & iDialog )
        hOpenScriptOrganizer() = false
        exit function
    endif

    '///<li>Call the associated slot</li>
    select case iDialog
    case 1 : ToolsMacrosOrganizeMacrosBeanShell
    case 2 : ToolsMacrosOrganizeMacrosJavaScript
    end select

    '///<li>Verify that the dialog is open, return TRUE if yes</li>
    kontext "ScriptOrganizer"
    if ( ScriptOrganizer.exists() ) then
        hOpenScriptOrganizer() = true
        printlog( CFN & "Dialog is open" )
    else
        hopenScriptOrganizer() = false
        warnlog( CFN & "Slot failed, dialog not open" )
    endif

    '///</ul>

end function
    
'*******************************************************************************

function hCloseScriptOrganizer() as boolean

    const CFN = "hCloseScriptOrganizer::" 
    dim iTry as integer
    
    hCloseScriptOrganizer() = false
    
    kontext "ScriptOrganizer"
    for iTry = 1 to 10 
    
        if ( ScriptOrganizer.exists() ) then
        
            ScriptOrganizer.cancel()
            wait( 100 )
            
        else
        
            exit for
            hCloseScriptOrganizer() = true
            
        endif
        
    next iTry
    
end function

'*******************************************************************************

function hOpenRunMacroDialog() as boolean

    ToolsMacrosRunMacro

    kontext "ScriptSelector"
    if ( ScriptSelector.exists() ) then
        hOpenRunMacroDialog() = true
    else
        hOpenRunMacroDialog() = false
    endif

end function
