'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: global_2.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: jsk $ $Date: 2005/12/20 14:25:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : global update test (Standardbar)
'*
'***************************************************************************
'**
' #1 tStandardBar_5             ' Check 'configure ...' and 'customize ...' out of the contextmenu on the Standardbar
' #1 tStandardBar_6             ' Check the 'new'-button in all appls ( without menu-Standardality )
' #1 tStandardBar_7             ' Open all documents with new-button in all applications
' #1 DoesTheStandardBarExists   ' Checking if the Toolbar exists in the module
' #1 StandardbarResetNow        ' Resetting the Standardbar
'**
'\***************************************************************************


testcase tStandardBar_5
    '///configure, customize and reset the Standardbar
    '///open a new document

    hCreateDocument()
    '///+open context menu on Standardbar and select the 2'th item (Customize)
    printlog "Customize ..."

    kontext "standardbar"
    Standardbar.OpenContextmenu()
    sleep( 1 )
    hMenuselectNr( 2 )
    sleep( 1 )
    '///+select all tabpages ( Menu, Keyboard, Toolbars, Events )

    kontext
    Active.SetPage
    
    kontext 
    Active.SetPage( TabCustomizeMenu )

    kontext "tabcustomizemenu"
    printlog( " * Menu" )
    Call Dialogtest(TabCustomizeMenu)

    kontext
    Active.SetPage TabTastatur

    kontext "tabtastatur"
    printlog( " * Keyboard" )
    Call Dialogtest(TabTastatur)

    kontext
    Active.SetPage TabCustomizeToolbars

    kontext "tabcustomizetoolbars"
    printlog( " * Toolbars" )
    Call Dialogtest(TabCustomizeToolbars)

    kontext
    Active.SetPage TabCustomizeEvents

    kontext "tabcustomizeevents"
    printlog( " * Events" )
    Call Dialogtest(TabCustomizeEvents)
    '///+click on 'OK' at Event-Tabpage

    kontext "tabcustomizeevents"
    TabCustomizeEvents.OK()
    '///+click on 'OK' at Event-Tabpage
    '///+open context menu on Standardbar and select the 2nd item (Customize Toolbar)

    kontext "standardbar"
    Standardbar.OpenContextmenu()
    sleep (1)
    hMenuselectNr (2)
    sleep (2)
    '///+close the Customize-Toolbars-Dialog with OK

    kontext "tabcustomizetoolbars"
    TabCustomizeToolbars.OK
    printlog "Reset"
    Call StandardbarResetNow
    '///+close the document
    hDestroyDocument()
endcase

'*******************************************************************************

testcase tStandardBar_6

    hUseImpressAutopilot( false )
    
    gApplication = "WRITER"
    
    '///Check the 'New'-menu-button in Standardbar in each application
    printlog "Check the 'New'-menu-button in Standardbar in each application"
    printlog "- click on menu-button -> open a new document as same document-type"
    
    '///open a new writer doc
    printlog "   - Writer"
    gApplication = "Writer"
    hCreateDocument()
    '///+click on 'new'

    kontext "standardbar"
    Neu.Click()
    '///+check if the new document is a writer-doc

    kontext "documentwriter"
    DocumentWriter.TypeKeys( "Hallo" )
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
    '///open a new calc doc
    printlog "   - Calc"
    gApplication = "Calc"
    hCreateDocument()
    '///+click on 'new'

    kontext "standardbar"
    Neu.Click()
    '///+check if the new document is a calc-doc

    kontext "documentcalc"
    DocumentCalc.TypeKeys( "Hallo" )
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
    '///open a new draw doc
    printlog "   - Draw"
    gApplication = "Draw"
    hCreateDocument()

    kontext "standardbar"
    '///+click on 'new'
    Neu.Click()
    '///+check if the new document is a draw-doc
    gMouseClick ( 50, 50 )
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
    '///open a new impress doc
    printlog "   - Impress"
    gApplication = "Impress"
    hCreateDocument()

    kontext "standardbar"
    '///+click on 'new'
    Neu.Click()
    '///+check if the new document is a impress-doc
    gMouseClick ( 50, 50 )
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
    '///open a new HTML doc
    printlog "   - HTML-document"
    gApplication = "HTML"
    hCreateDocument()
    '///+click on 'new'

    kontext "standardbar"
    Neu.Click()
    '///+check if the new document is a HTML-doc

    kontext "documentwriter"
    DocumentWriter.TypeKeys( "Hallo" )
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
    '///open a new master doc
    printlog "   - Master-document"
    gApplication = "MASTERDOC"
    hCreateDocument()
    '///+click on 'new'

    kontext "standardbar"
    Neu.Click()
    '///+check if the new document is a master doc

    kontext "documentwriter"
    DocumentWriter.TypeKeys( "Hallo" )
    '///+close the navigator and both new docs
    '///+...first doc

    kontext "navigator"
    sleep (1)
    if Navigator.Exists(5) then
        Navigator.Close()
    endif
    hDestroyDocument()
    '///+...second doc

    kontext "navigator"
    sleep (1)
    if Navigator.Exists(5) then
        Navigator.Close()
    endif
    
    hDestroyDocument()
    
    '///open a new math doc
    printlog "   - Math"
    gApplication = "Math"
    hCreateDocument()
    '///+click on 'new'

    kontext "standardbar"
    Neu.Click()
    
    '///+check if the new document is a math doc
    SchreibenInMathdok "a over b"
    
    '///+close both new docs
    hDestroyDocument()
    hDestroyDocument()
    
endcase

'*******************************************************************************

testcase tStandardBar_7

    '///open all applications with the 'New'-menu-button in Standardbar ( in all application )
    dim iCurrentApplication as Integer
    dim iNewButtonItem as Integer
    
    for iCurrentApplication = 1 to 7
    
        printlog "- tested application is : " &  hNumericDoctype( iCurrentApplication )
        hCreateDocument()

        for iNewButtonItem = 1 to 7
            '///+<i>(If Unix platform and application is Impress, get the focus of the document in each loop.)</i>

            if ( iCurrentApplication = 3 AND gPlatgroup = "unx" ) then

                kontext "documentimpress"
                DocumentImpress.MouseDoubleClick ( 50, 50 )
            endif

            '///+press the new-button in the Standardbar and select all items in the menu
            printlog "   click on the " + iNewButtonItem + ". item on the new-button"

            kontext "standardbar"
            Standardbar.OpenMenu Neu
            sleep (1)
            hMenuselectNr ( iNewButtonItem )
            sleep (3)
            '///+check if all applications or dialogs are opened correctly

            select case iNewButtonItem
            case 1  :   Kontext "DocumentWriter"
                        DocumentWriter.TypeKeys( "Hallo" )
                        hDestroyDocument()
            case 2  :   Kontext "DocumentCalc"
                        DocumentCalc.TypeKeys( "Hallo" )
                        hDestroyDocument()
            case 3  :   Kontext "DocumentImpress"
                        DocumentImpress.MouseDoubleClick ( 50, 50 )
                        hDestroyDocument()
            case 4  :   Kontext "DocumentDraw"
                        DocumentDraw.MouseDoubleClick ( 50, 50 )
                        hDestroyDocument()
            case 5  :   Kontext "DatabaseWizard"
                        CancelBtn.click()
            case 6  :   Kontext "DocumentWriter"     ' HTML Document
                        DocumentWriter.TypeKeys( "Hallo" )
                        hDestroyDocument()
            case 7  :   Kontext "DocumentWriter"     ' Master Document
                        DocumentWriter.TypeKeys( "Hallo" )

                        kontext "navigator"
                        if Navigator.Exists( 5 ) then
                            Navigator.Close()
                        endif
                        hDestroyDocument()
            case 8  :   SchreibenInMathdok "a over b"
                        hDestroyDocument()
            case 9  :   Kontext
                        Active.SetPage( TabEtiketten )

                        kontext "tabetiketten"
                        TabEtiketten.Cancel()
            case 10  :  Kontext
                        Active.SetPage()

                        kontext "tabetikettenmedium"
                        TabEtikettenMedium.Cancel()
            case 11 :   Kontext "TemplateAndDocuments"
                        TemplateAndDocuments.cancel()
            end select

            sleep(2)
            
        next iNewButtonItem

        hDestroyDocument()
        '///+close the document
        '///now do it again in each other application
    next iCurrentApplication

endcase

'*******************************************************************************

sub DoesTheStandardBarExists

    hCreateDocument()

    kontext "standardbar"
    if ( Standardbar.Exists() ) then

        if ( not Standardbar.IsVisible ) then
            warnlog( "The 'Standardbar' is not visible in " + gApplication )
        endif

    else
        warnlog( "The 'Standardbar' does not exist in " + gApplication )
    endif


    kontext "navigator"
    if ( Navigator.Exists(5) ) then
        Navigator.Close()
    endif
    
    hDestroyDocument()
    
end sub

'*******************************************************************************

sub StandardbarResetNow

    '/// Create a new document
    hCreateDocument()
    printlog " - Standardbar"

    kontext "standardbar"
    '/// Move the mouse on the Standardbar
    Standardbar.MouseMove ( 70, 50 )
    sleep (1)
    '/// Open the context menu on Standardbar
    Standardbar.OpenContextmenu
    '/// Click on 2. entry (Cutomize Toolbar)
    hMenuselectNr (2)
    sleep (1)

    kontext
    Active.SetPage TabCustomizeToolbars

    kontext "tabcustomizetoolbars"
    '/// Toggle to 'Toolbars' tab page.

    if TabCustomizeToolbars.Exists(2) then
        '/// Press in first section '... Toolbars' the 'toolbar'-button
        MenuBtn.Click
        sleep(1)
        '/// A drop down menu will be opened.
        '/// Select the first enabled menu entzry which should be 'Restore...'
        hMenuSelectNr(1)

        kontext

        if Active.Exists(2) then

            if Active.GetRT = 304 then
                '/// Press Yes button on verification dialog.
                Active.Yes
            end if

        else
            warnlog "No verification comes up if the RESET button has been pressed!"
        end if


        kontext "tabcustomizetoolbars"
        '/// Close 'Toolbars' tab page and the dialog with OK.
        TabCustomizeToolbars.OK
    else
        warnlog "The customze toolbar dialog does not come up after calling it from context menu!"
        'Closing the Context menu if the dialog does not come up.
        Menuselect(0)
    end if

    '/// Close document.
    hDestroyDocument()
    
end sub

