/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.chart.urls.XYURLGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private double gapThreshold = 1.0;
    private double defaultShapeScale;
    private boolean defaultShapeFilled;
    private Line2D line;

    public StandardXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n) {
        this(n, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
        if ((n & 1) != 0) {
            this.plotShapes = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.defaultShapeScale = 6.0;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotShapes != bl) {
            this.plotShapes = bl;
            this.firePropertyChanged("renderer.PlotShapes", bl2, new Boolean(bl));
        }
    }

    public double getDefaultShapeScale() {
        return this.defaultShapeScale;
    }

    public void setDefaultShapeScale(double d) {
        Double d2 = new Double(this.defaultShapeScale);
        this.defaultShapeScale = d;
        this.firePropertyChanged("renderer.DefaultShapeScale", d2, new Double(d));
    }

    public boolean getDefaultShapeFilled() {
        return this.defaultShapeFilled;
    }

    public void setDefaultShapeFilled(boolean bl) {
        Boolean bl2 = new Boolean(this.defaultShapeFilled);
        this.defaultShapeFilled = bl;
        this.firePropertyChanged("renderer.DefaultShapeFilled", bl2, new Boolean(bl));
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.firePropertyChanged("renderer.PlotLines", bl2, new Boolean(bl));
        }
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d) {
        Double d2 = new Double(this.gapThreshold);
        this.gapThreshold = d;
        this.firePropertyChanged("renderer.GapThreshold", d2, new Double(d));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotImages != bl) {
            this.plotImages = bl;
            this.firePropertyChanged("renderer.PlotImages", bl2, new Boolean(bl));
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 != null) {
            Object object;
            Object object2;
            double d;
            double d2 = number.doubleValue();
            double d3 = number2.doubleValue();
            double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            Paint paint2 = this.getPaint(xYPlot, n, n2, d4, d = valueAxis2.translateValueToJava2D(d3, rectangle2D));
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
            }
            if (this.plotLines && n2 > 0) {
                object2 = xYDataset.getXValue(n, n2 - 1);
                object = xYDataset.getYValue(n, n2 - 1);
                if (object != null) {
                    double d5 = ((Number)object2).doubleValue();
                    double d6 = ((Number)object).doubleValue();
                    boolean bl = true;
                    if (this.plotDiscontinuous) {
                        int n3 = xYDataset.getItemCount(n);
                        double d7 = xYDataset.getXValue(n, 0).doubleValue();
                        double d8 = xYDataset.getXValue(n, n3 - 1).doubleValue();
                        boolean bl2 = bl = d2 - d5 <= (d8 - d7) / (double)n3 * this.gapThreshold;
                    }
                    if (bl) {
                        double d9 = valueAxis.translateValueToJava2D(d5, rectangle2D);
                        double d10 = valueAxis2.translateValueToJava2D(d6, rectangle2D);
                        this.line.setLine(d9, d10, d4, d);
                        if (this.line.intersects(rectangle2D)) {
                            graphics2D.draw(this.line);
                        }
                    }
                }
            }
            if (this.plotShapes) {
                double d11 = this.getShapeScale(xYPlot, n, n2, d4, d);
                Shape shape2 = this.getShape(xYPlot, n, n2, d4, d, d11);
                if (shape2.intersects(rectangle2D)) {
                    if (this.isShapeFilled(xYPlot, n, n2, d4, d)) {
                        graphics2D.fill(shape2);
                    } else {
                        graphics2D.draw(shape2);
                    }
                }
                shape = shape2;
            }
            if (this.plotImages) {
                double d12 = this.getShapeScale(xYPlot, n, n2, d4, d);
                Image image = this.getImage(xYPlot, n, n2, d4, d);
                if (image != null) {
                    Point point = this.getImageHotspot(xYPlot, n, n2, d4, d, image);
                    graphics2D.drawImage(image, (int)(d4 - point.getX()), (int)(d - point.getY()), null);
                }
            }
            if (entityCollection != null) {
                if (shape == null) {
                    shape = new Rectangle2D.Double(d4 - 2.0, d - 2.0, 4.0, 4.0);
                }
                object2 = "";
                if (this.getToolTipGenerator() != null) {
                    object2 = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
                }
                object = null;
                if (this.getURLGenerator() != null) {
                    object = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(shape, (String)object2, (String)object, n, n2);
                entityCollection.addEntity(xYItemEntity);
            }
            if (valueAxis.isCrosshairLockedOnData()) {
                if (valueAxis2.isCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d2, d3);
                } else {
                    crosshairInfo.updateCrosshairX(d2);
                }
            } else if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d3);
            }
        }
    }

    protected Shape getShape(Plot plot, int n, int n2, double d, double d2, double d3) {
        return plot.getShape(n, n2, d, d2, d3);
    }

    protected double getShapeScale(Plot plot, int n, int n2, double d, double d2) {
        return this.defaultShapeScale;
    }

    protected boolean isShapeFilled(Plot plot, int n, int n2, double d, double d2) {
        return this.defaultShapeFilled;
    }

    protected Paint getPaint(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }
}

