/*************************************************************************
 *
 *  $RCSfile: BtreeDictCompactor.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.net.URL;

public final class BtreeDictCompactor extends FullBtreeDict {
  private CompactorDictBlock _currentLeaf;
  private byte[]          _lastKey = new byte[MaxKeyLength];
  private int             _lastKeyLength = 0;
  private int             _limit;
  private int             _nEntries = 0;
  private int             _entry = 0;
  
  private int             _counter = 0;
  private InternalBlockState _parent = null;
  
  private final class CompactorDictBlock extends FullDictBlock {
    private int restoreKey1(int entry, byte[] buffer) {
      int howMany = entryKeyLength(entry);
      int where = entryCompression(entry);
      int from = entryKey(entry);
      while (howMany-- > 0)
	buffer[where++] = _data[from++];
      return where;
    }
  
    protected void doMap1(BtreeDictCompactor owner, BtreeDictCompactor target)
      throws Exception {
	byte[] buffer = new byte[MaxKeyLength];
	final int freeSpace = free();
	int entry = firstEntry();
	if (_isLeaf)
	  while (entry < freeSpace) {
	    target.store(buffer, restoreKey1(entry, buffer), entryID(entry));
	    entry = nextEntry(entry);
	  }
	else {
	  owner.lock(this);
	  int entryIndex  = 0;
	  while (entry < freeSpace) {
	    owner.accessBlock1(getChildIdx(entryIndex)).doMap1(owner,target);
	    target.store(buffer, restoreKey1(entry, buffer), entryID(entry));
	    entry = nextEntry(entry);
	    ++entryIndex;
	  }
	  owner.accessBlock1(getChildIdx(entryIndex)).doMap1(owner, target);
	  owner.unlock(this);
	}
    }
  } // end of internal class

  private final class InternalBlockState {
    private CompactorDictBlock _block;
    private byte[]             _lastKey = new byte[MaxKeyLength];
    private int               _lastKeyLength;
    private int             _entry;
    private int             _nEntries;
    private int             _limit;
    private InternalBlockState _parent;
  
    public InternalBlockState(int leftChild) {
      System.out.println("NEW ROOT " + _counter);
      System.out.println(_params);
      _params.setRoot(_counter);
      _block = new CompactorDictBlock();
      _block._isLeaf = false;
      _block.setBlockNumber(_counter++);
      init(leftChild);
    }
    
    private void init(int leftChild) {
      _entry = _block.firstEntry();
      _nEntries = 0;
      _lastKeyLength = 0;
      _limit = 4*(lastPtrIndex - 1);
      _block.setChildIndex(0, leftChild);
    }
  
    public void store(byte[] buffer, int keyLen, int id, int newBlock) {
      //      System.out.println(new String(buffer, 0, keyLen) + " " + id);
      int cpr = 0;
      while (cpr < _lastKeyLength && _lastKey[cpr] == buffer[cpr])
	++cpr;
      int needed = ENTHEADERLEN + keyLen - cpr;
      if (_entry + needed <= _limit) {
	_block.makeEntry(_entry, buffer, id, keyLen - cpr, cpr);
	_entry += needed;
	_nEntries++;
	_block.setChildIndex(_nEntries, newBlock);
	_limit -= 4;
	_lastKeyLength = keyLen;
	System.arraycopy(buffer, cpr, _lastKey, cpr, keyLen - cpr);
      }
      else {
	System.out.println("NEW: SPLIT INTERNAL");
	_block.setFree(_entry);
	_block.setNumberOfEntries(_nEntries);
	if (_parent == null)
	  _parent = new InternalBlockState(_block._number);
	_parent.store(buffer, keyLen, id, newBlock(_block));
	init(newBlock);
      }
    }
    
    public void close() throws java.io.IOException {
      _block.setFree(_entry);
      _block.setNumberOfEntries(_nEntries);
      blockManager.writeBlock(_block);
      if (_parent == null)
	System.out.println("root: " + _block._number);
      else
	_parent.close();
    }
  } // end of internal class

  public BtreeDictCompactor(BtreeDictParameters params, boolean update)
    throws Exception {
      init(params, update, new BlockFactory() {
	public Block makeBlock() { return new CompactorDictBlock(); }
      });
      _currentLeaf = new CompactorDictBlock();
      _currentLeaf.setBlockNumber(_counter++);
      _limit = DATALEN - 2;
      _entry = _currentLeaf.firstEntry();
      _params = params;
  }

  protected CompactorDictBlock accessBlock1(int index) throws Exception {
    return (CompactorDictBlock)blockManager.accessBlock(index);
  }
  
  public void store(byte[] buffer, int keyLen, int id) {
    //    System.out.println(new String(buffer, 0, keyLen));
    if (id > 0)
      {
	int cpr = 0;
	while (cpr < _lastKeyLength && _lastKey[cpr] == buffer[cpr])
	  ++cpr;
	int needed = ENTHEADERLEN + keyLen - cpr;
	if (_entry + needed <= _limit) {
	  _currentLeaf.makeEntry(_entry, buffer, id, keyLen - cpr, cpr);
	  _entry += needed;
	  _nEntries++;
	  _lastKeyLength = keyLen;
	  System.arraycopy(buffer, cpr, _lastKey, cpr, keyLen - cpr);
	}
	else {
	  _currentLeaf.setFree(_entry);
	  _currentLeaf.setNumberOfEntries(_nEntries);
	  if (_parent == null)
	    _parent = new InternalBlockState(_currentLeaf._number);
	  _parent.store(buffer, keyLen, id, newBlock(_currentLeaf));
	  _entry = _currentLeaf.firstEntry();
	  _nEntries = 0;
	  _lastKeyLength = 0;
	}
      }
  }

  private int newBlock(DictBlock block) {
    int number = _counter++;
    try {
      blockManager.writeBlock(block); // write out full
      block.setBlockNumber(number); // recycle
      blockManager.writeBlock(block); // reserve space for new
    }
    catch (java.io.IOException e) {
      e.printStackTrace();
    }
    return number;
  }

  public void close() throws java.io.IOException {
    _currentLeaf.setFree(_entry);
    _currentLeaf.setNumberOfEntries(_nEntries);
    blockManager.writeBlock(_currentLeaf);
    if (_parent == null)
      System.out.println("root: " + _currentLeaf._number);
    else
      _parent.close();
    blockManager.close();
  }

  public void compact(BtreeDictParameters params) throws Exception {
    final BtreeDictCompactor target = new BtreeDictCompactor(params, true);
    ((CompactorDictBlock)blockManager.accessBlock(root)).doMap1(this, target);
    target.close();
  }
  
  /*
  public static void main(String[] args) {
    try {
      Schema schema = new Schema(args[0], false);
      BtreeDictParameters params = new BtreeDictParameters(schema, "DICTIONARY");
      BtreeDictCompactor source = new BtreeDictCompactor(params, false);
      URL url = new URL("file", "", args[1]);
      BtreeDictParameters params2 = new BtreeDictParameters(url, 2048, 0, 24);
      source.compact(params2);
    }
    catch (Exception e) {
      System.err.println(e);
      e.printStackTrace();
    }
  }
  */
}
