/*************************************************************************
 *
 *  $RCSfile: Configuration.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.util;

import java.io.File;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.net.URL;
import org.w3c.dom.*;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.parser.Resolver;
import org.xml.sax.InputSource;

public final class Configuration {
    public static Element configElementFromArgs(String[] args) throws Exception {
	URL configURL = null;
	for (int i = 0; i < args.length ; i++)
	    if (args[i].equals("-configFile") || args[i].equals("-cf")) {
		File config = new File(args[++i]);
		if (config.exists())
		    configURL = config.toURL();
		else
		    throw new Exception("config file doesn't exist");
	    }
	    else if (args[i].equals("-configURL") || args[i].equals("-cu"))
		configURL = new URL(args[++i]);
      
	if (configURL == null) {
	    System.err.println("No configuration specified!");
	    System.err.println("use: -configFile file | -configURL url");
	    return null;
	}
	else
	    return parse(configURL);
    }

    public static Element parse(URL location) throws Exception {
	InputSource input = Resolver.createInputSource(location, true);
	XmlDocument document = XmlDocument.createXmlDocument(input, false);
	return document.getDocumentElement();
    }

    public static Element parse(byte[] xmlBytes) throws Exception {
	ByteArrayInputStream input = new ByteArrayInputStream(xmlBytes);
	XmlDocument document = XmlDocument.createXmlDocument(input, false);
	return document.getDocumentElement();
    }

    /** arg: Element that can be direct parent of PrefixTranslation-s
	either in indexing or search engine configurations
    */
    public static String[] processPrefixTranslations(Element el) {
	NodeList list = el.getElementsByTagName("PrefixTranslation");
	if (list.getLength() > 0) {
	    Vector translations = new Vector();
	    for (int i = 0; i < list.getLength(); i++) {
		final Element ptEl = (Element)list.item(i);
		translations.addElement(ptEl.getAttribute("prefix"));
		translations.addElement(ptEl.getAttribute("replacement"));
	    }
	    String[] prefixTranslations = new String[translations.size()];
	    return (String[])translations.toArray(prefixTranslations);
	}
	else
	return null;
    }
}
