/*************************************************************************
 *
 *  $RCSfile: docfilter.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_DOCFILTER_HXX_
#include "docfilter.hxx"
#endif
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX 
#include <sfx2/docfilt.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_ 
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::io;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::document;
	using namespace ::com::sun::star::beans;

	//=====================================================================
	//= ODocumentFilterInfo
	//=====================================================================
	//---------------------------------------------------------------------
	ODocumentFilterInfo::ODocumentFilterInfo( const Reference< XMultiServiceFactory >& _rxORB, Window* _pErrorParent )
	{
		String sMissingServiceName;
		try
		{
			if (_rxORB.is())
			{
				// the type detection service
				const ::rtl::OUString sTypeDetectionService = ::rtl::OUString::createFromAscii("com.sun.star.document.TypeDetection");
				Reference< XInterface > xPure = _rxORB->createInstance(sTypeDetectionService);

				if (!xPure.is())
					sMissingServiceName = sTypeDetectionService;
				else
				{
					m_xTypeDetection = Reference< XTypeDetection >(xPure, UNO_QUERY);
					m_xAvailableTypes = Reference< XNameAccess >(m_xTypeDetection, UNO_QUERY);
					OSL_ENSURE(m_xTypeDetection.is(), "ODocumentFilterInfo::ODocumentFilterInfo: missing the XTypeDetection or XNameAccess interface!");
				}

				// the filter factory
				const ::rtl::OUString sFilterFactoryService = ::rtl::OUString::createFromAscii("com.sun.star.document.FilterFactory");
				xPure = _rxORB->createInstance(sFilterFactoryService);

				if (!xPure.is())
					sMissingServiceName = sFilterFactoryService;
				else
				{
					m_xFilterFactory = Reference< XNameAccess >(xPure, UNO_QUERY);
					OSL_ENSURE(m_xFilterFactory.is(), "ODocumentFilterInfo::ODocumentFilterInfo: missing the XNameAccess interface!");
				}
			}
		}
		catch(const Exception&)
		{
			OSL_ENSURE(sal_False, "ODocumentFilterInfo::ODocumentFilterInfo: caught a strange exception!");
		}

		if (sMissingServiceName.Len())
			ShowServiceNotAvailableError(_pErrorParent, sMissingServiceName, sal_False);
	}

	//---------------------------------------------------------------------
	sal_Bool ODocumentFilterInfo::implGetTypeDescription( const Reference< XInputStream >& _rxSource,
		::rtl::OUString& _rType, ::rtl::OUString& _rFilter )
	{
		OSL_ENSURE(m_xAvailableTypes.is(), "ODocumentFilterInfo::implGetTypeDescription: invalid call!");
		try
		{
			Sequence< PropertyValue > aDescriptor(1);
			aDescriptor[0].Name = ::rtl::OUString::createFromAscii("InputStream");
			aDescriptor[0].Value <<= _rxSource;
			_rType = m_xTypeDetection->queryTypeByDescriptor(aDescriptor, sal_True);

			implLookupPropertyValue( aDescriptor, "FilterName" ) >>= _rFilter;
			return sal_True;
		}
		catch(Exception&)
		{
			OSL_ENSURE(sal_False, "ODocumentFilterInfo::implGetTypeDescription: caught an exception!");
		}
		return sal_False;
	}

	//---------------------------------------------------------------------
	sal_Bool ODocumentFilterInfo::implGetTypeDescription( const ::rtl::OUString& _rFileName,
		::rtl::OUString& _rType, ::rtl::OUString& _rFilter )
	{
		OSL_ENSURE(m_xAvailableTypes.is(), "ODocumentFilterInfo::implGetTypeDescription: invalid call!");
		try
		{
			Sequence< PropertyValue > aDescriptor(1);
			aDescriptor[0].Name = ::rtl::OUString::createFromAscii("FileName");
			aDescriptor[0].Value <<= _rFileName;
			_rType = m_xTypeDetection->queryTypeByDescriptor(aDescriptor, sal_True);

			implLookupPropertyValue( aDescriptor, "FilterName" ) >>= _rFilter;
			return sal_True;
		}
		catch(Exception&)
		{
			OSL_ENSURE(sal_False, "ODocumentFilterInfo::implGetTypeDescription: caught an exception!");
		}
		return sal_False;
	}

	//---------------------------------------------------------------------
	const Any&	ODocumentFilterInfo::implLookupPropertyValue( const Sequence< PropertyValue >& _rProps, const sal_Char* _pProperty )
	{
		const PropertyValue* pProps = _rProps.getConstArray();
		const PropertyValue* pPropsEnd = pProps + _rProps.getLength();
		for (; pProps != pPropsEnd; ++pProps)
		{
#ifdef FS_PRIV_DEBUG
			::rtl::OUString sLetsHaveALook;
			pProps->Value >>= sLetsHaveALook;
#endif

			if (0 == pProps->Name.compareToAscii(_pProperty))
			{	// found it ...
				return pProps->Value;
			}
		}

		static Any aDefault;
		return aDefault;
	}

	//---------------------------------------------------------------------
	FilterDescriptor ODocumentFilterInfo::getFilter( const ::rtl::OUString& _rFileName )
	{
		FilterDescriptor aReturn;
		if ( implGetTypeDescription( _rFileName, aReturn.sTypeName, aReturn.sFilterName ) )
			aReturn.sExtension = implLookupExtension( aReturn.sTypeName );

		return aReturn;
	}

	//---------------------------------------------------------------------
	FilterDescriptor ODocumentFilterInfo::getFilter( const Reference< XInputStream >& _rxSource )
	{
		FilterDescriptor aReturn;
		if ( implGetTypeDescription( _rxSource, aReturn.sTypeName, aReturn.sFilterName ) )
			aReturn.sExtension = implLookupExtension( aReturn.sTypeName );

		return aReturn;
	}

	//---------------------------------------------------------------------
	::rtl::OUString ODocumentFilterInfo::implLookupExtension( const ::rtl::OUString& _rTypeName )
	{
		OSL_ENSURE(m_xAvailableTypes.is(), "ODocumentFilterInfo::implLookupExtension: invalid call!");
		::rtl::OUString sReturn;
		if (m_xAvailableTypes.is())
		{
			try
			{
				// get the filter (descriptor) which has been detected for the file
				Sequence< PropertyValue > aTypeDescriptor;
				Any aFilterDescriptorAny = m_xAvailableTypes->getByName(_rTypeName);
				aFilterDescriptorAny >>= aTypeDescriptor;

				Sequence< ::rtl::OUString > aExtensions;
				implLookupPropertyValue(aTypeDescriptor, "Extensions") >>= aExtensions;

				if (aExtensions.getLength())
					sReturn = aExtensions[0];
			}
			catch(const Exception&)
			{
				OSL_ENSURE(sal_False, "ODocumentFilterInfo::implLookupExtension: caught an exception!");
			}
		}
		return sReturn;
	}

	//---------------------------------------------------------------------
	FilterDescriptor ODocumentFilterInfo::getPreferedFilter( const Reference< XInputStream >& _rxSource )
	{
		FilterDescriptor aPreferredFilter = getFilter( _rxSource );
		implGetPreferedFilter( aPreferredFilter );
		return aPreferredFilter;
	}

	//---------------------------------------------------------------------
	FilterDescriptor ODocumentFilterInfo::getPreferedFilter( const ::rtl::OUString& _rFileName )
	{
		FilterDescriptor aPreferredFilter = getFilter( _rFileName );
		implGetPreferedFilter( aPreferredFilter );
		return aPreferredFilter;
	}

	//---------------------------------------------------------------------
	FilterDescriptor ODocumentFilterInfo::getPreferedFilter( const FilterDescriptor& _rFilter )
	{
		FilterDescriptor aReturn(_rFilter);
		implGetPreferedFilter(aReturn);
		return aReturn;
	}

	//---------------------------------------------------------------------
	void ODocumentFilterInfo::implGetPreferedFilter( FilterDescriptor& _rDesc )
	{
		if (m_xFilterFactory.is() && m_xAvailableTypes.is())
		{
			try
			{
				const sal_Char* pDocService = "DocumentService";
				::rtl::OUString sDocumentService;
				if (_rDesc.sFilterName.getLength())
				{
					// get the filter (descriptor) which has been detected for the file
					Sequence< PropertyValue > aFilterDescriptor;
					Any aFilterDescriptorAny = m_xFilterFactory->getByName( _rDesc.sFilterName );
					aFilterDescriptorAny >>= aFilterDescriptor;

					// get the document service for that filter
					implLookupPropertyValue(aFilterDescriptor, pDocService ) >>= sDocumentService;
				}
				else if ( _rDesc.sTypeName.getLength() )
				{
					// do it the expensive way: create the (default) filter for the type
					Reference< XMultiServiceFactory > xFilterFac( m_xFilterFactory, UNO_QUERY );
					Reference< XPropertySet > xFilter;
					if ( xFilterFac.is() )
						xFilter = Reference< XPropertySet >( xFilterFac->createInstance( _rDesc.sTypeName ), UNO_QUERY );
					OSL_ENSURE( xFilter.is(), "ODocumentFilterInfo::implGetPreferedFilter: no filter instance for this type1" );
					if ( xFilter.is() )
					{
						Reference< XPropertySetInfo > xPSI = xFilter->getPropertySetInfo( );
						const ::rtl::OUString sDocumentServiceProperty = ::rtl::OUString::createFromAscii( pDocService );
						if ( xPSI.is() && xPSI->hasPropertyByName( sDocumentServiceProperty ) )
							xFilter->getPropertyValue( sDocumentServiceProperty ) >>= sDocumentService;
					}
				}

				if (sDocumentService.getLength())
				{
					Sequence< PropertyValue > aFilterDescriptor;

					// loop through all filters, check which of them can handle this document service, too
					Sequence< ::rtl::OUString > aAvailableFilters = m_xFilterFactory->getElementNames();
					const ::rtl::OUString* pFilterLoop = aAvailableFilters.getConstArray();
					const ::rtl::OUString* pFilterLoopEnd = pFilterLoop + aAvailableFilters.getLength();
					for (;pFilterLoop != pFilterLoopEnd; ++pFilterLoop)
					{
						// get the current filter (descriptor)
						m_xFilterFactory->getByName(*pFilterLoop) >>= aFilterDescriptor;
						// and its document service
						Any aCurrentDocService = implLookupPropertyValue( aFilterDescriptor, pDocService );
						::rtl::OUString sCurrentDocService;
						aCurrentDocService >>= sCurrentDocService;
						if (sCurrentDocService == sDocumentService)
						{	// we have another filter which can handle the same document service
							sal_Int32 nFlags = 0;
							implLookupPropertyValue( aFilterDescriptor, "Flags" ) >>= nFlags;
							if (nFlags & SFX_FILTER_DEFAULT)
							{	// have it!!
								_rDesc.sFilterName	= *pFilterLoop;

								implLookupPropertyValue( aFilterDescriptor, "Type" ) >>= _rDesc.sTypeName;
								_rDesc.sExtension	= implLookupExtension( _rDesc.sTypeName );

								break;
							}
						}
					}
				}
			}
			catch(const Exception&)
			{
				OSL_ENSURE(sal_False, "ODocumentFilterInfo::getPreferedFilter: caught an exception!");
			}
		}
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

