/*************************************************************************
 *
 *  $RCSfile: svch.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sv.hxx>

#include <inet.hxx>
#include <inetsess.hxx>
#include <inetmain.hxx>

#include "chlist.hxx"


#define BUTTON_NOTIFYPERMISSION		1

// ========================================================================

class MyApp : public Application
{
public:
	void Main( int, char* [] );
};

class MyWin : public WorkWindow
{
	ToolBox*		pBox;
	BOOL			bNotifyPermission;

	INetWrapper*	pWrapper;
	ChannelList*	pChLst;

	DECL_LINK(SelectHdl, ToolBox*);
	DECL_LINK(UpdateAgentHdl, String*);
	DECL_LINK(NotifyPermissionHdl, void*);
public:
	MyWin( Window* pParent, WinBits aWinStyle );
	~MyWin();

	void    Resize();
};

void MyApp::Main( int, char* [] )
{
	EnableSVLook();
	SetAppFont( System::GetStandardFont( STDFONT_APP ) );

	MyWin aMainWin( NULL, WinBits( WB_APP | WB_STDWORK | WB_CLIPCHILDREN ) );
	aMainWin.SetText( String( "StarChannel Test" ) );
	aMainWin.Show();
	Execute();
}

MyApp aMyApp;

// ========================================================================

MyWin::MyWin( Window* pParent, WinBits aWinStyle ) :
	WorkWindow(pParent, aWinStyle | WB_SVLOOK )
{
	String aAppPath = aMyApp.GetAppFileName();
	int nPos = aAppPath.Len() - 1;
	while( nPos > 0 && aAppPath[(USHORT)nPos] != '\\' )
		--nPos;
	aAppPath.Cut( nPos );
	aAppPath += "\\";

	pWrapper = new INetWrapper();
	pChLst = new ChannelList( aAppPath );

	INetSession* pISess = pWrapper->NewINetSession();
	pISess->SetCacheSize(0);

	pChLst->SetINetSession( pISess );
	pChLst->SetNotifyPermissionHdl( LINK(this, MyWin, NotifyPermissionHdl) );
	pChLst->SetAgentUpdateHdl(  LINK(this, MyWin, UpdateAgentHdl) );

	pChLst->SetTimerInterval( 50 );
	pChLst->StartCheckChannels();

	bNotifyPermission = FALSE;

	pBox = new ToolBox( this, WB_SVLOOK | WB_BORDER | WB_LINESPACING );
	pBox->InsertItem( BUTTON_NOTIFYPERMISSION, "NotifyPermission", TIB_AUTOCHECK );
	pBox->SetSelectHdl(LINK(this, MyWin, SelectHdl));
	pBox->Show();
}

MyWin::~MyWin()
{
	delete pChLst;
	delete pWrapper;
	delete pBox;
}

IMPL_LINK( MyWin, SelectHdl, ToolBox*, pBox )
{
	USHORT nItemId = pBox->GetCurItemId();
	switch ( nItemId )
	{
		case BUTTON_NOTIFYPERMISSION :
			if( pBox->IsItemChecked(BUTTON_NOTIFYPERMISSION) )
				bNotifyPermission = TRUE;
			else
				bNotifyPermission = FALSE;
			break;
	}
	return 1;
}

IMPL_LINK(MyWin, UpdateAgentHdl, String*, pAgentName)
{
	String aMsg( "Es gibt eine neuere Version des Agenten '" );
	aMsg += *pAgentName;
	aMsg += "' wollen Sie diese Version installieren?";

	if( QueryBox(this, WB_YES_NO, aMsg).Execute() == RET_YES )
		return 1;

	return 0;
}

IMPL_LINK(MyWin, NotifyPermissionHdl, void*, pTmp)
{
	if( bNotifyPermission )
		return 1;
	return 0;
}

void MyWin::Resize()
{
	Size aSz	= GetOutputSizePixel();
	Size aBoxSz = pBox->CalcWindowSizePixel();
	pBox->SetPosSizePixel( Point(0,0), Size(aSz.Width(), aBoxSz.Height()) );
}
