#include <stdio.h>

#include <osl/file.h>
#include <osl/process.h>
#include <rtl/ustring.hxx>
#ifdef SAL_UNX
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <sys/stat.h>
#define TEST_VOLUME ""
#else
// WINDOWS
#define TEST_VOLUME "c:/"
#endif


char *aSource1[] =
{
	"a"    , "file:///" TEST_VOLUME "bla/a",
	"a/"   , "file:///" TEST_VOLUME "bla/a",
	"../a" , "file:///" TEST_VOLUME "a" ,
	"a/.." , "file:///" TEST_VOLUME "bla",
	"a/../b" , "file:///" TEST_VOLUME "bla/b",
	".."   , "file:///" TEST_VOLUME "",
	"a/b/c/d/"   , "file:///" TEST_VOLUME "bla/a/b/c/d",
	"a/./c"   , "file:///" TEST_VOLUME "bla/a/c",
	"file:///bla/blub", "file:///" TEST_VOLUME "bla/blub",
	0 , 0
};

char *aSource2[ ] =
{
	"a" , "file:///" TEST_VOLUME "bla/blubs/schnubbel/a",
	"a/", "file:///" TEST_VOLUME "bla/blubs/schnubbel/a",
	"../a", "file:///" TEST_VOLUME "bla/blubs/a",
	"../../a", "file:///" TEST_VOLUME "bla/a",
	"../../../a", "file:///" TEST_VOLUME "a",
	"../../../a/b/c/d", "file:///" TEST_VOLUME "a/b/c/d",
	0,0
};

char *aSource3[ ] =
{
	".." , "/a",
	"../a" , "/a/a",
	"e/f" , "/c/e/f",
	"../..", "",
	0,0
};

using namespace rtl;

void test_file()
{
#ifdef WIN32
	return;
#endif
	
	OUString base1( RTL_CONSTASCII_USTRINGPARAM( "file:///" TEST_VOLUME "bla" ) );
	int i;
	for( i = 0 ; aSource1[i] ; i +=2 )
	{
		OUString target;
		OUString rel = OUString::createFromAscii( aSource1[i] );
		oslFileError e = osl_getAbsoluteFileURL( base1.pData, rel.pData , &target.pData );
		OSL_ASSERT( osl_File_E_None == e );
		if( osl_File_E_None == e )
		{
			OSL_VERIFY( target.equalsAscii( aSource1[i+1] ) );
		}
		OString o = OUStringToOString( target , RTL_TEXTENCODING_ASCII_US );
		OString obase = OUStringToOString( base1 , RTL_TEXTENCODING_ASCII_US );
		fprintf( stderr, "%d %s + %s = %s\n" ,e, obase.getStr(), aSource1[i], o.pData->buffer );
	}

	OUString base2( RTL_CONSTASCII_USTRINGPARAM( "file:///" TEST_VOLUME "bla/blubs/schnubbel" ) );
	for(  i = 0 ; aSource2[i] ; i +=2 )
	{
		OUString target;
		OUString rel = OUString::createFromAscii( aSource2[i] );
		oslFileError e = osl_getAbsoluteFileURL( base2.pData, rel.pData , &target.pData );
		OSL_ASSERT( osl_File_E_None == e );
		if( osl_File_E_None == e )
		{
			OSL_VERIFY( target.equalsAscii( aSource2[i+1] ) );
		}
		OString o = OUStringToOString( target , RTL_TEXTENCODING_ASCII_US );
		OString obase = OUStringToOString( base2 , RTL_TEXTENCODING_ASCII_US );
//		fprintf( stderr, "%d %s + %s = %s\n" ,e, obase.getStr(), aSource2[i], o.pData->buffer );
	}

	// links !
#ifdef UNX
	char buf[PATH_MAX];
	if( getcwd( buf, PATH_MAX ) )
	{
		char buf2[PATH_MAX];
		strcpy( buf2 , buf );
		strcat( buf2, "/a" );
		
		if( 0 == mkdir( buf2 , S_IRWXG | S_IRWXO | S_IRWXU ) )
		{
			strcat( buf2, "/b" );
			if( 0 == mkdir( buf2, S_IRWXU | S_IRWXO | S_IRWXU ) )
			{
				if( 0 == symlink( buf2 , "c" ) )
				{
					OUString dir;
					osl_getProcessWorkingDir( &(dir.pData) );

					OUString base3 = dir;
					base3 += OUString( RTL_CONSTASCII_USTRINGPARAM( "/c" ) );
					for( i = 0 ; aSource3[i] ; i +=2 )
					{
						OUString target;
						OUString rel = OUString::createFromAscii( aSource3[i] );
						oslFileError e = osl_getAbsoluteFileURL( base3.pData, rel.pData , &target.pData );
						OSL_ASSERT( osl_File_E_None == e );
						if( osl_File_E_None == e )
						{
							OSL_ASSERT( target.getLength() >= dir.getLength() );
							if( target.getLength() >= dir.getLength() )
							{
								for( int j = dir.getLength() ;
									 j < target.getLength() &&
										 aSource3[i+1][j-dir.getLength()] == target[j]	 ; j++ );
								OSL_ASSERT( j == target.getLength() );
							}
						}
						OString o = OUStringToOString( target , RTL_TEXTENCODING_ASCII_US );
						OString obase = OUStringToOString( base3 , RTL_TEXTENCODING_ASCII_US );
						fprintf( stderr, "%d %s + %s = %s\n" ,e, obase.getStr(), aSource3[i], o.pData->buffer );
					}
					unlink( "c" );
				}
				else
				{
					OSL_ASSERT( 0 );
				}
				rmdir( "a/b" );
			}
			else
			{
				OSL_ASSERT( 0 );
			}
			rmdir( "a" );
		}
		else
		{
			OSL_ASSERT( 0 );
		}
	}
	else
	{
		OSL_ASSERT( 0 );
	}
#endif

	OUString base4( RTL_CONSTASCII_USTRINGPARAM( "file:///" TEST_VOLUME "bla/" ) );
	for( i = 0 ; aSource1[i] ; i +=2 )
	{
		OUString target;
		OUString rel = OUString::createFromAscii( aSource1[i] );
		oslFileError e = osl_getAbsoluteFileURL( base4.pData, rel.pData , &target.pData );
		OSL_ASSERT( osl_File_E_None == e );
		if( osl_File_E_None == e )
		{
			OSL_VERIFY( target.equalsAscii( aSource1[i+1] ) );
		}
		OString o = OUStringToOString( target , RTL_TEXTENCODING_ASCII_US );
		OString obase = OUStringToOString( base4 , RTL_TEXTENCODING_ASCII_US );
		fprintf( stderr, "%d %s + %s = %s\n" ,e, obase.getStr(), aSource1[i], o.pData->buffer );
	}


	OUString err1( RTL_CONSTASCII_USTRINGPARAM( "../.." ) );
	OUString target;
	OSL_VERIFY( osl_File_E_None != osl_getAbsoluteFileURL( base1.pData , err1.pData , &target.pData ) );
	
	fprintf( stderr, "test_file done\n" );
}
