/*************************************************************************
 *
 *  $RCSfile: agenda.hxx,v $
 *
 *  $Revision: 1.26.52.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/16 14:49:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SETUP_AGENDA_HXX
#define __SETUP_AGENDA_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _COM_SUN_STAR_SETUP_XSETUP_HPP_
#include <com/sun/star/setup/XSetup.hpp>
#endif

#ifndef _COM_SUN_STAR_SETUP_MODULEINFO_HPP_
#include <com/sun/star/setup/ModuleInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SETUP_MODULESTATE_HPP_
#include <com/sun/star/setup/ModuleState.hpp>
#endif

#include "simode.hxx"
#include "hashtbl.hxx"
#include "sistream.hxx"
#include "environ.hxx"
#include "decltor.hxx"
#include "actntype.hxx"

using namespace osl;
using namespace rtl;

using namespace com::sun::star::setup;
using namespace com::sun::star::uno;

// forward declarations --------------------------------------------------

class SiModuleList;
class SiFile;
class SiFileList;
class SiFolderItemList;
class SiProfileList;
class SiProfileItemList;
class SiRegistryItemList;
class SiRegistryAreaList;
class SiOs2ClassList;
class SiOs2TemplateList;
class SiCompiledScript;
class SiDirectory;
class SiDirectoryList;
class SiModule;
class SiFolder;
class SiFolderItem;
class SiZipFile;
class SiProcedure;
class SiProcedureList;
class SiCustomList;
class SiAction;
class SiUnzipAction;
class SiMakeDirAction;
class SiTransferAction;
class SiAppendAction;
class SiInstallFontAction;
class SiMakeFolderAction;
class SiMakeFolderItemAction;
class SiProfileItemAction;
class SiRunProcedureAction;
class SiCustomAction;
class SiRegistryItemAction;
class SiOs2RegisterClassAction;
class SiOs2CreateTemplateAction;
class SiOs2JoinEAsAction;
class SiOs2SetCreatorAction;
class SiUnixCreateSoftLinkAction;
class SiShortcutAction;
class SiMacAddApplicationAction;
class SiStarRegistryAction;
class SiDeleteDirAction;
class SiDeleteFileAction;
class SiUnregisterAction;
class SiDeleteFolderAction;
class SiWebAction;
class SiConfigurationAction;
class SiActiveXAction;
class SiCompiledScript;

class FileCopier;
struct HelpFileEntry;
class SiDirEntry;
class SimpleFileArchive;
class RegistryLoader;
class Config;

// unloader macros -------------------------------------------------------

#ifndef DONT_USE_THE_LEWD_UNLOADER

#define GET_DELFILENAME(envref,strref)								\
	SiDirEntry aDelFile((envref).GetInstalledPath());				\
	aDelFile += ByteString("delme");								\
	aDelFile.ToAbs();					 							\
	strref = aDelFile.GetFull();

#define DEL_DELFILE(envref)											\
	SiDirEntry aDelFile((envref).GetInstalledPath());				\
	aDelFile += ByteString("delme");								\
	aDelFile.Kill();

#define ADD_TO_DELFILE(envref,strref) {								\
	SiDirEntry aDelFile((envref).GetInstalledPath());				\
	aDelFile += ByteString("delme");								\
	aDelFile.ToAbs();												\
	FILE* pFile = fopen( aDelFile.GetFull().GetBuffer(), "a+" );	\
	if( pFile ) {													\
		fprintf( pFile, "%s\n", strref.GetBuffer() );				\
		fclose( pFile ); }}
#else

#define ADD_TO_DELFILE(envref,strref)
#define DEL_DELFILE(envref)
#define GET_DELFILENAME(envref,strref)

#endif

// structures & lists ----------------------------------------------------

class SiLogStream : public SiFileStream
{
public:
	BOOL m_bFlush;

		SiLogStream() { m_bFlush = FALSE; }

	SiFileStream& Success(BOOL b);
	SiFileStream::operator <<;
};

struct HelpFileEntry
{
	SiFile* pFile;
	BOOL	bInsert;
};

struct ProfileEntry
{
	ByteString	aFileName;
	Config*		pConfig;
};

DECLARE_LIST(SiActionList,SiAction*)
DECLARE_LIST(SiTransferList,SiTransferAction*)
DECLARE_LIST(SiAppendList,SiAppendAction*)
DECLARE_LIST(SiPItemList,SiProfileItemAction*)
DECLARE_LIST(SiHelpFileList,HelpFileEntry*)
DECLARE_LIST(SiOpenProfileList,ProfileEntry*)
DECLARE_LIST(SiComponentList,SiFile*)

DECLARE_HASHTABLE(SiDoneList,ByteString,UINT32);

// class SiAgendaCallback ------------------------------------------------

class SiAgendaCallback
{
public:
			virtual ~SiAgendaCallback()																		{}

	enum ChangedDisk { CHANGEDDISK_OK, CHANGEDDISK_CANCEL, CHANGEDDISK_IGNORE };
	enum ExecErrorAction { EEA_IGNORE, EEA_CANCEL, EEA_RETRY };

	virtual ChangedDisk			ChangeDisk( const ByteString& rFilename, int nDiskNo, const ByteString& rDiskname )	{ return CHANGEDDISK_IGNORE; }

	virtual ExecErrorAction		ErrorRegisterUnoComponent(const ByteString& rFilename)			   			{ return EEA_IGNORE; }
	virtual ExecErrorAction		ExecutionError( SiAction* pAction )								   			{ return EEA_IGNORE; }
	virtual BOOL				RequestBigFile( const ByteString& rDiskname )						  		{ return FALSE; }
	virtual BOOL				OverwriteFile( const ByteString& rFilename, const SiFile* pFile )	   		{ return TRUE; }

	virtual void				StartCompileHelp()			 												{}
	virtual void				EndCompileHelp()															{}

	virtual void				StartRegister()				 												{}
	virtual void				EndRegister()																{}

	virtual void				StartRegisterUNO()			 												{}
	virtual void				EndRegisterUNO()															{}

	virtual void				ProgressTransfer( USHORT nPercent )											{}
	virtual void				ProgressAction( SiActionType eType, USHORT nPercent, const ByteString& rMsg ) {}

	virtual ByteString 			GetAdminPassword()															{ return ""; }

};

// -----------------------------------------------------------------------------
// This is a helper class for the QueryTemplateValue functions, because we need also the encoding.
// This is help full in the ResultMeta() function, which returns now a value, which contains the encoding.
// This is important for our AddReplacement functions, which needs sometimes osl_getThreadTextEncoding or Langcode2TextEncoding, but
// at the action time, we can not known, how to convert right. Now, we can ;-)

struct QueryTemplateResult
{
	ByteString sValue;
	sal_Int16  nEncoding;

	QueryTemplateResult(ByteString const& _sStr, sal_Int16 _nEncoding = ENCODING_DEFAULT)
			:sValue(_sStr), nEncoding(_nEncoding)
		{}
};

// class SiAgenda --------------------------------------------------------

class SiAgenda
{
	SiAgendaCallback*		m_pCallback;
	Link					m_WindowHideLink;

	SiInstallSubMode		m_eInstallSubMode;
	BOOL					m_bInstallFromNet;
	BOOL					m_bRecoverOnly;
	SiLogStream				m_Logfile;

	int						m_nCurrentDiskNo;
	BOOL					m_bStopRunning;
	SiAction*				m_pCurrentAction;
	SiCompiledScript* 		m_pCScript;  // available only while run()

	ULONG					m_lBytesToCopy;
	ULONG					m_lBytesCopied;
	ULONG					m_lBytesToUnzip;
	ULONG					m_lBytesUnzipped;
	int						m_nRunProgress;

	SiActionList			m_ActionList;
	SiActionList			m_ActionProcList;
	SiActionList			m_ActionSlot1;
	SiTransferList			m_ActionSlot2;
	SiAppendList			m_ActionSlot3;
	SiActionList			m_ActionSlot4;
	SiActionList			m_ActionSlot5;
	SiPItemList				m_ActionSlot6;

	SiActionList			m_CfgActionSlot;

	BOOL 					m_bCompleteHelpReorg;
	SiHelpFileList			m_HelpFileList;

	SiOpenProfileList		m_aOpenProfiles;
	SiComponentList			m_aUnoComponents;

	BOOL 					DelHelpFiles(SiDirEntry& rEntry, SimpleFileArchive* pArch);
	void					OrganizeHelpFiles(SiCompiledScript& rCS);
	BOOL					AddHelpFileList(SiFile* pFile, BOOL bInsert);
	void 					AddAllInstalledHelpFiles(SiDoneList&, SiCompiledScript&, SiModule*);
	void 					DoCompleteHelpReorg(SiFile*, SiDoneList&, SiCompiledScript&);

	void 					RegisterAllUnoComponets(SiModule* pMod, BOOL bRegister = TRUE);
	void					RegisterListedUnoComponets();
	void					RegisterExplicitUnoComponets( SiCompiledScript& rCs );
	void 					DeleteKHPatchedFiles();
    void                    UpdateATToolSupport();

	// normal install
	void					Add(SiMakeDirAction*);
	void   					Add(SiTransferAction*);
	void					Add(SiAppendAction*);
	void					Add(SiInstallFontAction*);
	void					Add(SiMakeFolderAction*);
	void					Add(SiMakeFolderItemAction*);
	void					Add(SiRunProcedureAction* pAction, BOOL bExecBefore = FALSE);
	void					Add(SiProfileItemAction*);
	void   					Add(SiStarRegistryAction*);
	void	   				Add(SiRegistryItemAction*);
	void 					Add(SiOs2RegisterClassAction*);
	void					Add(SiOs2CreateTemplateAction*);
	void					Add(SiOs2JoinEAsAction*);
	void					Add(SiUnixCreateSoftLinkAction*);
	void					Add(SiShortcutAction*);
	void					Add(SiMacAddApplicationAction*);
	void					Add(SiDeleteDirAction*);
	void					Add(SiDeleteFileAction* pAction, BOOL bLink = FALSE );
	void					Add(SiUnregisterAction*);
	void					Add(SiDeleteFolderAction*);
	void					Add(SiWebAction*);
	void					Add(SiConfigurationAction*);
	void					Add(SiActiveXAction*);

	BOOL		 			CreateForInstall(SiModule*, SiDoneList&, SiCompiledScript&, BOOL bRecover = FALSE);
	BOOL  					CreateForUninstall(SiModule*, SiDoneList&, SiCompiledScript&);

protected:
	void					DeleteSwitchContext(SiModule* pModule, SiDoneList& aDoneList, SiCompiledScript& rCS, BOOL bRecursive = TRUE);
	void		 			InstallSwitchContext(SiModule* pModule, SiDoneList& aDoneList, SiCompiledScript& rCS, BOOL bRecursive = TRUE);

	BOOL		 			Install(SiModule const*, SiDoneList&, SiCompiledScript&);
	BOOL  					Install(SiDirectory const*, SiDoneList&);
	BOOL 		  			Install(SiFile*, SiDoneList&, SiCompiledScript&);
	BOOL 		  			InstallWeb(SiFile*, SiDoneList&, SiCompiledScript&);
	BOOL		 			Install(SiFileList const&, SiDoneList&, SiCompiledScript&);
	BOOL					Install(SiFolder const*, SiDoneList&);
	BOOL		 			Install(SiFolderItemList const&, SiDoneList&);
	BOOL		 			Install(SiFolderItem const*, SiDoneList&);
	BOOL 					Install(const SiProfileItem*, SiDoneList&);
	BOOL					Install(SiProfileItemList const&, SiDoneList&);
	BOOL	 				Install(const SiProcedure*, SiDoneList&, SiCompiledScript&);
	BOOL					Install(SiProcedureList const&, SiDoneList&, SiCompiledScript&);
	BOOL					Install(const SiRegistryItem*, SiDoneList& aDoneList);
	BOOL					Install(const SiRegistryItem*, SiDoneList& aDoneList, USHORT nLanguage);
	BOOL 					Install(SiRegistryItemList const&, SiDoneList&, SiCompiledScript&);
	BOOL					Install(const SiOs2Class*, SiDoneList& aDoneList);
	BOOL					Install(SiOs2ClassList const&, SiDoneList&);
	BOOL 					Install(const SiOs2Template*, SiDoneList& aDoneList);
	BOOL   					Install(SiOs2TemplateList const&, SiDoneList&);
	BOOL   					Install(const SiStarRegistryItem*, SiDoneList&, SiCompiledScript&);
	BOOL   					Install(const SiStarRegistryItemList&, SiDoneList&, SiCompiledScript&);
	BOOL	 				Install(const SiConfigurationItem*, SiDoneList&, SiCompiledScript&);
	BOOL	 				Install(const SiConfigurationItem*, SiDoneList&, SiCompiledScript&, USHORT nLanguage);
	BOOL	 				Install(const SiConfigurationItemList&, SiDoneList&, SiCompiledScript&);
	BOOL 					InstallShortcut( SiFile *pFile );
	SiAction*	   			InstallMultiVolumeFile(SiFile*);
	BOOL 	   				Install(SiDirectoryList const&, SiDoneList&);

	BOOL	   				Uninstall(SiModule const*, SiDoneList&, SiCompiledScript&);
	BOOL					Uninstall(SiDirectory const*, SiDoneList&);
	BOOL 	 				Uninstall(SiDirectoryList const&, SiDoneList&);
	BOOL 	 				Uninstall(SiFile const*, SiDoneList&);
	BOOL					UninstallWeb(SiFile const*, SiDoneList&);
	BOOL 	  				Uninstall(SiFileList const&, SiDoneList&);
	BOOL	 				Uninstall(SiFolder const*, SiDoneList&);
	BOOL	 				Uninstall(SiFolderItem const*, SiDoneList&);
	BOOL	  				Uninstall(SiFolderItemList const&, SiDoneList&);
	BOOL  					Uninstall(const SiProfile*, SiDoneList&);
	BOOL  					Uninstall(SiProfileList const&, SiDoneList&);
	BOOL   					Uninstall(const SiProfileItem*, SiDoneList&);
	BOOL   					Uninstall(SiProfileItemList	const&, SiDoneList&);
	BOOL 					Uninstall(const SiProcedure*, SiDoneList&, SiCompiledScript&);
	BOOL 	 				Uninstall(SiProcedureList const&, SiDoneList&, SiCompiledScript&);
	BOOL 	 				Uninstall(const SiRegistryItem*, SiDoneList&);
	BOOL 	 				Uninstall(const SiRegistryItem*, SiDoneList&, USHORT nLanguage);
	BOOL					Uninstall(SiRegistryItemList const&, SiDoneList&);
	BOOL  					Uninstall(const SiRegistryArea*, SiDoneList& aDoneList);
	BOOL  					Uninstall(SiRegistryAreaList const&, SiDoneList&);
	BOOL  					Uninstall(const SiOs2Class*, SiDoneList& aDoneList);
	BOOL  					Uninstall(SiOs2ClassList const&, SiDoneList&);
	BOOL   					Uninstall(class SiOs2Template*, SiDoneList&);
	BOOL   					Uninstall(SiOs2TemplateList	const&, SiDoneList&);
	BOOL 					Uninstall(const SiStarRegistry*, SiDoneList&);
	BOOL 	 				Uninstall(const SiStarRegistryItem*, SiDoneList&, SiCompiledScript&);
	BOOL	 				Uninstall(const SiStarRegistryItemList&, SiDoneList&, SiCompiledScript&);
	BOOL	 				Uninstall(const SiConfigurationItem*, SiDoneList&);
	BOOL	 				Uninstall(const SiConfigurationItem*, SiDoneList&, USHORT nLanguage);
	BOOL	 				Uninstall(const SiConfigurationItemList&, SiDoneList&);
	BOOL					UninstallShortcut( SiFile const* pFile );

private:
	void					SortDir4Uninstall();

	void 	 				EnableRecoverMode( BOOL b = TRUE ) { m_bRecoverOnly = b; }
	void 	 				GetCustoms( BOOL bBefore, SiActionList* pActions, SiModule* pModule,
										SiModule* pRoot, SiDoneList& rDoneList, SiCompiledScript& rCS );
	void 	 				CallCustoms( SiCompiledScript &rCS, BOOL bBefore );

	void	  				PrintHeader();
	void	 				PrintFoot( int nErrors );

public:
		DECL_LINK( CopyProgressHdl, FileCopier* );
		DECL_LINK( UnzipProgressHdl, SiZipFile* );
	void					AddCanceledFileSize( ULONG nSize, BOOL bUnzip = TRUE );
	void		  			AddCanceledFileSize( SiFile* pFile, BOOL bUnzip = TRUE );

	ByteString	  			GetSourceDir( SiFile const* pFile ) const;
	ByteString	   			GetDestDir( SiFile const* pFile, BOOL bWebMode = FALSE ) const;
	ByteString				GetSourceName( SiFile const* pFile ) const;

	SiLogStream&  			GetLogfile();
	BOOL		   			InstallFromNet() const;
	BOOL		 			InstallLocal() const;
	BOOL					DoRecoverOnly() const;

	BOOL	   				RequestDisk( ByteString const& CurrentFile, BOOL bNoWarn, int nDiskNo, ByteString const& DiskName );

	Config*		 			GetOpenProfile(const ByteString& rFileName);
	void 		 			CloseAllOpenProfiles();

	QueryTemplateResult		_QueryTemplateValue(const ByteString& rTpl);
	virtual QueryTemplateResult	QueryTemplateValue(ByteString const&);

	void 					AddUnoComponent(SiFile* pFile)	  				{ m_aUnoComponents.Insert(pFile); }
protected:
	SiInstallMode			m_eInstallMode;
	USHORT              	m_nAppLanguage;
	SiEnvironment*			m_pEnv;
	BOOL 					m_bWebMode;
	BOOL 					m_bSwitchMode;

public:
			SiAgenda();
			~SiAgenda();

	SiCompiledScript*		GetCScript() const 											{ return m_pCScript; }
	void 					OpenLogfile( const ByteString& r );
	void 					SetWindowHideLink(Link& rNew)								{ m_WindowHideLink = rNew; }
	Link& 					GetWindowHideLink()											{ return m_WindowHideLink; }

	virtual void		 	JoinActionLists();

	SiAgendaCallback*		GetCallback() const 										{ return m_pCallback; }
	void					SetCallback(SiAgendaCallback* pNew);

	void 		   			SetAppLanguage(USHORT nLang) 								{ m_nAppLanguage = nLang; }
	USHORT 					GetAppLanguage() const 										{ return m_nAppLanguage; }

	void 					SetEnvironment(SiEnvironment* pNew) 						{ m_pEnv = pNew; }
	SiEnvironment*			GetEnvironment() const 				 						{ return m_pEnv; }

	BOOL	  				CreateForInstall( SiCompiledScript&, SiInstallMode, BOOL bInstallFromNet);
	BOOL	 				CreateForUninstall(SiCompiledScript&, SiInstallSubMode eInstallSubMode = ISM_INVALID);
	BOOL	 				CreateForChange(SiCompiledScript&,	SiInstallSubMode);
	BOOL 	 				CreateForRecover(SiCompiledScript&);

	BOOL	 				Run(SiCompiledScript&, SiInstallSubMode eInstallSubMode = ISM_INVALID );
	void	 				StopRunning()												{ m_bStopRunning = TRUE; }
	BOOL	 				WasRunningStopped() const									{ return m_bStopRunning; }

	SiInstallMode  			GetInstallMode() const;
	SiInstallSubMode		GetInstallSubMode() const 									{ return m_eInstallSubMode; }
	SiInstallMode			GetOldInstallMode() const;

	int						GetPercentage() const;
	const SiAction*			GetCurrentAction() const									{ return m_pCurrentAction; }
};

// ------------------------------------------------------------------

class CachedConfiguration;

class SiWebAgenda : public SiAgenda
{
	SiActionList			m_WebActionList;

	SiActionList			m_WebDeActionSlot1;
	SiActionList			m_WebDeActionSlot2;
	SiActionList			m_WebDeActionSlot3;
	SiActionList			m_WebDeActionSlot4;

	SiActionList			m_WebActionSlot1;
	SiActionList			m_WebActionSlot2;
	SiActionList			m_WebActionSlot3;
	SiActionList			m_WebActionSlot4;
	SiActionList			m_WebActionSlot5;
	SiActionList			m_WebActionSlot6;

	CachedConfiguration*	m_pCachedConfig;


	ULONG					CreateDownload4Module( SiModule*, SiDoneList& );
	BOOL					CreateForWebDeinstall( SiModule*, CachedConfiguration*, SiDoneList&, BOOL );
	ULONG					CreateForWebInstall( SiModule*, CachedConfiguration*, SiDoneList&, BOOL );
public:
			SiWebAgenda();
			~SiWebAgenda();

	ULONG					_addDownload( SiFile* pFile, SiDoneList& rDonelist );
	CachedConfiguration*	GetCachedConfig() const { return m_pCachedConfig; }

	void					SubstituteTemplates( ByteString& rValue );

	void					AddWeb( SiWebAction* pAction );
	virtual void		 	JoinActionLists();

	SiActionList&			GetWebActionList() 	 								{ return m_WebActionList; }

	ULONG	  				CreateForWebInstall( CachedConfiguration*, const InstallEnvironment& );
};

// inlines ----------------------------------------------------------

inline SiLogStream& SiAgenda::GetLogfile()
{
	return m_Logfile;
}

inline SiInstallMode SiAgenda::GetInstallMode() const
{
	return m_eInstallMode;
}

inline BOOL	SiAgenda::InstallFromNet() const
{
	return m_bInstallFromNet
		|| GetInstallMode() == IM_WORKSTATION;
}

inline BOOL SiAgenda::InstallLocal() const
{
	return GetInstallMode() == IM_WORKSTATION
		|| GetInstallMode() == IM_STANDALONE;
}

inline BOOL SiAgenda::DoRecoverOnly() const
{
	return m_bRecoverOnly;
}

#endif // __AGENDA_HXX
