/*************************************************************************
 *
 *  $RCSfile: bsockcon.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:03:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "btcpcon.hxx"

#if SUPD > 358
#include <debug.hxx>
#endif

#define SC_INFOTYPE ( CM_NO_TEXT | CM_ALL )

/*****************************************************************************/
TcpConBase::TcpConBase( BOOL bDoSynchronesEmpfangen )
/*****************************************************************************/
: pComManager( NULL )
, pClientContext( NULL )
, bSynchronesEmpfangen( bDoSynchronesEmpfangen )
{
}

/*****************************************************************************/
void TcpConBase::LateInit()
/*****************************************************************************/
{
	if ( pComManager )
	{
		pComManager->SetConnectionOpenedHdl( LINK( this, TcpConBase, ConnectionOpenedHdl ));
		pComManager->SetConnectionClosedHdl( LINK( this, TcpConBase, ConnectionClosedHdl ));
		pComManager->SetDataReceivedHdl( LINK( this, TcpConBase, DataReceivedHdl ));

		pComManager->SetInfoType( SC_INFOTYPE );
	}
}

/*****************************************************************************/
TcpConBase::~TcpConBase()
/*****************************************************************************/
{
	pComManager->StopCommunication();

	if ( IsServer() ) {
		for ( ULONG i = 0; i < aClientContextList.Count(); i++ ) {
			delete aClientContextList.GetObject( i );
		}
	}
	else {
		delete pClientContext;
	}

	delete pComManager;
}

/*****************************************************************************/
IMPL_LINK( TcpConBase, ConnectionOpenedHdl, CommunicationLink*, pCL )
/*****************************************************************************/
{
	if ( IsServer() ) {
		ClientContext *pNewContext = new ClientContext( pCL );
		aClientContextList.Insert( pNewContext );

		ConnectionOpened( pNewContext );
	}
	else {
		pClientContext = new ClientContext( pCL );
		ConnectionOpened( pClientContext );
	}

	return 0;
}

/*****************************************************************************/
IMPL_LINK( TcpConBase, ConnectionClosedHdl, CommunicationLink*, pCL )
/*****************************************************************************/
{
	if ( IsServer() ) {
		for ( ULONG i = 0; i < aClientContextList.Count(); i++ ) {
			ClientContext *pContext = aClientContextList.GetObject( i );
			if ( pContext->IsEqual( pCL )) {
				ConnectionClosed( pContext );
				aClientContextList.Remove( i );
				delete pContext;
				return 0;
			}
		}
	}
	else {
		ConnectionClosed( pClientContext );
		delete pClientContext;
		pClientContext = 0;
	}

	return 0;
}

/*****************************************************************************/
IMPL_LINK( TcpConBase, DataReceivedHdl, CommunicationLink*, pCL )
/*****************************************************************************/
{
	ClientContext *pContext = NULL;

	if ( IsServer() ) {
		for ( ULONG i = 0; i < aClientContextList.Count() && !pContext ; i++ ) {
			if ( aClientContextList.GetObject( i )->IsEqual( pCL ))
				pContext = aClientContextList.GetObject( i );
		}
		if ( !pContext )
			return 0;
	}
	else
		pContext = pClientContext;

	SvStream *pInput = pCL->GetServiceData();

	DBG_ASSERT( !pInput->IsEof(), "EmptyStream received!" )
	if ( pInput->IsEof()) {
		delete pInput;
		return 0;
	}

	DataPack *pDataPack = new DataPack;

	(*pInput)>>pDataPack->nDataType;
	(*pInput)>>pDataPack->nDataSize;
	pDataPack->pDataBuffer = new unsigned char[ pDataPack->nDataSize ];
	pInput->Read( pDataPack->pDataBuffer, pDataPack->nDataSize );
	pDataPack->pConId = pContext;

	PacketRecieved( pDataPack );

	delete pDataPack;
	delete pInput;

	return 0;
}

/*****************************************************************************/
long int TcpConBase::SendData( DataPack *pDPack )
/*****************************************************************************/
{
	if ( !pDPack->pConId )
		return 0;

	CommunicationLink *pCL = pDPack->pConId->GetCommunicationLink();
	if ( !pComManager->IsLinkValid( pCL ))
		return 0;

	SvStream *pOutput = pCL->GetBestCommunicationStream();

	(*pOutput)<<pDPack->nDataType;
	(*pOutput)<<pDPack->nDataSize;
	pOutput->Write( pDPack->pDataBuffer, pDPack->nDataSize );

	pCL->TransferDataStream( pOutput );

//	if ( bSynchronesEmpfangen )
//		pCL->ReceiveDataStream();

	delete pOutput;

	return 0;
}


/*****************************************************************************/
void TcpConBase::ReceiveData( CommunicationLink* pCL )
/*****************************************************************************/
{
	if ( !pComManager->IsLinkValid( pCL ))
		return;

	if ( bSynchronesEmpfangen )
		pCL->ReceiveDataStream();
}
