/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/netwerk/base/public/nsIUploadChannel.idl
 */

#ifndef __gen_nsIUploadChannel_h__
#define __gen_nsIUploadChannel_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class nsIChannel; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    nsIUploadChannel */
#define NS_IUPLOADCHANNEL_IID_STR "ddf633d8-e9a4-439d-ad88-de636fd9bb75"

#define NS_IUPLOADCHANNEL_IID \
  {0xddf633d8, 0xe9a4, 0x439d, \
    { 0xad, 0x88, 0xde, 0x63, 0x6f, 0xd9, 0xbb, 0x75 }}

class NS_NO_VTABLE nsIUploadChannel : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IUPLOADCHANNEL_IID)

  /**
   * Set the stream to be uploaded by this channel. 
   * History here is that we need to support both streams that already have header (eg.
   * content-type & content-length) information prepend to the stream (namely plugins) 
   * as well as clients (composer, uploading application) that want to upload data streams 
   * without any knowledgle of protocol specifications.  For this reason, we have a special
   * meaning for contentType.  See below.
   * 
   *   @param stream
   *          Stream to be uploaded by this channel
   *   @param contentType
   *          If the contentType is nsnull, the protocol will assume that no content 
   *          headers are to be added to the uploaded stream and that any required
   *          headers are already in the param |stream|.  In HTTP's case, if you do
   *          specify a content header, the implemention should prepend this as a 
   *          content-type header to the uploading stream.  In FTP's case, this 
   *          parameter is ignored. 
   *   @param contentLength
   *          Use of -1 assumes that the data length is returned by the |stream|'s 
   *          Available() method. 
   */
  /* void setUploadStream (in nsIInputStream stream, in string contentType, in long contentLength); */
  NS_IMETHOD SetUploadStream(nsIInputStream *stream, const char *contentType, PRInt32 contentLength) = 0;

  /** 
   * Sets a file to be uploaded by this channel.  
   *   @param file
   *          The nsIFile to be uploaded by this channel
   *   @param contentType
   *          If the contentType is nsnull here, the protocol may ask the MIME service 
   *          for an appropriate content type if one is required for uploading.
   *   @param contentLength
   *          Use of -1 assumes that the data length is returned by nsIFile::fileSize 
   */
  /* void setUploadFile (in nsIFile file, in string contentType, in long contentLength); */
  NS_IMETHOD SetUploadFile(nsIFile *file, const char *contentType, PRInt32 contentLength) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIUPLOADCHANNEL \
  NS_IMETHOD SetUploadStream(nsIInputStream *stream, const char *contentType, PRInt32 contentLength); \
  NS_IMETHOD SetUploadFile(nsIFile *file, const char *contentType, PRInt32 contentLength); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIUPLOADCHANNEL(_to) \
  NS_IMETHOD SetUploadStream(nsIInputStream *stream, const char *contentType, PRInt32 contentLength) { return _to SetUploadStream(stream, contentType, contentLength); } \
  NS_IMETHOD SetUploadFile(nsIFile *file, const char *contentType, PRInt32 contentLength) { return _to SetUploadFile(file, contentType, contentLength); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIUPLOADCHANNEL(_to) \
  NS_IMETHOD SetUploadStream(nsIInputStream *stream, const char *contentType, PRInt32 contentLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUploadStream(stream, contentType, contentLength); } \
  NS_IMETHOD SetUploadFile(nsIFile *file, const char *contentType, PRInt32 contentLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUploadFile(file, contentType, contentLength); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsUploadChannel : public nsIUploadChannel
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIUPLOADCHANNEL

  nsUploadChannel();
  virtual ~nsUploadChannel();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsUploadChannel, nsIUploadChannel)

nsUploadChannel::nsUploadChannel()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsUploadChannel::~nsUploadChannel()
{
  /* destructor code */
}

/* void setUploadStream (in nsIInputStream stream, in string contentType, in long contentLength); */
NS_IMETHODIMP nsUploadChannel::SetUploadStream(nsIInputStream *stream, const char *contentType, PRInt32 contentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setUploadFile (in nsIFile file, in string contentType, in long contentLength); */
NS_IMETHODIMP nsUploadChannel::SetUploadFile(nsIFile *file, const char *contentType, PRInt32 contentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIUploadChannel_h__ */
