/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/widget/public/nsIClipboard.idl
 */

#ifndef __gen_nsIClipboard_h__
#define __gen_nsIClipboard_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

#ifndef __gen_nsITransferable_h__
#include "nsITransferable.h"
#endif

#ifndef __gen_nsIClipboardOwner_h__
#include "nsIClipboardOwner.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIClipboard */
#define NS_ICLIPBOARD_IID_STR "8b5314ba-db01-11d2-96ce-0060b0fb9956"

#define NS_ICLIPBOARD_IID \
  {0x8b5314ba, 0xdb01, 0x11d2, \
    { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 }}

class NS_NO_VTABLE nsIClipboard : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICLIPBOARD_IID)

  enum { kSelectionClipboard = 0 };

  enum { kGlobalClipboard = 1 };

  /**
    * Given a transferable, set the data on the native clipboard
    *
    * @param  aTransferable The transferable
    * @param  anOwner The owner of the transferable
    * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    * @result NS_Ok if no errors
    */
  /* void setData (in nsITransferable aTransferable, in nsIClipboardOwner anOwner, in long aWhichClipboard); */
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, PRInt32 aWhichClipboard) = 0;

  /**
    * Given a transferable, get the clipboard data.
    *
    * @param  aTransferable The transferable
    * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    * @result NS_Ok if no errors
    */
  /* void getData (in nsITransferable aTransferable, in long aWhichClipboard); */
  NS_IMETHOD GetData(nsITransferable *aTransferable, PRInt32 aWhichClipboard) = 0;

  /**
    * This empties the clipboard and notifies the clipboard owner.
    * This empties the "logical" clipboard. It does not clear the native clipboard.
    *
    * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    * @result NS_OK if successful.
    */
  /* void emptyClipboard (in long aWhichClipboard); */
  NS_IMETHOD EmptyClipboard(PRInt32 aWhichClipboard) = 0;

  /**
    * Some platforms support deferred notification for putting data on the clipboard
    * This method forces the data onto the clipboard in its various formats
    * This may be used if the application going away.
    *
    * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    * @result NS_OK if successful.
    */
  /* void forceDataToClipboard (in long aWhichClipboard); */
  NS_IMETHOD ForceDataToClipboard(PRInt32 aWhichClipboard) = 0;

  /**
    * This provides a way to give correct UI feedback about, for instance, a paste 
    * should be allowed. It does _NOT_ actually retreive the data and should be a very
    * inexpensive call. All it does is check if there is data on the clipboard matching
    * any of the flavors in the given list.
    *
    * @aFlavorList - nsISupportsString's in a nsISupportsArray (for JavaScript).
    * @param  aWhichClipboard Specifies the clipboard to which this operation applies.
    * @outResult - if data is present matching one of 
    * @result NS_OK if successful.
    */
  /* boolean hasDataMatchingFlavors (in nsISupportsArray aFlavorList, in long aWhichClipboard); */
  NS_IMETHOD HasDataMatchingFlavors(nsISupportsArray *aFlavorList, PRInt32 aWhichClipboard, PRBool *_retval) = 0;

  /**
    * Allows clients to determine if the implementation supports the concept of a 
    * separate clipboard for selection.
    * 
    * @outResult - true if 
    * @result NS_OK if successful.
    */
  /* boolean supportsSelectionClipboard (); */
  NS_IMETHOD SupportsSelectionClipboard(PRBool *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICLIPBOARD \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, PRInt32 aWhichClipboard); \
  NS_IMETHOD GetData(nsITransferable *aTransferable, PRInt32 aWhichClipboard); \
  NS_IMETHOD EmptyClipboard(PRInt32 aWhichClipboard); \
  NS_IMETHOD ForceDataToClipboard(PRInt32 aWhichClipboard); \
  NS_IMETHOD HasDataMatchingFlavors(nsISupportsArray *aFlavorList, PRInt32 aWhichClipboard, PRBool *_retval); \
  NS_IMETHOD SupportsSelectionClipboard(PRBool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICLIPBOARD(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, PRInt32 aWhichClipboard) { return _to SetData(aTransferable, anOwner, aWhichClipboard); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, PRInt32 aWhichClipboard) { return _to GetData(aTransferable, aWhichClipboard); } \
  NS_IMETHOD EmptyClipboard(PRInt32 aWhichClipboard) { return _to EmptyClipboard(aWhichClipboard); } \
  NS_IMETHOD ForceDataToClipboard(PRInt32 aWhichClipboard) { return _to ForceDataToClipboard(aWhichClipboard); } \
  NS_IMETHOD HasDataMatchingFlavors(nsISupportsArray *aFlavorList, PRInt32 aWhichClipboard, PRBool *_retval) { return _to HasDataMatchingFlavors(aFlavorList, aWhichClipboard, _retval); } \
  NS_IMETHOD SupportsSelectionClipboard(PRBool *_retval) { return _to SupportsSelectionClipboard(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICLIPBOARD(_to) \
  NS_IMETHOD SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, PRInt32 aWhichClipboard) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetData(aTransferable, anOwner, aWhichClipboard); } \
  NS_IMETHOD GetData(nsITransferable *aTransferable, PRInt32 aWhichClipboard) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetData(aTransferable, aWhichClipboard); } \
  NS_IMETHOD EmptyClipboard(PRInt32 aWhichClipboard) { return !_to ? NS_ERROR_NULL_POINTER : _to->EmptyClipboard(aWhichClipboard); } \
  NS_IMETHOD ForceDataToClipboard(PRInt32 aWhichClipboard) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForceDataToClipboard(aWhichClipboard); } \
  NS_IMETHOD HasDataMatchingFlavors(nsISupportsArray *aFlavorList, PRInt32 aWhichClipboard, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasDataMatchingFlavors(aFlavorList, aWhichClipboard, _retval); } \
  NS_IMETHOD SupportsSelectionClipboard(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->SupportsSelectionClipboard(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsClipboard : public nsIClipboard
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICLIPBOARD

  nsClipboard();
  virtual ~nsClipboard();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsClipboard, nsIClipboard)

nsClipboard::nsClipboard()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsClipboard::~nsClipboard()
{
  /* destructor code */
}

/* void setData (in nsITransferable aTransferable, in nsIClipboardOwner anOwner, in long aWhichClipboard); */
NS_IMETHODIMP nsClipboard::SetData(nsITransferable *aTransferable, nsIClipboardOwner *anOwner, PRInt32 aWhichClipboard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getData (in nsITransferable aTransferable, in long aWhichClipboard); */
NS_IMETHODIMP nsClipboard::GetData(nsITransferable *aTransferable, PRInt32 aWhichClipboard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void emptyClipboard (in long aWhichClipboard); */
NS_IMETHODIMP nsClipboard::EmptyClipboard(PRInt32 aWhichClipboard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forceDataToClipboard (in long aWhichClipboard); */
NS_IMETHODIMP nsClipboard::ForceDataToClipboard(PRInt32 aWhichClipboard)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasDataMatchingFlavors (in nsISupportsArray aFlavorList, in long aWhichClipboard); */
NS_IMETHODIMP nsClipboard::HasDataMatchingFlavors(nsISupportsArray *aFlavorList, PRInt32 aWhichClipboard, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean supportsSelectionClipboard (); */
NS_IMETHODIMP nsClipboard::SupportsSelectionClipboard(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIClipboard_h__ */
