/*************************************************************************
 *
 *  $RCSfile: b3dpolygon.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: thb $ $Date: 2004/02/16 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _BGFX_POLYGON_B3DPOLYGON_HXX
#define _BGFX_POLYGON_B3DPOLYGON_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class ImplB3DPolygon;

namespace basegfx
{
	class B3DPolygon;
	class B3DPoint;
	class B3DHomMatrix;
} // end of namespace basegfx

//////////////////////////////////////////////////////////////////////////////

namespace basegfx
{
	class B3DPolygon
	{
	private:
		// internal data.
		ImplB3DPolygon*								mpPolygon;

		// internal method to force a ref-counted instance to be copied
		// to a modifyable unique copy.
		void implForceUniqueCopy();

	public:
		B3DPolygon();
		B3DPolygon(const B3DPolygon& rPolygon);
		B3DPolygon(const B3DPolygon& rPolygon, sal_uInt32 nIndex, sal_uInt32 nCount);
		~B3DPolygon();

		// assignment operator
		B3DPolygon& operator=(const B3DPolygon& rPolygon);

		// compare operators
		bool operator==(const B3DPolygon& rPolygon) const;
		bool operator!=(const B3DPolygon& rPolygon) const;

		// member count
		sal_uInt32 count() const;

		// Coordinate interface
		::basegfx::B3DPoint getB3DPoint(sal_uInt32 nIndex) const;
		void setB3DPoint(sal_uInt32 nIndex, const ::basegfx::B3DPoint& rValue);

		// Coordinate insert/append
		void insert(sal_uInt32 nIndex, const ::basegfx::B3DPoint& rPoint, sal_uInt32 nCount = 1);
		void append(const ::basegfx::B3DPoint& rPoint, sal_uInt32 nCount = 1);

		// insert/append other 2D polygons
		void insert(sal_uInt32 nIndex, const B3DPolygon& rPoly, sal_uInt32 nIndex2 = 0, sal_uInt32 nCount = 0);
		void append(const B3DPolygon& rPoly, sal_uInt32 nIndex = 0, sal_uInt32 nCount = 0);

		// remove
		void remove(sal_uInt32 nIndex, sal_uInt32 nCount = 1);

		// clear all points
		void clear();

		// closed state
		bool isClosed() const;
		void setClosed(bool bNew);

		// flip polygon direction
		void flip();

		// test if Polygon has double points
		bool hasDoublePoints() const;

		// remove double points, at the begin/end and follow-ups, too
		void removeDoublePoints();

		// apply transformation given in matrix form to the polygon
		void transform(const ::basegfx::B3DHomMatrix& rMatrix);
	};
} // end of namespace basegfx

//////////////////////////////////////////////////////////////////////////////


#endif /* _BGFX_POLYGON_B3DPOLYGON_HXX */
