/*************************************************************************
 *
 *  $RCSfile: bezierclip.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: thb $ $Date: 2004/02/16 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef BASEGFX_BEZIERCLIP_HXX
#define BASEGFX_BEZIERCLIP_HXX

#include <vector>

struct Point2D
{
    typedef double value_type;
    Point2D( double _x, double _y ) : x(_x), y(_y) {}
    Point2D() : x(), y() {}
    double x;
    double y;
};

struct Bezier
{
    Point2D	p0;
    Point2D	p1;
    Point2D	p2;
    Point2D	p3;

    Point2D& 		operator[]( int i ) { return reinterpret_cast<Point2D*>(this)[i]; }
    const Point2D& 	operator[]( int i ) const { return reinterpret_cast<const Point2D*>(this)[i]; }
};

struct FatLine
{
    // line L through p1 and p4 in normalized implicit form
    double a;
    double b;
    double c;

    // the upper and lower distance from this line
    double dMin;
    double dMax;
};

template <typename DataType> DataType calcLineDistance( const DataType& a,
                                                        const DataType& b,
                                                        const DataType& c,
                                                        const DataType& x,
                                                        const DataType& y )
{
    return a*x + b*y + c;
}

typedef ::std::vector< Point2D > Polygon2D;

/* little abs template */
template <typename NumType> NumType absval( NumType x )
{
    return x<0 ? -x : x;
}

Polygon2D convexHull( const Polygon2D& rPoly );

// TODO: find proper epsilon here (try ::std::numeric_limits<NumType>::epsilon()?)!
#define DBL_EPSILON 1.0e-100

/* little approximate comparions */
template <typename NumType> bool tolZero( NumType n ) { return fabs(n) < DBL_EPSILON; }
template <typename NumType> bool tolEqual( NumType n1, NumType n2 ) { return tolZero(n1-n2); }
template <typename NumType> bool tolLessEqual( NumType n1, NumType n2 ) { return tolEqual(n1,n2) || n1<n2; }
template <typename NumType> bool tolGreaterEqual( NumType n1, NumType n2 ) { return tolEqual(n1,n2) || n1>n2; }

#endif /* BASEGFX_BEZIERCLIP_HXX */
