/*************************************************************************
 *
 *  $RCSfile: dispatch.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: obo $ $Date: 2004/06/04 03:01:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sal/alloca.h>
#include <osl/diagnose.h>

#include <rtl/alloc.h>
#include <rtl/ustrbuf.hxx>
#include <rtl/byteseq.hxx>

#include <uno/mapping.hxx>
#include <uno/threadpool.h>

#include <bridges/remote/remote.hxx>
#include <bridges/remote/marshal.hxx>
#include <bridges/remote/unmarshal.hxx>
#include <bridges/remote/stub.hxx>
#include <bridges/remote/proxy.hxx>
#include <bridges/remote/connection.h>
#include <bridges/remote/helper.hxx>

#include "iothreads.hxx"
#include "conversion.h"

#ifdef major
#undef major
#undef minor
#endif

#include <com/sun/star/corba/giop/MessageHeader_1_2.hpp>
#include <com/sun/star/corba/giop/RequestHeader_1_2.hpp>
#include <com/sun/star/corba/giop/ReplyHeader_1_2.hpp>
#include <com/sun/star/corba/giop/MsgType_1_1.hpp>
#include <com/sun/star/corba/iop/ServiceContext.hpp>
#include <com/sun/star/corba/LogicalThreadID.hpp>
#include <com/sun/star/corba/iop/ServiceIdGroup.hpp>
#include <com/sun/star/corba/ObjectKey.hpp>
#include "com/sun/star/uno/RuntimeException.hpp"

using namespace ::rtl;
using namespace ::bridges_remote;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::corba;
using namespace ::com::sun::star::corba::iop;
using namespace ::com::sun::star::corba::giop;							   

namespace bridges_remote
{

::com::sun::star::uno::Sequence< sal_Int8 > buildMarshaledObjectIdentifier(
	rtl_uString *pOid,
	rtl_uString *pType,
	sal_Bool bIsLittleEndian )
{
	Marshal marsh( bIsLittleEndian );

	ObjectKey key;
	key.sOid = OUString( pOid );
	key.sType = OUString( pType );
	marsh <<= key;
	return marsh.remove();
}



RequestInfo::RequestInfo( uno_Environment *pEnvRemote,
						  const Sequence< sal_Int8 > &seqBody,
	 					  sal_Bool bIsLittleEndian ) :
	m_pEnvRemote( pEnvRemote ),
	m_seqBody( seqBody ),
	m_unmarshal( seqBody.getConstArray(),
				 seqBody.getLength(),
				 bIsLittleEndian,
				 pEnvRemote,
				 remote_createStub ),
	m_bIsLittleEndian( bIsLittleEndian )
{
	m_pEnvRemote->acquire( m_pEnvRemote );
}

RequestInfo::~RequestInfo()
{
	m_pEnvRemote->release( m_pEnvRemote );
}

ReplyInfo::ReplyInfo( uno_Environment *pEnvRemote,
						const Sequence< sal_Int8 > &seqBody,
						sal_Bool bIsLittleEndian ) :
	m_pEnvRemote( pEnvRemote ),
	m_seqBody( seqBody ),
	m_unmarshal( seqBody.getConstArray(),
				 seqBody.getLength(),
				 bIsLittleEndian,
				 pEnvRemote,
				 remote_createStub ),
	m_bIsLittleEndian( bIsLittleEndian )
{
	m_pEnvRemote->acquire( m_pEnvRemote );
}

ReplyInfo::~ReplyInfo()
{
	m_pEnvRemote->release( m_pEnvRemote );
}




void SAL_CALL dispatchExtractOidCallback (
	remote_Interface *pRemoteI,
	rtl_uString **ppOid ,
	rtl_uString **ppsType )
{
	if( pRemoteI->acquire == Remote2RemoteStub::thisAcquire )
	{
		// Remote2RemoteStub
		Remote2RemoteStub *pStub = (Remote2RemoteStub * ) pRemoteI;
		rtl_uString_newFromString( ppOid , pStub->m_sOid.pData );
		rtl_uString_newFromString( ppsType , pStub->m_pType->aBase.pTypeName );
	}
	else
	{
		// Uno2RemoteStub
		Uno2RemoteStub *pStub = (Uno2RemoteStub * ) pRemoteI;
		rtl_uString_newFromString( ppOid , pStub->m_sOid.pData );
		rtl_uString_newFromString( ppsType , pStub->m_pType->aBase.pTypeName );
		pRemoteI->acquire( pRemoteI );
	}
}



void buildThreadIdServiceContext( ServiceContext *pContext ,
								  const ByteSequence &aThreadId,
								  sal_Bool bIsLittleEndian )
{

	Marshal marsh( bIsLittleEndian );


	// Marshal the sequence of one thread id
	sal_Int32 nLength = 1;
	marsh <<= nLength;

	// Marshal one thread id
	sal_Int32 nModus = 1;
	marsh <<= nModus;
	marsh.packByteSequence( (sal_Int8 *)aThreadId.getConstArray() , aThreadId.getLength() );
	
	pContext->context_id   = ServiceIdGroup::LogicalThreadId;
	pContext->context_data = marsh.remove();
}


void prepareRuntimeExceptionClientSide( uno_Any **ppException )
{
	Type type = ::getCppuType( ( ::com::sun::star::uno::RuntimeException *) 0 );
	uno_type_any_construct( *ppException , 0 , type.getTypeLibType() , 0 );
}

void SAL_CALL sendRequestClientSide(
	uno_Environment *pEnvRemote,
	typelib_TypeDescription * pMemberType,
	rtl_uString *pOid,
	typelib_InterfaceTypeDescription *pInterfaceType,
	void *pReturn,
	void *ppArgs[],
	uno_Any **ppException
	)
{	
	// cares for thread counting and correct dispose - handling
	remote_Context *pContext = (remote_Context *) pEnvRemote->pContext;
	iiop_BridgeImpl *pImpl = (iiop_BridgeImpl*) ( pContext->m_pBridgeImpl );
	
	if( pImpl->m_bDisposed )
	{
		prepareRuntimeExceptionClientSide( ppException );
		return;
	}
	
	typelib_InterfaceMethodTypeDescription *pMethodType = 0;
	typelib_InterfaceAttributeTypeDescription *pAttributeType = 0;

	if( typelib_TypeClass_INTERFACE_METHOD == pMemberType->eTypeClass )
	{
		pMethodType = ( typelib_InterfaceMethodTypeDescription * ) pMemberType;
	}
	
	if( typelib_TypeClass_INTERFACE_ATTRIBUTE == pMemberType->eTypeClass )
	{
		pAttributeType = ( typelib_InterfaceAttributeTypeDescription * ) pMemberType;
	}

	sal_Bool bIsLittleEndian = sal_True;
	
	RequestHeader_1_2 reqHdr;

	reqHdr.request_id = osl_incrementInterlockedCount( &( pImpl->m_nRequestId ) );
	reqHdr.response_flags = ( pMethodType && pMethodType->bOneWay ? 0 : 3 );
	
	reqHdr.target.nDiscriminator = 0;
	reqHdr.target.object_key = buildMarshaledObjectIdentifier(
		pOid,
		pInterfaceType->aBase.pTypeName,
		sal_True );


	if( pMethodType )
	{
		// Method call
		reqHdr.operation = OUString( pMethodType->aBase.pMemberName );
	}
	else if( pAttributeType && pReturn )
	{
		// attribute get
		OUStringBuffer o(56);
		o.appendAscii( "_get_" );
		o.append( pAttributeType->aBase.pMemberName ); 
		reqHdr.operation.theString = o.makeStringAndClear();
	}
	else // ( pAttributeType && pArgs )
	{
		// attribute set
		OUStringBuffer o(56);
		o.appendAscii( "_set_" );
		o.append( pAttributeType->aBase.pMemberName ); 
		reqHdr.operation.theString = o.makeStringAndClear();
	}

	ByteSequence aThreadId;
	{
		sal_Sequence *pThreadId = 0;
		uno_getIdOfCurrentThread( &pThreadId );
		aThreadId = ByteSequence( pThreadId );
		rtl_byte_sequence_release( pThreadId );
	}

	// create the appropriate context
	{
		ServiceContext context;
		buildThreadIdServiceContext(
			&context,
			aThreadId,
			bIsLittleEndian );
		reqHdr.service_context = ServiceContextList( &context , 1 );
	}
	
	// Pack the Request body
	Sequence< sal_Int8 > seqRequest;
	sal_Int32 nHeaderSize;
	{
		Marshal marsh( sal_True,
					   pEnvRemote,
					   dispatchExtractOidCallback,
					   REMOTE_MARSHALED_MSGHDR_SIZE);
		marsh <<= reqHdr;
		nHeaderSize = marsh.getPos();
		
		if( pMethodType )
		{
			sal_Int32 i;
			for( i = 0 ; i < pMethodType->nParams ; i ++ )
			{
				if( pMethodType->pParams[i].bIn )
				{
					typelib_TypeDescription *pType = 0;
					TYPELIB_DANGER_GET( &pType , pMethodType->pParams[i].pTypeRef );
					marsh.pack( ppArgs[i] , pType );
					TYPELIB_DANGER_RELEASE( pType );
				}
			}
		}
		else if( pAttributeType && pReturn )
		{
			// nothing to do !
		}
		else if( pAttributeType && ppArgs )
		{
			typelib_TypeDescription *pType = 0;
			TYPELIB_DANGER_GET( &pType , pAttributeType->pAttributeTypeRef );
			marsh.pack( ppArgs[0] , pType );
			TYPELIB_DANGER_RELEASE( pType );
		}
		else {
			OSL_ASSERT( 0 );
		}
		seqRequest = marsh.remove();
	}

	// ------------------
	// Create and pack the message header
	// ------------------
	MessageHeader_1_2 hdr;
	hdr.magic_1 = 'G';
	hdr.magic_2 = 'I';
	hdr.magic_3 = 'O';
	hdr.magic_4 = 'P';
	hdr.GIOP_version.major = CURRENT_IIOP_PROTOCOL_MAJOR;
	hdr.GIOP_version.minor = CURRENT_IIOP_PROTOCOL_MINOR;
	hdr.flags = 1;
	hdr.message_size = seqRequest.getLength() - REMOTE_MARSHALED_MSGHDR_SIZE;
	hdr.message_type = MsgType_1_1_Request;
	{
		// reuse the request sequence
		Marshal marsh( sal_True, seqRequest );
		marsh <<= hdr;
	}

	if( reqHdr.response_flags ) {
		// Non oneway
		uno_threadpool_attach( pImpl->m_hThreadPool );
	}

	////---------------------------------
	//// Logging 
	FILE *pFile = pImpl->m_pLogFile;
	if( pFile )
	{
		OString soOperation =
			OUStringToOString( reqHdr.operation.theString , RTL_TEXTENCODING_ASCII_US );
		fprintf( pFile ,
				 "calling [size=%ld(%d)] [rID=%ld] [synchron=%d] [name=%s]\n" ,
				 seqRequest.getLength()+12,
				 (int) (seqRequest.getLength() - nHeaderSize),
				 reqHdr.request_id,
				 reqHdr.response_flags == 3 ,
				 soOperation.pData->buffer
			);
	}
	///---------------------------------
	
    //---------------------------
	// Put the call on the line 
	//---------------------------
	pImpl->m_pWriter->enqueue( seqRequest );

	if( reqHdr.response_flags )
	{
		//---------------------------
		// Wait for the reply
		//---------------------------
		ReplyInfo * pData = 0;
		uno_threadpool_enter( pImpl->m_hThreadPool , (void **) &pData );

		uno_threadpool_detach( pImpl->m_hThreadPool );

		if( ! pData )
		{
			// An error ( maybe a hard abort ) has occured
			// generate a runtime exception !
			prepareRuntimeExceptionClientSide( ppException );
			uno_releaseIdFromCurrentThread();
			return;
		}

		////-----------------------------------------
		//// LOGGING 
		FILE *pFile = pImpl->m_pLogFile;
		if( pFile )
		{
			fprintf( pFile ,
					 "getting reply [size=%ld(%d)] [rID=%ld]\n" ,
					 pData->m_seqBody.getLength()+12,
			(int)( pData->m_seqBody.getLength() - pData->m_unmarshal.getPos()),
					 pData->m_replyHeader.request_id);
		}
		////-----------------------------------------------

		//--------------------------
		// Handle the reply, unpack data
		//--------------------------
		if( pData->m_replyHeader.reply_status == ReplyStatusType_1_2_NO_EXCEPTION )
		{
			//---------------------------------
			// alles ist gut
			//---------------------------------
			if( pMethodType )
			{
				if( pMethodType->pReturnTypeRef->eTypeClass != typelib_TypeClass_VOID )
				{
					typelib_TypeDescription *pType = 0;
					TYPELIB_DANGER_GET( &pType , pMethodType->pReturnTypeRef );
					pData->m_unmarshal.unpack( pReturn , pType );
					TYPELIB_DANGER_RELEASE( pType );
				}
			
				// out parameters
				sal_Int32 i;
				for( i = 0 ; i < pMethodType->nParams ; i ++ )
				{
					if( pMethodType->pParams[i].bOut )
					{
						typelib_TypeDescription *pType = 0;
						TYPELIB_DANGER_GET( &pType , pMethodType->pParams[i].pTypeRef );
						if( pMethodType->pParams[i].bIn )
						{
							uno_destructData( ppArgs[i] , pType , remote_release );
						}
						pData->m_unmarshal.unpack( ppArgs[i] , pType );
						TYPELIB_DANGER_RELEASE( pType );
					}
				}
			}
			else if( pAttributeType && pReturn ) 
			{
				typelib_TypeDescription *pType = 0;
				TYPELIB_DANGER_GET( &pType , pAttributeType->pAttributeTypeRef );
				pData->m_unmarshal.unpack( pReturn , pType );
				TYPELIB_DANGER_RELEASE( pType );
			}
			else if( pAttributeType && ppArgs )
			{
				// nothing to do
			}
			else {
				OSL_ASSERT( 0 );
			}
			*ppException = 0;
		}                                      
 		else if( pData->m_replyHeader.reply_status == ReplyStatusType_1_2_USER_EXCEPTION )
		{
			CorbaString8 string8;
			pData->m_unmarshal >>= string8;

			typelib_TypeDescription *pType = 0;
			typelib_typedescription_getByName(
				&pType ,
				string8.theString.pData );

			if( pType )
			{
				(*ppException)->pType = pType->pWeakRef;
				typelib_typedescriptionreference_acquire( (*ppException)->pType );
			
				(*ppException)->pData = rtl_allocateMemory( pType->nSize );
				pData->m_unmarshal.unpack( (*ppException)->pData , pType );
				typelib_typedescription_release( pType );
			}
			else
			{
				// The type of the exception could not be retrieved !
				// Construct a RuntimeException
				prepareRuntimeExceptionClientSide( ppException );
			}
		}
		delete pData;
	}
	else
	{
		//----------------
		// One way call
		//----------------
		*ppException = 0;

		// in general, one way call cannot have out parameters, but
		// to be robust, they are default constructed
		if( pMethodType->pReturnTypeRef->eTypeClass != typelib_TypeClass_VOID )
		{
			typelib_TypeDescription *pType = 0;
			TYPELIB_DANGER_GET( &pType , pMethodType->pReturnTypeRef );
			uno_constructData( pReturn , pType  );
			TYPELIB_DANGER_RELEASE( pType );
		}
		
		for( sal_Int32 i = 0 ; i < pMethodType->nParams ; i ++ )
		{
			if( pMethodType->pParams[i].bOut )
			{
				typelib_TypeDescription *pType = 0;
				TYPELIB_DANGER_GET( &pType , pMethodType->pParams[i].pTypeRef );
				uno_constructData( ppArgs[i] , pType );
				TYPELIB_DANGER_RELEASE( pType );
			}
		}
	}

	uno_releaseIdFromCurrentThread();
}

static sal_Bool equalsMethodName(
    const rtl_uString *pFullyQuallifiedName , rtl_uString *pMemberName )
{
	// pFullyQuallifiedName : com.sun.star.uno.XInterface::release
	// pMemberName release
	// --> just match the last charcters !
	if( pMemberName->length < pFullyQuallifiedName->length )
	{
		sal_Int32 nOffset = pFullyQuallifiedName->length - pMemberName->length;
		for( sal_Int32 i = pMemberName->length -1 ; i >= 0 ; i -- )
		{
			if( pMemberName->buffer[i] != pFullyQuallifiedName->buffer[i+nOffset] )
			{
				return sal_False;
			}
		}
		if( nOffset > 0 && ':' == pFullyQuallifiedName->buffer[nOffset-1] )
		{
			return sal_True;
		}
	}
	return sal_False;
}
static typelib_InterfaceMemberTypeDescription *getMemberTypeDescription(
	typelib_InterfaceTypeDescription *pInterface,
	const ::rtl::OUString &sMethodName )
{
	typelib_InterfaceMemberTypeDescription *pMemberType = 0;
	
	sal_Int32 i;
	for( i = 0 ; i < pInterface->nAllMembers ; i ++ )
	{
		if( equalsMethodName( pInterface->ppAllMembers[i]->pTypeName , sMethodName.pData ) )
		{
			typelib_typedescriptionreference_getDescription(
				(typelib_TypeDescription **) &pMemberType ,
				pInterface->ppAllMembers[i] );
			break;
		}
	}

	return pMemberType;
}


void SAL_CALL throwRuntimeExceptionServerSide(
	remote_Context *pContext,
	const RequestHeader_1_2 & reqHdr,
	const OUString & sMessage,
	sal_Bool bIsLittleEndian )
{
	Sequence < sal_Int8 > seqBody;
	{
		ReplyHeader_1_2 repHdr;
		repHdr.request_id = reqHdr.request_id;
		repHdr.service_context = reqHdr.service_context;
		repHdr.reply_status = ReplyStatusType_1_2_USER_EXCEPTION;

		Marshal marsh ( bIsLittleEndian, 0 , 0 , REMOTE_MARSHALED_MSGHDR_SIZE );

		// -------------------------------
		// Construct the RuntimeException
		// -------------------------------
		RuntimeException except;

		except.Message = sMessage;
		
		//---------------------
		// Treat the type string as a part of the protocol !
		//---------------------
		marsh <<= repHdr;
		CorbaString8 string8;
		string8.theString = OUString::createFromAscii( "com.sun.star.uno.RuntimeException" );
		marsh <<= string8;
		marsh <<= except;
		
		seqBody = marsh.remove();		
	}

	{
		MessageHeader_1_2 hdr;
		hdr.magic_1 = 'G';
		hdr.magic_2 = 'I';
		hdr.magic_3 = 'O';
		hdr.magic_4 = 'P';
		hdr.GIOP_version.major = CURRENT_IIOP_PROTOCOL_MAJOR;
		hdr.GIOP_version.minor = CURRENT_IIOP_PROTOCOL_MINOR;
		hdr.flags = bIsLittleEndian;
		hdr.message_size = seqBody.getLength() - REMOTE_MARSHALED_MSGHDR_SIZE;
		hdr.message_type = MsgType_1_1_Reply;

		Marshal marsh( bIsLittleEndian , seqBody );
		marsh <<= hdr;		
	}

	//---------------------------
	// put the reply on the line
	//---------------------------
	((iiop_BridgeImpl*)pContext->m_pBridgeImpl)->m_pWriter->enqueue( seqBody );
}




void SAL_CALL sendCloseConnection( uno_Environment *pEnvUno )
{
	remote_Context *pContext = ( remote_Context * ) pEnvUno->pContext;

	MessageHeader_1_2 hdr;
	hdr.magic_1 = 'G';
	hdr.magic_2 = 'I';
	hdr.magic_3 = 'O';
	hdr.magic_4 = 'P';
	hdr.GIOP_version.major = CURRENT_IIOP_PROTOCOL_MAJOR;
	hdr.GIOP_version.minor = CURRENT_IIOP_PROTOCOL_MINOR;
	hdr.flags = 1;
	hdr.message_size = 0;
	hdr.message_type = MsgType_1_1_CloseConnection;

	Marshal marsh( sal_True );
	marsh <<= hdr;

	((iiop_BridgeImpl*)pContext->m_pBridgeImpl)->m_pWriter->enqueue( marsh.remove() );
}



void SAL_CALL dispatchRequestServerSide( void *pThreadSpecificData )
{
	RequestInfo *pData = ( RequestInfo * ) pThreadSpecificData;
	remote_Context *pContext = ( remote_Context * ) pData->m_pEnvRemote->pContext;
	iiop_BridgeImpl *pImpl = ( iiop_BridgeImpl * ) pContext->m_pBridgeImpl;
	
	RemoteThreadCounter counter( pData->m_pEnvRemote );

	////----------------------------
	//// Logging
	////
	////---------------------------
	FILE *pFile = pImpl->m_pLogFile;
	if( pFile )
	{
		OString soOperation =
			OUStringToOString( pData->m_requestHeader.operation.theString ,
							   RTL_TEXTENCODING_ASCII_US );
		fprintf( pFile ,
				 "serving request [size=%ld(%d)] [rID=%ld] [synchron=%d] [name=%s]\n" ,
				 pData->m_seqBody.getLength()+12,
			 (int)(pData->m_seqBody.getLength() - pData->m_unmarshal.getPos()),
				 pData->m_requestHeader.request_id,
				 pData->m_requestHeader.response_flags == 3,
				 soOperation.pData->buffer
			);
	}
	////--------------------------------

	OSL_ASSERT( 0 == pData->m_requestHeader.target.nDiscriminator  );
	ObjectKey key;
	{
		Unmarshal unm2( pData->m_requestHeader.target.object_key.getConstArray(),
						pData->m_requestHeader.target.object_key.getLength(),
						pData->m_bIsLittleEndian );
		unm2 >>= key;
	}
	
	typelib_InterfaceTypeDescription *pInterfaceType = 0;
	typelib_typedescription_getByName( (typelib_TypeDescription ** ) &pInterfaceType,
									   key.sType.theString.pData );

	OUString sMethodName = pData->m_requestHeader.operation.theString;

	if( ! pInterfaceType || pImpl->m_bDisposed )
	{
		// -----------------
		// No Type info available in this process or disposed environment !
		// -----------------
		if( pData->m_requestHeader.response_flags  )
		{
			// The client is waiting for a response
			throwRuntimeExceptionServerSide(
				pContext,
				pData->m_requestHeader ,
				OUString::createFromAscii( "Unknown interface type" ),
				pData->m_bIsLittleEndian);
		}
		delete pData;
		return;
	}

	sal_Bool bIsReleaseCall =
		(! sMethodName.compareToAscii( REMOTE_RELEASE_METHOD_NAME ) );	

	//------------------
	// Locate appropriate interface
	//------------------
	remote_Interface *pRemoteI = 0;
	pData->m_pEnvRemote->pExtEnv->getRegisteredInterface(
		pData->m_pEnvRemote->pExtEnv ,
		( void **  ) &pRemoteI ,
		key.sOid.theString.pData,
		pInterfaceType );


	uno_Any any;
	uno_Any *pAny = 0;
	if( ! pRemoteI )
	{
		// -------------------
		// Initial object  ?
		// ------------------
		// be robust : Sending a release on a not constructed object
		//             provokes an segfault. Make sure, the call
		//             is not a release call.
		if( !bIsReleaseCall && pContext->m_pInstanceProvider )
		{
			pAny = &any;
			pContext->m_pInstanceProvider->getInstance(
				pContext->m_pInstanceProvider,
				pData->m_pEnvRemote,
				&pRemoteI,
				key.sOid.theString.pData,
				pInterfaceType,
				&pAny );
		}
		else
		{
			// Requested object could not be located in this environment,
			// throw a runtimeexception
  			if( pData->m_requestHeader.response_flags  )
  			{
  				// The client is waiting for a response
  				throwRuntimeExceptionServerSide(
  					pContext,
  					pData->m_requestHeader,
  					OUString::createFromAscii( "iiop: No instance provider set" ),
  					pData->m_bIsLittleEndian);
  			}
  			delete pData;
  			typelib_typedescription_release( (typelib_TypeDescription *) pInterfaceType );
			return;
		}
	}

	//-------------------------------
	// get the member typedescription
	//-------------------------------
	sal_Bool bIsGetter = ( 0 == sMethodName.compareToAscii( "_get_" , 5 ) );
	sal_Bool bIsSetter = ( 0 == sMethodName.compareToAscii( "_set_" , 5 ) );
	if( bIsGetter || bIsSetter )
	{
		sMethodName = sMethodName.copy( 5 );
	}

	typelib_InterfaceMemberTypeDescription *pMemberType =
		getMemberTypeDescription( pInterfaceType , sMethodName );

	if( ! pMemberType )
	{
		if( pData->m_requestHeader.response_flags  )
		{
			// The client is waiting for a response
			throwRuntimeExceptionServerSide(
				pContext,
				pData->m_requestHeader,
				OUString::createFromAscii( "Incompatible interfaces, unknown method !" ),
				pData->m_bIsLittleEndian);
		}
		delete pData;
		typelib_typedescription_release( (typelib_TypeDescription *) pInterfaceType );
		pRemoteI->release( pRemoteI );
		return;
	}

	// ------------------------
	// got the method type 
	// ------------------------
	typelib_InterfaceMethodTypeDescription *pMethodType = 0;
	typelib_InterfaceAttributeTypeDescription *pAttributeType = 0;
	typelib_TypeDescription *pReturnType = 0;
	typelib_TypeDescription **ppArgType = 0;
	sal_Int32 nArgCount = 0;
	sal_Bool *pbIsIn = 0;
	sal_Bool *pbIsOut = 0;

	void *pReturn = 0;
	void **ppArgs = 0;
	sal_Int32 i;
	
	//-------------------------------
	// gather the types ...
	//-------------------------------
	if( typelib_TypeClass_INTERFACE_ATTRIBUTE == pMemberType->aBase.eTypeClass )
	{
		//--------------------------
		// Prepare Attribute Access
		//--------------------------
		pAttributeType = ( typelib_InterfaceAttributeTypeDescription * ) pMemberType;

		if( bIsSetter )
		{
			ppArgType = ( typelib_TypeDescription ** ) alloca( sizeof( void * ) );
			ppArgType[0] = 0;
			TYPELIB_DANGER_GET( & ( ppArgType[0] ) , pAttributeType->pAttributeTypeRef );
			pbIsIn  = ( sal_Bool * ) alloca( sizeof( sal_Bool ) );
			pbIsOut = ( sal_Bool * ) alloca( sizeof( sal_Bool ) );
			pbIsIn[0]  = sal_True;
			pbIsOut[0] = sal_False;
			nArgCount = 1;
		}
		else
		{
			TYPELIB_DANGER_GET( &pReturnType , pAttributeType->pAttributeTypeRef );
		}
	}
	else if( typelib_TypeClass_INTERFACE_METHOD == pMemberType->aBase.eTypeClass )
	{
		//---------------------
		// Prepare Method call
		//---------------------
		pMethodType = (typelib_InterfaceMethodTypeDescription * ) pMemberType;
		nArgCount =  pMethodType->nParams;
		pbIsIn  = (sal_Bool * ) alloca( sizeof( sal_Bool ) * nArgCount );
		pbIsOut = (sal_Bool * ) alloca( sizeof( sal_Bool ) * nArgCount );
		ppArgType = ( typelib_TypeDescription ** ) alloca( sizeof(void *) * nArgCount );
		for( sal_Int32 i = 0 ; i < nArgCount ; i ++ )
		{
			ppArgType[i] = 0;
			TYPELIB_DANGER_GET( & ( ppArgType[i] ) , pMethodType->pParams[i].pTypeRef );
			pbIsIn[i] = pMethodType->pParams[i].bIn;
			pbIsOut[i] = pMethodType->pParams[i].bOut;
		}
		TYPELIB_DANGER_GET( &pReturnType, pMethodType->pReturnTypeRef );
	}


	// ------------------
	// now extract the in parameters !
	// ------------------
	sal_Bool bContinue = sal_True;
	if( pReturnType )
	{
		pReturn = alloca( pReturnType->nSize );
	}
	ppArgs  = (void **) alloca( nArgCount * sizeof( void * ) );
	for( i = 0; i < nArgCount ; i ++ )
	{
		ppArgs[i] = alloca( ppArgType[i]->nSize );
		if( pbIsIn[i] )
		{
			// everything needs to be constructed
			bContinue = pData->m_unmarshal.unpack( ppArgs[i], ppArgType[i] ) && bContinue;
		}
	}

	//-------------------------
	// Errors during extracting parameters ?
	//------------------------
	if( ! bContinue )
	{
		if( pData->m_requestHeader.response_flags )
		{
			// The client is waiting for a response
			throwRuntimeExceptionServerSide(
				pContext,
				pData->m_requestHeader,
				OUString::createFromAscii( "Errors during extracting parameters" ),
				pData->m_bIsLittleEndian);
		}

		if( pReturnType )
		{
			TYPELIB_DANGER_RELEASE( pReturnType );
		}
		for( i = 0; i < nArgCount ; i ++ )
		{
			// destruct in parameters
			if( pbIsIn[i] )
			{
				uno_destructData( ppArgs[i] , ppArgType[i] , 0 );
			}
			TYPELIB_DANGER_RELEASE( ppArgType[i] );
		}
	
		delete pData;
		typelib_typedescription_release( (typelib_TypeDescription * ) pMemberType );
		typelib_typedescription_release( (typelib_TypeDescription * ) pInterfaceType );		
		
		pRemoteI->release( pRemoteI );
		return;
	}


	if( pAny )
	{
		// exception during extraction
	}
	else if( ! pRemoteI )
	{
		// May only occur during the queryInterface call on the initial object !!!
		// construct the return value
		uno_type_any_construct( (uno_Any*) pReturn , 0 , 0 , 0 );
	}
	else
	{
		if( bIsReleaseCall )
		{
			//--------------------------
			// delegate the release call to the proxy
			//--------------------------
			pRemoteI->release( pRemoteI );
		}
		else
		{		
			//--------------------------
			// do the call !
			//--------------------------
			pAny = &any;
			pRemoteI->pDispatcher(
				pRemoteI,
				(typelib_TypeDescription * ) pMemberType,
				pReturn,
				ppArgs,
				&pAny );
		}
	}
	
	if( pData->m_requestHeader.response_flags ) {
		//-----------------------
		// pack reply
		//-----------------------
		ReplyHeader_1_2 repHdr;
		repHdr.request_id = pData->m_requestHeader.request_id;
		repHdr.service_context = pData->m_requestHeader.service_context;

		Marshal marsh( pData->m_bIsLittleEndian,
					   pData->m_pEnvRemote,
					   dispatchExtractOidCallback ,
					   REMOTE_MARSHALED_MSGHDR_SIZE );
		sal_Int32 nHeaderSize;
		if(pAny)
		{
			//--------------------
			// an exception was thrown
			//--------------------
			repHdr.reply_status = ReplyStatusType_1_2_USER_EXCEPTION;

			marsh <<= repHdr;
			nHeaderSize = marsh.getPos();

			//---------------------
			// Treat the type string as a part of the protocol !
			//---------------------
			CorbaString8 string8;
			string8.theString = OUString( any.pType->pTypeName );
			marsh <<= string8;
			
			marsh.pack( any.pData, any.pType );

			uno_any_destruct( pAny , remote_release );

			// destroy in parameters
			for( sal_Int32 i = 0 ; i < nArgCount ; i ++ )
			{
				if( pbIsIn[i] )
				{
					uno_destructData( ppArgs[i] , ppArgType[i] , remote_release );
				}
			}
		}
		else
		{
			//---------------------------
			// alles ist gut ...
			//--------------------------
			repHdr.reply_status = ReplyStatusType_1_2_NO_EXCEPTION;			
			marsh <<= repHdr;
			nHeaderSize = marsh.getPos();

			if( pReturnType )
			{
				marsh.pack( pReturn, pReturnType );
				uno_destructData( pReturn , pReturnType , 0 );
			}
			for( sal_Int32 i = 0 ; i < nArgCount ; i ++ )
			{
				if( pbIsOut[i] )
				{
					marsh.pack( ppArgs[i] , ppArgType[i] );
				}
				uno_destructData( ppArgs[i], ppArgType[i] , remote_release );
			}
		}

		Sequence < sal_Int8 > seqBody = marsh.remove();
		
		MessageHeader_1_2 hdr;
		hdr.magic_1 = 'G';
		hdr.magic_2 = 'I';
		hdr.magic_3 = 'O';
		hdr.magic_4 = 'P';
		hdr.GIOP_version.major = CURRENT_IIOP_PROTOCOL_MAJOR;
		hdr.GIOP_version.minor = CURRENT_IIOP_PROTOCOL_MINOR;
		hdr.flags = pData->m_bIsLittleEndian;
		hdr.message_size = seqBody.getLength() - REMOTE_MARSHALED_MSGHDR_SIZE;
		hdr.message_type = MsgType_1_1_Reply;

		{
			// use only one sequence
			Marshal marsh( pData->m_bIsLittleEndian, seqBody );
			marsh <<= hdr;
		}

		////-----------------------------------------
		//// LOGGING 
		FILE *pFile = pImpl->m_pLogFile;
		if( pFile )
		{
			OString soOperation =
				OUStringToOString( pData->m_requestHeader.operation.theString ,
								   RTL_TEXTENCODING_ASCII_US );
			fprintf( pFile ,
					 "replying [size=%ld(%d)] [rID=%ld] [name=%s]\n" ,
					 seqBody.getLength()+12,
					 (int) (seqBody.getLength()- nHeaderSize),
					 pData->m_requestHeader.request_id,
					 soOperation.pData->buffer
				);
		}
		////-----------------------------------------------

		//---------------------------
		// put the reply on the line
		//---------------------------
		pImpl->m_pWriter->enqueue( seqBody );
	}

	else
	{
		// Oneway call, destruct in parameters
		for( sal_Int32 i = 0 ; i < pMethodType->nParams ; i ++ )
		{
			// usually all parameters must be in parameters, but to be robust ...
			if( pbIsIn[i] )
			{
				uno_destructData( ppArgs[i] , ppArgType[i] , 0 );
			}
		}

		if(pAny)
		{
			uno_any_destruct( pAny , remote_release );
		}		
	}

	delete pData;

	//-------------------
	// free the types ...
	//-------------------
	if( pReturnType )
	{
		TYPELIB_DANGER_RELEASE( pReturnType );
	}
	for( i = 0; i < nArgCount ; i ++ )
	{
		TYPELIB_DANGER_RELEASE( ppArgType[i] );
	}

	
	typelib_typedescription_release( (typelib_TypeDescription * ) pMemberType );
	typelib_typedescription_release( (typelib_TypeDescription * ) pInterfaceType );
		
	pRemoteI->release( pRemoteI );
}


} // end namespace bridges_remote
