/*************************************************************************
 *
 *  $RCSfile: canvasbase.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:02:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_CANVAS_CANVASBASE_HXX
#define INCLUDED_CANVAS_CANVASBASE_HXX

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_XCANVAS_HPP_
#include <drafts/com/sun/star/lang/XCanvas.hpp>
#endif

#ifndef _OSL_MUTEX_HXX_ 
#include <osl/mutex.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif


namespace canvas { namespace internal
{
    /** Helper template to handle XCanvas method forwarding to CanvasHelper

    	Use this helper to handle the XCanvas part of your
    	implementation. In theory, we could have provided CanvasHelper
    	and CanvasBase as a single template, but that would duplicate
    	a lot of code now residing in CanvasHelper only.

        This template basically interposes itself between the full
        interface you implement (i.e. not restricted to XCanvas. The
        problem with UNO partial interface implementation actually is,
        that you cannot do it the plain way, since deriving from a
        common base subclass always introduces the whole set of pure
        virtuals, that your baseclass helper just overrided) and your
        implementation class. You then only have to implement the
        functionality <em>besides</em> XCanvas.

        @tpl Base
        Base class to use, most probably one of the
        WeakComponentImplHelperN templates with the appropriate
        interfaces. At least XCanvas should be among them (why else
        would you use this template, then?). Base class must have an
        Base( const Mutex& ) constructor (like the
        WeakComponentImplHelperN templates have).

        @tpl CanvasHelper
        Canvas helper implementation for the backend in question

        @tpl Mutex
        Lock strategy to use. Defaults to using the
        OBaseMutex-provided lock.  Everytime one of the methods is
        entered, an object of type Mutex is created with m_aMutex as
        the sole parameter, and destroyed again when the method scope
        is left.
     */
    template< class Base, class CanvasHelper, class Mutex=::osl::MutexGuard > class CanvasBase : public ::comphelper::OBaseMutex, public Base
    {
    public:
        typedef Base 			BaseType;
        typedef CanvasHelper	HelperType;
        typedef Mutex			MutexType;

        /** Create CanvasBase
         */
        CanvasBase() :
            BaseType( m_aMutex ),
            maCanvasHelper(),
            mbSurfaceDirty( true )
        {
        }

        virtual void SAL_CALL disposing()
        {
            MutexType aGuard( m_aMutex );

            maCanvasHelper.disposing();
        }

        // XCanvas
        virtual void SAL_CALL drawPoint( const ::drafts::com::sun::star::geometry::RealPoint2D& 	aPoint, 
                                         const ::drafts::com::sun::star::rendering::ViewState& 		viewState, 
                                         const ::drafts::com::sun::star::rendering::RenderState& 	renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );

            mbSurfaceDirty = true;

            maCanvasHelper.drawPoint( aPoint, viewState, renderState );
        }

        virtual void SAL_CALL drawLine( const ::drafts::com::sun::star::geometry::RealPoint2D& 	aStartPoint, 
                                        const ::drafts::com::sun::star::geometry::RealPoint2D& 	aEndPoint, 
                                        const ::drafts::com::sun::star::rendering::ViewState& 	viewState, 
                                        const ::drafts::com::sun::star::rendering::RenderState& renderState	) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            maCanvasHelper.drawLine(aStartPoint, aEndPoint, viewState, renderState);
        }

        virtual void SAL_CALL drawBezier( const ::drafts::com::sun::star::geometry::RealBezierSegment2D& 	aBezierSegment, 
                                          const ::drafts::com::sun::star::geometry::RealPoint2D& 			aEndPoint,
                                          const ::drafts::com::sun::star::rendering::ViewState& 			viewState, 
                                          const ::drafts::com::sun::star::rendering::RenderState& 			renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            maCanvasHelper.drawBezier(aBezierSegment, aEndPoint, viewState, renderState);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                             const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                             const ::drafts::com::sun::star::rendering::RenderState& 										renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.drawPolyPolygon(xPolyPolygon, viewState, renderState);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokePolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                               const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                               const ::drafts::com::sun::star::rendering::RenderState& 											renderState, 
                               const ::drafts::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.strokePolyPolygon(xPolyPolygon, viewState, renderState, strokeAttributes);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokeTexturedPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                       const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                                       const ::drafts::com::sun::star::rendering::RenderState& 											renderState, 
                                       const ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::rendering::Texture >& 			textures, 
                                       const ::drafts::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.strokeTexturedPolyPolygon(xPolyPolygon, viewState, renderState, textures, strokeAttributes);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	strokeTextureMappedPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                            const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                                            const ::drafts::com::sun::star::rendering::RenderState& 										renderState, 
                                            const ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::rendering::Texture >& 			textures, 
                                            const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::geometry::XMapping2D >& 		xMapping, 
                                            const ::drafts::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.strokeTextureMappedPolyPolygon(xPolyPolygon, viewState, renderState, textures, xMapping, strokeAttributes);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >   SAL_CALL 	
        	queryStrokeShapes( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                               const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                               const ::drafts::com::sun::star::rendering::RenderState& 											renderState, 
                               const ::drafts::com::sun::star::rendering::StrokeAttributes& 									strokeAttributes ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.queryStrokeShapes(xPolyPolygon, viewState, renderState, strokeAttributes);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                             const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                             const ::drafts::com::sun::star::rendering::RenderState& 										renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.fillPolyPolygon(xPolyPolygon, viewState, renderState );
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillTexturedPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& xPolyPolygon, 
                                     const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                                     const ::drafts::com::sun::star::rendering::RenderState& 										renderState, 
                                     const ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::rendering::Texture >& 		textures ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.fillTexturedPolyPolygon(xPolyPolygon, viewState, renderState, textures);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	fillTextureMappedPolyPolygon( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& 	xPolyPolygon, 
                                          const ::drafts::com::sun::star::rendering::ViewState& 											viewState, 
                                          const ::drafts::com::sun::star::rendering::RenderState& 											renderState, 
                                          const ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::rendering::Texture >& 			textures, 
                                          const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::geometry::XMapping2D >& 		xMapping ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.fillTextureMappedPolyPolygon(xPolyPolygon, viewState, renderState, textures, xMapping);
        }


        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCanvasFont > SAL_CALL 
        	createFont( const ::drafts::com::sun::star::rendering::FontRequest& 							fontRequest, 
                        const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& 	extraFontProperties, 
                        const ::drafts::com::sun::star::geometry::Matrix2D& 								fontMatrix ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            return maCanvasHelper.createFont( fontRequest, extraFontProperties, fontMatrix );
        }


        virtual ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::rendering::FontInfo > SAL_CALL 
        	queryAvailableFonts( const ::drafts::com::sun::star::rendering::FontInfo& 								aFilter, 
                                 const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& 	aFontProperties ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            return maCanvasHelper.queryAvailableFonts( aFilter, aFontProperties );
        }


        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 
        	drawText( const ::drafts::com::sun::star::rendering::StringContext& 									text, 
                      const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCanvasFont >& 	xFont, 
                      const ::drafts::com::sun::star::rendering::ViewState& 										viewState, 
                      const ::drafts::com::sun::star::rendering::RenderState& 										renderState, 
                      sal_Int8 																						textDirection ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.drawText(text, xFont, viewState, renderState, textDirection);
        }


        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 
        	drawTextLayout( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XTextLayout >& layoutetText, 
                            const ::drafts::com::sun::star::rendering::ViewState& 										viewState, 
                            const ::drafts::com::sun::star::rendering::RenderState& 									renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.drawTextLayout( layoutetText, viewState, renderState );
        }


        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawBitmap( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmap >& xBitmap, 
                        const ::drafts::com::sun::star::rendering::ViewState& 									viewState, 
                        const ::drafts::com::sun::star::rendering::RenderState& 								renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.drawBitmap(xBitmap, viewState, renderState);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCachedPrimitive > SAL_CALL 	
        	drawBitmapModulated( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XBitmap >& 	xBitmap, 
                                 const ::drafts::com::sun::star::rendering::ViewState& 										viewState, 
                                 const ::drafts::com::sun::star::rendering::RenderState& 									renderState ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            mbSurfaceDirty = true;

            return maCanvasHelper.drawBitmapModulated(xBitmap, viewState, renderState);
        }

        virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XGraphicDevice >   SAL_CALL 	
        	getDevice() throw (::com::sun::star::uno::RuntimeException)
        {
            MutexType aGuard( m_aMutex );
            
            return maCanvasHelper.getDevice();
        }


    protected:
        ~CanvasBase() {} // we're a ref-counted UNO class. _We_ destroy ourselves.

        HelperType 			maCanvasHelper;
        mutable bool		mbSurfaceDirty;

    private:
        // default: disabled copy/assignment
        CanvasBase(const CanvasBase&);
        CanvasBase& operator=( const CanvasBase& );
    };
} }

#endif /* INCLUDED_CANVAS_CANVASBASE_HXX */
