/*************************************************************************
 *
 *  $RCSfile: linepolypolygonbase.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:02:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CANVAS_LINEPOLYPOLYGONBASE_HXX
#define _CANVAS_LINEPOLYPOLYGONBASE_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE2_HXX_
#include <cppuhelper/compbase2.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_XLINEPOLYPOLYGON2D_HPP_
#include <drafts/com/sun/star/rendering/XLinePolyPolygon2D.hpp>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYPOLYGON_HXX
#include <basegfx/polygon/b2dpolypolygon.hxx>
#endif

namespace canvas 
{ 
    namespace tools
    {
		typedef ::cppu::WeakComponentImplHelper2< 
			::drafts::com::sun::star::rendering::XLinePolyPolygon2D,
            ::com::sun::star::lang::XServiceInfo > LinePolyPolygon_Base;

		class LinePolyPolygonBase : public ::comphelper::OBaseMutex, public LinePolyPolygon_Base
		{
		public:
			explicit LinePolyPolygonBase( const ::basegfx::B2DPolyPolygon& );

			// XPolyPolygon2D
			virtual void SAL_CALL addPolyPolygon( const ::drafts::com::sun::star::geometry::RealPoint2D& position, const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XPolyPolygon2D >& polyPolygon ) throw (::com::sun::star::uno::RuntimeException);
			virtual sal_Int32 SAL_CALL getNumberOfPolygons(  ) throw (::com::sun::star::uno::RuntimeException);
			virtual sal_Int32 SAL_CALL getNumberOfPolygonPoints( sal_Int32 polygon ) throw (::com::sun::star::uno::RuntimeException);
			virtual ::drafts::com::sun::star::rendering::FillRule SAL_CALL getFillRule(  ) throw (::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL setFillRule( ::drafts::com::sun::star::rendering::FillRule fillRule ) throw (::com::sun::star::uno::RuntimeException);
			virtual sal_Bool SAL_CALL isClosed( sal_Int32 index ) throw (::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL setClosed( sal_Int32 index, sal_Bool closedState ) throw (::com::sun::star::uno::RuntimeException);

			// XLinePolyPolygon2D
			virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::geometry::RealPoint2D > > SAL_CALL getPoints( sal_Int32 nPolygonIndex, sal_Int32 nNumberOfPolygons, sal_Int32 nPointIndex, sal_Int32 nNumberOfPoints ) throw (::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL setPoints( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::drafts::com::sun::star::geometry::RealPoint2D > >& points, sal_Int32 nPolygonIndex, sal_Int32 nPointIndex ) throw (::com::sun::star::uno::RuntimeException);
			virtual ::drafts::com::sun::star::geometry::RealPoint2D SAL_CALL getPoint( sal_Int32 nPolygonIndex, sal_Int32 nPointIndex ) throw (::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL setPoint( const ::drafts::com::sun::star::geometry::RealPoint2D& point, sal_Int32 nPolygonIndex, sal_Int32 nPointIndex ) throw (::com::sun::star::uno::RuntimeException);

	        ::basegfx::B2DPolyPolygon getPolyPolygon() const;

		protected:
			~LinePolyPolygonBase(); // we're a ref-counted UNO class. _We_ destroy ourselves.

		private:
			// default: disabled copy/assignment
			LinePolyPolygonBase(const LinePolyPolygonBase&);
			LinePolyPolygonBase& operator=( const LinePolyPolygonBase& );

	        ::basegfx::B2DPolyPolygon	maPolyPoly;
		};
    }
}

#endif /* _CANVAS_LINEPOLYPOLYGONBASE_HXX */
