/*************************************************************************
 *
 *  $RCSfile: dx_surfacemanager.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:25:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DXCANVAS_SURFACEMANAGER_HXX
#define _DXCANVAS_SURFACEMANAGER_HXX

#include <dx_winstuff.hxx>
#include <dx_device.hxx>
#include <dx_surface.hxx>
#include <dx_texture.hxx>

#ifndef _BGFX_VECTOR_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif

namespace dxcanvas
{
	/* Definition of SurfaceManager class */

    class SurfaceManager
    {
    public:
        static SurfaceManager& getInstance();

        /** Create a new hardware-accelerated surface

        	@param rSize
            Size of the surface in pixel

            @param priority
            Priority of the surface (how important it is to keep it in
            display mem). Where 0 means completely unimportant, and 1
            means highest priority.

            @return a shared pointer to the newly generated
            surface. Simply release all references to the surface to
            destroy it.
         */
        PlainSurfaceSharedPtr 	createSurface( const ::basegfx::B2ISize& 	rSize, 
                                               double 						priority, 
                                               const DeviceSharedPtr& 		rDevice );
        
        /** Create a new hardware-accelerated texture surface

        	@param rSize
            Size of the texture in pixel

            @param priority
            Priority of the texture (how important it is to keep it in
            display mem). Where 0 means completely unimportant, and 1
            means highest priority.

            @return a shared pointer to the newly generated
            texture. Simply release all references to the texture to
            destroy it.
         */
        TextureSharedPtr	createTexture( const ::basegfx::B2ISize& 	rSize, 
                                           double 						priority, 
                                           const DeviceSharedPtr& 		rDevice );

    private:
        friend struct InitInstance;

        // singleton
        SurfaceManager();
        ~SurfaceManager();

        TextureSharedPtr	implCreateTexture( const ::basegfx::B2ISize& 	rSize, 
                                               const ::basegfx::B2ISize& 	rOrigSize, 
                                               double 						priority, 
                                               const DeviceSharedPtr& 		rDevice );

        bool clearSurface( IDirectDrawSurface*, DWORD nFillColor ) const;
        
        // default: disabled copy/assignment
        SurfaceManager(const SurfaceManager&);
        SurfaceManager& operator=( const SurfaceManager& );

    };

}

#endif /* _DXCANVAS_SURFACEMANAGER_HXX */
