/*************************************************************************
 *
 *  $RCSfile: dx_textlayout_drawhelper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:26:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TEXTLAYOUT_DRAWHELPER_HXX
#define _TEXTLAYOUT_DRAWHELPER_HXX

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_STRINGCONTEXT_HPP__
#include <drafts/com/sun/star/rendering/StringContext.hpp>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_XCANVASFONT_HPP__
#include <drafts/com/sun/star/rendering/XCanvasFont.hpp>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_GEOMETRY_MATRIX2D_HPP__
#include <drafts/com/sun/star/geometry/Matrix2D.hpp>
#endif

#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif

#ifndef _DRAFTS_COM_SUN_STAR_RENDERING_XGRAPHICDEVICE_HPP__
#include <drafts/com/sun/star/rendering/XGraphicDevice.hpp>
#endif

#ifndef _BGFX_VECTOR_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif

// predefines
class VirtualDevice;

namespace dxcanvas
{
	class TextLayoutDrawHelper
	{
		HDC										maHDC;
		::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XGraphicDevice > mxGraphicDevice;
		VirtualDevice*							mpVirtualDevice;

	public:
		TextLayoutDrawHelper(
			HDC aHDC,
			const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XGraphicDevice >& xGraphicDevice);
		~TextLayoutDrawHelper();

		// draw text
		void drawText(
			const ::drafts::com::sun::star::rendering::ViewState& rViewState, 
			const ::drafts::com::sun::star::rendering::RenderState& rRenderState,
			const ::basegfx::B2ISize& rOutputOffset,
			const ::drafts::com::sun::star::rendering::StringContext& rText,
			const ::com::sun::star::uno::Sequence< double >& rLogicalAdvancements,
			const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::rendering::XCanvasFont >& rCanvasFont,
			const ::drafts::com::sun::star::geometry::Matrix2D& rFontMatrix);
	};
}

#endif /* _TEXTLAYOUT_DRAWHELPER_HXX */
// eof
