/*************************************************************************
 *
 *  $RCSfile: dx_texture.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:26:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DXCANVAS_TEXTURE_HXX
#define _DXCANVAS_TEXTURE_HXX

#include <dx_winstuff.hxx>
#include <dx_surface.hxx>

#ifndef _BGFX_RANGE_B1DRANGE_HXX
#include <basegfx/range/b1drange.hxx>
#endif
#ifndef _BGFX_RANGE_B2IRECTANGLE_HXX
#include <basegfx/range/b2irectangle.hxx>
#endif
#ifndef _BGFX_VECTOR_B2ISIZE_HXX
#include <basegfx/vector/b2isize.hxx>
#endif
#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

namespace dxcanvas
{
	/* Definition of Texture class */

    class Texture : public Surface
    {
    public:
        /** Create a DirectX texture holder

			@param rDDSurface
            Surface interface

            @param rD3DTexture
            Texture interface

            @param rTextureRect
            Rectangle within whole texture (textures might be shared
            between various smaller Texture instances), where this
            object's data resides

            @param rTextureTotalSize
            Total size of the whole texture (the object represented by
            the IDirect3DTexture interface). Together with
            rTextureRect, this can be used to calculate the necessary
            u and v parameter ranges.

            @param rTextureScreenSize
            The size of the texture as it shall appear on
            screen. Needed to calc the scaling afterwards, if
            SurfaceManager decided to shrink the surface.

            @param bIsShared
            Whether this Texture shares an IDirect3DTexture object
            with other Textures.
         */
        Texture( const COMReference<IDirectDrawSurface>& 	rDDSurface,
                 const COMReference<IDirect3DTexture2>& 	rD3DTexture,
                 const ::basegfx::B2IRectangle&				rTextureRect,
                 const ::basegfx::B2ISize&					rTextureTotalSize,
                 const ::basegfx::B2ISize&					rTextureScreenSize,
                 bool										bIsShared );
        virtual ~Texture();

        /** Request a Gdiplus::Graphics for this surface

        	The Graphics is wrapped in a RAII class, which
        	transparently handles resource release when getting
        	destroyed.

        	@return a SurfaceGraphics for this surface, which might be
        	non-functional if something went wrong.

            @see getDC
         */
        virtual SurfaceGraphicsSharedPtr getGraphics();

        /** Query whether the content of this surface was lost

			Content of DirectX surfaces is somewhat volatile, in that
			other applications can in some circumstances claim video
			resources and thus destroy the content
         */
        virtual bool contentLost() const;

    private:
        friend class Device;

        /** Calc range of u variable to include only this texture
         */
        ::basegfx::B1DRange calcURange() const;

        /** Calc range of v variable to include only this texture
         */
        ::basegfx::B1DRange calcVRange() const;

        // default: disabled copy/assignment
        Texture(const Texture&);
        Texture& operator=( const Texture& );

        COMReference<IDirectDrawSurface> 	mpSurface;
        COMReference<IDirect3DTexture2> 	mpTexture;
        ::basegfx::B2IRectangle				maTextureRect;
        ::basegfx::B2ISize					maTextureTotalSize;
        ::basegfx::B2ISize					maTextureScreenSize;
        bool								mbIsShared;
    };

    typedef ::boost::shared_ptr< Texture > 	TextureSharedPtr;

}

#endif /* _DXCANVAS_TEXTURE_HXX */
