/*************************************************************************
 *
 *  $RCSfile: SchMemChart.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:11:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SCH_MEMCHRT_HXX
#define _SCH_MEMCHRT_HXX

#ifndef _SCH_CELLRANGES_HXX_
#include "cellranges.hxx"
#endif

// interfaces and types
#ifndef _COM_SUN_STAR_CHART_CHARTDATAROWSOURCE_HPP_
#include <com/sun/star/chart/ChartDataRowSource.hpp>
#endif

// interfaces and types from chart2
#ifndef _COM_SUN_STAR_CHART2_XDATASOURCE_HPP_
#include <com/sun/star/chart2/XDataSource.hpp>
#endif
// #ifndef _COM_SUN_STAR_CHART2_XDATASINK_HPP_
// #include <com/sun/star/chart2/XDataSink.hpp>
// #endif
// #ifndef _COM_SUN_STAR_CHART2_XDATASEQUENCE_HPP_
// #include <com/sun/star/chart2/XDataSequence.hpp>
// #endif

// for old stuff
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif

// for auto_ptr
#include <memory>

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

// ________________________________________
// forward declarations

class SvNumberFormatter;

namespace com { namespace sun { namespace star
{
    namespace util
    {
        class XNumberFormatsSupplier;
    }
}}}

namespace chart { namespace wrapper { namespace impl {
    class ChartRangeHelper;
}}}

// ________________________________________

class SchMemChart
{
public:

// Calc
// ----

// Get(Col|Row)Count
// Get(Col|Row)Text
// SetNumberFormatter
// SetReadOnly
// SetSelectionHdl
// SomeData1
// SomeData2
// SomeData3
// SomeData4
// [SG]etChartRange
// [SG]etData

// chartarr
// --------

// CopySettings: (new method ?)
// [SG]et(Row|Col)?Translation
// [SG]etMainTitle
// [SG]etSubTitle
// [SG]et[XYZ]AxisTitle

// SetDataType
// SetNumFormatId(Col|Row)

// Writer
// ------

// Get(Col|Row)Count
// GetChartRange
// Set(Col|Row)Text
// SetNumberFormatter
// SetReadOnly
// SetSelectionHdl
// SetSubTitle
// Set[XYZ]AxisTitle
// SomeData[1234]
// [GS]etMainTitle
// [GS]etMainTitle

	short GetColCount() const;
	short GetRowCount() const;

    /// get table ranges for entire chart
    SchChartRange GetChartRange() const;
    /// set table ranges for entire chart
    void SetChartRange( const SchChartRange & rRange );

    // still necessary ?
    // note: eType is an SvNumberFormatter option (see svtools/zforlist.hxx)
// 	void SetDataType( short eType );

    void SetNumFormatIdRow( const long nRow, const long nFmtId );
	void SetNumFormatIdCol( const long nCol, const long nFmtId );
    void SetNumberFormatter( SvNumberFormatter* pNumFormatter );
    void SetReadOnly( BOOL bNewValue );
    void SetSelectionHdl( const Link & rLink );

    String GetMainTitle()  const;
	String GetSubTitle()   const;
	String GetXAxisTitle() const;
	String GetYAxisTitle() const;
	String GetZAxisTitle() const;

	void SetMainTitle(  const String& rText );
	void SetSubTitle(   const String& rText );
	void SetXAxisTitle( const String& rText );
	void SetYAxisTitle( const String& rText );
	void SetZAxisTitle( const String& rText );


    String& SomeData1();
	String& SomeData2();
	String& SomeData3();
	String& SomeData4();

// 	const String& SomeData1() const;
// 	const String& SomeData2() const;
// 	const String& SomeData3() const;
// 	const String& SomeData4() const;

    // replaced by:
//     String GetSomeData( sal_Int32 nIndex ) const;
//     void   SetSomeData( sal_Int32 nIndex, const String & rString );

	String GetColText( short nCol ) const;
	String GetRowText( short nRow ) const;

    void SetColText( short nCol, const String & rText );
	void SetRowText( short nRow, const String & rText );

    // avoid exporting the following
//     const long * GetRowTranslation() const;
//     const long * GetColTranslation() const;
//     void SetRowTranslation( const long* pTransTable );
//     void SetColTranslation( const long* pTransTable );

	double GetData( short nCol, short nRow ) const throw();
	void   SetData( short nCol, short nRow, const double& rVal ) throw();

    // XML range stuff

    void SetChartRangeAsXMLString( const ::rtl::OUString & rXMLString );
    ::rtl::OUString GetTableNumberList() const;

    /** Parses the given table-number list and modify the chart range by setting
        its mnTableNumber members accordingly.

        @param aList a list of table numbers given as a string of integer
            numbers separated by whitespace
     */
    void UpdateTableNumbersFromList( ::rtl::OUString & rList );

    void ConvertChartRangeForCalc( bool bOldToNew );

    /** Note: In the old chart the parameter was bNewToOld, i.e. the parameter
        worked exactly the other way round.
     */
    void ConvertChartRangeForWriter( bool bOldToNew );

public:
	SchMemChart();
	virtual ~SchMemChart();

protected:
    void SetSeriesNumberFormatKey( sal_Int32 nIndex, sal_Int32 nFormatKey );

    /** @return the DataRowSource set at the RectangularDataSource stored in
                m_xDataSource.
     */
    ::com::sun::star::chart::ChartDataRowSource GetChartDataRowSource() const;

private:

    /** this DataSource is one that supports the service RectangularDataSource
     */
    ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XDataSource > m_xDataSource;

        /** The sequences are always ordered like this, where n is the value
        returned by GetRowCount() and m is the value returned by GetColCount():

        - The first series contains category labels.  If there are no labels,
          the sequence contains empty strings.  The length of this sequence is
          n-1.

        - The second series contains x-values for an XY-diagram or the first
          series of any other diagram.  The length is n.

        - The following series (3 to m + 1, or m + 2 for XY-diagrams) contain
          further series, starting with the first for XY-diagrams and the second
          for all other diagrams.  The length of all these sequence is also n.
     */
//     ::com::sun::star::uno::Sequence<
//         ::com::sun::star::uno::Reference<
//         ::com::sun::star::chart2::XDataSequence > >
//         m_aDataSequences;

    ::com::sun::star::uno::Reference<
        ::com::sun::star::util::XNumberFormatsSupplier >
        m_xNumberFormatsSupplier;

    bool            m_bReadOnly;
    Link            m_aSelectionCallBack;

    // ____ chart range ____

    /** An object that contains the chart source range and can convert the range
        to an XML-conform string, as well as to legacy strings for the binary
        5.0 file format.

        @note Keep property m_aSourceRange consistent with the helper.  You
        can use UpdateChartRangeHelper() for that.
     */
//     mutable impl::ChartRangeHelper    m_aChartRangeHelper;
    ::std::auto_ptr< chart::wrapper::impl::ChartRangeHelper > m_pChartRangeHelper;

    /** Checks whether m_aSourceRange and the range stored in
        m_aChartRangeHelper match.  If they don't, m_aChartRangeHelper is
        updated according to m_aSourceRange.

        @return true, if the range was updated.
     */
    bool UpdateChartRangeHelper() const;
};

// _SCH_MEMCHRT_HXX
#endif
