/*************************************************************************
 *
 *  $RCSfile: DataSeriesTreeHelper.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CHART2_DATASERIESTREEHELPER_HXX
#define CHART2_DATASERIESTREEHELPER_HXX

#ifndef _COM_SUN_STAR_CHART2_XDATASERIES_HPP_
#include <com/sun/star/chart2/XDataSeries.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XDIAGRAM_HPP_
#include <com/sun/star/chart2/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_STACKMODE_HPP_
#include <com/sun/star/chart2/StackMode.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XCHARTTYPE_HPP_
#include <com/sun/star/chart2/XChartType.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XCHARTTYPEGROUP_HPP_
#include <com/sun/star/chart2/XChartTypeGroup.hpp>
#endif

#include <vector>

namespace chart
{
namespace helper
{

class DataSeriesTreeHelper
{
public:
    /** return all data series found in a diagram.
     */
    static ::com::sun::star::uno::Sequence<
        ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDataSeries > >
        getDataSeriesFromDiagram(
            const ::com::sun::star::uno::Reference<
                ::com::sun::star::chart2::XDiagram > & xDia );

    /** returns the number of series found in the nth chart-type group, where n
        is 0-based.
     */
    static sal_Int32 getNumberOfSeriesForChartTypeByIndex(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XDataSeriesTreeParent > & xTree,
        sal_Int32 _nGroupNumber = 0 );

    static ::com::sun::star::chart2::StackMode
        getStackMode( const ::com::sun::star::uno::Reference<
                          ::com::sun::star::chart2::XDataSeriesTreeParent > & xParent );

    static bool setStackMode(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XDataSeriesTreeParent > & xParent,
        ::com::sun::star::chart2::StackMode eMode );

    static ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XChartType >
        getChartTypeByIndex(
            const ::com::sun::star::uno::Reference<
                ::com::sun::star::chart2::XDataSeriesTreeParent > & xTree,
            sal_Int32 _nGroupNumber = 0 );

    static ::std::vector<
            ::com::sun::star::uno::Reference<
                    ::com::sun::star::chart2::XChartTypeGroup > > getChartTypes(
                        const ::com::sun::star::uno::Reference<
                            ::com::sun::star::chart2::XDataSeriesTreeParent > &
                        xTree );

private:
    // not implemented
	DataSeriesTreeHelper();
};

} //  namespace chart
} //  namespace helper

// CHART2_DATASERIESTREEHELPER_HXX
#endif
