/*************************************************************************
 *
 *  $RCSfile: algohelper.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: bm $ $Date: 2003/10/06 09:58:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CHART_ALGOHELPER_HXX
#define CHART_ALGOHELPER_HXX

#include <algorithm>
#include <functional>
#include <vector>
#include <set>
#include <map>

#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

// Helpers

// ____________________
namespace chart
{

// ____________________
namespace helper
{

/** unary function to convert any type T into a ::com::sun::star::uno::Any.

    <p>uno::makeAny is an inline function.  Thus is cannot be taken directly
    (via mem_fun_ptr)</p>
*/
template< typename T >
struct makeAny : public ::std::unary_function< ::com::sun::star::uno::Any, T >
{
    ::com::sun::star::uno::Any operator() ( const T & aVal )
    {
        return ::com::sun::star::uno::makeAny( aVal );
    }
};

/** unary function to convert an ::rtl::OUString into a double number.

    <p>For conversion rtl::math::StringToDouble is used.</p>
 */
struct OUStringToDouble : public ::std::unary_function< double, ::rtl::OUString >
{
    double operator() ( const ::rtl::OUString & rStr )
    {
        rtl_math_ConversionStatus eConversionStatus;
        double fResult = ::rtl::math::stringToDouble( rStr, '.', ',', & eConversionStatus, NULL );

        if( eConversionStatus != rtl_math_ConversionStatus_Ok )
            ::rtl::math::setNan( & fResult );

        return fResult;
    }
};

/** unary function to convert a double number into an ::rtl::OUString.

    <p>For conversion rtl::math::DoubleToOUString is used.</p>
 */
struct DoubleToOUString : public ::std::unary_function< ::rtl::OUString, double >
{
    ::rtl::OUString operator() ( double fNumber )
    {
        return ::rtl::math::doubleToUString(
            fNumber,
            rtl_math_StringFormat_Automatic,
            -1, // use maximum number of decimal places
            static_cast< sal_Char >( '.' ),
            false // do not erase trailing zeros
            );
    }
};

/** unary function to convert ::com::sun::star::uno::Any into a double number.

    <p>In case no number can be generated from the Any, NaN (see
    rtl::math::SetNAN()) is returned.</p>
*/
struct AnyToDouble : public ::std::unary_function< double, ::com::sun::star::uno::Any >
{
    double operator() ( const ::com::sun::star::uno::Any & rAny )
    {
        double fResult;
        ::rtl::math::setNan( & fResult );

        ::com::sun::star::uno::TypeClass eClass( rAny.getValueType().getTypeClass() );
        if( eClass == ::com::sun::star::uno::TypeClass_STRING )
        {
            rtl_math_ConversionStatus eConversionStatus;
            fResult = ::rtl::math::stringToDouble(
                * reinterpret_cast< const ::rtl::OUString * >( rAny.getValue() ),
                sal_Char( '.' ), sal_Char( ',' ),
                & eConversionStatus, NULL );

            if( eConversionStatus != rtl_math_ConversionStatus_Ok )
                ::rtl::math::setNan( & fResult );
        }
        else if( eClass == ::com::sun::star::uno::TypeClass_DOUBLE )
        {
            fResult = * reinterpret_cast< const double * >( rAny.getValue() );
        }

        return fResult;
    }
};

/** unary function to convert ::com::sun::star::uno::Any into an
    ::rtl::OUString.
*/
struct AnyToString : public ::std::unary_function< ::rtl::OUString, ::com::sun::star::uno::Any >
{
    ::rtl::OUString operator() ( const ::com::sun::star::uno::Any & rAny )
    {
        ::com::sun::star::uno::TypeClass eClass( rAny.getValueType().getTypeClass() );
        if( eClass == ::com::sun::star::uno::TypeClass_DOUBLE )
        {
            return ::rtl::math::doubleToUString(
                * reinterpret_cast< const double * >( rAny.getValue() ),
                rtl_math_StringFormat_Automatic,
                -1, // use maximum decimal places available
                sal_Char( '.' ), // decimal separator
                false // do not erase trailing zeros
                );
        }
        else if( eClass == ::com::sun::star::uno::TypeClass_STRING )
        {
            return * reinterpret_cast< const ::rtl::OUString * >( rAny.getValue() );
        }

        return ::rtl::OUString();
    }
};

/** comparison function for sorting ::com::sun::star::beans::Property elements
 */
struct PropertyLess : public ::std::binary_function< ::com::sun::star::beans::Property,
                                      ::com::sun::star::beans::Property,
                                      bool >
{
    bool operator() ( const ::com::sun::star::beans::Property & rFirst,
                      const ::com::sun::star::beans::Property & rSecond )
    {
        return ( rFirst.Name.compareTo( rSecond.Name ) < 0 );
    }
};

// you can instead use
// ::std::compose1( ::std::bind2nd( ::std::equal_to< Value >(), aMyValue ),
//                  ::std::select2nd< ::std::pair< Key, Value > >());
// e.g.
//     tMapType aMap;
//     ::std::find_if( aMap.begin(), aMap.end(),
//                     ::std::compose1( ::std::bind2nd(
//                                          ::std::equal_to< tMapType::data_type >(),
//                                          42 ),
//                                      ::std::select2nd< tMapType::value_type >())));

/** can be used to find a certain value in a map

    ::std::find_if( aMap.begin(), aMap.end(),
                    SecondOfPairEquals< string, int >( 42 ));
 */
template< typename Key, typename Value >
class SecondOfPairEquals : public ::std::unary_function< bool, ::std::pair< Key, Value > >
{
public:
    SecondOfPairEquals( const Value & aVal )
            : m_aValueToCompareWith( aVal )
    {}
    bool operator() ( const ::std::pair< Key, Value > & rMapElem )
    {
        return rMapElem.second == m_aValueToCompareWith;
    }

private:
    Value m_aValueToCompareWith;
};

// see ::std::select1st

// template< typename T, typename U >
// struct FirstOfPair : public ::std::unary_function< T, ::std::pair< T, U > >
// {
//     T operator() ( const ::std::pair< T, U > & aPair )
//     {
//         return aPair.first;
//     }
// };

// see ::std::select2nd

// template< typename T, typename U >
// struct SecondOfPair : public ::std::unary_function< U, ::std::pair< T, U > >
// {
//     U operator() ( const ::std::pair< T, U > & aPair )
//     {
//         return aPair.second;
//     }
// };

/** Input:  an STL-vector with elements of type T
    Output: a UNO-Sequence containing the same elements as the STL-container
 */
template< typename T >
::com::sun::star::uno::Sequence< T > VectorToSequence(
    const ::std::vector< T > & rCont )
{
    ::com::sun::star::uno::Sequence< T > aResult( rCont.size());
    ::std::copy( rCont.begin(), rCont.end(), aResult.getArray());
    return aResult;
}

/** Input:  an STL-set with elements of type T
    Output: a UNO-Sequence containing the same elements as the STL-container
 */
template< typename T >
::com::sun::star::uno::Sequence< T > SetToSequence(
    const ::std::set< T > & rCont )
{
    ::com::sun::star::uno::Sequence< T > aResult( rCont.size());
    ::std::copy( rCont.begin(), rCont.end(), aResult.getArray());
    return aResult;
}

/** Input:  a UNO-Sequence with elements of type T
    Output: an STL-vector containing the same elements as Sequence
 */
template< typename T >
::std::vector< T > SequenceToVector( const ::com::sun::star::uno::Sequence< T > & rSeq )
{
    ::std::vector< T > aResult( rSeq.getLength());
    ::std::copy( rSeq.getConstArray(), rSeq.getConstArray() + rSeq.getLength(),
                 aResult.begin() );
    return aResult;
}

/** Input:  an STL-map with keys of type Key
    Output: a UNO-Sequence containing the same elements as the keys of the map
 */
template< typename Key, typename Value >
::com::sun::star::uno::Sequence< Key > MapKeysToSequence(
    const ::std::map< Key, Value > & rCont )
{
    ::com::sun::star::uno::Sequence< Key > aResult( rCont.size());
    ::std::transform( rCont.begin(), rCont.end(), aResult.getArray(),
                      ::std::select1st< ::std::pair< Key, Value > >());
    return aResult;
}

/** Input:  an STL-map with values of type Value
    Output: a UNO-Sequence containing the same elements as the values of the map
 */
template< typename Key, typename Value >
::com::sun::star::uno::Sequence< Value > MapValuesToSequence(
    const ::std::map< Key, Value > & rCont )
{
    ::com::sun::star::uno::Sequence< Value > aResult( rCont.size());
    ::std::transform( rCont.begin(), rCont.end(), aResult.getArray(),
                      ::std::select2nd< ::std::pair< Key, Value > >());
    return aResult;
}

}  // namespace helper
}  // namespace chart

// CHART_ALGOHELPER_HXX
#endif
