/*************************************************************************
 *
 *  $RCSfile: BoundedCoordinateSystem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CHART_BOUNDEDCOORDINATESYSTEM_HXX
#define CHART_BOUNDEDCOORDINATESYSTEM_HXX

#ifndef _CPPUHELPER_IMPLBASE3_HXX_
#include <cppuhelper/implbase3.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#include "ServiceMacros.hxx"

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
// #ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
// #include <com/sun/star/uno/XComponentContext.hpp>
// #endif
#ifndef _COM_SUN_STAR_CHART2_XBOUNDEDCOORDINATESYSTEM_HPP_
#include <com/sun/star/chart2/XBoundedCoordinateSystem.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCLONEABLE_HPP_
#include <com/sun/star/util/XCloneable.hpp>
#endif

#include <vector>

namespace chart
{

class BoundedCoordinateSystem : public ::cppu::WeakImplHelper3<
    ::com::sun::star::lang::XServiceInfo,
    ::com::sun::star::chart2::XBoundedCoordinateSystem,
    ::com::sun::star::util::XCloneable >
{
public:
	BoundedCoordinateSystem(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XCoordinateSystem > & xCoordSys );
	virtual ~BoundedCoordinateSystem();

    APPHELPER_XSERVICEINFO_DECL()
//     /// establish methods for factory instatiation
// 	APPHELPER_SERVICE_FACTORY_HELPER( BoundedCoordinateSystem )

protected:
    // ____ XBoundedCoordinateSystem ____
        virtual void SAL_CALL setScaleByDimension(
            sal_Int32 nDimension,
            const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XScale >& aScale )
        throw (::com::sun::star::lang::IndexOutOfBoundsException,
               ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XScale > SAL_CALL getScaleByDimension( sal_Int32 nDimension )
        throw (::com::sun::star::lang::IndexOutOfBoundsException,
               ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setOrigin(
        const ::com::sun::star::uno::Sequence<
            ::com::sun::star::uno::Any >& aOrigin )
        throw (::com::sun::star::lang::IllegalArgumentException,
               ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence<
            ::com::sun::star::uno::Any > SAL_CALL getOrigin()
        throw (::com::sun::star::uno::RuntimeException);

    // ________ XCoordinateSystem (Base of XBoundedCoordinateSystem)  ________
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XTransformation > SAL_CALL getTransformationToCartesian()
        throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XTransformation > SAL_CALL getTransformationFromCartesian()
        throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Int32 SAL_CALL getDimension()
        throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getCoordinateSystemType()
        throw (::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getViewServiceName()
        throw (::com::sun::star::uno::RuntimeException);

    // ____ XCloneable ____
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::util::XCloneable > SAL_CALL createClone()
        throw (::com::sun::star::uno::RuntimeException);

private:
    ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XCoordinateSystem >     m_xCoordSys;

    ::std::vector< ::com::sun::star::uno::Reference<
        ::com::sun::star::chart2::XScale > >              m_aScales;
    ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any > m_aOrigin;
//     ::com::sun::star::uno::Reference<
//         ::com::sun::star::uno::XComponentContext >                m_xContext;
};

} //  namespace chart

// CHART_BOUNDEDCOORDINATESYSTEM_HXX
#endif
