/*************************************************************************
 *
 *  $RCSfile: ContinuousScaleGroup.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "ContinuousScaleGroup.hxx"
#include "macros.hxx"
#include "algohelper.hxx"

#ifndef _COM_SUN_STAR_CHART2_XDATASERIES_HPP_
#include <com/sun/star/chart2/XDataSeries.hpp>
#endif

#include <algorithm>

using namespace ::com::sun::star;
using ::osl::MutexGuard;

namespace chart
{

ContinuousScaleGroup::ContinuousScaleGroup(
    const uno::Reference< uno::XComponentContext > & xContext ) :
        m_xContext( xContext )
{
    if( m_xContext.is())
    {
        m_xContext->getValueByName( C2U( "CoordinateSystem" ) ) >>= m_xCoordSys;

        if( ! ( m_xContext->getValueByName( C2U( "RepresentedDimension" ) ) >>= m_nDimension ))
            m_nDimension = 0;
    }
}

ContinuousScaleGroup::~ContinuousScaleGroup()
{}

// ____ XScaleGroup ____
uno::Reference< chart2::XBoundedCoordinateSystem > SAL_CALL ContinuousScaleGroup::getCoordinateSystem()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_xCoordSys;
    // \--
}

sal_Int32 SAL_CALL ContinuousScaleGroup::getRepresentedDimension()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_nDimension;
    // \--
}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL ContinuousScaleGroup::getChildren()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return helper::VectorToSequence( m_aChildren );
    // \--
}

void SAL_CALL ContinuousScaleGroup::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    bool bArgumentOk = false;

    if( aNode.is())
    {
        if( aNode->queryInterface(
                ::getCppuType( (uno::Reference< chart2::XDataSeries >* )(0))).hasValue() )
        {
            bArgumentOk = true;
        }
        else
        {
            uno::Reference< lang::XServiceInfo > xInfo( aNode, uno::UNO_QUERY );
            if( xInfo.is())
            {
                bArgumentOk = xInfo->supportsService( C2U( "com.sun.star.chart2.ContinuousScaleGroup" ));
            }
        }
    }

    if( bArgumentOk )
    {
        // /--
        MutexGuard aGuard( m_aMutex );
        m_aChildren.push_back( aNode );
        // \--
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL ContinuousScaleGroup::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
    // \--
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > ContinuousScaleGroup::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.ContinuousScaleGroup" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( ContinuousScaleGroup,
                             C2U( "com.sun.star.comp.chart2.ContinuousScaleGroup" ));


// ========================================


ContinuousStackableScaleGroup::ContinuousStackableScaleGroup(
    const uno::Reference< uno::XComponentContext > & xContext ) :
        m_aStackMode( chart2::StackMode_NONE ),
        m_xContext( xContext )
{
    if( m_xContext.is())
    {
        m_xContext->getValueByName( C2U( "CoordinateSystem" ) ) >>= m_xCoordSys;

        if( ! ( m_xContext->getValueByName( C2U( "RepresentedDimension" ) ) >>= m_nDimension ))
            m_nDimension = 0;
    }
}

ContinuousStackableScaleGroup::~ContinuousStackableScaleGroup()
{}

// ____ XStackableScaleGroup ____
chart2::StackMode SAL_CALL ContinuousStackableScaleGroup::getStackMode()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_aStackMode;
    // \--
}

void SAL_CALL ContinuousStackableScaleGroup::setStackMode( chart2::StackMode aMode )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_aStackMode = aMode;
    // \--
}

// ____ XScaleGroup ____
uno::Reference< chart2::XBoundedCoordinateSystem > SAL_CALL ContinuousStackableScaleGroup::getCoordinateSystem()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_xCoordSys;
    // \--
}

sal_Int32 SAL_CALL ContinuousStackableScaleGroup::getRepresentedDimension()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_nDimension;
    // \--
}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL ContinuousStackableScaleGroup::getChildren()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return helper::VectorToSequence( m_aChildren );
    // \--
}

void SAL_CALL ContinuousStackableScaleGroup::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    bool bArgumentOk = false;

    if( aNode.is())
    {
        if( aNode->queryInterface(
                ::getCppuType( (uno::Reference< chart2::XDataSeries >* )(0))).hasValue() )
        {
            bArgumentOk = true;
        }
        else
        {
            uno::Reference< lang::XServiceInfo > xInfo( aNode, uno::UNO_QUERY );
            if( xInfo.is())
            {
                bArgumentOk = xInfo->supportsService( C2U( "com.sun.star.chart2.ContinuousScaleGroup" ));
            }
        }
    }

    if( bArgumentOk )
    {
        // /--
        MutexGuard aGuard( m_aMutex );
        m_aChildren.push_back( aNode );
        // \--
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL ContinuousStackableScaleGroup::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
    // \--
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > ContinuousStackableScaleGroup::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.ContinuousStackableScaleGroup" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( ContinuousStackableScaleGroup,
                             C2U( "com.sun.star.comp.chart2.ContinuousStackableScaleGroup" ));


} //  namespace chart
