/*************************************************************************
 *
 *  $RCSfile: TTableHelper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/08/02 16:49:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONNECTIVITY_TABLEHELPER_HXX
#define CONNECTIVITY_TABLEHELPER_HXX

#ifndef _CONNECTIVITY_SDBCX_TABLE_HXX_
#include "connectivity/sdbcx/VTable.hxx"
#endif
#ifndef CONNECTIVITY_STDTYPEDEFS_HXX
#include "connectivity/StdTypeDefs.hxx"
#endif

namespace connectivity
{
	typedef connectivity::sdbcx::OTable OTable_TYPEDEF;

    ::rtl::OUString getTypeString(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& xColProp);

	class OTableHelper :	public OTable_TYPEDEF
	{
        ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >	m_xMetaData;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >			m_xConnection;

		void refreshPrimaryKeys(std::vector< ::rtl::OUString>& _rKeys);
		void refreshForgeinKeys(std::vector< ::rtl::OUString>& _rKeys);

	protected:
		/** creates the column collection for the table
			@param	_rNames
				The column names.
		*/
		virtual sdbcx::OCollection* createColumns(const TStringVector& _rNames) = 0;

		/** creates the key collection for the table
			@param	_rNames
				The key names.
		*/
		virtual sdbcx::OCollection* createKeys(const TStringVector& _rNames) = 0;

		/** creates the index collection for the table
			@param	_rNames
				The index names.
		*/
		virtual sdbcx::OCollection* createIndexes(const TStringVector& _rNames) = 0;

		/** this function is called upon disposing the component
		*/
		virtual void SAL_CALL disposing();

	public:
		virtual void refreshColumns();
		virtual void refreshKeys();
		virtual void refreshIndexes();

	public:
		OTableHelper(	sdbcx::OCollection* _pTables,
						const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _xConnection,
						sal_Bool _bCase);
		OTableHelper(	sdbcx::OCollection* _pTables,
						const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _xConnection,
						sal_Bool _bCase,
						const ::rtl::OUString& _Name,
						const ::rtl::OUString& _Type,
						const ::rtl::OUString& _Description = ::rtl::OUString(),
						const ::rtl::OUString& _SchemaName = ::rtl::OUString(),
						const ::rtl::OUString& _CatalogName = ::rtl::OUString()
			);

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData> getMetaData() const;
		inline ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection> getConnection() const { return m_xConnection; }

		virtual void SAL_CALL acquire() throw();
        virtual void SAL_CALL release() throw();

		// XRename
        virtual void SAL_CALL rename( const ::rtl::OUString& newName ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::container::ElementExistException, ::com::sun::star::uno::RuntimeException);

		// XAlterTable
        virtual void SAL_CALL alterColumnByIndex( sal_Int32 index, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& descriptor ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
		// XNamed
		virtual ::rtl::OUString SAL_CALL getName() throw(::com::sun::star::uno::RuntimeException);
	};
}
#endif // CONNECTIVITY_TABLEHELPER_HXX

