/*************************************************************************
 *
 *  $RCSfile: DataSourceHolder.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/08/02 16:51:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef CONNECTIVITY_DATASOURCEHOLDER_HXX
#include "connectivity/DataSourceHolder.hxx"
#endif // CONNECTIVITY_DATASOURCEHOLDER_HXX

#ifndef _CPPUHELPER_COMPBASE1_HXX_
#include <cppuhelper/compbase1.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif


namespace dbtools
{
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::util;

	typedef	::cppu::WeakComponentImplHelper1<	::com::sun::star::util::XCloseListener > OPrivateCloseListener_BASE;
	class OPrivateCloseListener : public ::comphelper::OBaseMutex,public OPrivateCloseListener_BASE
	{
		::com::sun::star::uno::Reference< ::com::sun::star::util::XCloseable> m_xCloseable;
	protected:
		virtual void SAL_CALL disposing();
	public:
		OPrivateCloseListener(const ::com::sun::star::uno::Reference< ::com::sun::star::util::XCloseable>& _xCloseable);

		virtual void SAL_CALL queryClosing( const ::com::sun::star::lang::EventObject& Source, sal_Bool GetsOwnership ) throw (::com::sun::star::util::CloseVetoException, ::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL notifyClosing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException);
	};

	OPrivateCloseListener::OPrivateCloseListener(const Reference< XCloseable>& _xCloseable)
		:OPrivateCloseListener_BASE(m_aMutex)
		,m_xCloseable(_xCloseable)
	{
		osl_incrementInterlockedCount( &m_refCount );
		if ( m_xCloseable.is() )
		{
			m_xCloseable->addCloseListener(static_cast<XCloseListener*>(this));
		}
		osl_decrementInterlockedCount( &m_refCount );
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OPrivateCloseListener::queryClosing( const ::com::sun::star::lang::EventObject& Source, sal_Bool GetsOwnership ) throw (CloseVetoException, RuntimeException)
	{
		throw CloseVetoException();
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OPrivateCloseListener::notifyClosing( const ::com::sun::star::lang::EventObject& Source ) throw (RuntimeException)
	{
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OPrivateCloseListener::disposing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException)
	{
		OSL_ENSURE(0,"Who disposed us? We always throw an exception in queryClosing!");
		m_xCloseable = NULL;
	}
	// -----------------------------------------------------------------------------
	void SAL_CALL OPrivateCloseListener::disposing()
	{
		try
		{
			if ( m_xCloseable.is() )
			{
				m_xCloseable->removeCloseListener(static_cast<XCloseListener*>(this));
				m_xCloseable->close(sal_True);
			}
		}
		catch(Exception)
		{
		}
	}
	// -----------------------------------------------------------------------------
	ODataSourceHolder::ODataSourceHolder(const Reference< XCloseable>& _xCloseable)
	{
		m_xListener = new OPrivateCloseListener(_xCloseable);
	}
	// -----------------------------------------------------------------------------
	ODataSourceHolder::~ODataSourceHolder()
	{
		::comphelper::disposeComponent(m_xListener);
	}
	// -----------------------------------------------------------------------------
//.........................................................................
}
// namespace dbtools
//.........................................................................

