#ifndef _CONNECTIVITY_MAB_MOZABHELPER_HXX_
#define _CONNECTIVITY_MAB_MOZABHELPER_HXX_
#ifndef _CONNECTIVITY_MAB_NS_DECLARES_HXX_
#include "MNSDeclares.hxx"
#endif
#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif

#include <MNSInclude.hxx>

namespace connectivity
{
	namespace mozab
	{
		namespace ProxiedFunc
		{
			enum
			{
				FUNC_TESTLDAP_INIT_LDAP=1,
				FUNC_TESTLDAP_IS_LDAP_CONNECTED,
				FUNC_TESTLDAP_RELEASE_RESOURCE,
				FUNC_GET_TABLE_STRINGS,
				FUNC_EXECUTE_QUERY,
				FUNC_QUERYHELPER_CREATE_NEW_CARD,
				FUNC_QUERYHELPER_DELETE_CARD,
				FUNC_QUERYHELPER_COMMIT_CARD,
				FUNC_QUERYHELPER_RESYNC_CARD,
				FUNC_NEW_ADDRESS_BOOK
			};
		}

		struct RunArgs
		{
			sal_Int32 funcIndex; //Function Index
			sal_Int32 argCount;  //parameter count
			void *	arg1;
			void *	arg2;
			void *	arg3;
			void *	arg4;
			void *	arg5;
			void *  arg6;
		        RunArgs()
            		{
			    arg1 = NULL;
			    arg2 = NULL;
			    arg3 = NULL;
			    arg4 = NULL;
			    arg5 = NULL;
			    arg6 = NULL;
            		}
		};
		typedef RunArgs RunArgs;
	class MNSMozabProxy : public nsIRunnable
        {
        public:
            nsIRunnable * ProxiedObject();
            MNSMozabProxy();
            virtual ~MNSMozabProxy();
            NS_DECL_ISUPPORTS
            NS_DECL_NSIRUNNABLE
        
        public:
        	sal_Int32 StartProxy(RunArgs * args); //Call this to start proxy

        protected:
			nsresult testLDAPConnection();
			nsresult InitLDAP(sal_Char* sUri, sal_Unicode* sBindDN, sal_Unicode* sPasswd,sal_Bool * nUseSSL);
			nsresult QueryHelperStub();
        private:
            nsIRunnable* _ProxiedObject;
            RunArgs * m_Args;
#if OSL_DEBUG_LEVEL > 0
            oslThreadIdentifier m_oThreadID;
#endif
        };
    }
}
#endif //_CONNECTIVITY_MAB_MOZABHELPER_HXX_
