/*************************************************************************
 *
 *  $RCSfile: HelperCollections.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/12/16 12:39:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBA_HELPERCOLLECTIONS_HXX
#define DBA_HELPERCOLLECTIONS_HXX

#ifndef _CONNECTIVITY_SDBCX_COLLECTION_HXX_
#include "connectivity/sdbcx/VCollection.hxx"
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef _DBHELPER_DBCONVERSION_HXX_
#include <connectivity/dbconversion.hxx>
#endif
#ifndef _CONNECTIVITY_SDBCX_COLUMN_HXX_
#include <connectivity/PColumn.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

namespace dbaccess
{
	using namespace dbtools;
	using namespace comphelper;
	using namespace connectivity;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::sdbcx;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::script;
	using namespace ::cppu;
	using namespace ::osl;
	// -----------------------------------------------------------------------------
	typedef connectivity::sdbcx::OCollection OPrivateColumns_Base;
	class OPrivateColumns : public OPrivateColumns_Base
	{
		::vos::ORef< ::connectivity::OSQLColumns>	m_aColumns;
	protected:
		virtual Reference< XNamed > createObject(const ::rtl::OUString& _rName);
		virtual void impl_refresh() throw(RuntimeException) {}
		virtual Reference< XPropertySet > createEmptyObject()
		{
			return NULL;
		}
	public:
		OPrivateColumns(const ::vos::ORef< ::connectivity::OSQLColumns>& _rColumns,
						sal_Bool _bCase,
						::cppu::OWeakObject& _rParent,
						::osl::Mutex& _rMutex,
						const ::std::vector< ::rtl::OUString> &_rVector,
						sal_Bool _bUseAsIndex = sal_False
					);
		virtual void SAL_CALL disposing(void);
	};
	typedef connectivity::sdbcx::OCollection OPrivateTables_BASE;

	//==========================================================================
	//= OPrivateTables
	//==========================================================================
	class OPrivateTables : public OPrivateTables_BASE
	{
		OSQLTables	m_aTables;
	protected:
		virtual Reference< XNamed > createObject(const ::rtl::OUString& _rName);
		virtual void impl_refresh() throw(RuntimeException) {}
		virtual Reference< XPropertySet > createEmptyObject()
		{
			return NULL;
		}
	public:
		OPrivateTables(	const OSQLTables& _rTables,
						sal_Bool _bCase,
						::cppu::OWeakObject& _rParent,
						::osl::Mutex& _rMutex,
						const ::std::vector< ::rtl::OUString> &_rVector
					) : sdbcx::OCollection(_rParent,_bCase,_rMutex,_rVector)
						,m_aTables(_rTables)
		{
		}
		virtual void SAL_CALL disposing(void)
		{
			clear_NoDispose();
				// we're not owner of the objects we're holding, instead the object we got in our ctor is
				// So we're not allowed to dispose our elements.
			m_aTables.clear();
			OPrivateTables_BASE::disposing();
		}
	};
}
#endif // DBA_HELPERCOLLECTIONS_HXX
