/*************************************************************************
 *
 *  $RCSfile: AdabasPage.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/08/02 15:38:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_ADABASPAGE_HXX
#define DBAUI_ADABASPAGE_HXX

#ifndef _DBAUI_ADMINPAGES_HXX_
#include "adminpages.hxx"
#endif
#ifndef _SV_FIELD_HXX 
#include <vcl/field.hxx>
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif

FORWARD_DECLARE_INTERFACE(beans,XPropertySet)
FORWARD_DECLARE_INTERFACE(sdbc,XConnection)
FORWARD_DECLARE_INTERFACE(lang,XMultiServiceFactory)

namespace dbaui
{
	class IAdminHelper;
	//========================================================================
	class OAdabasAdminSettings : public OGenericAdministrationPage
	{
	public:
		static	SfxTabPage*	Create( Window* pParent, const SfxItemSet& rAttrSet );

		// must be overloaded by subclasses, but it isn't pure virtual
		virtual void implInitControls(const SfxItemSet& _rSet, sal_Bool _bSaveValue);

		// <method>OGenericAdministrationPage::fillControls</method>
		virtual void fillControls(::std::vector< ISaveValueWrapper* >& _rControlList);

		// <method>OGenericAdministrationPage::fillWindows</method>
		virtual void fillWindows(::std::vector< ISaveValueWrapper* >& _rControlList);
	protected:
		virtual int			DeactivatePage(SfxItemSet* _pSet);

	private:
		FixedText			m_FT_CACHE_SIZE;
		NumericField		m_NF_CACHE_SIZE;

		FixedText			m_FT_DATA_INCREMENT;
		NumericField		m_NF_DATA_INCREMENT;

		FixedLine			aFL_1;
		FixedText			m_FT_CTRLUSERNAME;
		Edit				m_ET_CTRLUSERNAME;
		FixedText			m_FT_CTRLPASSWORD;
		Edit				m_ET_CTRLPASSWORD;

		CheckBox			m_CB_SHUTDB;
		PushButton			m_PB_STAT;
		String				m_sUser;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >
							m_xCurrentConnection;	/// valid as long as the page is active
		BOOL				bAttrsChanged;

		OAdabasAdminSettings( Window* pParent, const SfxItemSet& rCoreAttrs );
		virtual ~OAdabasAdminSettings();

		DECL_LINK( AttributesChangedHdl,	void * );
		DECL_LINK( UserSettingsHdl,			void * );
		DECL_LINK( LoseFocusHdl,			Edit * );
		DECL_LINK( PBClickHdl,				Button *);
	};

}
#endif // DBAUI_ADABASPAGE_HXX

