/*************************************************************************
 *
 *  $RCSfile: genericcontroller.hxx,v $
 *
 *  $Revision: 1.32 $
 *
 *  last change: $Author: obo $ $Date: 2005/01/05 12:36:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_GENERICCONTROLLER_HXX
#define DBAUI_GENERICCONTROLLER_HXX

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
#include <com/sun/star/frame/XFrameActionListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDERINTERCEPTOR_HPP_
#include <com/sun/star/frame/XDispatchProviderInterceptor.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_FRAME_XLAYOUTMANAGER_HPP_
#include <drafts/com/sun/star/frame/XLayoutManager.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHINFORMATIONPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchInformationProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_COMMANDGROUP_HPP_
#include <com/sun/star/frame/CommandGroup.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XMODIFYLISTENER_HPP_
#include <com/sun/star/util/XModifyListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _CPPUHELPER_COMPBASE7_HXX_
#include <cppuhelper/compbase7.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE1_HXX_
#include <cppuhelper/compbase1.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_H_
#include <cppuhelper/interfacecontainer.h>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef DBAUI_ASYNCRONOUSLINK_HXX
#include "AsyncronousLink.hxx"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
#include <com/sun/star/sdbc/XDataSource.hpp>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef DBAUI_ICONTROLLER_HXX
#include "IController.hxx"
#endif

class Window;
class VCLXWindow;
namespace dbaui
{
	class ODataView;

	typedef ::comphelper::OBaseMutex	OGenericUnoController_MBASE;

	typedef ::cppu::WeakComponentImplHelper7	<	::com::sun::star::frame::XDispatch
												,	::com::sun::star::frame::XDispatchProviderInterceptor
												,	::com::sun::star::util::XModifyListener
												,	::com::sun::star::frame::XFrameActionListener
												,	::com::sun::star::lang::XInitialization
												,	::com::sun::star::lang::XServiceInfo
												,	::com::sun::star::frame::XDispatchInformationProvider
												>	OGenericUnoController_COMPBASE;

	typedef ::cppu::ImplHelper1	<	::com::sun::star::frame::XController
								>	OGenericUnoController_CTRBASE;

	// a smaller version of the FeatureEvent to be broadcasted by an ::com::sun::star::frame::XController
	// -------------------------------------------------------------------------
	struct FeatureState
	{
		::com::sun::star::uno::Any	aState;
		sal_Bool					bEnabled;
		sal_Bool					bRequery;

		FeatureState() : bEnabled(sal_False), bRequery(sal_False) { }
	};

	// ====================================================================
	// = helper
	// ====================================================================
	// (would like to have them local to OGenericUnoController, but SunPro5 complains then ...)

	// --------------------------------------------------------------------
	// ....................................................................
    struct ControllerFeature : public ::com::sun::star::frame::DispatchInformation
    {
        sal_uInt16 nFeatureId;
    };

    typedef ::std::map  <   ::rtl::OUString
                        ,   ControllerFeature
                        ,   ::std::less< ::rtl::OUString >
                        >   SupportedFeatures;

	/// binary_function Functor object for class SupportedFeatures::value_type returntype is bool
	// ....................................................................
	struct SupportedFeaturesEqualId : ::std::binary_function< SupportedFeatures::value_type, sal_Int32, bool >
	{
		// ................................................................
		inline bool operator()( const SupportedFeatures::value_type& _aType, const sal_Int32& _nId ) const
		{
			return !!( _nId == _aType.second.nFeatureId );
		}
	};

	// --------------------------------------------------------------------
	// ....................................................................
	typedef struct FeatureStruct
	{
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >
					xListener;
		sal_Int32	nId;
		sal_Bool	bForceBroadcast;
	} FeaturePair;

	// ....................................................................
	typedef ::std::deque< FeaturePair > FeaturePairDeque;

	/// binary_function Functor object for class FeaturePair returntype is bool
	// ....................................................................
	struct FeaturePairFunctor : ::std::binary_function< FeaturePair, ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >, bool >
	{
		// ................................................................
		inline bool operator()( const FeaturePair& lhs, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >& rhs ) const
		{
			return !!( lhs.xListener == rhs );
		}
	};

	// ====================================================================
	class OGenericUnoController	:public OGenericUnoController_MBASE
								,public OGenericUnoController_COMPBASE
								,public OGenericUnoController_CTRBASE
								,public dbaui::OModuleClient
								,public IController
	{
    private:
		SupportedFeatures		m_aSupportedFeatures;	// look at the name

#if OSL_DEBUG_LEVEL >= 2
        bool    m_bDescribingSupportedFeatures;
#endif

	protected:
        // ----------------------------------------------------------------
        // attributes
		struct DispatchTarget
		{
			::com::sun::star::util::URL					aURL;
			::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > 	xListener;

			DispatchTarget() { }
			DispatchTarget(const ::com::sun::star::util::URL& rURL, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  xRef) : aURL(rURL), xListener(xRef) { }
		};

		DECLARE_STL_MAP( sal_uInt16, FeatureState, ::std::less< sal_uInt16 >, StateCache );
		DECLARE_STL_VECTOR( DispatchTarget, Dispatch);

		FeaturePairDeque m_aFeaturesToInvalidate;

		::osl::Mutex			m_aAsyncLoadSafety;		// for multi-thread access to our members
		::osl::Mutex			m_aFeatureMutex;		// locked when features are append to or remove from deque
		StateCache				m_aStateCache;			// save the current status of feature state
		Dispatch				m_arrStatusListener;	// all our listeners where we dispatch status changes
		OAsyncronousLink		m_aAsyncInvalidateAll;
		OAsyncronousLink		m_aAsyncCloseTask;		// called when a task shoud be closed

		::com::sun::star::uno::Reference< ::com::sun::star::util::XURLTransformer > 		m_xUrlTransformer;		// needed sometimes
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >	m_xMultiServiceFacatory;
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >					m_xCurrentFrame;// the frame we're residing in
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > 		m_xSlaveDispatcher;		// for intercepting dispatches
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > 		m_xMasterDispatcher;	// dito
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >		m_xDatabaseContext;

		ODataView*				m_pView;				// our (VCL) "main window"
		sal_Bool				m_bPreview;
		sal_Bool				m_bReadOnly;
		sal_Int32				m_nInInvalidate;

		sal_Bool				m_bFrameUiActive		: 1;		// updated in ::frameAction
		sal_Bool				m_bCurrentlyModified	: 1;
		sal_Bool				m_bCurrentlyInConnect	: 1;
		


        // ----------------------------------------------------------------
        // attribute access
		::osl::Mutex&				getMutex( )				{ return OGenericUnoController_MBASE::m_aMutex; }
		::cppu::OBroadcastHelper&	getBroadcastHelper()	{ return OGenericUnoController_COMPBASE::rBHelper; }

        // ----------------------------------------------------------------
        // methods
        OGenericUnoController(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rM);

		/** open the help agent for the given help id.
			@param	_nHelpId
				The help id to dispatch.
		*/
		void openHelpAgent(sal_Int32 _nHelpId);

		// closes the task when possible
		void closeTask();

        // if getMenu returns a non empty string than this will be dispatched at the frame
		virtual void			loadMenu(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& _xFrame);

		/** called when our menu has been loaded into our frame, can be used to load sub toolbars

            @param _xLayoutManager
				The layout manager.
		*/
		virtual void			onLoadedMenu(const ::com::sun::star::uno::Reference< drafts::com::sun::star::frame::XLayoutManager >& _xLayoutManager);

		// all the features which should be handled by this class
		virtual void			describeSupportedFeatures();

		// state of a feature. 'feature' may be the handle of a ::com::sun::star::util::URL somebody requested a dispatch interface for OR a toolbar slot.
		virtual FeatureState	GetState(sal_uInt16 nId) const;
		// execute a feature
		virtual void			Execute(sal_uInt16 nId , const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs) = 0;

        /** describes a feature supported by the controller

            Must not be called outside <member>describeSupportedFeatures</member>.

            @param _pAsciiCommandURL
                the URL of the feature command
            @param _nFeatureId
                the id of the feature. Later references to this feature usually happen by id, not by
                URL
            @param _nCommandGroup
                the command group of the feature. This is important for configuring the controller UI
                by the user, see also <type scope="com::sun::star::frame">CommandGroup</type>.
        */
        void    implDescribeSupportedFeature(
                    const sal_Char* _pAsciiCommandURL,
                    sal_uInt16 _nFeatureId,
                    sal_Int16 _nCommandGroup = ::com::sun::star::frame::CommandGroup::INTERNAL
                );

        // gets the URL which the given id is assigned to
		::com::sun::star::util::URL getURLForId(sal_Int32 _nId) const;

		// connect to a datasource
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > connect(
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDataSource>& _xDataSource
			,sal_Bool _bStartListening = sal_False
		);

		// connect to a datasource
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > connect(
			const ::rtl::OUString& _rDataSourceName,
			sal_Bool _bStartListening = sal_False
		);

		// connect to a datasource
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > connect(
			const ::rtl::OUString& _rsDataSourceName,
			const ::rtl::OUString& _rContextInformation,
			const ::rtl::OUString& _rContextDetails = ::rtl::OUString(),
			sal_Bool _bStartListening = sal_False
		);

		void startConnectionListening(const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection);
		void stopConnectionListening(const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection);

		/** return the container window of the top most frame
			@return
				The top most container window, nmay be <NULL/>.
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow> getTopMostContainerWindow() const;

		/** sets the title on the current frame
			@param	_sName
				The title of the document
		*/
		virtual void setTitle(const ::rtl::OUString& _sName);

		// XInitialize will be called inside initialize
		virtual void impl_initialize(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments);

		/** updateTitle will be called when a new frame is attached
		*/
		virtual void updateTitle( );

		virtual ~OGenericUnoController();

	private:
			// invalidate features - implementation
		void InvalidateAll_Impl();
		void InvalidateFeature_Impl();

		void ImplInvalidateFeature( sal_Int32 _nId, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >& _xListener, sal_Bool _bForceBroadcast );

		sal_Bool ImplInvalidateTBItem(sal_uInt16 nId, const FeatureState& rState);
		void ImplBroadcastFeatureState(const ::rtl::OUString& _rFeature, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & xListener, sal_Bool _bIgnoreCache);

		sal_Bool	startFrameListening( );
		void		stopFrameListening( );

		// link methods
		DECL_LINK(OnAsyncInvalidateAll, void*);
		DECL_LINK(OnAsyncCloseTask, void*);

	public:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > getORB() const { return m_xMultiServiceFacatory; }
		ODataView* getView() const { return m_pView; }
		// shows a error box if the SQLExceptionInfo is valid
		void showError(const ::dbtools::SQLExceptionInfo& _rInfo);
		// temp
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow > getComponentWindow() const;
		// if xListener is NULL the change will be forwarded to all listeners to the given ::com::sun::star::util::URL
		// if _bForceBroadcast is sal_True, the current feature state is broadcasted no matter if it is the same as the cached state
#if defined(_MSC_VER) && (_MSC_VER >= 1310 )
		static ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > m_subst;
		virtual void InvalidateFeature(const ::rtl::OUString& rURLPath, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & xListener = m_subst, sal_Bool _bForceBroadcast = sal_False);
#else
		virtual void InvalidateFeature(const ::rtl::OUString& rURLPath, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & xListener = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > (), sal_Bool _bForceBroadcast = sal_False);
#endif
		// if there is an ::com::sun::star::util::URL translation for the id ('handle') the preceding InvalidateFeature is used.
		// if there is a toolbar slot with the given id it is updated (the new state is determined via GetState)
		// if _bForceBroadcast is sal_True, the current feature state is broadcasted no matter if it is the same as the cached state
#if defined(_MSC_VER) && (_MSC_VER >= 1310 )
		typedef ::com::sun::star::frame::XStatusListener xstlist_type;
		typedef ::com::sun::star::uno::Reference< xstlist_type > xlistener_type;
		virtual void InvalidateFeature(sal_uInt16 nId, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & xListener = xlistener_type(), sal_Bool _bForceBroadcast = sal_False);
#else
		virtual void InvalidateFeature(sal_uInt16 nId, const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & xListener = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > (), sal_Bool _bForceBroadcast = sal_False);
#endif //_MSC_VER >= 1310

		/** InvalidateAll invalidates all features currently known
		*/
		virtual void InvalidateAll();
		// late construction
		virtual sal_Bool Construct(Window* pParent);

		/** get the layout manager
			@param	_xFrame
				The frame to ask for the layout manager.
			@return
				The layout manager of the frame, can be <NULL/> if the frame isn't initialized.
		*/
		::com::sun::star::uno::Reference< drafts::com::sun::star::frame::XLayoutManager > getLayoutManager(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& _xFrame) const;

		// IController
		virtual void executeUnChecked(const ::com::sun::star::util::URL& _rCommand, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs);
		virtual void executeChecked(const ::com::sun::star::util::URL& _rCommand, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs);
		virtual void executeChecked(sal_uInt16 _nCommandId, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs);
		virtual sal_Bool isCommandEnabled(sal_uInt16 _nCommandId) const;
		virtual sal_Bool isCommandEnabled(const ::com::sun::star::util::URL& _rCommand) const;
		virtual sal_Bool isDataSourceReadOnly() const { return sal_False; }

		// ::com::sun::star::lang::XEventListener
		virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& Source) throw( ::com::sun::star::uno::RuntimeException );

		// ::com::sun::star::util::XModifyListener
		virtual void SAL_CALL modified(const ::com::sun::star::lang::EventObject& aEvent) throw( ::com::sun::star::uno::RuntimeException );

		// XInterface
		virtual ::com::sun::star::uno::Any	SAL_CALL queryInterface(const ::com::sun::star::uno::Type& _rType) throw (::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL acquire(  ) throw ();
		virtual void SAL_CALL release(  ) throw ();

		// XTypeProvider
		virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId(  ) throw (::com::sun::star::uno::RuntimeException) = 0;

		// ::com::sun::star::frame::XController
		virtual void SAL_CALL attachFrame(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > & xFrame) throw( ::com::sun::star::uno::RuntimeException );
		virtual sal_Bool SAL_CALL attachModel(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel > & xModel) throw( ::com::sun::star::uno::RuntimeException );
		virtual sal_Bool SAL_CALL suspend(sal_Bool bSuspend) throw( ::com::sun::star::uno::RuntimeException ) = 0;
		virtual ::com::sun::star::uno::Any SAL_CALL getViewData(void) throw( ::com::sun::star::uno::RuntimeException );
		virtual void SAL_CALL restoreViewData(const ::com::sun::star::uno::Any& Data) throw( ::com::sun::star::uno::RuntimeException );
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >  SAL_CALL getModel(void) throw( ::com::sun::star::uno::RuntimeException ){ return ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel > (); };
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  SAL_CALL getFrame(void) throw( ::com::sun::star::uno::RuntimeException ){ return m_xCurrentFrame; };

		// ::com::sun::star::frame::XDispatch
		virtual void 		SAL_CALL dispatch(const ::com::sun::star::util::URL& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs) throw(::com::sun::star::uno::RuntimeException);
		virtual void 		SAL_CALL addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw(::com::sun::star::uno::RuntimeException);
		virtual void 		SAL_CALL removeStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw(::com::sun::star::uno::RuntimeException);

		// ::com::sun::star::frame::XDispatchProviderInterceptor
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider >  SAL_CALL getSlaveDispatchProvider(void) throw(::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL setSlaveDispatchProvider(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > & _xNewProvider) throw(::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider >  SAL_CALL getMasterDispatchProvider(void) throw(::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL setMasterDispatchProvider(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > & _xNewProvider) throw(::com::sun::star::uno::RuntimeException);

		// ::com::sun::star::frame::XDispatchProvider
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  SAL_CALL queryDispatch(const ::com::sun::star::util::URL& aURL, const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags) throw( ::com::sun::star::uno::RuntimeException );
		virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  > SAL_CALL queryDispatches(const ::com::sun::star::uno::Sequence< ::com::sun::star::frame::DispatchDescriptor >& aDescripts) throw( ::com::sun::star::uno::RuntimeException );

		// ::com::sun::star::lang::XComponent
		virtual void SAL_CALL dispose() throw(::com::sun::star::uno::RuntimeException) {OGenericUnoController_COMPBASE::dispose(); }
		virtual void SAL_CALL disposing();
		virtual void SAL_CALL addEventListener(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener > & aListener) throw(::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL removeEventListener(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener > & aListener) throw(::com::sun::star::uno::RuntimeException);

		// ::com::sun::star::frame::XFrameActionListener
		virtual void		SAL_CALL frameAction(const ::com::sun::star::frame::FrameActionEvent& aEvent) throw( ::com::sun::star::uno::RuntimeException );
		// lang::XInitialization
		virtual void SAL_CALL initialize( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aArguments ) throw(::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

        // XServiceInfo
		virtual ::rtl::OUString SAL_CALL getImplementationName() throw(::com::sun::star::uno::RuntimeException) = 0;
		virtual sal_Bool SAL_CALL supportsService(const ::rtl::OUString& ServiceName) throw(::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence< ::rtl::OUString> SAL_CALL getSupportedServiceNames() throw(::com::sun::star::uno::RuntimeException) = 0;

        // XDispatchInformationProvider
        virtual ::com::sun::star::uno::Sequence< ::sal_Int16 > SAL_CALL getSupportedCommandGroups() throw (::com::sun::star::uno::RuntimeException);
        virtual ::com::sun::star::uno::Sequence< ::com::sun::star::frame::DispatchInformation > SAL_CALL getConfigurableDispatchInformation( ::sal_Int16 ) throw (::com::sun::star::uno::RuntimeException);
	};
}

#endif //DBAUI_GENERICCONTROLLER_HXX


