/*************************************************************************
 *
 *  $RCSfile: javainteractionhandler.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2004/11/09 14:04:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DESKTOP_JAVAINTERACTION_HXX_
#include "javainteractionhandler.hxx"
#endif

#ifndef _DESKTOP_RESID_HXX_
#include "desktopresid.hxx"
#endif

#ifndef _DESKTOP_HRC_
#include "desktop.hrc"
#endif

#ifndef _DESK_APP_HXX
#include "app.hxx"
#endif

#include <com/sun/star/task/XInteractionContinuation.hpp>
#include <com/sun/star/task/XInteractionAbort.hpp>
#include <com/sun/star/task/XInteractionRetry.hpp>
#include <com/sun/star/java/JavaNotFoundException.hpp>
#include <com/sun/star/java/InvalidJavaSettingsException.hpp>
#include <com/sun/star/java/JavaDisabledException.hpp>
#include <com/sun/star/java/JavaVMCreationFailureException.hpp>
#include <com/sun/star/java/RestartRequiredException.hpp>

#include <cppuhelper/implbase1.hxx>
#include <uno/current_context.hxx>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _SVTOOLS_JAVAPTIONS_HXX
#include <svtools/javaoptions.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/string.hxx>

#include <jvmfwk/framework.h>
using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::task;

namespace desktop
{

JavaInteractionHandler::JavaInteractionHandler()
{
}

JavaInteractionHandler::~JavaInteractionHandler()
{
}


void SAL_CALL JavaInteractionHandler::handle( const Reference< XInteractionRequest >& Request )
throw (RuntimeException)
{
    Any anyExc = Request->getRequest();
    Sequence< Reference< XInteractionContinuation > > aSeqCont = Request->getContinuations();

    Reference< XInteractionAbort > abort;
    Reference< XInteractionRetry > retry;
    sal_Int32 i;

    for ( i = 0; i < aSeqCont.getLength(); i++ )
    {
        abort = Reference< XInteractionAbort>::query( aSeqCont[i]);
        if ( abort.is() )
            break;
    }
    
	for ( i= 0; i < aSeqCont.getLength(); i++)
    {
        retry= Reference<XInteractionRetry>::query( aSeqCont[i]);
        if ( retry.is() )
            break;
    }

    com::sun::star::java::JavaNotFoundException e1;
    com::sun::star::java::InvalidJavaSettingsException e2;
 	com::sun::star::java::JavaDisabledException				e3;
    com::sun::star::java::JavaVMCreationFailureException	e4;
    com::sun::star::java::RestartRequiredException e5;
	// Try to recover the Exception type in the any and
	// react accordingly.
	USHORT		nResult = RET_CANCEL;
	OUString	aParameter;

	if ( anyExc >>= e1 )
	{
		// No suitable JRE found
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JAVANOTFOUND ));
		String aTitle = String( DesktopResId( STR_WARNING_JAVANOTFOUND ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
	}
	else if ( anyExc >>= e2 )
	{
		// javavendors.xml was updated and Java has not been configured yet
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_INVALIDJAVASETTINGS ));
		String aTitle = String( DesktopResId( STR_WARNING_INVALIDJAVASETTINGS ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
	}
	else if ( anyExc >>= e3 )
	{
		// Java disabled. Give user a chance to enable Java inside Office.
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		QueryBox aWarningBox( NULL, DesktopResId( QBX_JAVADISABLED ));
		String aTitle = String( DesktopResId( STR_QUESTION_JAVADISABLED ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
		if ( nResult == RET_YES )
		{
            jfw_setEnabled(sal_True);
		}
	}
	else if ( anyExc >>= e4 )
	{
		// Java not correctly installed, or damaged
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );
		
		ErrorBox aWarningBox( NULL, DesktopResId( ERRORBOX_JVMCREATIONFAILED ));
		String aTitle = String( DesktopResId( STR_ERROR_JVMCREATIONFAILED ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
	}
	else if ( anyExc >>= e5 )
	{
		// a new JRE was selected, but office needs to be restarted
        //before it can be used.
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );
		
		ErrorBox aWarningBox( NULL, DesktopResId( ERRORBOX_RESTARTREQUIRED ));
		String aTitle = String( DesktopResId( STR_ERROR_RESTARTREQUIRED ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
	}

	if ( nResult == RET_CANCEL || nResult == RET_NO)
	{
		// Unknown exception type or user wants to cancel
		if ( abort.is() )
			abort->select();
	}
	else // nResult == RET_OK 
	{
		// User selected OK => retry Java usage
		if ( retry.is() )
			retry->select();
	}
}

JavaContext::JavaContext( const Reference< XCurrentContext > & ctx )
    : m_xNextContext( ctx )
{
}

Any SAL_CALL JavaContext::getValueByName( const OUString& Name) throw (RuntimeException)
{
    Any retVal;

    if ( 0 == Name.compareToAscii( JAVA_INTERACTION_HANDLER_NAME ))
    {
        retVal = makeAny( Reference< XInteractionHandler >( new JavaInteractionHandler()) );
    }
	else if( m_xNextContext.is() )
	{
        // Call next context in chain if found
        retVal = m_xNextContext->getValueByName( Name );
	}
    return retVal;
}


}
