/*************************************************************************
 *
 *  $RCSfile: propbrowserui.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/16 12:10:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX
#define EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX

/** === begin UNO includes === **/
/** === end UNO includes === **/

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

//........................................................................
namespace pcr
{
//........................................................................

	//====================================================================
	//= EPropertyCategory
	//====================================================================
    enum EPropertyCategory
    {
        eGeneral,
        eData,
        eEvents
    };

	//====================================================================
	//= IPropertyBrowserUI
	//====================================================================
    /** a callback for <type>IPropertyHandler</type>
    */
    class IPropertyBrowserUI
    {
    public:
        /// enables or disables all components belonging to the UI representation of a property
        virtual void    enablePropertyUI( const ::rtl::OUString& _rPropertyName, bool _bEnable ) = 0;

        /** enables or disables the up to two buttons which can be part of the UI representation of a property

            Note that the complete UI for the property must be enabled in order for these settings to
            be evaluated. That is, enablePropertyButtons does not have any effect until you enabled
            the UI for this property with enablePropertyUI.
        */
        virtual void    enablePropertyButtons( const ::rtl::OUString& _rPropertyName, bool _bEnablePrimary, bool _bEnableSecondary ) = 0;

        /// rebuilds the UI for the given property.
        virtual void    rebuildPropertyUI( const ::rtl::OUString& _rPropertyName ) = 0;

        /// shows the ui for a given property
        virtual void    showPropertyUI( const ::rtl::OUString& _rPropertyName, bool _bRefreshIfExistent ) = 0;

        /// hides the ui for a given property
        virtual void    hidePropertyUI( const ::rtl::OUString& _rPropertyName ) = 0;

        /// shows or hides all properties belonging to a given category
        virtual void    showCategory( EPropertyCategory _eCategory, bool _bShow ) = 0;
    };

//........................................................................
} // namespace pcr
//........................................................................

#endif // EXTENSIONS_SOURCE_PROPCTRLR_PROPBROWSERUI_HXX

