<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: table_columns.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2004/09/20 12:21:55 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:office="http://openoffice.org/2000/office"
    xmlns:style="http://openoffice.org/2000/style"
    xmlns:text="http://openoffice.org/2000/text"
    xmlns:table="http://openoffice.org/2000/table"
    xmlns:draw="http://openoffice.org/2000/drawing"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:number="http://openoffice.org/2000/datastyle"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:chart="http://openoffice.org/2000/chart"
    xmlns:dr3d="http://openoffice.org/2000/dr3d"
    xmlns:math="http://www.w3.org/1998/Math/MathML"
    xmlns:form="http://openoffice.org/2000/form"
    xmlns:script="http://openoffice.org/2000/script"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:meta="http://openoffice.org/2000/meta"
    xmlns:config="http://openoffice.org/2001/config"
    xmlns:help="http://openoffice.org/2000/help"
    xmlns:xt="http://www.jclark.com/xt"
    xmlns:common="http://exslt.org/common"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help xt common xalan">

    <xsl:param name="tableColumnElement"            select="'col'" />

    <!-- ******************************************** -->
    <!-- *** Create table columns style variable  *** -->
    <!-- ******************************************** -->

    <!-- current node is a table:table or table:sub-table -->
    <xsl:template name="create-column-style-variable">
        <xsl:param name="globalData" />
        <xsl:param name="allVisibleTableRows" />

        <!-- all columns of the table -->
        <xsl:variable name="allTableColumns" select="table:table-column |
                                                     table:table-column-group/descendant::table:table-column |
                                                     table:table-header-columns/descendant::table:table-column" />
        <!-- allTableColumns: Containing all columns of the table, hidden and viewed.
            - if a column is hidden, if table:visibility has the value 'collapse' or 'filter', otherwise the value is 'visible'
            - if a column is being repeated, each repeated column is explicitly written as entry in this variable.
              Later (during template "write-cell") the style of the column will be mixed with the cell-style by using
              the position() of the column entry and comparing it with the iterating cell number. -->
        <xsl:variable name="allTableColumns-RTF">
            <xsl:for-each select="$allTableColumns">
                <xsl:call-template name="adding-column-styles-entries">
                    <xsl:with-param name="globalData"       select="$globalData" />
                    <xsl:with-param name="allTableColumns"  select="$allTableColumns" />
                </xsl:call-template>
            </xsl:for-each>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="function-available('xt:node-set')">
                <xsl:call-template name="create-table-children">
                    <xsl:with-param name="globalData"           select="$globalData" />
                    <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
                    <xsl:with-param name="allTableColumns"      select="xt:node-set($allTableColumns-RTF)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('xalan:nodeset')">
                <xsl:call-template name="create-table-children">
                    <xsl:with-param name="globalData"           select="$globalData" />
                    <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
                    <xsl:with-param name="allTableColumns"      select="xalan:nodeset($allTableColumns-RTF)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('common:node-set')">
                <xsl:call-template name="create-table-children">
                    <xsl:with-param name="globalData"           select="$globalData" />
                    <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
                    <xsl:with-param name="allTableColumns"      select="common:node-set($allTableColumns-RTF)" />
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- current node is a table:table or table:sub-table -->
    <xsl:template name="create-table-children">
        <xsl:param name="globalData" />
        <xsl:param name="allVisibleTableRows" />
        <xsl:param name="allTableColumns" />


        <xsl:for-each select="$allTableColumns/table:table-column">
            <xsl:if test="not(@table:visibility = 'collapse' or @table:visibility = 'filter')">

                <xsl:call-template name="create-column-element">
                    <xsl:with-param name="globalData"           select="$globalData" />
                    <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
                    <xsl:with-param name="allTableColumns"      select="$allTableColumns" />
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>

        <xsl:call-template name="create-table-rows">
            <xsl:with-param name="globalData"           select="$globalData" />
            <xsl:with-param name="allVisibleTableRows"  select="$allVisibleTableRows" />
            <xsl:with-param name="allTableColumns"      select="$allTableColumns" />
        </xsl:call-template>
    </xsl:template>

    <!-- To be OVERWRITTEN -->
    <xsl:template name="create-column-element" />

    <!-- current node is a table:table-column -->
    <xsl:template name="adding-column-styles-entries">
        <xsl:param name="globalData" />
        <xsl:param name="allTableColumns" />

        <xsl:choose>
            <!-- if parser reads DTD the default is set to '1' -->
            <xsl:when test="not(@table:number-columns-repeated and @table:number-columns-repeated > 1)">
                <!-- writes an entry of a column in the columns-variable -->
                <xsl:copy-of select="." />
            </xsl:when>
            <!-- No higher repetition of cells greater than 99 for the last and second last column.
                 This is a workaround for some sample document (Waehrungsumrechner.sxc),
                 having 230 repeated columns in the second last column to emulate background -->
            <!-- 2DO: Testcase with a table containing table:table-column-group and/or table:table-header-columns -->
            <xsl:when test="(last() or (last() - 1)) and @table:number-columns-repeated &gt; 99">
                <!-- writes an entry of a column in the columns-variable -->
                <xsl:call-template name="repeat-adding-table-column">
                    <xsl:with-param name="numberColumnsRepeated"    select="1" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- repeated colums will be written explicit several times in the variable-->
                <xsl:call-template name="repeat-adding-table-column">
                    <xsl:with-param name="numberColumnsRepeated"    select="@table:number-columns-repeated" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
     </xsl:template>


    <!-- WRITES THE REPEATED COLUMN STYLE EXPLICIT AS AN ELEMENT IN THE COLUMNS-VARIABLE -->
    <!-- current node is a table:table-column -->
    <xsl:template name="repeat-adding-table-column">
        <xsl:param name="table:table-column" />
        <xsl:param name="numberColumnsRepeated" />


        <xsl:choose>
            <xsl:when test="$numberColumnsRepeated > 1">
                <!-- writes an entry of a column in the columns-variable -->
                <xsl:copy-of select="." />
                <!-- repeat calling this method until all elements written out -->
                <xsl:call-template name="repeat-adding-table-column">
                    <xsl:with-param name="numberColumnsRepeated"    select="$numberColumnsRepeated - 1" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- writes an entry of a column in the columns-variable -->
                <xsl:copy-of select="." />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!--debugEnabled-START-->
    <!-- giving out the 'allColumnStyle' variable:
        For each 'table:table-column' of the 'allTableColumns' variable the style-name is given out.
        In case of 'column-hidden-flag' attribute the text 'Column is hidden is given out.-->
    <!-- current node is a table:table or table:sub-table -->
    <xsl:template name="table-debug-allTableColumns">
        <xsl:param name="allTableColumns" />

        <!-- debug output as table summary attribut in html -->
        <xsl:attribute name="summary">
            <xsl:call-template name="table-debug-column-out">
                <xsl:with-param name="allTableColumns" select="$allTableColumns" />
            </xsl:call-template>
        </xsl:attribute>
        <!-- debug output to console -->
        <xsl:message>
            <xsl:call-template name="table-debug-column-out">
                <xsl:with-param name="allTableColumns" select="$allTableColumns" />
            </xsl:call-template>
        </xsl:message>
    </xsl:template>

    <!-- current node is a table:table or table:sub-table -->
    <xsl:template name="table-debug-column-out">
        <xsl:param name="allTableColumns" />
            <xsl:text>
            DebugInformation: For each 'table:table-column' of the 'allTableColumns' variable the style-name is given out.
                              In case of table:visibility attribute unequal 'visible' the 'column is hidden' no text is given out.
            </xsl:text>
                <xsl:for-each select="$allTableColumns/table:table-column">
                <xsl:choose>
                <xsl:when test="@table:visibility = 'collapse' or @table:visibility = 'filter' ">
            <xsl:text>  </xsl:text><xsl:value-of select="@table:style-name" /><xsl:text>column is hidden</xsl:text><xsl:text>
            </xsl:text>
                </xsl:when>
                <xsl:otherwise>
            <xsl:text>  </xsl:text><xsl:value-of select="@table:style-name" /><xsl:text> </xsl:text><xsl:value-of select="@table:default-cell-style-name" /><xsl:text>
            </xsl:text>
                </xsl:otherwise>
                </xsl:choose>
                           </xsl:for-each>
    </xsl:template>
    <!--debugEnabled-END-->

</xsl:stylesheet>
