<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: table_of_content.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/01/28 15:22:02 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:office="http://openoffice.org/2000/office"
    xmlns:style="http://openoffice.org/2000/style"
    xmlns:text="http://openoffice.org/2000/text"
    xmlns:table="http://openoffice.org/2000/table"
    xmlns:draw="http://openoffice.org/2000/drawing"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:number="http://openoffice.org/2000/datastyle"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:chart="http://openoffice.org/2000/chart"
    xmlns:dr3d="http://openoffice.org/2000/dr3d"
    xmlns:math="http://www.w3.org/1998/Math/MathML"
    xmlns:form="http://openoffice.org/2000/form"
    xmlns:script="http://openoffice.org/2000/script"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:meta="http://openoffice.org/2000/meta"
    xmlns:config="http://openoffice.org/2001/config"
    xmlns:help="http://openoffice.org/2000/help"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
    xmlns:common="http://exslt.org/common"
    xmlns:xt="http://www.jclark.com/xt"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java sxg xt common xalan">

    <!-- ****************************** -->
    <!-- ***    Table of Content    *** -->
    <!-- ****************************** -->


    <xsl:template match="text:table-of-content">
        <xsl:param name="globalData" />

        <xsl:apply-templates>
            <xsl:with-param name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>


    <xsl:template match="text:index-body">
        <xsl:param name="globalData" />

        <xsl:choose>
            <xsl:when test="$javaEnabled">
                <xsl:apply-templates mode="content-table">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates>
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="text:index-title" mode="content-table">
        <xsl:param name="globalData" />

        <xsl:apply-templates>
            <xsl:with-param name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>


    <!-- ************************************************ -->
    <!-- *** Create Table for Content Table Paragraph *** -->
    <!-- ************************************************ -->

    <!-- Usually the paragraph in a content-table are ordered by tab-stops, which can not be displayed correctly by XHTML/CSS
     Therefore they will be simulated by a table -->
    <xsl:template match="text:p" mode="content-table">
        <xsl:param name="globalData" />

        <xsl:variable name="allTabStopStyles" select="$globalData/office:automatic-styles/style:style[@style:name = current()/@text:style-name]/style:properties/style:tab-stops" />
        <xsl:element namespace="{$namespace}" name="table">
            <xsl:attribute name="border">0</xsl:attribute>
            <xsl:attribute name="cellspacing">0</xsl:attribute>
            <xsl:attribute name="cellpadding">0</xsl:attribute>
            <xsl:variable name="value" select="$globalData/all-ooo-styles/style[@style:name = current()/@table:style-name]/style:properties/@style:rel-width" />
            <xsl:if test="$value">
                <xsl:attribute name="width">
                    <xsl:value-of select="$value" />
                </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="class">
                <xsl:value-of select="translate(@text:style-name, '. %()/\+', '')" />
            </xsl:attribute>

            <xsl:element namespace="{$namespace}" name="colgroup">
                <xsl:call-template name="create-col-element">
                    <xsl:with-param name="lastNodePosition" select="count($allTabStopStyles/style:tab-stop)" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:element>

            <!-- all elements before the first tabStop -->
            <xsl:variable name="testNo-RTF">
                <xsl:apply-templates select="node()" mode="cell-content" />
            </xsl:variable>

            <xsl:choose>
                <xsl:when test="function-available('xt:node-set')">
                    <xsl:variable name="tabNodePositions" select="xt:node-set($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count($allTabStopStyles/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="function-available('xalan:nodeset')">
                    <xsl:variable name="tabNodePositions" select="xalan:nodeset($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count($allTabStopStyles/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:when test="function-available('common:node-set')">
                    <xsl:variable name="tabNodePositions" select="common:node-set($testNo-RTF)" />
                    <xsl:element namespace="{$namespace}" name="tr">
                        <xsl:call-template name="create-td-elements">
                            <xsl:with-param name="lastNodePosition" select="count($allTabStopStyles/style:tab-stop)" />
                            <xsl:with-param name="position" select="1" />
                            <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                            <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>


    <xsl:template name="create-col-element">
        <xsl:param name="lastNodePosition" />
        <xsl:param name="allTabStopStyles" />

        <xsl:for-each select="$allTabStopStyles/style:tab-stop">
            <xsl:element namespace="{$namespace}" name="col">
                <xsl:attribute name="style">
                    <xsl:text>width: </xsl:text>
                    <xsl:call-template name="grap-cell-width">
                        <xsl:with-param name="position" select="position()" />
                        <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                    </xsl:call-template>
                </xsl:attribute>
            </xsl:element>
        </xsl:for-each>

    </xsl:template>
<!--
Scenarios tabstops

1) style:type of style:tab-stop is 'right' and earlier tabStop is not right
 -> Earlier text-nodes and following text-nodes, will be put into an inner table, with two TD first aligned left, with proceding textnodes, the latter aligned right.

2) style:type is 'right' and earlier tabStop is right
 -> following text-nodes, will be put into a right aligned TD

3) style:type is 'non-right' and earlier tabStop 'non-right' as well
 -> put the preceding tab stops into a TD (left aligned is default)

4) first style:type would have no right precedign tabStop
 -> works well with first sceanrios 1 and 3

5) last style:type would be a special case, if it would be left aligned, but this won't happen in our case.. :D

Scenarios unmatched:
- text:styleposition 'center' will not be matched in our case (effort for nothing), there will be only 'right' and not 'right'
- If the last tabStop is not from text:stylepostion 'right', the length of the last cell is undefined and a document length must be found.
  Not happens in our master document case. Also the algorithm below would have to be expanded (cp. scenario 5).

-->
    <xsl:template name="create-td-elements">
        <xsl:param name="globalData" />
        <xsl:param name="lastNodePosition" />
        <xsl:param name="position" />
        <xsl:param name="allTabStopStyles" />
        <xsl:param name="tabNodePositions" />

        <xsl:variable name="currentStyleType" select="$allTabStopStyles/style:tab-stop[$position]/@style:type" />
        <xsl:variable name="earlierStyleType" select="$allTabStopStyles/style:tab-stop[$position - 1]/@style:type" />

        <xsl:choose>
            <xsl:when test="not($currentStyleType)">
            <!-- in case no TAB STOP is being set -->
                <xsl:element namespace="{$namespace}" name="td">
                    <xsl:apply-templates mode="content-table">
                        <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$currentStyleType = 'right'">
                        <xsl:choose>
                            <xsl:when test="$earlierStyleType = 'right'">
                                <!--
                                2) style:type is 'right' and earlier tabStop is right
                                    -> following text-nodes, will be put into a right aligned TD -->
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:attribute name="style">
                                        <xsl:text>align: right</xsl:text>
                                    </xsl:attribute>
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position + 1" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$earlierStyleType = 'right'"></xsl:when>
                            <xsl:otherwise>
                            <!--
                               3) style:type is 'non-right' and earlier tabStop 'non-right' as well
                                    -> put the preceding tab stops into a TD (left aligned is default) -->
                                <xsl:element namespace="{$namespace}" name="td">
                                    <xsl:call-template name="grap-cell-content-before-tab-stop">
                                        <xsl:with-param name="globalData" select="$globalData" />
                                        <xsl:with-param name="endingTabStopPosition" select="$position" />
                                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                                    </xsl:call-template>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>

                <xsl:if test="$position != $lastNodePosition">
                    <xsl:call-template name="create-td-elements">
                        <xsl:with-param name="globalData" select="$globalData" />
                        <xsl:with-param name="lastNodePosition" select="$lastNodePosition" />
                        <xsl:with-param name="position" select="$position + 1" />
                        <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                        <xsl:with-param name="tabNodePositions" select="$tabNodePositions" />
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="grap-cell-content-before-tab-stop">
        <xsl:param name="globalData" />
        <xsl:param name="endingTabStopPosition" />
        <xsl:param name="tabNodePositions" />
        <xsl:param name="lastNodePosition" />

        <xsl:choose>
            <xsl:when test="$endingTabStopPosition = 1">
                <xsl:apply-templates mode="content-table" select="node()[position() &lt; $tabNodePositions/tab-stop-node-position[$endingTabStopPosition]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:when test="$endingTabStopPosition > $lastNodePosition">
                <xsl:apply-templates mode="content-table" select="node()[position() > $tabNodePositions/tab-stop-node-position[$endingTabStopPosition - 1]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates mode="content-table" select="node()[position() &lt; $tabNodePositions/tab-stop-node-position[$endingTabStopPosition]][position() > $tabNodePositions/tab-stop-node-position[$endingTabStopPosition - 1]]">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="grap-cell-width">
        <xsl:param name="position" />
        <xsl:param name="allTabStopStyles" />

        <xsl:variable name="tabStopPosition" select="$allTabStopStyles/style:tab-stop[$position]/@style:position" />
        <xsl:choose>
            <xsl:when test="contains($tabStopPosition, 'cm')">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="number(substring-before($tabStopPosition,'cm'))" />
                    <xsl:with-param name="unit" select="'cm'" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="contains($tabStopPosition, 'in')">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="number(substring-before($tabStopPosition,'in'))" />
                    <xsl:with-param name="unit" select="'in'" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="contains($tabStopPosition, 'ch')">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="number(substring-before($tabStopPosition,'ch'))" />
                    <xsl:with-param name="unit" select="'ch'" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="contains($tabStopPosition, 'pt')">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="number(substring-before($tabStopPosition,'pt'))" />
                    <xsl:with-param name="unit" select="'pt'" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="create-cell-width">
        <xsl:param name="width" />
        <xsl:param name="unit" />
        <xsl:param name="position" />
        <xsl:param name="allTabStopStyles" />

        <xsl:choose>
            <xsl:when test="$position > 1">
                <xsl:call-template name="create-cell-width">
                    <xsl:with-param name="width" select="$width - number(substring-before($allTabStopStyles/style:tab-stop[$position]/@style:position,$unit))" />
                    <xsl:with-param name="unit" select="$unit" />
                    <xsl:with-param name="position" select="$position - 1" />
                    <xsl:with-param name="allTabStopStyles" select="$allTabStopStyles" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$position = 1">
                <xsl:value-of select="concat($width - number(substring-before($allTabStopStyles/style:tab-stop[$position]/@style:position,$unit)), $unit)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($width, $unit)" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- ************************************** -->
    <!--    CREATION OF A CONTENT TABLE LINK    -->
    <!-- ************************************** -->


     <!-- content table link  -->
    <xsl:template match="text:a" mode="content-table">
        <xsl:param name="globalData" />

        <!-- For anchors in content-headers a bug exists (cp. bug id# 102311) and they have to be worked out separately.
            Currently the link used in the content-table of an Office XML (e.g. in the content table as '#7.Some%20Example%20Headline%7Outline')
            is not a valid URL (cp. bug id# 102311). No file destination is specified nor exist any anchor element for these
            links in the Office XML, nor is the chapter no. known in the linked files.
            A workaround for this transformation therefore had to be made. This time-consuming mechanism is disabled by default and
            can be activated by a parameter (i.e. 'parseChildDocuments'). A creation of an anchor is made for each header element.
            All header titles gonna be encoding to be usable in a relative URL. -->
        <xsl:choose>
            <xsl:when test="$javaEnabled and $masterDocumentEnabled">
                <xsl:call-template name="create-content-table-link">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="create-common-anchor-link">
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- a special behavior of text:a
        (called from the 'text:a' template) -->

    <xsl:template name="create-content-table-link">
        <xsl:param name="globalData" />

        <xsl:element namespace="{$namespace}" name="a">
            <xsl:attribute name="href">
                <xsl:choose>
                    <xsl:when test="starts-with(@xlink:href, '#')">
                        <xsl:variable name="correctHeading" select="$globalData/content-table-headings/heading[current()/@xlink:href = @content-table-id]" />
                        <xsl:call-template name="get-relative-child-u-r-l">
                            <xsl:with-param name="toChildFileRef" select="$correctHeading/@out-file-url" />
                        </xsl:call-template>
                        <xsl:text>#</xsl:text>
                        <xsl:value-of select="$correctHeading/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$correctHeading/@encoded-title" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="create-common-anchor-link">
                            <xsl:with-param name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>


    <xsl:template match="text:s" mode="content-table">
        <xsl:call-template name="write-breakable-whitespace">
            <xsl:with-param name="whitespaces" select="@text:c" />
        </xsl:call-template>
    </xsl:template>



    <!-- ***************************************************************** -->
    <!-- *** Extern of ToC - Creating an Anchor Name for every heading *** -->
    <!-- ***************************************************************** -->

    <!-- necessary as anchor for the content table -->
    <xsl:template name="create-heading-anchor">
        <xsl:param name="globalData" />

        <!--
        Currently the link used in the Office XML (e.g. in the content table as '#7.Some%20Example%20Headline%7Outline')
        is not a valid URL (cmp. bug id# 102311). No file destination is specified nor exist any anchor element for these
        links in the Office XML.
        Here we are creating an anchor with the space normalized text of this header as potential jump address of the content table -->
        <xsl:choose>
            <xsl:when test="$currentChildContentRef">
                <!-- 2DO: Have to be removed (here a Java-Helper is necessary)  -->
                <xsl:variable name="currentFileHeadingNo">
                    <xsl:call-template name="get-next-current-file-heading-no">
                        <xsl:with-param name="file" select="$currentChildContentRef" />
                    </xsl:call-template>
                </xsl:variable>

                <xsl:variable name="testResult" select="$contentTableHeadings/heading[$currentChildContentRef = @file-url][number($currentFileHeadingNo)]" />
                <xsl:if test="$debugEnabled">
                    <xsl:message>Matching child document header No. <xsl:value-of select="$currentFileHeadingNo" />
                    </xsl:message>
                    <xsl:message>absolute-chapter-level:         <xsl:value-of select="$testResult/@absolute-chapter-level" />
                    </xsl:message>
                    <xsl:message>encodedTitle:                   <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:message>
                    <xsl:message>currentChildContentRef: <xsl:value-of select="$currentChildContentRef" />
                    </xsl:message>
                    <xsl:message>*** </xsl:message>
                </xsl:if>
                <xsl:element namespace="{$namespace}" name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$testResult/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:attribute>
                </xsl:element>
            </xsl:when>

            <xsl:otherwise>
                <!-- When the chapter is in the master document itself the link has to be relative (e.g. #index) a absolute href does not
                    work with the browser. In case of chapter in the master document, the output URL of the master document was taken. -->
                <xsl:variable name="currentFileHeadingNo">
                    <xsl:call-template name="get-next-current-file-heading-no">
                        <xsl:with-param name="file" select="$contentTableURL" />
                    </xsl:call-template>
                </xsl:variable>
                <xsl:variable name="testResult" select="$globalData/content-table-headings/heading[$contentTableURL = @file-url][number($currentFileHeadingNo)]" />

                <xsl:if test="$debugEnabled">
                    <xsl:message>Matching master document header No. <xsl:value-of select="$currentFileHeadingNo" />
                    </xsl:message>
                    <xsl:message>absolute-chapter-level:  <xsl:value-of select="$testResult/@absolute-chapter-level" />
                    </xsl:message>
                    <xsl:message>encodedTitle:            <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:message>
                    <xsl:message>contentTableURL:         <xsl:value-of select="$contentTableURL" />
                    </xsl:message>
                    <xsl:message>*** </xsl:message>
                </xsl:if>

                <xsl:element namespace="{$namespace}" name="a">
                    <xsl:attribute name="name">
                        <xsl:value-of select="$testResult/@absolute-chapter-level" />
                        <xsl:text>_</xsl:text>
                        <xsl:value-of select="$testResult/@encoded-title" />
                    </xsl:attribute>
                </xsl:element>

            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="get-relative-child-u-r-l">
        <xsl:param name="toChildFileRef" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:get-relative-child-u-r-l')">
                <xsl:value-of select="sxg:get-relative-child-u-r-l(string($toChildFileRef))" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL(string($toChildFileRef))" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getRelativeChildURL</xsl:message>
            </xsl:otherwise>
       </xsl:choose>
    </xsl:template>


    <!-- ******************** -->
    <!-- *** Common Rules *** -->
    <!-- ******************** -->

    <!-- deactivating default template -->
    <xsl:template match="*" mode="content-table" />

    <xsl:template match="*" mode="cell-content">
        <xsl:if test="name() = 'text:tab-stop' or *[name() = 'text:tab-stop']">
            <xsl:element name="tab-stop-node-position" namespace="">
                <xsl:value-of select="position()" />
            </xsl:element>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
