<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: header.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2005/01/28 15:23:52 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help"
                exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help"
                xmlns="http://www.w3.org/1999/xhtml">



    <!-- ************** -->
    <!-- *** header *** -->
    <!-- ************** -->

    <xsl:template name="create-header">
        <xsl:param name="globalData" />

        <xsl:element name="head">
            <xsl:if test="$debugEnabled"><xsl:message>CSS helper variable will be created....</xsl:message></xsl:if>
            <xsl:call-template name='xhtml-header-properties'>
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:call-template>

            <!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
            <xsl:if test="$outputType = 'CSS_HEADER'">
                <xsl:if test="$debugEnabled"><xsl:message>CSS variable ready, header will be created....</xsl:message></xsl:if>
                <!-- constructing the css header simulating inheritance of style-families by style order -->
                <xsl:call-template name='create-css-styleheader'>
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
                <xsl:if test="$debugEnabled"><xsl:message>CSS header creation finished!</xsl:message></xsl:if>
            </xsl:if>
        </xsl:element>

    </xsl:template>


    <!-- Creating a CSS style header from the collected styles of the 'globalData' parameter -->
    <xsl:template name='create-css-styleheader'>
        <xsl:param name="globalData" />

        <xsl:element name="style">
            <xsl:attribute name="type">text/css</xsl:attribute>
<xsl:text>
    </xsl:text>
    <xsl:call-template name='create-page-layout'>
        <xsl:with-param name="globalData" select="$globalData" />
    </xsl:call-template>
<xsl:text>table { border-collapse:collapse; border-spacing:0; empty-cells:show }
    </xsl:text>
<xsl:text>td, th { vertical-align:top; }
    </xsl:text>
<xsl:text>h1, h2, h3, h4, h5, h6 { clear:both }
    </xsl:text>
<xsl:text>* { margin:0; }
    </xsl:text>
            <xsl:for-each select="$globalData/all-styles/style">
            <!-- 2DO: only the style family in conjunction with the style name, makes the style unambigous -->
        <xsl:text>*.</xsl:text><!--<xsl:value-of select="@style:family" /><xsl:text>:</xsl:text>--><xsl:value-of select="translate(@style:name, '. %()/\+', '')" /><xsl:text> { </xsl:text> <xsl:value-of select="final-properties" /><xsl:text>}
    </xsl:text>
            </xsl:for-each>
        </xsl:element>

    </xsl:template>


    <!-- Creating CSS page layout based on first office master style -->
    <xsl:template name='create-page-layout'>
        <xsl:param name="globalData" />

<xsl:text>@page { </xsl:text>

        <xsl:call-template name="page-size">
            <xsl:with-param name="globalData"   select="$globalData" />
        </xsl:call-template>
        <xsl:call-template name="page-margin">
            <xsl:with-param name="globalData"   select="$globalData" />
        </xsl:call-template>

<xsl:text> }
    </xsl:text>

    </xsl:template>



    <xsl:template name="page-size">
        <xsl:param name="globalData" />

        <xsl:variable name="printOrientation"  select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@style:print-orientation" />
        <xsl:variable name="pageWidth"         select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:page-width" />
        <xsl:variable name="pageHeight"        select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:page-height" />
        <xsl:choose>
            <xsl:when test="$pageWidth and $pageHeight">
                <xsl:text>size: </xsl:text>
                <xsl:value-of select="$pageWidth" />
                <xsl:text> </xsl:text>
                <xsl:value-of select="$pageHeight" />
                <xsl:text>; </xsl:text>
            </xsl:when>
            <xsl:when test="$printOrientation">
                <xsl:text>size: </xsl:text>
                <xsl:value-of select="$printOrientation" />
                <xsl:text>; </xsl:text>
            </xsl:when>
        </xsl:choose>
    </xsl:template>



    <xsl:template name="page-margin">
        <xsl:param name="globalData" />

        <xsl:variable name="marginTop"  select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:margin-top" />
        <xsl:if test="$marginTop">
            <xsl:text>margin-top: </xsl:text>
            <xsl:value-of select="$marginTop" />
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:variable name="marginBottom"  select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:margin-bottom" />
        <xsl:if test="$marginBottom">
            <xsl:text>margin-bottom: </xsl:text>
            <xsl:value-of select="$marginBottom" />
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:variable name="marginLeft"  select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:margin-left" />
        <xsl:if test="$marginLeft">
            <xsl:text>margin-left: </xsl:text>
            <xsl:value-of select="$marginLeft" />
            <xsl:text>; </xsl:text>
        </xsl:if>
        <xsl:variable name="marginRight"  select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/@fo:margin-right" />
        <xsl:if test="$marginRight">
            <xsl:text>margin-right: </xsl:text>
            <xsl:value-of select="$marginRight" />
        </xsl:if>
    </xsl:template>



    <!-- ********************************************************** -->
    <!-- *** Common XHTML header for CSS_INLINED and CSS_HEADER *** -->
    <!-- ********************************************************** -->

    <xsl:template name='xhtml-header-properties'>
        <xsl:param name="globalData" />

        <!-- explicit output content-type for low-tech browser (e.g. IE6) -->
        <xsl:element name="meta">
            <xsl:attribute name="http-equiv">content-type</xsl:attribute>
            <xsl:attribute name="content">text/html; charset=utf-8</xsl:attribute>
        </xsl:element>

        <!-- title of document for browser frame title -->
        <xsl:element name="title">
            <xsl:choose>
                <xsl:when test="$globalData/meta-file/*/office:meta/dc:title">
                    <xsl:value-of select="$globalData/meta-file/*/office:meta/dc:title" />
                </xsl:when>
                <!--<xsl:otherwise>
                    <xsl:text>- no title specified</xsl:text>
                </xsl:otherwise>-->
            </xsl:choose>
        </xsl:element>

        <!-- a bit commercial -->
        <xsl:element name="meta">
            <xsl:attribute name="name">generator</xsl:attribute>
            <xsl:attribute name="content">StarOffice/OpenOffice XSLT (http://xml.openoffice.org/sx2ml)</xsl:attribute>
        </xsl:element>

        <!-- the author of the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'author'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/meta:initial-creator" />
        </xsl:call-template>

        <!-- creation-date of the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'created'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/meta:creation-date" />
        </xsl:call-template>

        <!-- name of last changing person of the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'changedby'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/dc:creator" />
        </xsl:call-template>

        <!-- last changing date of the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'changed'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/dc:date" />
        </xsl:call-template>


        <!-- short description about the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'subject'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/dc:subject" />
        </xsl:call-template>

        <!-- detailed description about the input source -->
        <xsl:call-template name="add-meta-tag">
            <xsl:with-param name="meta-name" select="'description'" />
            <xsl:with-param name="meta-data" select="$globalData/meta-file/*/office:meta/dc:description" />
        </xsl:call-template>

        <!-- keywords about the input source -->
        <xsl:call-template name="add-meta-keywords">
            <xsl:with-param name="keyWords" select="$globalData/meta-file/*/office:meta/meta:keywords" />
        </xsl:call-template>

        <!-- title of document for browser frame title -->
        <xsl:element name="base">
            <xsl:attribute name="href">
                <xsl:value-of select="$targetURL" />
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <!-- generic template for adding common meta tags -->
    <xsl:template name="add-meta-tag">
        <xsl:param name="meta-name" />
        <xsl:param name="meta-data" />

        <xsl:if test="$meta-data">
            <xsl:element name="meta">
                <xsl:attribute name="name">
                    <xsl:value-of select="$meta-name" />
                </xsl:attribute>
                <xsl:attribute name="content">
                    <xsl:value-of select="$meta-data" />
                </xsl:attribute>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <!-- helper template to write keyword elements into a tokenized string -->
    <xsl:template name="add-meta-keywords">
        <xsl:param name="keyWords" />

        <xsl:if test="$keyWords">
            <xsl:element name="meta">
                <xsl:attribute name="name">keywords</xsl:attribute>
                <xsl:attribute name="content">
                    <xsl:for-each select="$keyWords/meta:keyword">
                        <xsl:value-of select="." />
                        <xsl:if test="position() != last()">
                            <xsl:text>, </xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:attribute>
            </xsl:element>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
