/*************************************************************************
 *
 *  $RCSfile: CheckXDispatchInformationProvider.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Date: 2004/11/16 14:52:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package complex.dispatches;

import com.sun.star.frame.*;
import com.sun.star.lang.*;
import com.sun.star.util.*;
import com.sun.star.beans.*;
import com.sun.star.uno.*;

import java.util.*;

import complexlib.ComplexTestCase;

import helper.URLHelper;

//-----------------------------------------------
/** @short  Check the interface XDispatchInformationProvider

    @descr  Because there exists more then one implementation of a dispatch
            object, we have to test all these implementations ...
 */
public class CheckXDispatchInformationProvider extends ComplexTestCase
{
    //-------------------------------------------
    // some const
    
    //-------------------------------------------
    // member
    
    /** points to the global uno service manager. */    
    private XMultiServiceFactory m_xMSF = null;
    
    /** provides XDispatchInformationProvider interface. */
    private XFrame m_xFrame = null;
    
    //-------------------------------------------
    // test environment
    
    //-------------------------------------------
    /** @short  A function to tell the framework,
                which test functions are available.
                
        @return All test methods.
        @todo   Think about selection of tests from outside ...     
     */
    public String[] getTestMethodNames()
    {
        return new String[]
        {
            "checkDispatchInfoOfWriter",
            "checkDispatchInfoOfCalc",
            "checkDispatchInfoOfDraw",
            "checkDispatchInfoOfImpress",
            "checkDispatchInfoOfMath",
            "checkDispatchInfoOfChart",
            "checkDispatchInfoOfBibliography",
            "checkDispatchInfoOfQueryDesign",
            "checkDispatchInfoOfTableDesign",
            "checkDispatchInfoOfFormGridView",
            "checkDispatchInfoOfDataSourceBrowser",
            "checkDispatchInfoOfRelationDesign",
            "checkDispatchInfoOfBasic",
            "checkDispatchInfoOfStartModule"
        };
    }
    
    //-------------------------------------------
    /** @short  Create the environment for following tests.
    
        @descr  create an empty test frame, where we can load
                different components inside.
     */
    public void before()
    {
        // get uno service manager from global test environment
        m_xMSF = (XMultiServiceFactory)param.getMSF();

        // create frame instance
        try
        {
            XFrame xDesktop = (XFrame)UnoRuntime.queryInterface(
                                XFrame.class, 
                                m_xMSF.createInstance("com.sun.star.frame.Desktop"));
            m_xFrame = xDesktop.findFrame("_blank", 0);
            m_xFrame.getContainerWindow().setVisible(true);
        }
        catch(java.lang.Throwable ex)
        {
            failed("Could not create the frame instance.");
        }
    }

    //-------------------------------------------
    /** @short  close the environment.
     */
    public void after()
    {
        XCloseable xClose = (XCloseable)UnoRuntime.queryInterface(
                                XCloseable.class,
                                m_xFrame);
        try
        {
            xClose.close(false);
        }
        catch(com.sun.star.util.CloseVetoException exVeto)
        {
            failed("Test frame couldn't be closed successfully.");
        }
        
        m_xFrame = null;
    }

    //-------------------------------------------
    public void checkDispatchInfoOfWriter()
    {
        impl_loadIntoFrame("private:factory/swriter");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfCalc()
    {
        impl_loadIntoFrame("private:factory/scalc");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfDraw()
    {
        impl_loadIntoFrame("private:factory/sdraw");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfImpress()
    {
        impl_loadIntoFrame("private:factory/simpress");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfChart()
    {
        impl_loadIntoFrame("private:factory/schart");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfMath()
    {
        impl_loadIntoFrame("private:factory/smath");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfDataBase()
    {
        impl_loadIntoFrame("private:factory/sdatabase");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfBibliography()
    {
        impl_loadIntoFrame(".component:Bibliography/View1");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfQueryDesign()
    {
        impl_loadIntoFrame(".component:DB/QueryDesign");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfTableDesign()
    {
        impl_loadIntoFrame(".component:DB/TableDesign");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfFormGridView()
    {
        impl_loadIntoFrame(".component:DB/FormGridView");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfDataSourceBrowser()
    {
        impl_loadIntoFrame(".component:DB/DataSourceBrowser");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfRelationDesign()
    {
        impl_loadIntoFrame(".component:DB/RelationDesign");
        impl_checkDispatchInfo(m_xFrame);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfBasic()
    {
        Object aComponent = impl_createUNOComponent("com.sun.star.script.BasicIDE");
        impl_checkDispatchInfo(aComponent);
    }
    
    //-------------------------------------------
    public void checkDispatchInfoOfStartModule()
    {
        Object aComponent = impl_createUNOComponent("com.sun.star.frame.StartModule");
        impl_checkDispatchInfo(aComponent);
    }
            
    //-------------------------------------------
    /** @short  load an URL into the current test frame.
     */
    public void impl_loadIntoFrame(String sURL)
    {
        XComponentLoader xLoader = (XComponentLoader)UnoRuntime.queryInterface(
                                        XComponentLoader.class,
                                        m_xFrame);
        if (xLoader == null)
            failed("Frame does not provide required interface XComponentLoader.");
        
        XComponent xDoc = null;
        try
        {
            xDoc = xLoader.loadComponentFromURL(sURL, "_self", 0, null);
        }
        catch(java.lang.Throwable ex)
        {
            xDoc = null;
        }
        
        if (xDoc == null)
            failed("Could not load \""+sURL+"\".");
    }
    
    //-------------------------------------------
    /** @short  create an uno implementation directly.
     */
    public Object impl_createUNOComponent(String sName)
    {
        Object aComponent = null;
        try
        {
            aComponent = m_xMSF.createInstance(sName);
        }
        catch(java.lang.Throwable ex)
        {
            aComponent = null;
        }
        
        if (aComponent == null)
            failed("Could not create UNO component \""+sName+"\".");
        return aComponent;
    }
    
    //-------------------------------------------
    /** @short  check the interface XDispatchInformationProvider
                at the specified component.
     */
    private void impl_checkDispatchInfo(Object aComponent)
    {
        XDispatchInformationProvider xInfoProvider = (XDispatchInformationProvider)UnoRuntime.queryInterface(
                                                        XDispatchInformationProvider.class,
                                                        aComponent);
        if (xInfoProvider == null)
        {
            // Warning
            log.println("Warning:\tComponent does not provide the [optional!] interface XDispatchInformationProvider.");
            return;
        }
        
        try
        {
            short[] lGroups = xInfoProvider.getSupportedCommandGroups();
            int     c1      = lGroups.length;
            int     i1      = 0;
            for (i1=0; i1<c1; ++i1)
            {
                short                 nGroup = lGroups[i1];
                DispatchInformation[] lInfos = xInfoProvider.getConfigurableDispatchInformation(nGroup);
                int                   c2     = lInfos.length;
                int                   i2     = 0;
                
                // check for empty lists
                // Warning
                if (lInfos.length < 1)
                    log.println("Warning:\tCould not get any DispatchInformation for group ["+nGroup+"].");

                // check for duplicates (and by the way, if the info item match the requested group)
                HashMap aCheckMap = new HashMap(c2);
                for (i2=0; i2<c2; ++i2)
                {
                    DispatchInformation aInfo = lInfos[i2];
                    if (aInfo.GroupId != nGroup)
                    {
                        // Error
                        failed("At least one DispatchInformation item does not match the requested group.\n\trequested group=["+nGroup+
                               "] returned groupd=["+aInfo.GroupId+"] command=\""+aInfo.Command+"\"", true); // true => dont break this test
                        continue;
                    }

                    if (aCheckMap.containsKey(aInfo.Command))
                    {
                        // Error
                        failed("Found a duplicate item: group=["+aInfo.GroupId+"] command=\""+aInfo.Command+"\"", true); // true => dont break this test
                        continue;
                    }

                    aCheckMap.put(aInfo.Command, aInfo.Command);
                    log.println("\t["+aInfo.GroupId+"] \""+aInfo.Command+"\"");
                }
            }
        }
        catch(java.lang.Throwable ex)
        {
            failed("Exception caught during using XDispatchInformationProvider.");
            ex.printStackTrace();
        }
    }
}