/*************************************************************************
 *
 *  $RCSfile: b2drascon.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/06 15:02:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_RASCON_HXX
#include "b2drascon.hxx"
#endif

#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif

//************************************************************
// Helper class for holding hor line segments during raster
// conversion
//************************************************************

class ImplLineNode
{
	ImplLineNode*				mpNext;
	sal_uInt32					mnYCounter;
	double						mfXPos;
	double						mfXDelta;

public:
	ImplLineNode(const Point& rP1, const Point& rP2);

	const double& GetXPos() const { return mfXPos; }
	ImplLineNode* GetNext() const { return mpNext; }
	void SetNext(ImplLineNode* pNew) { mpNext = pNew; }

	sal_Bool Progress();
};

ImplLineNode::ImplLineNode(const Point& rP1, const Point& rP2)
:	mpNext(0L),
	mnYCounter((rP2.Y() - rP1.Y()) - 1),
	mfXPos(double(rP1.X()))
{
	mfXDelta = double(rP2.X() - rP1.X()) / double(mnYCounter);
}

sal_Bool ImplLineNode::Progress()
{
	if(mnYCounter)
	{
		// go one step in Y
		mfXPos += mfXDelta;
		mnYCounter--;

		return sal_False;
	}
	else
	{
		return sal_True;
	}
}

//************************************************************
//   Base2D PolyPolygon Raster Converter (Rasterizer)
//************************************************************

void B2dPolyPolygonRasterConverter::ImplAddSortedLineNode(ImplLineNode* pNew, ImplLineNode** ppDestList)
{
	if(pNew)
	{
		ImplLineNode* pCurrent = *ppDestList;
		ImplLineNode* pPrevious = 0L;

		while(pCurrent && pNew->GetXPos() > pCurrent->GetXPos())
		{
			pPrevious = pCurrent;
			pCurrent = pCurrent->GetNext();
		}

		if(!pPrevious)
		{
			// add as first
			pNew->SetNext(pCurrent);
			*ppDestList = pNew;
		}
		else
		{
			// add after pPrevious
			pNew->SetNext(pCurrent);
			pPrevious->SetNext(pNew);
		}
	}
}

void B2dPolyPolygonRasterConverter::ImplAddList(const Polygon& rPolygon)
{
	if(rPolygon.GetSize() > 2)
	{
		const sal_uInt16 nPolySize(rPolygon.GetSize());

		for(sal_uInt32 a(0); a < nPolySize; a++)
		{
			const Point& rP1 = rPolygon[(sal_uInt16)a];
			const Point& rP2 = rPolygon[((sal_uInt16)a + 1) % nPolySize];

			if(rP1.Y() != rP2.Y())
			{
				sal_Int32 nYMin(rP1.Y());
				ImplLineNode* pNew = 0L;

				if(rP2.Y() < nYMin)
				{
					pNew = new ImplLineNode(rP2, rP1);
					nYMin = rP2.Y();
				}
				else
				{
					pNew = new ImplLineNode(rP1, rP2);
				}

				const sal_uInt32 nIndex(nYMin - maPolyPolyRectangle.Top());
				ImplAddSortedLineNode(pNew, &mppLineNodes[nIndex]);
			}
		}
	}
}

void B2dPolyPolygonRasterConverter::ImplBuildLists()
{
	sal_uInt32 a; // for the "for" loop

	if(!maPolyPolyRectangle.IsEmpty())
	{
		const sal_uInt32 nStepCount(maPolyPolyRectangle.Bottom() - maPolyPolyRectangle.Top());

		if(nStepCount)
		{
			mppLineNodes = new ImplLineNode*[nStepCount + 1];

			for( a = 0; a < nStepCount + 1; a++)
			{
				mppLineNodes[a] = 0L;
			}

			for( a = 0; a < mrPolyPolygonRaster.Count(); a++)
			{
				ImplAddList(mrPolyPolygonRaster[(sal_uInt16)a]);
			}
		}
	}
}

void B2dPolyPolygonRasterConverter::ImplPrepareLine()
{
	// sort current lines
	ImplLineNode* pNode = mpCurrentLine;
	ImplLineNode* pPrevNode = 0L;

	while(pNode && pNode->GetNext())
	{
		ImplLineNode* pNextNode = pNode->GetNext();

		if(pNode->GetXPos() > pNode->GetNext()->GetXPos())
		{
			// exchange pNode, pNextNode
			pNode->SetNext(pNextNode->GetNext());
			pNextNode->SetNext(pNode);
			
			if(pPrevNode)
			{
				pPrevNode->SetNext(pNextNode);
			}
			else
			{
				mpCurrentLine = pNextNode;
			}

			pPrevNode = pNextNode;
		}
		else
		{
			pPrevNode = pNode;
			pNode = pNextNode;
		}
	}

	// add new nodes for this line
	if(mppLineNodes)
	{
		pNode = mppLineNodes[mnYCurrent];

		if(pNode)
		{
			while(pNode)
			{
				ImplLineNode* pNextNode = pNode->GetNext();
				ImplAddSortedLineNode(pNode, &mpCurrentLine);
				pNode = pNextNode;
			}

			mppLineNodes[mnYCurrent] = 0L;
		}
	}
}

void B2dPolyPolygonRasterConverter::ImplProcessLine()
{
	// step through mpCurrentLine and call Scanline(...) for every pair
	ImplLineNode* pNode = mpCurrentLine;
	sal_uInt32 nNodeNumber(0L);

	while(pNode)
	{
		ImplLineNode* pNextNode = pNode->GetNext();
		
		if(pNextNode)
		{
			Scanline(pNode->GetXPos(), pNextNode->GetXPos(), maPolyPolyRectangle.Top() + mnYCurrent, nNodeNumber++);
		}

		pNode = pNextNode;
	}
}

void B2dPolyPolygonRasterConverter::ImplProgressLine()
{
	ImplLineNode* pNode = mpCurrentLine;
	ImplLineNode* pPrev = 0L;

	while(pNode)
	{
		if(pNode->Progress())
		{
			// remove this entry
			ImplLineNode* pNext = pNode->GetNext();

			if(pPrev)
				pPrev->SetNext(pNext);
			else
				mpCurrentLine = pNext;

			delete pNode;

			pNode = pNext;
		}
		else
		{
			pPrev = pNode;
			pNode = pNode->GetNext();
		}
	}
}

B2dPolyPolygonRasterConverter::B2dPolyPolygonRasterConverter(const PolyPolygon& rPolyPolyRaster)
:	mnYCurrent(0L),
	mppLineNodes(0L),
	mpCurrentLine(0L),
	mrPolyPolygonRaster(rPolyPolyRaster),
	maPolyPolyRectangle(rPolyPolyRaster.GetBoundRect())
{
	ImplBuildLists();
}

B2dPolyPolygonRasterConverter::~B2dPolyPolygonRasterConverter()
{
	delete mppLineNodes;
}

void B2dPolyPolygonRasterConverter::Convert()
{
	const sal_uInt32 nStepCount(maPolyPolyRectangle.Bottom() - maPolyPolyRectangle.Top());

	while(mnYCurrent <= nStepCount)
	{
		ImplPrepareLine();
		ImplProcessLine();
		ImplProgressLine();
		mnYCurrent++;
	}
}

// eof
