/*************************************************************************
 *
 *  $RCSfile: ChXDiagram.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change:$Date: 2003/09/08 12:23:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package mod._sch;

import java.io.PrintWriter;

import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

import com.sun.star.awt.Rectangle;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

/**
* Test for object which is represented by the following services:
* <ul>
*   <li> <code>com.sun.star.chart.Dim3DDiagram</code> </li>
*   <li> <code>com.sun.star.chart.StockDiagram</code> </li>
*   <li> <code>com.sun.star.chart.LineDiagram</code> </li>
*   <li> <code>com.sun.star.chart.BarDiagram</code> </li>
*   <li> <code>com.sun.star.chart.StackableDiagram</code> </li>
* </ul>
*  <p>
* Object implements the following interfaces :
* <ul>
*  <li> <code>com::sun::star::chart::XDiagram</code></li>
*  <li> <code>com::sun::star::chart::ChartAxisXSupplier</code></li>
*  <li> <code>com::sun::star::chart::Dim3DDiagram</code></li>
*  <li> <code>com::sun::star::chart::StockDiagram</code></li>
*  <li> <code>com::sun::star::chart::ChartAxisZSupplier</code></li>
*  <li> <code>com::sun::star::chart::XTwoAxisXSupplier</code></li>
*  <li> <code>com::sun::star::chart::LineDiagram</code></li>
*  <li> <code>com::sun::star::chart::BarDiagram</code></li>
*  <li> <code>com::sun::star::chart::XAxisYSupplier</code></li>
*  <li> <code>com::sun::star::chart::Diagram</code></li>
*  <li> <code>com::sun::star::chart::X3DDisplay</code></li>
*  <li> <code>com::sun::star::chart::ChartTwoAxisYSupplier</code></li>
*  <li> <code>com::sun::star::chart::StackableDiagram</code></li>
*  <li> <code>com::sun::star::chart::ChartAxisYSupplier</code></li>
*  <li> <code>com::sun::star::chart::XAxisXSupplier</code></li>
*  <li> <code>com::sun::star::chart::ChartTwoAxisXSupplier</code></li>
*  <li> <code>com::sun::star::drawing::XShape</code></li>
*  <li> <code>com::sun::star::chart::XTwoAxisYSupplier</code></li>
*  <li> <code>com::sun::star::chart::ChartStatistics</code></li>
*  <li> <code>com::sun::star::beans::XPropertySet</code></li>
*  <li> <code>com::sun::star::drawing::XShapeDescriptor</code></li>
*  <li> <code>com::sun::star::chart::XAxisZSupplier</code></li>
*  <li> <code>com::sun::star::chart::XStatisticDisplay</code></li>
* </ul>
* @see com.sun.star.chart.XDiagram
* @see com.sun.star.chart.ChartAxisXSupplier
* @see com.sun.star.chart.Dim3DDiagram
* @see com.sun.star.chart.StockDiagram
* @see com.sun.star.chart.ChartAxisZSupplier
* @see com.sun.star.chart.XTwoAxisXSupplier
* @see com.sun.star.chart.LineDiagram
* @see com.sun.star.chart.BarDiagram
* @see com.sun.star.chart.XAxisYSupplier
* @see com.sun.star.chart.Diagram
* @see com.sun.star.chart.X3DDisplay
* @see com.sun.star.chart.ChartTwoAxisYSupplier
* @see com.sun.star.chart.StackableDiagram
* @see com.sun.star.chart.ChartAxisYSupplier
* @see com.sun.star.chart.XAxisXSupplier
* @see com.sun.star.chart.ChartTwoAxisXSupplier
* @see com.sun.star.drawing.XShape
* @see com.sun.star.chart.XTwoAxisYSupplier
* @see com.sun.star.chart.ChartStatistics
* @see com.sun.star.beans.XPropertySet
* @see com.sun.star.drawing.XShapeDescriptor
* @see com.sun.star.chart.XAxisZSupplier
* @see com.sun.star.chart.XStatisticDisplay
* @see ifc.chart._XDiagram
* @see ifc.chart._ChartAxisXSupplier
* @see ifc.chart._Dim3DDiagram
* @see ifc.chart._StockDiagram
* @see ifc.chart._ChartAxisZSupplier
* @see ifc.chart._XTwoAxisXSupplier
* @see ifc.chart._LineDiagram
* @see ifc.chart._BarDiagram
* @see ifc.chart._XAxisYSupplier
* @see ifc.chart._Diagram
* @see ifc.chart._X3DDisplay
* @see ifc.chart._ChartTwoAxisYSupplier
* @see ifc.chart._StackableDiagram
* @see ifc.chart._ChartAxisYSupplier
* @see ifc.chart._XAxisXSupplier
* @see ifc.chart._ChartTwoAxisXSupplier
* @see ifc.drawing._XShape
* @see ifc.chart._XTwoAxisYSupplier
* @see ifc.chart._ChartStatistics
* @see ifc.beans._XPropertySet
* @see ifc.drawing._XShapeDescriptor
* @see ifc.chart._XAxisZSupplier
* @see ifc.chart._XStatisticDisplay
*/
public class ChXDiagram extends TestCase {
    XSpreadsheetDocument xSheetDoc = null;

    /**
    * Creates Spreadsheet document.
    */
    protected void initialize( TestParameters tParam, PrintWriter log ) {
        // get a soffice factory object
        SOfficeFactory SOF = SOfficeFactory.getFactory( (XMultiServiceFactory)tParam.getMSF());

        try {
            log.println( "creating a sheetdocument" );
            xSheetDoc = SOF.createCalcDoc(null);;
        } catch (com.sun.star.uno.Exception e) {
            // Some exception occures.FAILED
            e.printStackTrace( log );
            throw new StatusException( "Couldn't create document", e );
        }
    }

    /**
    * Disposes Spreadsheet document.
    */
    protected void cleanup( TestParameters tParam, PrintWriter log ) {
        log.println( "    disposing xSheetDoc " );
        XComponent oComp = (XComponent)
            UnoRuntime.queryInterface(XComponent.class, xSheetDoc);
        oComp.dispose();
    }

    /**
    * Creating a Testenvironment for the interfaces to be tested.
    * Retrieves a collection of spreadsheets from a document
    * and takes one of them. Inserts some values into the cells of the some cell
    * range address. Adds and retrieves the chart that using the data from
    * the cells of this cell range address. Obtains the chart document which is
    * embedded into the retrieved chart using the interface
    * <code>XEmbeddedObjectSupplier</code>. Retrieves the diagram from
    * the obtained chart document. The retrieved diagram is the instance of
    * the service <code>com.sun.star.chart.Diagram</code>.
    * Obtains the data source of the chart from the chart document.
    * Creates a stock-diagram, a bar-diagram, a XY-diagram and line-diagram
    * that are the instances of the following services:
    * <ul>
    *   <li> <code>com.sun.star.chart.StockDiagram</code> </li>
    *   <li> <code>com.sun.star.chart.BarDiagram</code> </li>
    *   <li> <code>com.sun.star.chart.LineDiagram</code> </li>
    *   <li> <code>com.sun.star.chart.StackableDiagram</code> </li>
    * </ul>.
    * Object relations created :
    * <ul>
    *  <li> <code>'CHARTDOC'</code> for
    *      {@link ifc.chart._Dim3DDiagram}, {@link ifc.chart._StockDiagram},
    *      {@link ifc.chart._ChartAxisZSupplier}, {@link _LineDiagram},
    *      {@link ifc.chart._BarDiagram}, {@link ifc.chart._Diagram},
    *      {@link ifc.chart._ChartTwoAxisYSupplier},
    *      {@link ifc.chart._StackableDiagram}, {@link ifc.chart._Diagram},
    *      {@link ifc.chart._ChartAxisYSupplier},
    *      {@link ifc.chart._ChartTwoAxisXSupplier},
    *      {@link ifc.chart._ChartStatistics} (the obtained chart document)</li>
    *  <li> <code>'ROWAMOUNT', 'COLAMOUNT'</code> for
    *      {@link ifc.chart._XDiagram}(the number of chart columns and
    *       the number of chart rows) </li>
    *  <li> <code>'STOCK'</code> for
    *      {@link ifc.chart._StockDiagram}(the created stock-diagram) </li>
    *  <li> <code>'BAR'</code> for
    *      {@link ifc.chart._BarDiagram}, {@link ifc.chart._ChartAxisZSupplier},
    *      {@link ifc.chart._ChartTwoAxisXSupplier},
    *      {@link ifc.chart._ChartTwoAxisYSupplier}(the created bar-diagram)</li>
    *  <li> <code>'LINE'</code> for
    *      {@link ifc.chart._LineDiagram}(the created XY-diagram) </li>
    *  <li> <code>'STACK'</code> for
    *      {@link ifc.chart._StackableDiagram}(the created Line-diagram) </li>
    * </ul>
    * @see com.sun.star.document.XEmbeddedObjectSupplier
    * @see com.sun.star.chart.Diagram
    * @see com.sun.star.chart.StockDiagram
    */
    protected synchronized TestEnvironment createTestEnvironment
            (TestParameters Param, PrintWriter log) {

        XSpreadsheet oSheet=null;
        XChartDocument xChartDoc=null;
        XDiagram oObj = null;

        System.out.println("Getting spreadsheet") ;
        XSpreadsheets oSheets = xSheetDoc.getSheets() ;
        XIndexAccess oIndexSheets = (XIndexAccess)
            UnoRuntime.queryInterface(XIndexAccess.class, oSheets);
        try {
            oSheet = (XSpreadsheet) AnyConverter.toObject(
                    new Type(XSpreadsheet.class),oIndexSheets.getByIndex(0));
        } catch(com.sun.star.lang.WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        } catch(com.sun.star.lang.IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        } catch(com.sun.star.lang.IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }

        log.println("Creating the Header") ;

        insertIntoCell(1,0,"JAN",oSheet,"");
        insertIntoCell(2,0,"FEB",oSheet,"");
        insertIntoCell(3,0,"MAR",oSheet,"");
        insertIntoCell(4,0,"APR",oSheet,"");
        insertIntoCell(5,0,"MAI",oSheet,"");
        insertIntoCell(6,0,"JUN",oSheet,"");
        insertIntoCell(7,0,"JUL",oSheet,"");
        insertIntoCell(8,0,"AUG",oSheet,"");
        insertIntoCell(9,0,"SEP",oSheet,"");
        insertIntoCell(10,0,"OCT",oSheet,"");
        insertIntoCell(11,0,"NOV",oSheet,"");
        insertIntoCell(12,0,"DEC",oSheet,"");
        insertIntoCell(13,0,"SUM",oSheet,"");

        log.println("Fill the lines");

        insertIntoCell(0,1,"Smith",oSheet,"");
        insertIntoCell(1,1,"42",oSheet,"V");
        insertIntoCell(2,1,"58.9",oSheet,"V");
        insertIntoCell(3,1,"-66.5",oSheet,"V");
        insertIntoCell(4,1,"43.4",oSheet,"V");
        insertIntoCell(5,1,"44.5",oSheet,"V");
        insertIntoCell(6,1,"45.3",oSheet,"V");
        insertIntoCell(7,1,"-67.3",oSheet,"V");
        insertIntoCell(8,1,"30.5",oSheet,"V");
        insertIntoCell(9,1,"23.2",oSheet,"V");
        insertIntoCell(10,1,"-97.3",oSheet,"V");
        insertIntoCell(11,1,"22.4",oSheet,"V");
        insertIntoCell(12,1,"23.5",oSheet,"V");
        insertIntoCell(13,1,"=SUM(B2:M2)",oSheet,"");

        insertIntoCell(0,2,"Jones",oSheet,"");
        insertIntoCell(1,2,"21",oSheet,"V");
        insertIntoCell(2,2,"40.9",oSheet,"V");
        insertIntoCell(3,2,"-57.5",oSheet,"V");
        insertIntoCell(4,2,"-23.4",oSheet,"V");
        insertIntoCell(5,2,"34.5",oSheet,"V");
        insertIntoCell(6,2,"59.3",oSheet,"V");
        insertIntoCell(7,2,"27.3",oSheet,"V");
        insertIntoCell(8,2,"-38.5",oSheet,"V");
        insertIntoCell(9,2,"43.2",oSheet,"V");
        insertIntoCell(10,2,"57.3",oSheet,"V");
        insertIntoCell(11,2,"25.4",oSheet,"V");
        insertIntoCell(12,2,"28.5",oSheet,"V");
        insertIntoCell(13,2,"=SUM(B3:M3)",oSheet,"");

        insertIntoCell(0,3,"Brown",oSheet,"");
        insertIntoCell(1,3,"31.45",oSheet,"V");
        insertIntoCell(2,3,"-20.9",oSheet,"V");
        insertIntoCell(3,3,"-117.5",oSheet,"V");
        insertIntoCell(4,3,"23.4",oSheet,"V");
        insertIntoCell(5,3,"-114.5",oSheet,"V");
        insertIntoCell(6,3,"115.3",oSheet,"V");
        insertIntoCell(7,3,"-171.3",oSheet,"V");
        insertIntoCell(8,3,"89.5",oSheet,"V");
        insertIntoCell(9,3,"41.2",oSheet,"V");
        insertIntoCell(10,3,"71.3",oSheet,"V");
        insertIntoCell(11,3,"25.4",oSheet,"V");
        insertIntoCell(12,3,"38.5",oSheet,"V");
        insertIntoCell(13,3,"=SUM(A4:L4)",oSheet,"");

        // insert a chart
        Rectangle oRect = new Rectangle(500, 3000, 25000, 11000);

        XCellRange oRange = (XCellRange)
            UnoRuntime.queryInterface(XCellRange.class, oSheet);
        XCellRange myRange = oRange.getCellRangeByName("A1:N4");
        XCellRangeAddressable oRangeAddr = (XCellRangeAddressable)
            UnoRuntime.queryInterface(XCellRangeAddressable.class, myRange);
        CellRangeAddress myAddr = oRangeAddr.getRangeAddress();

        CellRangeAddress[] oAddr = new CellRangeAddress[1];
        oAddr[0] = myAddr;
        XTableChartsSupplier oSupp = (XTableChartsSupplier)
            UnoRuntime.queryInterface(XTableChartsSupplier.class, oSheet);

        log.println("Insert Chart");
        XTableCharts oCharts = oSupp.getCharts();


        if (!oCharts.hasByName("ChXDiagram")) {
            oCharts.addNewByName("ChXDiagram", oRect, oAddr, true, true);
        }

        // get the TableChart
        XTableChart oChart = null;
        try {
            oChart = (XTableChart) AnyConverter.toObject(
                new Type(XTableChart.class),((XNameAccess)
                    UnoRuntime.queryInterface(
                        XNameAccess.class, oCharts)).getByName("ChXDiagram"));
        } catch (com.sun.star.lang.WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        } catch (com.sun.star.container.NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }  catch (com.sun.star.lang.IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }

        XEmbeddedObjectSupplier oEOS = (XEmbeddedObjectSupplier)
            UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, oChart);
        XInterface oInt = oEOS.getEmbeddedObject();
        xChartDoc = (XChartDocument)
             UnoRuntime.queryInterface(XChartDocument.class,oInt);
        oObj = (XDiagram) xChartDoc.getDiagram();

        log.println( "creating a new environment for chartdocument object" );
        TestEnvironment tEnv = new TestEnvironment( oObj );

        log.println( "adding ChartDocument as mod relation to environment" );
        tEnv.addObjRelation("CHARTDOC", xChartDoc);

        XChartDataArray da = (XChartDataArray)
            UnoRuntime.queryInterface(XChartDataArray.class, xChartDoc.getData());
        int cols = da.getColumnDescriptions().length;
        int rows = da.getRowDescriptions().length;

        tEnv.addObjRelation("ROWAMOUNT", new Integer(rows));
        tEnv.addObjRelation("COLAMOUNT", new Integer(cols));

        SOfficeFactory SOF = SOfficeFactory.getFactory( (XMultiServiceFactory)Param.getMSF());
        Object stock = SOF.createDiagram(xChartDoc,"StockDiagram");
        tEnv.addObjRelation("STOCK",stock);

        Object bar = SOF.createDiagram(xChartDoc,"BarDiagram");
        tEnv.addObjRelation("BAR",bar);

        Object line = SOF.createDiagram(xChartDoc,"XYDiagram");
        tEnv.addObjRelation("LINE",line);

        Object stack = SOF.createDiagram(xChartDoc,"LineDiagram");
        tEnv.addObjRelation("STACK",stack);

        return tEnv;
    } // finish method getTestEnvironment

    /**
    * Inserts a value or a formula in the cell of the spreasheet.
    * @param CellX is the column index of the cell
    * @param CellY is the row index of the cell
    * @param theValue string representation of the value
    * @param TT1 specify the spreadsheet, the interface
    * <code>com.sun.star.sheet.XSpreadsheet</code>
    * @param flag if it's equal to <code>'V'</code> then the method inserts
    * a double-value in the cell else it inserts a formula in the cell
    */
    public static void insertIntoCell(
        int CellX, int CellY, String theValue, XSpreadsheet TT1, String flag) {

        XCell oCell = null;

        try {
            oCell = TT1.getCellByPosition(CellX, CellY);
        } catch (com.sun.star.lang.IndexOutOfBoundsException ex) {
            System.out.println("Could not get Cell");
        }
        if (flag.equals("V")) {oCell.setValue((new Float(theValue)).floatValue());}
                   else {oCell.setFormula(theValue);}

    } // end of insertIntoCell


}    // finish class ChXDiagram

