/*************************************************************************
 *
 *  $RCSfile: XclImpCharts.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: vg $ $Date: 2004/12/23 11:04:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef SC_XCLIMPCHARTS_HXX
#include "XclImpCharts.hxx"
#endif

#ifndef SVX_XFILLIT0_HXX
#include <svx/xfillit0.hxx>
#endif
#ifndef _SVX_XFLGRIT_HXX
#include <svx/xflgrit.hxx>
#endif
#ifndef _SVX_XBTMPIT_HXX
#include <svx/xbtmpit.hxx>
#endif
#ifndef _SVX_UNOMID_HXX
#include <svx/unomid.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_DRWLAYER_HXX
#include "drwlayer.hxx"
#endif

#ifndef SC_XISTYLE_HXX
#include "xistyle.hxx"
#endif
#ifndef SC_XIESCHER_HXX
#include "xiescher.hxx"
#endif
#ifndef SC_XLTRACER_HXX
#include "xltracer.hxx"
#endif


#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif
#ifndef _EXCFORM_HXX
#include "excform.hxx"
#endif

using namespace ::com::sun::star;

//___________________________________________________________________

template< typename Type >
inline void lcl_Exchange( Type& rData1, Type& rData2 )
{
    Type aTemp( rData1 );
	rData1 = rData2;
	rData2 = aTemp;
}

template< typename Type >
inline void lcl_CopyContent( Type*& rpDestPtr, const Type* pSourcePtr )
{
    rpDestPtr = pSourcePtr ? new Type( *pSourcePtr ) : NULL;
}

template< typename Type >
inline void lcl_MovePtr( Type*& rpDestPtr, Type*& rpSourcePtr )
{
	rpDestPtr = rpSourcePtr;
	rpSourcePtr = NULL;
}


//___________________________________________________________________

XclImpStream& operator>>( XclImpStream& rStrm, XclImpChart_Pos& rPos )
{
    rStrm >> rPos.nPosX >> rPos.nPosY >> rPos.nWidth >> rPos.nHeight;
    return rStrm;
}


//___________________________________________________________________

XclImpChart_Lineformat::XclImpChart_Lineformat( XclImpStream& rStrm )
{
    UINT16 nFlags, nColorIdx;

    rStrm.Ignore( 4 );  // Line color RGB
    rStrm >> nPattern >> nWeight >> nFlags >> nColorIdx;

    bAuto       = ::get_flag( nFlags, EXC_CHART_LINEF_AUTO );
    bDrawTick   = ::get_flag( nFlags, EXC_CHART_LINEF_TICK );
    nLineColor  = rStrm.GetRoot().GetPalette().GetColorData( nColorIdx );
}


//___________________________________________________________________

XclImpChart_FillData::XclImpChart_FillData( const XclImpRoot& rRoot ) :
    XclImpRoot( rRoot ),
    maItemSet( rRoot.GetDoc().GetDrawLayer()->GetItemPool() ),
    meMode( drawing::BitmapMode_REPEAT )
{
}

void XclImpChart_FillData::ReadGelframe( XclImpStream& rStrm )
{
    // use temporary object manager, not the one of the root data
    XclImpObjectManager aObjManager( GetRoot() );
    XclImpEscherPropSet aPropSet( aObjManager.GetDffManager() );
    // read from stream
    rStrm.ResetRecord( true, rStrm.GetRecId() );
    rStrm >> aPropSet;
    // get the data
    aPropSet.FillToItemSet( maItemSet );
    sal_uInt32 nType = aPropSet.GetPropertyValue( DFF_Prop_fillType, mso_fillSolid );
    meMode = (nType == mso_fillPicture) ?
        drawing::BitmapMode_STRETCH : drawing::BitmapMode_REPEAT;
}

void XclImpChart_FillData::ReadPicf( XclImpStream& rStrm )
{
    sal_uInt16 nBmpMode;
    rStrm >> nBmpMode;
    meMode = (nBmpMode == EXC_CHART_PICF_STRETCH) ?
        drawing::BitmapMode_STRETCH : drawing::BitmapMode_REPEAT;
}

bool XclImpChart_FillData::GetGradient( awt::Gradient& rGradient ) const
{
    bool bRet = false;
    const XFillStyleItem* pStyleItem = static_cast< const XFillStyleItem* >( maItemSet.GetItem( XATTR_FILLSTYLE, FALSE ) );
    if( pStyleItem && (pStyleItem->GetValue() == XFILL_GRADIENT) )
    {
        const XFillGradientItem* pGradItem = static_cast< const XFillGradientItem* >( maItemSet.GetItem( XATTR_FILLGRADIENT, FALSE ) );
        uno::Any aAny;
        bRet = pGradItem && pGradItem->QueryValue( aAny, MID_FILLGRADIENT ) && (aAny >>= rGradient);
        rGradient.StepCount = 256;
    }
    return bRet;
}

bool XclImpChart_FillData::GetBitmap( uno::Reference< awt::XBitmap >& rXBitmap ) const
{
    bool bRet = false;
    const XFillStyleItem* pStyleItem = static_cast< const XFillStyleItem* >( maItemSet.GetItem( XATTR_FILLSTYLE, FALSE ) );
    if( pStyleItem && (pStyleItem->GetValue() == XFILL_BITMAP) )
    {
        const XFillBitmapItem* pBmpItem = static_cast< const XFillBitmapItem* >( maItemSet.GetItem( XATTR_FILLBITMAP, FALSE ) );
        uno::Any aAny;
        bRet = pBmpItem && pBmpItem->QueryValue( aAny, MID_BITMAP ) && (aAny >>= rXBitmap);
    }
    return bRet;
}


//___________________________________________________________________

XclImpChart_Areaformat::XclImpChart_Areaformat( XclImpStream& rStrm ) :
	pFillData( NULL )
{
    UINT16 nFlags, nForeIdx, nBackIdx;

    rStrm.Ignore( 8 );  // foreground RGB, background RGB
    rStrm >> nPattern >> nFlags >> nForeIdx >> nBackIdx;

    bAuto           = ::get_flag( nFlags, EXC_CHART_AREAF_AUTO );
    bInvertIfNeg    = ::get_flag( nFlags, EXC_CHART_AREAF_INVERT );

    const XclImpPalette& rPal = rStrm.GetRoot().GetPalette();
    nForeColor      = rPal.GetColorData( nForeIdx );
    nBackColor      = rPal.GetColorData( nBackIdx );
}

XclImpChart_Areaformat::~XclImpChart_Areaformat()
{
    delete pFillData;
}


//___________________________________________________________________

XclImpChart_MarkerFormat::XclImpChart_MarkerFormat( XclImpStream& rStrm )
{
    UINT16 nFlags, nForeIdx, nBackIdx;

    rStrm.Ignore( 8 );  // foreground RGB, background RGB
    rStrm >> nMarkerType >> nFlags >> nForeIdx >> nBackIdx >> nMarkerSize;

    const XclImpPalette& rPal = rStrm.GetRoot().GetPalette();
    nForeColor      = rPal.GetColorData( nForeIdx );
    nBackColor      = rPal.GetColorData( nBackIdx );
}


//___________________________________________________________________

XclImpChart_Text::XclImpChart_Text() :
		pString( NULL ), pFont( NULL ), pLine( NULL ), pArea( NULL ),
        nRot( 0 ),
		nAlignHor( EXC_CHART_TEXT_ALIGNCENTER ),
		nAlignVert( EXC_CHART_TEXT_ALIGNCENTER ),
		nMode( EXC_CHART_TEXT_BGTRANS ),
		nDataLabelPlace( EXC_CHART_TEXT_POSDEFAULT ),
        nTextColor( COL_BLACK ),    // !TODO
		nLinkObj( EXC_CHART_OLINK_NONE ),
		nLinkSer( 0 ), nLinkPoint( 0 )
{
	bAutoColor = bAutoText = bGenerated = bAutoBackgr = TRUE;
	bShowKey = bShowVal = bShowLabPrct = bShowPrct = bShowBSize = bShowLabel = FALSE;
	bVertical = bDeleted = FALSE;
}

XclImpChart_Text::XclImpChart_Text( XclImpStream& rStrm ) :
		pString( NULL ), pFont( NULL ),	pLine( NULL ), pArea( NULL ),
		nLinkObj( EXC_CHART_OLINK_NONE ),
		nLinkSer( 0 ), nLinkPoint( 0 )
{
    UINT16 nFlags, nPlace, nColorIdx;

    rStrm >> nAlignHor >> nAlignVert >> nMode;
    rStrm.Ignore( 4 );  // text color RGB
    rStrm >> aPos >> nFlags >> nColorIdx >> nPlace >> nRot;

    bAutoColor      = ::get_flag( nFlags, EXC_CHART_TEXT_AUTOCOLOR );
    bShowKey        = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWKEY );
    bShowVal        = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWVALUE );
    bVertical       = ::get_flag( nFlags, EXC_CHART_TEXT_VERTICAL );
    bAutoText       = ::get_flag( nFlags, EXC_CHART_TEXT_AUTOTEXT );
    bGenerated      = ::get_flag( nFlags, EXC_CHART_TEXT_GENERATED );
    bDeleted        = ::get_flag( nFlags, EXC_CHART_TEXT_DELETED );
    bAutoBackgr     = ::get_flag( nFlags, EXC_CHART_TEXT_AUTOMODE );
    bShowLabPrct    = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWLABELPERC );
    bShowPrct       = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWPERCENT );
    bShowBSize      = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWBSIZE );
    bShowLabel      = ::get_flag( nFlags, EXC_CHART_TEXT_SHOWLABEL );
	nDataLabelPlace = (UINT8)(nPlace & 0x000F);
    nTextColor      = rStrm.GetRoot().GetPalette().GetColorData( nColorIdx );
}

XclImpChart_Text::~XclImpChart_Text()
{
    delete pString;
    delete pLine;
    delete pArea;
}


//___________________________________________________________________

XclImpChart_LinkedData::XclImpChart_LinkedData( const XclImpRoot& rRoot ) :
    XclImpRoot( rRoot ),
    eState( dsNull ),
    bHasCatList( FALSE ),
    nSerCnt( 0 ),
    nMinColVal( SCCOL_MAX ),
    nMinRowVal( SCROW_MAX ),
    bValidChartRange( TRUE )
{
    xValList = new ScRangeList;
    xTitleList = new ScRangeList;
    xCatList = new ScRangeList;
}

void XclImpChart_LinkedData::UpdateMinValues( const ScRange& rRange )
{
    nMinColVal = Min( rRange.aStart.Col(), nMinColVal );
    nMinRowVal = Min( rRange.aStart.Row(), nMinRowVal );
}

void XclImpChart_LinkedData::AppendValues( const ScRange& rRange )
{
    GetDir( rRange );
    xValList->Append( rRange );
    UpdateMinValues( rRange );
}

void XclImpChart_LinkedData::AppendTitle( const ScRange& rRange )
{
    xTitleList->Append( rRange );
}

void XclImpChart_LinkedData::AppendCatNames( const ScRange& rRange )
{
    if( !bHasCatList )
    {
        GetDir( rRange );
        xCatList->Append( rRange );
        UpdateMinValues( rRange );
    }
}

void XclImpChart_LinkedData::GetDir( const ScRange& rRange )
{
	if( nSerCnt )
	{
		if( eState == dsFirst )
		{
			const ScRange* pLast = xValList->Last();
			if( pLast )
				eState = (pLast->aStart.Row() == pLast->aEnd.Row()) ? dsRows : dsCols;
		}
	}
	else
	{
		if( eState == dsNull )
		{
			if( rRange.aStart.Col() == rRange.aEnd.Col() )
				eState = (rRange.aStart.Row() == rRange.aEnd.Row()) ? dsFirst : dsCols;
			else if( rRange.aStart.Row() == rRange.aEnd.Row() )
				eState = dsRows;
			else if( (rRange.aEnd.Row() - rRange.aStart.Row()) >= static_cast<SCCOLROW>((rRange.aEnd.Col() - rRange.aStart.Col())) )
				eState = dsCols;
			else
				eState = dsRows;
		}
		else if( eState == dsFirst )
		{
			const ScRange*	pLast = xValList->Last();
			if( pLast )
				eState = (pLast->aStart.Row() == rRange.aStart.Row()) ? dsRows : dsCols;
		}
	}
}

void XclImpChart_LinkedData::EndSeries()
{
    nSerCnt++;
    bHasCatList = (xCatList->Count() != 0);
}

BOOL XclImpChart_LinkedData::Close()
{
    BOOL bValid = TRUE;
    const ScRange* pRange;

    // For use with Tracing: if our Chart Range is still valid, check
    // for range symmetry by comparing the start row/column positions.
    if(GetTracer().IsEnabled() && bValidChartRange)
    {
        bool bRange = true;
        if(eState == dsCols)
        {
            if(const ScRange* pCatRange = xCatList->First())
            {
                SCROW nFirstRow = pCatRange->aStart.Row();
                for( pRange = xValList->First(); pRange && bRange; pRange = xValList->Next() )
                {
                    SCROW nValRow = pRange->aStart.Row();
                    bRange = (nFirstRow == nValRow);
                }
                bValidChartRange = bRange;
            }
        }
        else if(eState == dsRows)
        {
            if(const ScRange* pCatRange = xCatList->First())
            {
                SCCOL nFirstCol = pCatRange->aStart.Col();
                for( pRange = xValList->First(); pRange && bRange; pRange = xValList->Next() )
                {
                    SCCOL nValCol = pRange->aStart.Col();
                    bRange = (nFirstCol == nValCol);
                }
                bValidChartRange = bRange;
            }
        }
    }

    // test title ranges (must be on top or left of value ranges)
    for( pRange = xTitleList->First(); pRange && bValid; pRange = xTitleList->Next() )
        bValid = (pRange->aEnd.Col() < nMinColVal) || (pRange->aEnd.Row() < nMinRowVal);

    if( bValid )
    {
        // append all title ranges
        for( pRange = xTitleList->First(); pRange; pRange = xTitleList->Next() )
			xValList->Append( *pRange );
        // append category ranges
        for( pRange = xCatList->First(); pRange; pRange = xCatList->Next() )
            xValList->Append( *pRange );

        // #i1508# XY chart needs own title range for X values range
        ScRange* pTitle = xTitleList->First();
        ScRange* pFirstCat = xCatList->First();
        if( pTitle && pFirstCat )
        {
            ScRange aNewTitle( *pTitle );
            if( eState == dsRows )  // modify row number
            {
                aNewTitle.aStart.SetRow( pFirstCat->aStart.Row() );
                aNewTitle.aEnd.SetRow( pFirstCat->aStart.Row() );
            }
            else                    // modify column numbers
            {
                aNewTitle.aStart.SetCol( pFirstCat->aStart.Col() );
                aNewTitle.aEnd.SetCol( pFirstCat->aStart.Col() );
            }
            xValList->Append( aNewTitle );
        }
    }

    return !bValid;
}

BOOL XclImpChart_LinkedData::ValidScatterRange()
{
    bool bRange = true;
    const ScRange* pRange;

    // Scatter charts will ony appear if the category(X) data range is
    // located in the left most column.
    if(const ScRange* pCatRange = xCatList->First())
    {
        SCCOL nFirstCol = pCatRange->aStart.Col();
        for( pRange = xValList->First(); pRange && bRange; pRange = xValList->Next() )
        {
            SCCOL nValCol = pRange->aStart.Col();
            bRange = (nFirstCol <= nValCol);
        }
    }
    return bRange;
}


//___________________________________________________________________

XclImpChart_Point::XclImpChart_Point( UINT32 nIndex ) :
		nPointNum( nIndex ),
		pLine( NULL ),
		pArea( NULL ),
		pText( NULL ),
		pMarker( NULL ),
		p3DData( NULL ),
		pPieDist( NULL ),
		pLabel( NULL )
{
}

XclImpChart_Point::~XclImpChart_Point()
{
    delete pLine;
    delete pArea;
    delete pText;
    delete pMarker;
    delete p3DData;
    delete pPieDist;
    delete pLabel;
}

void XclImpChart_Point::Update( const XclImpChart_Point& rPoint )
{
	if( !pLine )
		lcl_CopyContent( pLine, rPoint.pLine );
	if( !pArea )
		lcl_CopyContent( pArea, rPoint.pArea );
	if( !pText )
		lcl_CopyContent( pText, rPoint.pText );
	if( !pMarker )
		lcl_CopyContent( pMarker, rPoint.pMarker );
	if( !p3DData )
		lcl_CopyContent( p3DData, rPoint.p3DData );
	if( !pPieDist )
		lcl_CopyContent( pPieDist, rPoint.pPieDist );
	if( !pLabel )
		lcl_CopyContent( pLabel, rPoint.pLabel );
}

BOOL XclImpChart_Point::HasAttachedLabel()
{
    return pLabel ? ::get_flag( *pLabel, EXC_CHART_ATLAB_ISATTACHED ) : FALSE;
}


//___________________________________________________________________

XclImpChart_PointList::~XclImpChart_PointList()
{
    for( XclImpChart_Point* pPoint = First(); pPoint; pPoint = Next() )
		delete pPoint;
}

XclImpChart_Point* XclImpChart_PointList::Find( UINT16 nPoint )
{
    for( XclImpChart_Point* pPoint = First(); pPoint; pPoint = Next() )
		if( pPoint->nPointNum == nPoint )
			return pPoint;
	return NULL;
}

XclImpChart_Point& XclImpChart_PointList::GetPoint( UINT16 nPoint )
{
    XclImpChart_Point* pPoint = Find( nPoint );
	if( !pPoint )
	{
        pPoint = new XclImpChart_Point( nPoint );
		Append( pPoint );
	}
	return *pPoint;
}

BOOL XclImpChart_PointList::HasAttachedLabel()
{
    for( XclImpChart_Point* pPoint = First(); pPoint; pPoint = Next() )
		if( pPoint->HasAttachedLabel() )
			return TRUE;
	return FALSE;
}


//___________________________________________________________________

XclImpChart_Series::XclImpChart_Series( UINT16 nSerI ) :
		nSerInd( nSerI ),
		nSerNum( 0xFFFF ),
		pAll( NULL ),
		pSpec( NULL ),
		bSecondary( FALSE )
{
}

XclImpChart_Series::~XclImpChart_Series()
{
    delete pAll;
    delete pSpec;
}

XclImpChart_Point& XclImpChart_Series::GetPoint( UINT16 nPointNum )
{
	if( nPointNum == EXC_CHART_DATAF_SERIES )
	{
		if( !pAll )
            pAll = new XclImpChart_Point( nPointNum );
		return *pAll;
	}

	if( !pSpec )
        pSpec = new XclImpChart_PointList;
	return pSpec->GetPoint( nPointNum );
}

BOOL XclImpChart_Series::HasAttachedLabel()
{
	return (pAll ? pAll->HasAttachedLabel() : FALSE) || (pSpec ? pSpec->HasAttachedLabel() : FALSE);
}

sal_uInt32 XclImpChart_Series::GetProgressSize() const
{
    return (pAll ? 1 : 0) + (pSpec ? pSpec->Count() : 0);
}


//___________________________________________________________________

XclImpChart_SeriesList::XclImpChart_SeriesList() :
		pCurrSer( NULL ),
		pAll( NULL )
{
}

XclImpChart_SeriesList::~XclImpChart_SeriesList()
{
    for( XclImpChart_Series* pSer = First(); pSer; pSer = Next() )
		delete pSer;
    delete pAll;
}

XclImpChart_Series* XclImpChart_SeriesList::Find( UINT16 nSerInd )
{
	if( pCurrSer && (pCurrSer->nSerInd == nSerInd) )
		return pCurrSer;

    for( XclImpChart_Series* pSer = First(); pSer; pSer = Next() )
		if( pSer->nSerInd == nSerInd )
			return pSer;

	return NULL;
}

const XclImpChart_Series* XclImpChart_SeriesList::FindBySerNum( UINT32 nSerNum ) const
{
	if( pCurrSer && (pCurrSer->nSerNum == nSerNum) )
		return pCurrSer;

	for( UINT32 nIndex = 0; nIndex < Count(); nIndex++ )
	{
        const XclImpChart_Series* pSer = Get( nIndex );
		if( pSer && (pSer->nSerNum == nSerNum) )
			return pSer;
	}

	return NULL;
}

XclImpChart_Series& XclImpChart_SeriesList::GetSeries( UINT16 nSerInd )
{
    XclImpChart_Series* pSer = Find( nSerInd );
	if( !pSer )
	{
        pSer = new XclImpChart_Series( nSerInd );
		Append( pSer );
	}
	return *pSer;
}

XclImpChart_Point& XclImpChart_SeriesList::GetPoint( UINT16 nSerInd, UINT16 nPointNum )
{
    XclImpChart_Series& rSer = GetSeries( nSerInd );
	return rSer.GetPoint( nPointNum );
}

XclImpChart_Point& XclImpChart_SeriesList::GetGlobalFormat()
{
	if( !pAll )
        pAll = new XclImpChart_Point( 0 );
	return *pAll;
}

BOOL XclImpChart_SeriesList::HasAttachedLabel()
{
	if( pAll && pAll->HasAttachedLabel() )
		return TRUE;
    for( XclImpChart_Series* pSer = First(); pSer; pSer = Next() )
		if( pSer->HasAttachedLabel() )
			return TRUE;
	return FALSE;
}

void XclImpChart_SeriesList::SetSeriesNumber( UINT16 nSerInd, UINT16 nSerNum )
{
    XclImpChart_Series& rSer = GetSeries( nSerInd );
	rSer.nSerNum = nSerNum;
}

void XclImpChart_SeriesList::SetSecondaryFlag( UINT16 nSerInd )
{
    XclImpChart_Series& rSer = GetSeries( nSerInd );
	rSer.bSecondary = TRUE;
}

sal_uInt32 XclImpChart_SeriesList::GetProgressSize() const
{
    sal_uInt32 nSize = 0;
    for( sal_uInt32 nIndex = 0; nIndex < Count(); ++nIndex )
        nSize += Get( nIndex )->GetProgressSize();
    return nSize;
}


//___________________________________________________________________

XclImpChart_ValueRange::XclImpChart_ValueRange( XclImpStream& rStrm )
{
	UINT16 nFlags;
    rStrm >> fMin >> fMax >> fMajorInc >> fMinorInc >> fCross >> nFlags;

    bAutoMin    = ::get_flag( nFlags, EXC_CHART_VALR_AUTOMIN );
    bAutoMax    = ::get_flag( nFlags, EXC_CHART_VALR_AUTOMAX );
    bAutoMajor  = ::get_flag( nFlags, EXC_CHART_VALR_AUTOMAJOR );
    bAutoMinor  = ::get_flag( nFlags, EXC_CHART_VALR_AUTOMINOR );
    bAutoCross  = ::get_flag( nFlags, EXC_CHART_VALR_AUTOCROSS );
    bLogScale   = ::get_flag( nFlags, EXC_CHART_VALR_LOGSCALE );
    bReverse    = ::get_flag( nFlags, EXC_CHART_VALR_REVERSE );
    bMaxCross   = ::get_flag( nFlags, EXC_CHART_VALR_MAXCROSS );
}


//___________________________________________________________________

XclImpChart_Tick::XclImpChart_Tick( XclImpStream& rStrm )
{
	UINT8	nBkgMode;
    UINT16  nFlags, nColorIdx;

    rStrm >> nMajor >> nMinor >> nLabel >> nBkgMode;
    rStrm.Ignore( 20 ); // label text color RGB + 16 reserved
    rStrm >> nFlags >> nColorIdx >> nRot;

	bTransparent	= (nBkgMode != EXC_CHART_TICK_OPAQUE);
    bAutoColor      = ::get_flag( nFlags, EXC_CHART_TICK_AUTO );
    bAutoBack       = ::get_flag( nFlags, EXC_CHART_TICK_AUTOMODE );
    bAutoRot        = ::get_flag( nFlags, EXC_CHART_TICK_AUTOROT );
    nTextColor      = rStrm.GetRoot().GetPalette().GetColorData( nColorIdx );
}


//___________________________________________________________________

XclImpChart_Axis::XclImpChart_Axis()
{
	pValueRange = NULL;
	pTick = NULL;

	pAxisLine = pMajorLine = pMinorLine = pWallLine = NULL;
	pWallArea = NULL;

	pTitle = NULL;
    pCaptionText = new XclImpChart_Text;

	nNumForm = EXC_CHART_IFMT_INVALID;
	bBreakText = TRUE;
}

XclImpChart_Axis::~XclImpChart_Axis()
{
    delete pValueRange;
    delete pTick;
    delete pAxisLine;
    delete pMajorLine;
    delete pMinorLine;
    delete pWallLine;
    delete pWallArea;
    delete pTitle;
    delete pCaptionText;
}

sal_Bool XclImpChart_Axis::HasCaption() const
{
    return
        (pTick ? (pTick->nLabel != EXC_CHART_TICK_NOLABEL) : sal_True) &&
        (pAxisLine ? pAxisLine->bDrawTick : sal_True);
}

sal_uInt32 XclImpChart_Axis::GetProgressSize() const
{
    return (pTitle ? 1 : 0) + (HasCaption() ? 1 : 0);
}


//___________________________________________________________________

XclImpChart_AxesSet::~XclImpChart_AxesSet()
{
    delete pCatAxis;
    delete pValueAxis;
    delete pSeriesAxis;
}

sal_uInt32 XclImpChart_AxesSet::GetProgressSize() const
{
    sal_uInt32 nSize = 0;
    if( pCatAxis )
        nSize += pCatAxis->GetProgressSize();
    if( pValueAxis )
        nSize += pValueAxis->GetProgressSize();
    if( pSeriesAxis )
        nSize += pSeriesAxis->GetProgressSize();
    return nSize;
}


//___________________________________________________________________

XclImpChart_Data3D::XclImpChart_Data3D( XclImpStream& rStrm )
{
	UINT16 nFlags;
    rStrm >> nRot >> nElev >> nDist >> nHeight >> nDepth >> nGap >> nFlags;

    bPersp      = ::get_flag( nFlags, EXC_CHART_3D_PERSP );
    bCluster    = ::get_flag( nFlags, EXC_CHART_3D_CLUSTER );
    b3DScaling  = ::get_flag( nFlags, EXC_CHART_3D_AUTOSCALE );
    b2DWalls    = ::get_flag( nFlags, EXC_CHART_3D_2DWALLS );
}


//___________________________________________________________________

XclImpChart_Dropbar::XclImpChart_Dropbar( XclImpStream& rStrm ) :
		pLine( NULL ), pArea( NULL )
{
    rStrm >> nGap;
}

XclImpChart_Dropbar::~XclImpChart_Dropbar()
{
    delete pLine;
    delete pArea;
}


//___________________________________________________________________

XclImpChart_Legend::XclImpChart_Legend( XclImpStream& rStrm ) :
		pLine( NULL ), pArea( NULL ), pText( NULL )
{
	UINT16 nFlags;
    rStrm >> aPos >> nType >> nSpacing >> nFlags;

    bDocked         = ::get_flag( nFlags, EXC_CHART_LEGEND_DOCKED );
    bAutoSeries     = ::get_flag( nFlags, EXC_CHART_LEGEND_AUTOSERIES );
    bAutoPosX       = ::get_flag( nFlags, EXC_CHART_LEGEND_AUTOPOSX );
    bAutoPosY       = ::get_flag( nFlags, EXC_CHART_LEGEND_AUTOPOSY );
    bVert           = ::get_flag( nFlags, EXC_CHART_LEGEND_VERT );
    bWasDataTable   = ::get_flag( nFlags, EXC_CHART_LEGEND_DATATABLE );
}

XclImpChart_Legend::~XclImpChart_Legend()
{
    delete pLine;
    delete pArea;
    delete pText;
}


//___________________________________________________________________
// class XclImpChart

XclImpChart::XclImpChart( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    pStateStack( new XclImpChart_StateStack ),
    pSourceData( new XclImpChart_LinkedData ( *(rRootData.pIR) ) ),
    pLine( NULL ),
    pArea( NULL ),
    pPlotLine( NULL ),
    pPlotArea( NULL ),
    pChartTitle( NULL ),
    pSeries( NULL ),
    nCurSeries( 0 ),
    pLastDataPoint( NULL ),
    pPrimAS( NULL ),
    pSecAS( NULL ),
    p3D( NULL ),
    pLegend( NULL ),
    pUpBar( NULL ),
    pDownBar( NULL ),
    pHiLoLine( NULL ),
    nCurrDefText( -1 ),
    pDefText0( NULL ),
    pDefText1( NULL ),
    pDefText2( NULL ),
    pNewText( NULL ),
    ppCurrLine( NULL ),
    ppCurrArea( NULL ),
    ppCurrText( NULL ),
    pCurrAS( NULL ),
    pCurrAxis( NULL ),
    pCurrBar( NULL ),
    nBaseTab( 0 ),
    bSymbols( FALSE ),
    bSecondary( FALSE ),
    bHasSeriesNames( FALSE ),
    bHasCategoryNames( FALSE ),
    bStock( FALSE ),
    bSpline( FALSE ),
    eChartType( ctUnknown ),
    nMaxPieDist( 0 ),
    nRowOffset( 0 )
{
    pStateStack->Push( csGlobal );
}

XclImpChart::XclImpChart( XclImpChart& rCpy ) :
    ExcRoot( rCpy.pExcRoot ),
    nBaseTab( rCpy.nBaseTab ),
    nCurSeries( rCpy.nCurSeries ),
    nCurrDefText( rCpy.nCurrDefText ),
    bSymbols( rCpy.bSymbols ),
    bSecondary( rCpy.bSecondary ),
    bHasSeriesNames( rCpy.bHasSeriesNames ),
    bHasCategoryNames( rCpy.bHasCategoryNames ),
    bStock( rCpy.bStock ),
    bSpline( rCpy.bSpline ),
    eChartType( rCpy.eChartType ),
    nMaxPieDist( rCpy.nMaxPieDist ),
    nRowOffset( rCpy.nRowOffset )
{
	lcl_MovePtr( pStateStack, rCpy.pStateStack );

	lcl_MovePtr( pSourceData, rCpy.pSourceData );

	lcl_MovePtr( pLine, rCpy.pLine );
	lcl_MovePtr( pArea, rCpy.pArea );

	lcl_MovePtr( pPlotLine, rCpy.pPlotLine );
	lcl_MovePtr( pPlotArea, rCpy.pPlotArea );

	lcl_MovePtr( pChartTitle, rCpy.pChartTitle );

	lcl_MovePtr( pSeries, rCpy.pSeries );
	lcl_MovePtr( pLastDataPoint, rCpy.pLastDataPoint );

	lcl_MovePtr( pPrimAS, rCpy.pPrimAS );
	lcl_MovePtr( pSecAS, rCpy.pSecAS );

	lcl_MovePtr( p3D, rCpy.p3D );
	lcl_MovePtr( pLegend, rCpy.pLegend );
	lcl_MovePtr( pUpBar, rCpy.pUpBar );
	lcl_MovePtr( pDownBar, rCpy.pDownBar );
	lcl_MovePtr( pHiLoLine, rCpy.pHiLoLine );

	lcl_MovePtr( pDefText0, rCpy.pDefText0 );
	lcl_MovePtr( pDefText1, rCpy.pDefText1 );
	lcl_MovePtr( pDefText2, rCpy.pDefText2 );
	lcl_MovePtr( pNewText, rCpy.pNewText );

	lcl_MovePtr( ppCurrLine, rCpy.ppCurrLine );
	lcl_MovePtr( ppCurrArea, rCpy.ppCurrArea );
	lcl_MovePtr( ppCurrText, rCpy.ppCurrText );
	lcl_MovePtr( pCurrAS, rCpy.pCurrAS );
	lcl_MovePtr( pCurrAxis, rCpy.pCurrAxis );
	lcl_MovePtr( pCurrBar, rCpy.pCurrBar );
}

XclImpChart::~XclImpChart()
{
	Reset();
}

void XclImpChart::Reset()
{
	nBaseTab = 0;

    DELETEZ( pStateStack );
    DELETEZ( pSourceData );

    DELETEZ( pLine );
    DELETEZ( pArea );

    DELETEZ( pPlotLine );
    DELETEZ( pPlotArea );

    DELETEZ( pChartTitle );

    DELETEZ( pSeries );
	nCurSeries = 0;
	pLastDataPoint = NULL;

    DELETEZ( pPrimAS );
    DELETEZ( pSecAS );

    DELETEZ( p3D );
    DELETEZ( pLegend );
    DELETEZ( pUpBar );
    DELETEZ( pDownBar );
    DELETEZ( pHiLoLine );

	nCurrDefText = -1;
    DELETEZ( pDefText0 );
    DELETEZ( pDefText1 );
    DELETEZ( pDefText2 );
    DELETEZ( pNewText );

	ppCurrLine = NULL;
	ppCurrArea = NULL;
	ppCurrText = NULL;
	pCurrAS = NULL;
	pCurrAxis = NULL;
	pCurrBar = NULL;

	bSecondary = FALSE;
	bHasSeriesNames = bHasCategoryNames = FALSE;
    bSymbols = bStock = bSpline = FALSE;

	eChartType = ctUnknown;
	nMaxPieDist = 0;
	nRowOffset = 0;
}

sal_uInt32 XclImpChart::GetProgressSize() const
{
    sal_uInt32 nSegSize = 0;

    /* progress bar sizes:
        1 for title
        1 for legend
        1 for default format of each series
        1 for each different formatted point
        1 for each axis title
        1 for each axis caption
    */

    if( pChartTitle )
        ++nSegSize;
    if( pLegend )
        ++nSegSize;
    if( pSeries )
        nSegSize += pSeries->GetProgressSize();
    if( pPrimAS )
        nSegSize += pPrimAS->GetProgressSize();
    if( pSecAS )
        nSegSize += pSecAS->GetProgressSize();

    return nSegSize;
}

// for derived classes

void XclImpChart::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
}

void XclImpChart::ApplyExtPost( uno::Reference< lang::XComponent > xComponent )
{
}

// internal chart data

void XclImpChart::UpdateState( XclImpChart_State eState )
{
	ppCurrLine = NULL;
	ppCurrArea = NULL;
	switch( eState )
	{
		case csChartFrame:
			ppCurrLine = &pLine;
			ppCurrArea = &pArea;
		break;
		case csPointFormat:
		case csDataFormat:
			if( pLastDataPoint )
			{
				ppCurrLine = &pLastDataPoint->pLine;
				ppCurrArea = &pLastDataPoint->pArea;
			}
		break;
		case csAxis:
			ppCurrText = pCurrAxis ? &pCurrAxis->pCaptionText : NULL;
		break;
		case csDropbar:
			if( pCurrBar )
			{
				ppCurrLine = &pCurrBar->pLine;
				ppCurrArea = &pCurrBar->pArea;
			}
		break;
		case csLegendText:
			if( pLegend )
				MoveNewTextTo( pLegend->pText );
		break;
		case csLegendFrame:
			if( pLegend )
			{
				ppCurrLine = &pLegend->pLine;
				ppCurrArea = &pLegend->pArea;
			}
		break;
		case csDefText:
		{
			switch( nCurrDefText )
			{
				case 0:	MoveNewTextTo( pDefText0 );	break;
				case 1:	MoveNewTextTo( pDefText1 );	break;
				case 2:	MoveNewTextTo( pDefText2 );	break;
			}
		}
		break;
		case csText:
			ppCurrText = &pNewText;
		break;
		case csTextFrame:
			if( ppCurrText && *ppCurrText )
			{
				ppCurrLine = &(*ppCurrText)->pLine;
				ppCurrArea = &(*ppCurrText)->pArea;
			}
		break;
		case csPlotarea:
			ppCurrLine = &pPlotLine;
			ppCurrArea = &pPlotArea;
		break;
		default:
			ppCurrText = NULL;
	}

	nCurrDefText = -1;
}

void XclImpChart::EndAxis()
{
	if( !pCurrAxis ) return;

	if( pCurrAxis->pCaptionText && pCurrAxis->pTick )
		pCurrAxis->pCaptionText->nRot = pCurrAxis->pTick->nRot;
	pCurrAxis = NULL;
}

void XclImpChart::MoveNewTextTo( XclImpChart_Text*& rpDest )
{
    DELETEZ( rpDest );
	rpDest = pNewText;
	pNewText = NULL;
	ppCurrText = &rpDest;
}

void XclImpChart::LinkNewText()
{
	if( !pNewText ) return;

	switch( pNewText->nLinkObj )
	{
		case EXC_CHART_OLINK_TITLE:
			MoveNewTextTo( pChartTitle );
		break;
		case EXC_CHART_OLINK_XAXIS:
			if( pPrimAS && pPrimAS->pCatAxis )
				MoveNewTextTo( pPrimAS->pCatAxis->pTitle );
		break;
		case EXC_CHART_OLINK_YAXIS:
			if( pPrimAS && pPrimAS->pValueAxis )
				MoveNewTextTo( pPrimAS->pValueAxis->pTitle );
		break;
		case EXC_CHART_OLINK_ZAXIS:
			if( pPrimAS && pPrimAS->pSeriesAxis )
				MoveNewTextTo( pPrimAS->pSeriesAxis->pTitle );
		break;
		case EXC_CHART_OLINK_DATA:
		{
            XclImpChart_Point& rPoint = GetPoint( pNewText->nLinkSer, pNewText->nLinkPoint );
			MoveNewTextTo( rPoint.pText );
		}
		break;
		default:
            DELETEZ( pNewText );
			ppCurrText = NULL;
	}
}

XclImpChart_Point& XclImpChart::GetPoint( UINT16 nSerInd, UINT16 nPointNum )
{
	if( !pSeries )
        pSeries = new XclImpChart_SeriesList;
	return pSeries->GetPoint( nSerInd, nPointNum );
}

XclImpChart_Point& XclImpChart::GetGlobalFormat()
{
	if( !pSeries )
        pSeries = new XclImpChart_SeriesList;
	return pSeries->GetGlobalFormat();
}

// CHART common recs

void XclImpChart::ReadBegin()
{
    if( eNewState == csKeepState )
        eNewState = pStateStack->Top();
	pStateStack->Push( eNewState );
	UpdateState( eNewState );
	eNewState = csUnknown;
}

void XclImpChart::ReadEnd()
{
	switch( pStateStack->Pop() )
	{
		case csText:		LinkNewText();		break;
		case csAxis:		pCurrAxis = NULL;	break;
		case csAxisParent:	pCurrAS = NULL;		break;
		case csDropbar: 	pCurrBar = NULL;	break;
		case csSeries:		nCurSeries++;		break;
	}
	UpdateState( GetState() );
}

void XclImpChart::ReadChart()
{
	eNewState = csChart;
}

// FRAME group

void XclImpChart::ReadFrame()
{
	if( eNewState != csUnknown ) return;	// for csPlotarea
	switch( GetState() )
	{
		case csChart:	eNewState = csChartFrame;		break;
		case csDefText:
		case csText:	eNewState = csTextFrame;		break;
		case csLegend:	eNewState = csLegendFrame;		break;
		default:		eNewState = csUnknown;
	}
}

void XclImpChart::ReadLineformat( XclImpStream& rStrm )
{
	if( ppCurrLine )
	{
        DELETEZ( *ppCurrLine );
        *ppCurrLine = new XclImpChart_Lineformat( rStrm );

        if(pExcRoot->pIR->GetTracer().IsEnabled() && GetState() == csChartFrame)
            if((*ppCurrLine)->bAuto)
                pExcRoot->pIR->GetTracer().TraceChartBorderAuto();
	}
}

void XclImpChart::ReadAreaformat( XclImpStream& rStrm )
{
	if( ppCurrArea )
	{
        DELETEZ( *ppCurrArea );
        *ppCurrArea = new XclImpChart_Areaformat( rStrm );
	}
}

void XclImpChart::ReadGelframe( XclImpStream& rStrm )
{
	if( ppCurrArea && *ppCurrArea )
	{
        DELETEZ( (*ppCurrArea)->pFillData );
        (*ppCurrArea)->pFillData = new XclImpChart_FillData( *pExcRoot->pIR );
        (*ppCurrArea)->pFillData->ReadGelframe( rStrm );
        eNewState = csKeepState;
	}
}

void XclImpChart::ReadPicf( XclImpStream& rStrm )
{
    if( ppCurrArea && *ppCurrArea && (*ppCurrArea)->pFillData )
        (*ppCurrArea)->pFillData->ReadPicf( rStrm );
}

// TEXT group

void XclImpChart::ReadText( XclImpStream& rStrm )
{
    DELETEZ( pNewText );
    pNewText = new XclImpChart_Text( rStrm );
	ppCurrText = &pNewText;

	if( (nCurrDefText >= 0) && (nCurrDefText <= 2) )
		eNewState = csDefText;
	else
	{
		switch( GetState() )
		{
			case csLegend:	eNewState = csLegendText;	break;
			default:		eNewState = csText;
		}
	}
}

void XclImpChart::ReadFontx( XclImpStream& rStrm )
{
	if( ppCurrText && *ppCurrText )
	{
		UINT16 nFontx;
        rStrm >> nFontx;

        (*ppCurrText)->pFont = pExcRoot->pIR->GetFontBuffer().GetFont( nFontx );
	}
}

void XclImpChart::ReadSeriestext( XclImpStream& rStrm )
{
	if( ppCurrText && *ppCurrText )
	{
        String*& rpString = (*ppCurrText)->pString;
        DELETEZ( rpString );
        rStrm.Ignore( 2 );
        UINT8 nLen;
        rStrm >> nLen;
        rpString = new String( rStrm.ReadUniString( nLen ) );
	}
}

void XclImpChart::ReadObjectlink( XclImpStream& rStrm )
{
	if( ppCurrText && *ppCurrText )
	{
        rStrm   >> (*ppCurrText)->nLinkObj
                >> (*ppCurrText)->nLinkSer
                >> (*ppCurrText)->nLinkPoint;
	}
}

void XclImpChart::ReadDefaulttext( XclImpStream& rStrm )
{
    rStrm >> nCurrDefText;
}

// SERIES group

void XclImpChart::ReadSeries(XclImpStream& rStrm )
{
	eNewState = csSeries;

    if(pExcRoot->pIR->GetTracer().IsEnabled())
    {
        // Store the fact that the category count and value count may be not equal.
        // This will be used by the Tracer later.
        UINT16	nSdtX, nSdtY, nCValx, nCValy, nSdtBSize, nCValBSize;
        rStrm >> nSdtX >> nSdtY >> nCValx >> nCValy >> nSdtBSize >> nCValBSize;
        // We only need to determine if there is a difference in one data series.
        if(pSourceData && pSourceData->GetValidChartRange() && nCValx != nCValy)
            pSourceData->SetValidChartRange(FALSE);
    }
}

void XclImpChart::ReadSertocrt( XclImpStream& rStrm )
{
    UINT16 nAxesSet;
    rStrm >> nAxesSet;

    if( (nAxesSet == EXC_CHART_SECONDAXESSET) && pSeries )
		pSeries->SetSecondaryFlag( nCurSeries );
}

void XclImpChart::ReadAi( XclImpStream& rStrm, ExcelToSc8& rFmlConv )
{
    if( GetState() != csSeries ) return;

	UINT8	nId, nRt;
	UINT16	nGrbit, nIfmt, nCce;
    rStrm >> nId >> nRt >> nGrbit >> nIfmt >> nCce;
    if( !nCce ) return;

    ScRangeList aRL;
    if( rFmlConv.GetAbsRefs( aRL, nCce ) )
    {
        for( const ScRange* pRange = aRL.First(); pRange; pRange = aRL.Next() )
        {
            switch( nId )
            {
                case EXC_CHART_AI_LINKTITLE:
                    pSourceData->AppendTitle( *pRange );
                    bHasSeriesNames = TRUE;
                break;
                case EXC_CHART_AI_LINKVALUE:
                    pSourceData->AppendValues( *pRange );
                break;
                case EXC_CHART_AI_LINKCAT:
                    pSourceData->AppendCatNames( *pRange );
                    bHasCategoryNames = TRUE;
                break;
            }
        }
    }
}

void XclImpChart::EndSerValues()
{
    if( pSourceData )
        pSourceData->EndSeries();
}

void XclImpChart::CloseSourceData( void )
{
    if( pSourceData && pSourceData->Close() )
        bHasSeriesNames = bHasCategoryNames = FALSE;
}

// DATAFORMAT group

void XclImpChart::ReadDataformat( XclImpStream& rStrm )
{
    EndSerValues();
	UINT16 nPoint, nSerInd, nSerNum;
    rStrm >> nPoint >> nSerInd >> nSerNum;

	if( nSerNum == EXC_CHART_DATAF_CHART )
	{
        XclImpChart_Point& rPoint = GetGlobalFormat();
		pLastDataPoint = &rPoint;
	}
	else
	{
        XclImpChart_Point& rPoint = GetPoint( nSerInd, nPoint );
		pLastDataPoint = &rPoint;
		pSeries->SetSeriesNumber( nSerInd, nSerNum );
	}

	switch( GetState() )
	{
		case csSeries:	eNewState = csPointFormat;	break;
		case csFormat:	eNewState = csDataFormat;	break;
		default:		eNewState = csUnknown;
	}
}

void XclImpChart::ReadMarkerformat( XclImpStream& rStrm )
{
	if( pLastDataPoint )
	{
		if( !pLastDataPoint->pMarker )
        {
            pLastDataPoint->pMarker = new XclImpChart_MarkerFormat( rStrm );
            // #i19559# remember existence of symbols, must be set at diagram
            if( pLastDataPoint->pMarker->nMarkerType != 0 )
                bSymbols = TRUE;
        }
	}
}

void XclImpChart::Read3DDataformat( XclImpStream& rStrm )
{
	if( pLastDataPoint )
	{
		UINT8 nBase, nTop;
        rStrm >> nBase >> nTop;

		if( !pLastDataPoint->p3DData )
            pLastDataPoint->p3DData = new XclImpChart_3DDataFormat( nBase, nTop );
	}
}

void XclImpChart::ReadPieformat( XclImpStream& rStrm )
{
	if( pLastDataPoint )
	{
		UINT16 nDist;
        rStrm >> nDist;

		if( !pLastDataPoint->pPieDist )
			pLastDataPoint->pPieDist = new UINT16( nDist );
		nMaxPieDist = Max( nMaxPieDist, nDist );
	}
}

void XclImpChart::ReadSerfmt( XclImpStream& rStrm )
{
	UINT16 nFlags;
    rStrm >> nFlags;
    bSpline |= ::get_flag( nFlags, EXC_CHART_SERF_SMOOTHED );
}

void XclImpChart::ReadAttachedlabel( XclImpStream& rStrm )
{
	if( pLastDataPoint )
	{
		UINT16 nLabel;
        rStrm >> nLabel;

		if( !pLastDataPoint->pLabel )
			pLastDataPoint->pLabel = new UINT16( nLabel );
	}
}

// AXIS group

void XclImpChart::ReadAxesused( XclImpStream& rStrm )
{
	UINT16 nUsed;
    rStrm >> nUsed;
	bSecondary = (nUsed > 1);
}

void XclImpChart::ReadAxisparent( XclImpStream& rStrm )
{
	UINT16 nAxesSet;
    rStrm >> nAxesSet;

    if( nAxesSet == EXC_CHART_FIRSTAXESSET )
	{
		if( !pPrimAS )
            pPrimAS = new XclImpChart_AxesSet;
		pCurrAS = pPrimAS;
	}
    else if( nAxesSet == EXC_CHART_SECONDAXESSET )
	{
		if( !pSecAS )
            pSecAS = new XclImpChart_AxesSet;
		pCurrAS = pSecAS;
	}
	else
		pCurrAS = NULL;

    if( (nAxesSet == EXC_CHART_FIRSTAXESSET) && pCurrAS )
        rStrm >> pCurrAS->aPos;

	eNewState = csAxisParent;
}

void XclImpChart::ReadAxis( XclImpStream& rStrm )
{
	pCurrAxis = NULL;

	UINT16 nAxis;
    rStrm >> nAxis;

	if( pCurrAS )
	{
		switch( nAxis )
		{
			case EXC_CHART_XAXIS:
				if( !pCurrAS->pCatAxis )
                    pCurrAS->pCatAxis = new XclImpChart_Axis;
				pCurrAxis = pCurrAS->pCatAxis;
			break;
			case EXC_CHART_YAXIS:
				if( !pCurrAS->pValueAxis )
                    pCurrAS->pValueAxis = new XclImpChart_Axis;
				pCurrAxis = pCurrAS->pValueAxis;
			break;
			case EXC_CHART_ZAXIS:
				if( !pCurrAS->pSeriesAxis )
                    pCurrAS->pSeriesAxis = new XclImpChart_Axis;
				pCurrAxis = pCurrAS->pSeriesAxis;
			break;
		}
	}
	eNewState = csAxis;
}

void XclImpChart::ReadCatserrange( XclImpStream& rStrm )
{
	if( pCurrAxis )
	{
        rStrm.Ignore( 2 );
		UINT16 nLabelFreq;
        rStrm >> nLabelFreq;
		pCurrAxis->bBreakText = (nLabelFreq == 1);
	}
}

void XclImpChart::ReadValuerange( XclImpStream& rStrm )
{
	if( pCurrAxis )
	{
        DELETEZ( pCurrAxis->pValueRange );
        pCurrAxis->pValueRange = new XclImpChart_ValueRange( rStrm );
    }
}

void XclImpChart::ReadTick( XclImpStream& rStrm )
{
	if( pCurrAxis )
	{
        DELETEZ( pCurrAxis->pTick );
        pCurrAxis->pTick = new XclImpChart_Tick( rStrm );
		if( pCurrAxis->pCaptionText )
			pCurrAxis->pCaptionText->nRot = pCurrAxis->pTick->nRot;
	}
}
void XclImpChart::ReadSerauxtrend( )
{
    pExcRoot->pIR->GetTracer().TraceChartTrendLines();
}

void XclImpChart::ReadIfmt( XclImpStream& rStrm )
{
	if( pCurrAxis )
        pCurrAxis->nNumForm = pExcRoot->pIR->GetNumFmtBuffer().GetScFormat( rStrm.ReaduInt16() );
}


void XclImpChart::ReadAxislineformat( XclImpStream& rStrm )
{
	ppCurrLine = NULL;
	ppCurrArea = NULL;

	if( pCurrAxis )
	{
		UINT16 nLineType;
        rStrm >> nLineType;

		switch( nLineType )
		{
			case EXC_CHART_AXLINEF_AXISLINE:	ppCurrLine = &pCurrAxis->pAxisLine;		break;
			case EXC_CHART_AXLINEF_MAJORGRID:	ppCurrLine = &pCurrAxis->pMajorLine;	break;
			case EXC_CHART_AXLINEF_MINORGRID:	ppCurrLine = &pCurrAxis->pMinorLine;	break;
			case EXC_CHART_AXLINEF_WALLS:
				ppCurrLine = &pCurrAxis->pWallLine;
				ppCurrArea = &pCurrAxis->pWallArea;
			break;
		}
	}
}

void XclImpChart::ReadPlotarea()
{
	eNewState = csPlotarea;
}

void XclImpChart::ReadAlruns()
{
    // text formatting for Titles or data labels.
    pExcRoot->pIR->GetTracer().TraceChartTextFormatting();
}

// CHARTFORMAT group

void XclImpChart::ReadChartformat()
{
	eNewState = csFormat;
}

void XclImpChart::Read3D( XclImpStream& rStrm )
{
    DELETEZ( p3D );
    p3D = new XclImpChart_Data3D( rStrm );
}

void XclImpChart::ReadLegend( XclImpStream& rStrm )
{
    DELETEZ( pLegend );
    pLegend = new XclImpChart_Legend( rStrm );
	eNewState = csLegend;

    if(pExcRoot->pIR->GetTracer().IsEnabled())
    {
        // If a legend is present, the legend entry( data source) name must be
        // linked to a worksheet cell.
        if(!bHasSeriesNames && (eChartType != ctPie && eChartType != ctDonut ))
            pExcRoot->pIR->GetTracer().TraceChartDSName();

        if(pLegend->bWasDataTable)
            pExcRoot->pIR->GetTracer().TraceChartDataTable();

        if(pLegend->nType == EXC_CHART_LEGEND_NOTDOCKED)
            pExcRoot->pIR->GetTracer().TraceChartLegendPosition();
    }
}

void XclImpChart::ReadDropbar( XclImpStream& rStrm )
{
	if( !pUpBar )
        pCurrBar = pUpBar = new XclImpChart_Dropbar( rStrm );
	else if( !pDownBar )
        pCurrBar = pDownBar = new XclImpChart_Dropbar( rStrm );
	else
		pCurrBar = NULL;

	bStock = TRUE;
	eNewState = csDropbar;
}

void XclImpChart::ReadChartline( XclImpStream& rStrm )
{
	UINT16 nId;
    rStrm >> nId;
	switch( nId )
	{
		case EXC_CHART_CHLINE_HILO:		ppCurrLine = &pHiLoLine;	break;
		default:						ppCurrLine = NULL;
	}

	bStock = TRUE;
}

void XclImpChart::ReadPivotChartTableName( )
{
    pExcRoot->pIR->GetTracer().TracePivotChartExists();
}

//___________________________________________________________________
// line charts

XclImpChartLine::XclImpChartLine( XclImpChart& rChart, XclImpStream& rStrm, BOOL bArea ) :
        XclImpChart( rChart )
{
	UINT16 nFlags;
    rStrm >> nFlags;

    bStacked        = ::get_flag( nFlags, EXC_CHART_LINE_STACKED );
    bCatAsPercent   = ::get_flag( nFlags, EXC_CHART_LINE_PERCENT );
    bHasShadow      = ::get_flag( nFlags, EXC_CHART_LINE_SHADOW );

	eChartType = bArea ? ctArea : ctLine;
}

XclImpChartLine::~XclImpChartLine()
{
}


//___________________________________________________________________
// bar & column charts

XclImpChartBar::XclImpChartBar( XclImpChart& rChart, XclImpStream& rStrm ) :
        XclImpChart( rChart )
{
	UINT16 nFlags;
    rStrm >> nSpaceBeetwBar >> nSpaceBeetwCat >> nFlags;
    nSpaceBeetwBar = -nSpaceBeetwBar;

    bHorizontal     = ::get_flag( nFlags, EXC_CHART_BAR_TRANS );
    bStacked        = ::get_flag( nFlags, EXC_CHART_BAR_STACKED );
    bCatAsPercent   = ::get_flag( nFlags, EXC_CHART_BAR_PERCENT );
    bHasShadow      = ::get_flag( nFlags, EXC_CHART_BAR_SHADOW );

	eChartType = bHorizontal ? ctBar : ctColumn;
}

XclImpChartBar::~XclImpChartBar()
{
}


//___________________________________________________________________
// pie & donut charts

XclImpChartPie::XclImpChartPie( XclImpChart& rChart, XclImpStream& rStrm ) :
        XclImpChart( rChart )
{
	UINT16 nFlags;
    rStrm >> nAngleFirstSlice >> nHoleSize >> nFlags;

    bHasShadow          = ::get_flag( nFlags, EXC_CHART_PIE_SHADOW );
    bShowLeaderLines    = ::get_flag( nFlags, EXC_CHART_PIE_LINES );

	eChartType = nHoleSize ? ctDonut : ctPie;
}

XclImpChartPie::~XclImpChartPie()
{
}


//___________________________________________________________________
// radar charts

XclImpChartRadar::XclImpChartRadar( XclImpChart& rChart ) :
        XclImpChart( rChart )
{
	eChartType = ctNet;
}

XclImpChartRadar::~XclImpChartRadar()
{
}


//___________________________________________________________________
// surface charts

XclImpChartSurface::XclImpChartSurface( XclImpChart& rChart ) :
        XclImpChart( rChart )
{
}

XclImpChartSurface::~XclImpChartSurface()
{
}


//___________________________________________________________________
// scatter charts

XclImpChartScatter::XclImpChartScatter( XclImpChart& rChart, XclImpStream& rStrm ) :
        XclImpChart( rChart )
{
	UINT16 nFlags;
        rStrm >> nBubbleSizeRatio >> nBubbleSize >> nFlags;

    bBubbles        = ::get_flag( nFlags, EXC_CHART_SCAT_BUBBLES );
    bShowNegBubbles = ::get_flag( nFlags, EXC_CHART_SCAT_NEGBUBBLES );
    bHasShadows     = ::get_flag( nFlags, EXC_CHART_SCAT_SHADOW );

	bHasCategoryNames = FALSE;
	nRowOffset = 1;

	eChartType = ctScatter;

    if(pExcRoot->pIR->GetTracer().IsEnabled() )
    {
        if(pSourceData && !pSourceData->ValidScatterRange())
            pExcRoot->pIR->GetTracer().TraceChartInvalidXY();
    }
}

XclImpChartScatter::~XclImpChartScatter()
{
}

