/*************************************************************************
 *
 *  $RCSfile: scuiautofmt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2004/06/04 14:13:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef SCUI_AUTOFMT_HXX
#define SCUI_AUTOFMT_HXX
#include "autofmt.hxx"

class ScAutoFormatDlg : public ModalDialog
{
public:
			ScAutoFormatDlg( Window*					pParent,
							 ScAutoFormat*				pAutoFormat,
                             const ScAutoFormatData*    pSelFormatData,
                             ScDocument*                pDoc );
			~ScAutoFormatDlg();

	USHORT GetIndex() const { return nIndex; }
	String GetCurrFormatName();

private:
    FixedLine       aFlFormat;
	ListBox			aLbFormat;
	AutoFmtPreview*	pWndPreview;
	OKButton		aBtnOk;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;
	PushButton		aBtnAdd;
	PushButton		aBtnRemove;
	MoreButton		aBtnMore;
    FixedLine       aFlFormatting;
	CheckBox		aBtnNumFormat;
	CheckBox		aBtnBorder;
	CheckBox		aBtnFont;
	CheckBox		aBtnPattern;
	CheckBox		aBtnAlignment;
	CheckBox		aBtnAdjust;
	PushButton		aBtnRename;
	String			aStrTitle;
	String			aStrLabel;
	String			aStrClose;
	String			aStrDelTitle;
	String			aStrDelMsg;
	String			aStrRename;

	//------------------------
	ScAutoFormat*			pFormat;
	const ScAutoFormatData*	pSelFmtData;
	USHORT					nIndex;
	BOOL					bCoreDataChanged;
	BOOL					bFmtInserted;

	void Init			();
	void UpdateChecks	();
	//------------------------
	DECL_LINK( CheckHdl, Button * );
	DECL_LINK( AddHdl, void * );
	DECL_LINK( RemoveHdl, void * );
	DECL_LINK( SelFmtHdl, void * );
	DECL_LINK( CloseHdl, PushButton * );
	DECL_LINK( DblClkHdl, void * );
	DECL_LINK( RenameHdl, void *);

};
#endif

