/*************************************************************************
 *
 *  $RCSfile: transobj.hxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: kz $ $Date: 2004/10/04 20:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SC_TRANSOBJ_HXX
#define SC_TRANSOBJ_HXX

#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif

//REMOVE	#ifndef _EMBOBJ_HXX
//REMOVE	#include <so3/embobj.hxx>
//REMOVE	#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef SC_ADDRESS_HXX
#include "address.hxx"
#endif

class ScDocShell;
class ScMarkData;
class SfxObjectShell;

namespace com { namespace sun { namespace star {
	namespace sheet {
		class XSheetCellRanges;
	}
}}}

#include <sfx2/objsh.hxx>

class ScTransferObj : public TransferableHelper
{
private:
	ScDocument*						pDoc;
	ScRange							aBlock;
	SCROW							nNonFiltered;		// non-filtered rows
	TransferableDataHelper			aOleData;
	TransferableObjectDescriptor	aObjDesc;
//REMOVE		SvEmbeddedObjectRef				aDocShellRef;
//REMOVE		SvEmbeddedObjectRef				aDrawPersistRef;
	SfxObjectShellRef				aDocShellRef;
	SfxObjectShellRef				aDrawPersistRef;
	com::sun::star::uno::Reference<com::sun::star::sheet::XSheetCellRanges> xDragSourceRanges;
	SCCOL							nDragHandleX;
	SCROW							nDragHandleY;
	SCTAB							nVisibleTab;
	USHORT							nDragSourceFlags;
	BOOL							bDragWasInternal;
	BOOL							bUsedForLink;

	void		InitDocShell();
	static void	StripRefs( ScDocument* pDoc, SCCOL nStartX, SCROW nStartY,
							SCCOL nEndX, SCROW nEndY,
							ScDocument* pDestDoc=0,
							SCCOL nSubX=0, SCROW nSubY=0 );
	static void PaintToDev( OutputDevice* pDev, ScDocument* pDoc, double nPrintFactor,
							const ScRange& rBlock, BOOL bMetaFile );
	static void GetAreaSize( ScDocument* pDoc, SCTAB nTab1, SCTAB nTab2, SCROW& nRow, SCCOL& nCol );

public:
			ScTransferObj( ScDocument* pClipDoc, const TransferableObjectDescriptor& rDesc );
	virtual ~ScTransferObj();

	virtual void		AddSupportedFormats();
	virtual sal_Bool	GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
	virtual sal_Bool	WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId,
										const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
	virtual void		ObjectReleased();
	virtual void		DragFinished( sal_Int8 nDropAction );

	ScDocument*			GetDocument()			{ return pDoc; }		// owned by ScTransferObj
	const ScRange&		GetRange() const		{ return aBlock; }
	SCROW				GetNonFilteredRows() const { return nNonFiltered; }
	SCCOL				GetDragHandleX() const	{ return nDragHandleX; }
	SCROW				GetDragHandleY() const	{ return nDragHandleY; }
	SCTAB				GetVisibleTab() const	{ return nVisibleTab; }
	USHORT				GetDragSourceFlags() const	{ return nDragSourceFlags; }
	ScDocShell*			GetSourceDocShell();
	ScDocument*			GetSourceDocument();
	ScMarkData			GetSourceMarkData();

	void				SetDrawPersist( const SfxObjectShellRef& rRef );
	void				SetDragHandlePos( SCCOL nX, SCROW nY );
	void				SetVisibleTab( SCTAB nNew );
	void				SetDragSource( ScDocShell* pSourceShell, const ScMarkData& rMark );
	void				SetDragSourceFlags( USHORT nFlags );
	void				SetDragWasInternal();

	static ScTransferObj* GetOwnClipboard( Window* pUIWin );

	static SfxObjectShell*	SetDrawClipDoc( BOOL bAnyOle );		// update ScGlobal::pDrawClipDocShellRef
};

#endif

