/*************************************************************************
 *
 *  $RCSfile: chmod3d.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2003/11/24 17:36:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef SCH_CHARTMODEL_3D_OBJECTS
#define SCH_CHARTMODEL_3D_OBJECTS


//Ableitungen der 3D-Objekte, um #52277# zu beheben.
//Ueberladen der NbcSetAttributes um Attr abzufangen und in das ChartModel zu leiten

#ifndef _E3D_EXTRUD3D_HXX //autogen
#include <svx/extrud3d.hxx>
#endif
#ifndef _E3D_POLYGON3D_HXX //autogen
#include <svx/polygn3d.hxx>
#endif
#ifndef _E3D_DEFLT3D_HXX //autogen
#include <svx/deflt3d.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _E3D_LATHE3D_HXX //autogen
#include <svx/lathe3d.hxx>
#endif
#define CHART_SHAPE3D_IGNORE  -2 //intern! (GetChartShapeStyle()!)
#define CHART_SHAPE3D_ANY	  -1 //undefinierter Typ (GetChartShapeStyle()!)
#define CHART_SHAPE3D_SQUARE   0
#define CHART_SHAPE3D_CYLINDER 1
#define CHART_SHAPE3D_CONE     2
#define CHART_SHAPE3D_PYRAMID  3 //reserved
#define CHART_SHAPE3D_HANOI	   4

//////////////////////////////////////////////////////////////////////////////

#ifndef _SDR_PROPERTIES_E3DLATHEPROPERTIES_HXX
#include <svx/sdr/properties/e3dlatheproperties.hxx>
#endif

#ifndef _SDR_PROPERTIES_E3DEXTRUDEPROPERTIES_HXX
#include <svx/sdr/properties/e3dextrudeproperties.hxx>
#endif

#ifndef _SDR_PROPERTIES_RECTANGLEPROPERTIES_HXX
#include <svx/sdr/properties/rectangleproperties.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class SchLatheProperties : public E3dLatheProperties
		{
		protected:
			// Do the internal ItemChange. If only nWhich is given, the item needs to be cleared.
			// Also needs to handle if nWhich and pNewItem is 0, which means to clear all items.
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0);

		public:
			// basic constructor
			SchLatheProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			SchLatheProperties(const SchLatheProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~SchLatheProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

class SchE3dLatheObj : public E3dLatheObj
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

public:
	SchE3dLatheObj(E3dDefaultAttributes& rDefault, const PolyPolygon& rPP)
		:E3dLatheObj(rDefault,rPP){};
	SchE3dLatheObj(E3dDefaultAttributes& rDefault, const XPolyPolygon& rXPP)
		:E3dLatheObj(rDefault,rXPP){};
	SchE3dLatheObj(E3dDefaultAttributes& rDefault, const XPolygon& rXPoly)
		:E3dLatheObj(rDefault,rXPoly){};
	SchE3dLatheObj(E3dDefaultAttributes& rDefault, const PolyPolygon3D rPoly3D)
		:E3dLatheObj(rDefault,rPoly3D){};
	SchE3dLatheObj()
		:E3dLatheObj(){};
};

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class SchExtrudeProperties : public E3dExtrudeProperties
		{
		protected:
			// Do the internal ItemChange. If only nWhich is given, the item needs to be cleared.
			// Also needs to handle if nWhich and pNewItem is 0, which means to clear all items.
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0);

		public:
			// basic constructor
			SchExtrudeProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			SchExtrudeProperties(const SchExtrudeProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~SchExtrudeProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

class SchE3dExtrudeObj : public E3dExtrudeObj
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

public:
	SchE3dExtrudeObj(E3dDefaultAttributes& rDefault, const PolyPolygon& rPP, double fDepth)
		:E3dExtrudeObj(rDefault,rPP,fDepth){};
	SchE3dExtrudeObj(E3dDefaultAttributes& rDefault, const XPolyPolygon& rXPP, double fDepth)
		:E3dExtrudeObj(rDefault,rXPP,fDepth){};
	SchE3dExtrudeObj()
		:E3dExtrudeObj(){};
};

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class SchPolygonProperties : public E3dCompoundProperties
		{
		protected:
			// Do the internal ItemChange. If only nWhich is given, the item needs to be cleared.
			// Also needs to handle if nWhich and pNewItem is 0, which means to clear all items.
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0);

		public:
			// basic constructor
			SchPolygonProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			SchPolygonProperties(const SchPolygonProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~SchPolygonProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

class SchE3dPolygonObj : public E3dPolygonObj
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

public:
	SchE3dPolygonObj(E3dDefaultAttributes& rDefault, const PolyPolygon3D& rPoly3D,
		BOOL bLinOnly=FALSE)
		:E3dPolygonObj(rDefault,rPoly3D,bLinOnly){};

	SchE3dPolygonObj(E3dDefaultAttributes& rDefault, const PolyPolygon3D& rPoly3D,
		const PolyPolygon3D& rVector3D, BOOL bLinOnly=FALSE)
		:E3dPolygonObj(rDefault,rPoly3D,rVector3D,bLinOnly){};

	SchE3dPolygonObj(E3dDefaultAttributes& rDefault, const PolyPolygon3D& rPoly3D,
		const PolyPolygon3D& rVector3D, const PolyPolygon3D& rNormal3D, BOOL bLinOnly=FALSE)
		:E3dPolygonObj(rDefault,rPoly3D,rVector3D,rNormal3D,bLinOnly){};

	SchE3dPolygonObj(E3dDefaultAttributes& rDefault, const Vector3D& rP1,
		const Vector3D& rP2, BOOL bLinOnly=TRUE)
		: E3dPolygonObj(rDefault,rP1,rP2,bLinOnly){};

	SchE3dPolygonObj() : E3dPolygonObj(){};
};

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class Sch3DProperties : public E3dProperties
		{
		protected:
			// Do the internal ItemChange. If only nWhich is given, the item needs to be cleared.
			// Also needs to handle if nWhich and pNewItem is 0, which means to clear all items.
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0);

		public:
			// basic constructor
			Sch3DProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			Sch3DProperties(const Sch3DProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~Sch3DProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

class SchE3dObject : public E3dObject
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

public:
	 SchE3dObject()
		 :E3dObject(){};
};

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		class SchRectangleProperties : public RectangleProperties
		{
		protected:
			// Do the internal ItemChange. If only nWhich is given, the item needs to be cleared.
			// Also needs to handle if nWhich and pNewItem is 0, which means to clear all items.
			virtual void ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem = 0);

		public:
			// basic constructor
			SchRectangleProperties(SdrObject& rObj);

			// constructor for copying, but using new object
			SchRectangleProperties(const SchRectangleProperties& rProps, SdrObject& rObj);

			// destructor
			virtual ~SchRectangleProperties();

			// Clone() operator, normally just calls the local copy constructor
			virtual BaseProperties& Clone(SdrObject& rObj) const;
		};
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

class SchRectObj : public SdrRectObj
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

public:
	SchRectObj(SdrObjKind eNewTextKind, const Rectangle& rRect)
		:SdrRectObj(eNewTextKind,rRect){};
	SchRectObj(const Rectangle& rRect): SdrRectObj(rRect){};

	virtual void NbcSetOutlinerParaObject(OutlinerParaObject* pTextObject);
};

//////////////////////////////////////////////////////////////////////////////

#endif




