/*************************************************************************
 *
 *  $RCSfile: globfunc.cxx,v $
 *
 *  $Revision: 1.22 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/11/03 09:06:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma optimize("e",off)

#pragma hdrstop
#define ITEMID_FONTLIST	 		0
#define ITEMID_POSTURE	 	    0
#define ITEMID_WEIGHT	 	    0
#define ITEMID_UNDERLINE	    0
#define ITEMID_CROSSEDOUT	    0
#define ITEMID_SHADOWED	 	    0
#define ITEMID_AUTOKERN	 	    0
#define ITEMID_WORDLINEMODE     0
#define ITEMID_CONTOUR	 	    0
#define ITEMID_PROPSIZE	 	    0
#define ITEMID_CHARSETCOLOR     0
#define ITEMID_KERNING	 	    0
#define ITEMID_CASEMAP	 	    0
#define ITEMID_ESCAPEMENT	    0
#define ITEMID_LANGUAGE	 	    0
#define ITEMID_NOLINEBREAK	    0
#define ITEMID_NOHYPHENHERE     0
#define ITEMID_BLINK	 	    0

#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH   EE_CHAR_FONTWIDTH

#include <svtools/whiter.hxx>

#include <svx/eeitem.hxx>

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>
#endif


#include <svx/fhgtitem.hxx>
#include <svx/fwdtitem.hxx>

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDOCIRC_HXX //autogen
#include <svx/svdocirc.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif


#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif

#ifndef _XLNCLIT_HXX
#include <svx/xlnclit.hxx>
#endif
#ifndef _XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <svx/dlgutil.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif

#ifndef _E3D_POLYGON3D_HXX
#include <svx/polygn3d.hxx>
#endif

#ifndef _E3D_CUBE3D_HXX
#include <svx/cube3d.hxx>
#endif

#ifndef _E3D_DLIGHT3D_HXX
#include <svx/dlight3d.hxx>
#endif

#include "math.h"
#include "float.h"
#include <axisid.hxx>

#include "pairs.hxx"
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif

#include "chdescr.hxx"
#ifndef _SVX_FWDTITEM_HXX //autogen
#include <svx/fwdtitem.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_WGHTITEM_HXX //autogen
#include <svx/wghtitem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <svx/udlnitem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX //autogen
#include <svx/crsditem.hxx>
#endif
#ifndef _SVX_POSTITEM_HXX //autogen
#include <svx/postitem.hxx>
#endif
#ifndef _SVX_ITEM_HXX //autogen
#include <svx/cntritem.hxx>
#endif
#ifndef _SVX_SHDDITEM_HXX //autogen
#include <svx/shdditem.hxx>
#endif
#ifndef _SVX_ESCPITEM_HXX //autogen
#include <svx/escpitem.hxx>
#endif
#ifndef _SVX_AKRNITEM_HXX //autogen
#include <svx/akrnitem.hxx>
#endif
#ifndef _SVX_KERNITEM_HXX //autogen
#include <svx/kernitem.hxx>
#endif
#ifndef _SVX_WRLMITEM_HXX //autogen
#include <svx/wrlmitem.hxx>
#endif

#include <algorithm>
#include <functional>

/*************************************************************************
|*
|* Objekt attributieren
|*
\************************************************************************/

SdrObject *SetObjectAttr (SdrObject  *pObj,
						  UINT16     nID,
						  BOOL       bProtect,
						  BOOL       bResize,
						  SfxItemSet *pAttr)
{
	pObj->InsertUserData (new SchObjectId (nID));
	pObj->SetMoveProtect (bProtect);
	pObj->SetResizeProtect (bResize);
	if (pAttr)
		pObj->SetMergedItemSet(*pAttr);

	return pObj;
}

/*************************************************************************
|*
|* Objektgruppe erzeugen
|*
\************************************************************************/

SdrObjList *CreateGroup (SdrObjList &rObjList,
						 UINT16     nID,
						 ULONG      nIndex)
{
	SdrObjGroup *pGroup = (SdrObjGroup *) SetObjectAttr (new SchObjGroup, nID, TRUE, TRUE, 0);

	rObjList.NbcInsertObject((SdrObject *) pGroup, nIndex);
	return pGroup->GetSubList();
}

/*************************************************************************
|*
|* Objektgruppe erzeugen
|*
\************************************************************************/

SchObjGroup *CreateSimpleGroup (UINT16 nID,
								BOOL   bProtect,
								BOOL   bResize)
{
	return (SchObjGroup *) SetObjectAttr (new SchObjGroup, nID, bProtect, bResize, 0);
}


/*************************************************************************
|*
|* Berechne kub. Spline
|*
\************************************************************************/

void CubicSpline (XPolygon &pKnownPoints,
				  int      n,
				  int      splineSize,
				  XPolygon &pSplines)
{
	double *h      = new double [n + 1];
	double *m      = new double [n + 1];
	double *q      = new double [n + 1];
	double *u      = new double [n + 1];

	for (int k = 1;
			 k <= n;
			 k ++)
		h [k] = pKnownPoints [k].X () - pKnownPoints [k - 1].X ();

	double p;
	double lambda = 0.0;
	double d      = 0.0;
	double mue;

	q [0] = -lambda / 2.0;
	u [0] = d / 2.0;

	int j;
	for (j = 1;
			 j <= n;
			 j ++)
	{
		mue        = (j < n)
						 ? h[j] / (h [j] + h [j + 1])
						 : 0.0;
		p          = mue * q [j - 1] + 2.0;
		lambda     = 1.0 - mue;
		q [j]      = -lambda / p;
		d          = (j < n)
						 ? 6.0 * ((pKnownPoints [j + 1].Y () - pKnownPoints [j].Y ()) / h [j + 1] -
								  (pKnownPoints [j].Y () - pKnownPoints [j - 1].Y ()) / h [j]) / (h [j] + h [j + 1])
						 : 0.0;
		u [j]      = (d - mue * u [j - 1]) / p;
	}

	m [n] = u [n];

	for (j = n - 1;
		 j >= 0;
		 j --)
		m [j] = q [j] * m [j + 1] + u [j];

	for (j = 0;
		 j < n;
		 j ++)
	{
		double xStep = (pKnownPoints [j + 1].X () - pKnownPoints [j].X ()) / splineSize;
		double x     = pKnownPoints [j].X ();

		double alpha = pKnownPoints [j].Y ();
		double gamma = m [j] / 2;
		double beta  = (pKnownPoints [j + 1].Y () - pKnownPoints [j].Y ()) / h [j + 1] -
					   ((2 * m [j] + m [j + 1]) * h [j + 1]) / 6;
		double delta = (m [j + 1] - m [j]) / (6 * h [j + 1]);

		for (int i = 0;
				 i < splineSize;
				 i ++)
		{
			double xdiff = (x - pKnownPoints [j].X ());
			int    index = j * splineSize + i;

			pSplines [(short) index].Y () = long(alpha + xdiff * (beta + xdiff * (gamma + xdiff * delta)));
			pSplines [(short) index].X () = long(x);
			x                            += xStep;
		}
	}

	pSplines [n * splineSize].Y () = pKnownPoints [n].Y ();
	pSplines [n * splineSize].X () = pKnownPoints [n].X ();

	delete[] h;
	delete[] m;
	delete[] q;
	delete[] u;
}

/*************************************************************************
|*
|* Bestimme Knotenvektor fuer B-Spline
|*
\************************************************************************/

void TVector (int    n,
			  int    k,
			  double *t)
{
	for (int i = 0;
			 i <= n + k;
			 i ++)
	{
		if (i < k) t [i] = 0;
		else if (i <= n) t [i] = i - k + 1;
			 else t [i] = n - k + 2;
	}
}

/*************************************************************************
|*
|* Berechne linken Knotenvektor
|*
\************************************************************************/

double TLeft (double x,
			  int    i,
			  int    k,
			  double *t)
{
	double deltaT = t [i + k - 1] - t [i];

	return (deltaT == 0.0)
			   ? 0.0
			   : (x - t [i]) / deltaT;
}

/*************************************************************************
|*
|* Berechne rechten Knotenvektor
|*
\************************************************************************/

double TRight (double x,
			   int    i,
			   int    k,
			   double *t)
{
	double deltaT = t [i + k] - t [i + 1];

	return (deltaT == 0.0)
			   ? 0.0
			   : (t [i + k] - x) / deltaT;
}

/*************************************************************************
|*
|* Berechne Gewichtungsvektor
|*
\************************************************************************/

void BVector (double x,
			  int    n,
			  int    k,
			  double *b,
			  double *t)
{
	for (int i = 0;
			 i <= n + k;
			 i ++)
		b [i] = 0;

	int i0 = (int) floor (x) + k - 1;
	b [i0] = 1;

	for (int j = 2;
			 j <= k;
			 j ++)
		for (int i = 0;
				 i <= i0;
				 i ++)
			b [i] = TLeft (x, i, j, t) * b [i] + TRight (x, i, j, t) * b [i + 1];
}

/*************************************************************************
|*
|* Berechne einzelnen Punkt
|*
\************************************************************************/

void BSPoint (int      n,
			  Point    &p1,
			  Point    &p2,
			  XPolygon &pKnownPoints,
			  double   *b)
{
	for (int i = 0;
			 i <= n;
			 i ++)
	{
		p1.Y () = long(p1.Y () + b [i] * pKnownPoints [i].Y ());
		p2.Y () = long(p2.Y () + b [n - i] * pKnownPoints [i].Y ());
	}
}

/*************************************************************************
|*
|* Berechne B-Spline
|*
\************************************************************************/

void approxMesh (int      splineSize,
				 XPolygon &pSplines,
				 XPolygon &pKnownPoints,
				 int      n,
				 int      k)
{
	int    pCount   = splineSize * n;
	double *b       = new double [n + k + 1];
	double *t       = new double [n + k + 2];
	double xStep    = ((double) n - (double) k + 2.0) / (double) pCount;
	double dStep = ((double) pKnownPoints [n].X () - (double) pKnownPoints [0].X ()) / (double) pCount;
	double dXUp     = pKnownPoints [0].X ();
	double dXDown   = pKnownPoints [n].X ();
	double x        = 0.0;
	int    nEnd     = pCount / 2 + 1;

	TVector (n, k, t);

	for (int j = 0;
			 j <= nEnd;
			 j ++)
	{
		Point aPoint1;
		Point aPoint2;

		BVector (x, n, k, b, t);
		BSPoint (n, aPoint1, aPoint2, pKnownPoints, b);

		pSplines [j].X ()          = (int)(floor(dXUp)+0.5);
		pSplines [j].Y ()          = aPoint1.Y ();
		pSplines [pCount - j].X () = (int)(floor(dXDown)+0.5);
		pSplines [pCount - j].Y () = aPoint2.Y ();

		x      += xStep;
		dXUp   += dStep;
		dXDown -= dStep;
	}

	delete[] t;
	delete[] b;
}

/*************************************************************************
|*
|* Passe untere Grenze an den Wertebereich an
|*
\************************************************************************/

double SizeBounds (double dMinValue,
				   double dMaxValue,
				   BOOL   bIsMax)
{
	if( (dMinValue == DBL_MIN) ||
		(dMaxValue == DBL_MIN) ||
		(dMinValue == dMaxValue) ||
		(dMinValue == 0.0) )
		return 0.0;

	return bIsMax? dMaxValue : dMinValue;

	// BM: I removed some very strange code here. It
	// calculated a kind of log10 but the charts didn't
	// really use the value calculated.
}

/*************************************************************************
|*
|* Erhoehe einen Wert mit Log.
|*
\************************************************************************/

void IncValue(double &rValue,
			  double fInc,
			  BOOL   bLogarithm)
{
	if (bLogarithm)
		rValue *= fInc;
	else
		rValue += fInc;
}

/*************************************************************************
|*
|* Vermindere einen Wert mit Log.
|*
\************************************************************************/

void DecValue(double &rValue,
			  double fInc,
			  BOOL   bLogarithm)
{
	if (bLogarithm) rValue /= fInc;
	else rValue -= fInc;
}

/*************************************************************************
|*
|* Faktor fuer Koordinaten-Multiplikation berechnen
|*
\************************************************************************/

double CalcFact(double fValue,
				BOOL   bLogarithm,
				double fMinValue,
				double fMaxValue)
{
	if (fValue == DBL_MIN)
	{
		return DBL_MIN;
	}
	else if (fMinValue == fMaxValue)
	{
		return 0.0;
	}
	else if (bLogarithm)
	{
		double fVal = (fValue > 0.0) ? log10(fValue) : log10(fMinValue);

		DBG_ASSERT( fMinValue <= 0, "Chart: CalcFact: Argument for logarithm is not positive" );
		DBG_ASSERT( fMaxValue <= 0, "Chart: CalcFact: Argument for logarithm is not positive" );
		return (fVal - log10(fMinValue)) / (log10(fMaxValue) - log10(fMinValue));
	}
	else
	{
		return (fValue - fMinValue) / (fMaxValue - fMinValue);
	}
}

/*************************************************************************
|*
|* Konvertiert in echte RGB-Farben.
|*
\************************************************************************/

Color RGBColor(ColorData nColorName)
{
	Color aColor(nColorName);

	return Color(aColor.GetRed(), aColor.GetGreen(), aColor.GetBlue());
}

/*************************************************************************
|*
|* "Stapelt" den angegebenen String.
|*
\************************************************************************/

String StackString( const String& aString )
{
	String aStackStr;
	xub_StrLen nLen = aString.Len();

	if( nLen )
	{
		// '\n' is interpreted as newline by the outliner
		aStackStr.Fill( nLen * 2 - 1, (sal_Unicode)('\n') );

		for( xub_StrLen posSrc=0, posDest=0;
			 posSrc < nLen;
			 posSrc++, posDest += 2 )
			aStackStr.SetChar( posDest, aString.GetChar( posSrc ));
	}

	return aStackStr;
}

/*************************************************************************
|*
|* "Entstapelt" den angegebenen String.
|*
\************************************************************************/

String UnstackString( const String& aString )
{
	// prerequisite: aString was stacked by StackString
	// => every second letter is a '\n' (except the very end)

	String aUnstackStr;
	xub_StrLen nLen = aString.Len();

	if( nLen )
	{
		aUnstackStr.Fill( nLen / 2 + 1 );

		for( xub_StrLen posSrc=0, posDest=0;
			 posSrc < nLen;
			 posSrc += 2, posDest++ )
			aUnstackStr.SetChar( posDest, aString.GetChar( posSrc ));
	}

	return aUnstackStr;
}

/*************************************************************************
|*
|* Aendert die Helligkeit der Fuellfarbe des Ziel-ItemSets;
|* Liefert die alte Fuellfarbe zurueck.
|*
\************************************************************************/

Color SetBrightness(const SfxItemSet &rSourceAttr,
					SfxItemSet       &rDestAttr,
					double           fLightFactor)
{
	Color aOldColor(((const XFillColorItem&)rSourceAttr.Get(XATTR_FILLCOLOR)).GetValue());
	Color aColor (aOldColor);

	aColor.SetRed((UINT8)(fLightFactor * aColor.GetRed()));
	aColor.SetGreen((UINT8)(fLightFactor * aColor.GetGreen()));
	aColor.SetBlue((UINT8)(fLightFactor * aColor.GetBlue()));
	rDestAttr.Put(XFillColorItem(String(), aColor));

	return aOldColor;
}

/*************************************************************************
|*
|* Position des ungedrehten Rechtecks entsprechend der Ausrichtung anpassen
|*
\************************************************************************/

void AdjustRect(Rectangle          &rRect,
				ChartAdjust        eAdjust)
{
	Point aPos = rRect.TopLeft();
	Size aSize = rRect.GetSize();

	switch (eAdjust)
	{
		case CHADJUST_TOP_LEFT:

			break;

		case CHADJUST_TOP_CENTER:

			aPos.X() -= aSize.Width() / 2;
			break;

		case CHADJUST_TOP_RIGHT:

			aPos.X() -= aSize.Width();
			break;

		case CHADJUST_CENTER_LEFT:

			aPos.Y() -= aSize.Height() / 2;
			break;

		case CHADJUST_CENTER_CENTER:

			aPos.X() -= aSize.Width() / 2;
			aPos.Y() -= aSize.Height() / 2;
			break;

		case CHADJUST_CENTER_RIGHT:

			aPos.X() -= aSize.Width();
			aPos.Y() -= aSize.Height() / 2;
			break;

		case CHADJUST_BOTTOM_LEFT:

			aPos.Y() -= aSize.Height();
			break;

		case CHADJUST_BOTTOM_CENTER:

			aPos.X() -= aSize.Width() / 2;
			aPos.Y() -= aSize.Height();
			break;

		case CHADJUST_BOTTOM_RIGHT:
			aPos.X() -= aSize.Width();
			aPos.Y() -= aSize.Height();

	}

	rRect.SetPos(aPos);
}

/*************************************************************************
|*
|* Position des gedrehten Rechtecks entsprechend der Ausrichtung anpassen
|*
\************************************************************************/

Size AdjustRotatedRect(const Rectangle       &rOldRect,
					   ChartAdjust        eAdjust,
					   const Rectangle          &rNewRect)
{

	Size aMovement;
	Point aOld;
	Point aNew;
	Point aDifference;

	switch (eAdjust)
	{
		case CHADJUST_TOP_LEFT:

			aOld = rOldRect.TopLeft();
			aNew = rNewRect.TopLeft();
			break;

		case CHADJUST_TOP_CENTER:

			aOld = rOldRect.TopCenter();
			aNew = rNewRect.TopCenter();
			break;

		case CHADJUST_TOP_RIGHT:

			aOld = rOldRect.TopRight();
			aNew = rNewRect.TopRight();
			break;

		case CHADJUST_CENTER_LEFT:

			aOld = rOldRect.LeftCenter();
			aNew = rNewRect.LeftCenter();
			break;

		case CHADJUST_CENTER_CENTER:

			aOld = rOldRect.Center();
			aNew = rNewRect.Center();
			break;

		case CHADJUST_CENTER_RIGHT:

			aOld = rOldRect.RightCenter();
			aNew = rNewRect.RightCenter();
			break;

		case CHADJUST_BOTTOM_LEFT:

			aOld = rOldRect.BottomLeft();
			aNew = rNewRect.BottomLeft();
			break;

		case CHADJUST_BOTTOM_CENTER:

			aOld = rOldRect.BottomCenter();
			aNew = rNewRect.BottomCenter();
			break;

		case CHADJUST_BOTTOM_RIGHT:

			aOld = rOldRect.BottomRight();
			aNew = rNewRect.BottomRight();
			break;
	}

	aDifference = ( aOld - aNew);
	aMovement =  Size(aDifference.X(),aDifference.Y());

	return aMovement;
}
//Umrechnung Textgre in Gre des BoundRects rotierter Texte
Size GetRotatedTextSize(const Size& rSize,const long nDegrees)
{
	if(nDegrees)
	{
		double fDeg,fSin,fCos;
		fDeg=CDEG2RAD(nDegrees);
		fSin=fabs(sin(fDeg));
		fCos=fabs(cos(fDeg));
		Size aRetSize(
		(long)( (double)rSize.Width()*fCos + (double)rSize.Height()*fSin ),
		(long)( (double)rSize.Width()*fSin + (double)rSize.Height()*fCos )
			);
		return aRetSize;
	}
	Size aRetSize(rSize);
	return aRetSize;
}
/*************************************************************************
|*
|* die Rotation des Textes in Grad zurueckgeben, falls kein DEGREE-item
|* vorhanden, (z.B. 4.0-Chart) so wird das Item ergaenzt
|*
\************************************************************************/
long GetTextRotation(SfxItemSet &rAttr) //Wrapper, falls eOrient noch nicht ermittelt
{
	SvxChartTextOrient eOrient
		= ((const SvxChartTextOrientItem&)rAttr.Get(SCHATTR_TEXT_ORIENT)).GetValue();
	return GetTextRotation(rAttr,eOrient);
}

long GetTextRotation(SfxItemSet &rAttr,SvxChartTextOrient eOrient)
{

	const SfxPoolItem* pPoolItem = NULL;
	long nDegrees = 0;

    // the attribute is set: use it
	if( rAttr.GetItemState( SCHATTR_TEXT_DEGREES, TRUE, &pPoolItem ) == SFX_ITEM_SET )
	{
        nDegrees = ((const SfxInt32Item*)pPoolItem)->GetValue();
        return nDegrees;
	}

    // otherwise use orientation to set default rotation
	switch( eOrient )
	{
		case CHTXTORIENT_BOTTOMTOP:
            nDegrees = 9000;    // 90 deg
			break;

		case CHTXTORIENT_TOPBOTTOM:
            nDegrees = 27000;   // 270 deg
			break;

		case CHTXTORIENT_STANDARD:
		case CHTXTORIENT_STACKED:
			break;
	}

	return nDegrees;
}


/*************************************************************************
|*
|* Ausrichtung entsprechend der Orientierung anpassen
|*
\************************************************************************/

void SetAdjust(ChartAdjust        &rAdjust,
			   SvxChartTextOrient eOrient)
{
	switch (eOrient)
	{
		case CHTXTORIENT_BOTTOMTOP:
			switch (rAdjust)
			{
				case CHADJUST_TOP_LEFT:
					rAdjust = CHADJUST_TOP_RIGHT;
					break;

				case CHADJUST_TOP_CENTER:
					rAdjust = CHADJUST_CENTER_RIGHT;
					break;

				case CHADJUST_TOP_RIGHT:
					rAdjust = CHADJUST_BOTTOM_RIGHT;

					break;

				case CHADJUST_CENTER_LEFT:
					rAdjust = CHADJUST_TOP_CENTER;
					break;

				case CHADJUST_CENTER_RIGHT:
					rAdjust = CHADJUST_BOTTOM_CENTER;
					break;

				case CHADJUST_BOTTOM_LEFT:
					rAdjust = CHADJUST_TOP_LEFT;
					break;

				case CHADJUST_BOTTOM_CENTER:
					rAdjust = CHADJUST_CENTER_LEFT;
					break;

				case CHADJUST_BOTTOM_RIGHT:
					rAdjust = CHADJUST_BOTTOM_LEFT;
					break;
			}
			break;

		case CHTXTORIENT_TOPBOTTOM:
			switch (rAdjust)
			{
				case CHADJUST_TOP_LEFT:
					rAdjust = CHADJUST_BOTTOM_LEFT;
					break;

				case CHADJUST_TOP_CENTER:
					rAdjust = CHADJUST_CENTER_LEFT;
					break;

				case CHADJUST_TOP_RIGHT:
					rAdjust = CHADJUST_TOP_LEFT;
					break;

				case CHADJUST_CENTER_LEFT:
					rAdjust = CHADJUST_BOTTOM_CENTER;
					break;

				case CHADJUST_CENTER_RIGHT:
					rAdjust = CHADJUST_TOP_CENTER;
					break;

				case CHADJUST_BOTTOM_LEFT:
					rAdjust = CHADJUST_BOTTOM_RIGHT;
					break;

				case CHADJUST_BOTTOM_CENTER:
					rAdjust = CHADJUST_CENTER_RIGHT;
					break;

				case CHADJUST_BOTTOM_RIGHT:
					rAdjust = CHADJUST_TOP_RIGHT;
					break;
			}
			break;
	}
}

/*************************************************************************
|*
|* Textobjekt positionieren
|*
\************************************************************************/
void SetTextPos(SdrTextObj  &rTextObj,
				const Point &rPos,SfxItemSet* pAttr)
{
	SchObjectAdjust	   *pObjAdjust = GetObjectAdjust(rTextObj);
	ChartAdjust			eAdjust	   = pObjAdjust->GetAdjust();
	double				fVal;
	SvxChartTextOrient	eOrient	   = pObjAdjust->GetOrient();
	
	switch (eOrient)
	{
		case CHTXTORIENT_BOTTOMTOP:
		case CHTXTORIENT_TOPBOTTOM:
		{
			long nAng = 36000 - rTextObj.GetRotateAngle();
			fVal = nAng * nPi180;
			rTextObj.NbcRotate(rPos, nAng, sin(fVal), cos(fVal));
			break;
		}
	}

	Rectangle aRect = rTextObj.GetLogicRect();
	aRect.SetPos(rPos);
	AdjustRect(aRect, eAdjust);
	rTextObj.NbcSetLogicRect(aRect);
	
	switch (eOrient)
	{
		case CHTXTORIENT_BOTTOMTOP:
		case CHTXTORIENT_TOPBOTTOM:
		{
			long nDegrees = GetTextRotation(*pAttr,eOrient);
			Rectangle aOldBoundRect=rTextObj.GetCurrentBoundRect();
			fVal = nDegrees * nPi180;
			rTextObj.NbcRotate(rPos, nDegrees, sin(fVal), cos(fVal));
			Rectangle aNewBoundRect=rTextObj.GetCurrentBoundRect();
			rTextObj.NbcMove( AdjustRotatedRect(aOldBoundRect, eAdjust, aNewBoundRect));
			break;
		}
	}
}

/*************************************************************************
|*
|* Textobjekt-Groesse entsprechend der Ausrichtung anpassen
|*
\************************************************************************/

void AdjustTextSize(SdrTextObj &rTextObj,
					const Size &rTextSize)
{
	Rectangle aRect = rTextObj.GetLogicRect();

	if (aRect.GetSize() != rTextSize)
	{
		SchObjectAdjust    *pObjAdjust = GetObjectAdjust(rTextObj);
		ChartAdjust        eAdjust     = pObjAdjust->GetAdjust();
		SvxChartTextOrient eOrient     = pObjAdjust->GetOrient();

		SetAdjust(eAdjust, eOrient);

		Point aOldPos = aRect.TopLeft();

		switch (eAdjust)
		{
			case CHADJUST_TOP_CENTER:
				aRect.Left() = aRect.Left() + aRect.GetWidth() / 2 - rTextSize.Width() / 2;
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;

			case CHADJUST_TOP_RIGHT:
				aRect.Left() = aRect.Right() - rTextSize.Width();
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;

			case CHADJUST_CENTER_LEFT:
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Top() = aRect.Top() + aRect.GetHeight() / 2 -	rTextSize.Height() / 2;
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;

			case CHADJUST_CENTER_CENTER:
				aRect.Left() = aRect.Left() + aRect.GetWidth() / 2 - rTextSize.Width() / 2;
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Top() = aRect.Top() + aRect.GetHeight() / 2 -	rTextSize.Height() / 2;
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;

			case CHADJUST_CENTER_RIGHT:
				aRect.Left() = aRect.Right() - rTextSize.Width();
				aRect.Top() = aRect.Top() + aRect.GetHeight() / 2 -	rTextSize.Height() / 2;
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;

			case CHADJUST_BOTTOM_LEFT:
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Top() = aRect.Bottom() - rTextSize.Height();
				break;

			case CHADJUST_BOTTOM_CENTER:
				aRect.Left() = aRect.Left() + aRect.GetWidth() / 2 - rTextSize.Width() / 2;
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Top() = aRect.Bottom() - rTextSize.Height();
				break;

			case CHADJUST_BOTTOM_RIGHT:
				aRect.Left() = aRect.Right() - rTextSize.Width();
				aRect.Top() = aRect.Bottom() - rTextSize.Height();
				break;

			default:
				aRect.Right() = aRect.Left() + rTextSize.Width();
				aRect.Bottom() = aRect.Top() + rTextSize.Height();
				break;
		}

		Point aNewPos = aRect.TopLeft();

		if (aNewPos != aOldPos)
		{
			long nArc = rTextObj.GetRotateAngle();

			if (nArc)
			{
				double fVal = nArc * nPi180;
				RotatePoint(aNewPos, aOldPos, sin(fVal), cos(fVal));
				aRect.SetPos(aNewPos);
			}
		}

		rTextObj.SetLogicRect(aRect);
	}
}

/*************************************************************************
|*
|* Ausgabegroesse ermitteln
|*
\************************************************************************/

Size GetOutputSize(SdrTextObj& rTextObj)
{
	return (rTextObj.GetCurrentBoundRect().GetSize());
}

/*************************************************************************
|*
|* Haenge die Beschriftungen an die Segmente
|*
\************************************************************************/

void SegmentDescr (DataDescription &rDescr,
				   const Rectangle &rRect,
				   long            nStartAng,
				   long            nEndAng,
				   long            nHeight,
				   double          a,
				   double          b)
{
	long nAngleDiff;
	long nAngleHook;

	// bestimme die Winkelhalbierenden des Segments
	if (nStartAng > nEndAng)
	{
		nAngleDiff = (nEndAng + 36000 - nStartAng) / 2;
		nAngleHook = (nStartAng + nAngleDiff) % 36000;
	}
	else
	{
		nAngleDiff = (nEndAng - nStartAng) / 2;
		nAngleHook = nStartAng + nAngleDiff;
	}

	// und dementsprechend die Textausrichtung
	if (nAngleHook < 2250) rDescr.eAdjust = CHADJUST_CENTER_LEFT;
	else if (nAngleHook < 6750) rDescr.eAdjust = CHADJUST_BOTTOM_LEFT;
		 else if (nAngleHook < 11250) rDescr.eAdjust = CHADJUST_BOTTOM_CENTER;
			  else if (nAngleHook < 15750) rDescr.eAdjust = CHADJUST_BOTTOM_RIGHT;
				   else if (nAngleHook < 20250) rDescr.eAdjust = CHADJUST_CENTER_RIGHT;
						else if (nAngleHook < 24750) rDescr.eAdjust = CHADJUST_TOP_RIGHT;
							 else if (nAngleHook < 29250) rDescr.eAdjust = CHADJUST_TOP_CENTER;
								  else if (nAngleHook < 33750) rDescr.eAdjust = CHADJUST_TOP_LEFT;
									   else rDescr.eAdjust = CHADJUST_CENTER_LEFT;

	// die Seiten werden etwas verlaengert, um einen Offset Text<-->Segment zu erhalten
	double fAng = F_PI * (double) nAngleHook / 18000;
	rDescr.aTextPos2D       = rRect.Center();
	rDescr.aTextPos2D.X() += long((a * 10 / 9) * cos (fAng));
	rDescr.aTextPos2D.Y() -= long((b * 10 / 9) * sin (fAng));

	// Winkel im Bereich der Bodenplatte -> Texte etwas tiefer setzen
	if ((nAngleHook > 18000) && (nAngleHook < 36000)) rDescr.aTextPos2D.Y() += nHeight;

	// TVM: vorlaeufiger Bug-Fix, pText kann bei 3DPieChart Null sein
	DBG_ASSERT(rDescr.pLabelObj,"Beschriftungstext ist nicht vorhanden");
	if(rDescr.pLabelObj)
	{
		Rectangle aObjRect = rDescr.pLabelObj->GetLogicRect();

		aObjRect.SetPos(rDescr.aTextPos2D);
		AdjustRect(aObjRect, rDescr.eAdjust);
		rDescr.pLabelObj->SetLogicRect(aObjRect);
	}
}


/**	Draw a donut segment's description centered into that segment.
	Please see the header for a detailed documentation.
*/
void SegmentDescr (DataDescription &rDescr,
				   const Rectangle &rRect,
				   long            nStartAng,
				   long            nEndAng,
				   double          fRadius)
{
	//	Calculate the radial line on which the desctiption will be positioned.
	long nAngleHook;
	if (nStartAng > nEndAng)
		nAngleHook = (nStartAng + (nEndAng + 36000 - nStartAng) / 2) % 36000;
	else
		nAngleHook = nStartAng + (nEndAng - nStartAng) / 2;

	//	Place description at the given radius.
	double fAng = F_PI * (double) nAngleHook / 18000;
	rDescr.aTextPos2D = rRect.Center();
	rDescr.aTextPos2D.X() += long(fRadius * cos (fAng));
	rDescr.aTextPos2D.Y() -= long(fRadius * sin (fAng));

	//	Description will be centerd around it's reference point.
	rDescr.eAdjust = CHADJUST_CENTER_CENTER;

	//	Create description.
	DBG_ASSERT(rDescr.pLabelObj,"Beschriftungstext ist nicht vorhanden");
	if(rDescr.pLabelObj)
	{
		Rectangle aObjRect = rDescr.pLabelObj->GetLogicRect();

		aObjRect.SetPos(rDescr.aTextPos2D);
		AdjustRect(aObjRect, rDescr.eAdjust);
		rDescr.pLabelObj->SetLogicRect(aObjRect);
	}
}
/*************************************************************************
|*
|* zeichne Fehlerbalken
|*
\************************************************************************/

void ShowErrorLineY( BOOL              bIsVertical,
					 double            fErrorUp,
					 double            fErrorDown,
					 SfxItemSet        &rAttr,
					 const  Point&	   rPos,
					 SvxChartIndicate  eMyIndicate,
					 SdrObjList        *pList,
                     ChartModel *      pModel )
{
	long              nPosX,nPosY;

	XPolygon   aErrorPolygon (2);
	XPolygon   aTopPolygon (2);
	XPolygon   aBottomPolygon (2);
// 	SfxItemSet aSolidAttr (rAttr);

// 	aSolidAttr.ClearItem (XATTR_LINESTYLE);
// 	aSolidAttr.Put(XLineStyleItem (XLINE_SOLID));

	if(bIsVertical) //Bei Gelegenheit sollte hier mal aufgerumt werden....
	{
		nPosX = rPos.Y();
		nPosY = rPos.X();
	}
	else
	{
		nPosX = rPos.X();
		nPosY = rPos.Y();
	}

	switch (eMyIndicate)
	{
		case CHINDICATE_BOTH :
            {
                if (bIsVertical)
                {
                    aErrorPolygon [0].Y()  =
                        aErrorPolygon [1].Y()  = nPosX;
                    aErrorPolygon [0].X()  =
                        aTopPolygon [0].X()    =
                        aTopPolygon [1].X()    = (long) fErrorUp;
                    aErrorPolygon [1].X()  =
                        aBottomPolygon [0].X() =
                        aBottomPolygon [1].X() = (long) fErrorDown;
                    aTopPolygon [0].Y()    =
                        aBottomPolygon [0].Y() = nPosX - 100;
                    aTopPolygon [1].Y()    =
                        aBottomPolygon [1].Y() = nPosX + 100;
                }
                else
                {
                    aErrorPolygon [0].X()  =
                        aErrorPolygon [1].X()  = nPosX;
                    aErrorPolygon [0].Y()  =
                        aTopPolygon [0].Y()    =
                        aTopPolygon [1].Y()    = (long) fErrorUp;
                    aErrorPolygon [1].Y()  =
                        aBottomPolygon [0].Y() =
                        aBottomPolygon [1].Y() = (long) fErrorDown;
                    aTopPolygon [0].X()    =
                        aBottomPolygon [0].X() = nPosX - 100;
                    aTopPolygon [1].X()    =
                        aBottomPolygon [1].X() = nPosX + 100;
                }

                ::std::vector< XPolygon > aPolygons;
                aPolygons.push_back( aErrorPolygon );
                aPolygons.push_back( aTopPolygon );
                aPolygons.push_back( aBottomPolygon );
                pList->NbcInsertObject( CreateErrorGroup( pModel, aPolygons, rAttr ) );
            }
			break;

		case CHINDICATE_UP :
            {
                if (bIsVertical)
                {
                    aErrorPolygon [0].Y()  =
                        aErrorPolygon [1].Y()  = nPosX;
                    aErrorPolygon [0].X()  =
                        aTopPolygon [0].X()    =
                        aTopPolygon [1].X()    = (long) fErrorUp;
                    aErrorPolygon [1].X()  = nPosY;
                    aTopPolygon [0].Y()    = nPosX - 100;
                    aTopPolygon [1].Y()    = nPosX + 100;
                }
                else
                {
                    aErrorPolygon [0].X()  =
                        aErrorPolygon [1].X()  = nPosX;
                    aErrorPolygon [0].Y()  =
                        aTopPolygon [0].Y()    =
                        aTopPolygon [1].Y()    = (long) fErrorUp;
                    aErrorPolygon [1].Y()  = nPosY;
                    aTopPolygon [0].X()    = nPosX - 100;
                    aTopPolygon [1].X()    = nPosX + 100;
                }

                ::std::vector< XPolygon > aPolygons;
                aPolygons.push_back( aErrorPolygon );
                aPolygons.push_back( aTopPolygon );
                pList->NbcInsertObject( CreateErrorGroup( pModel, aPolygons, rAttr ) );
            }
			break;

		case CHINDICATE_DOWN :
            {
                if (bIsVertical)
                {
                    aErrorPolygon [0].Y()  =
                        aErrorPolygon [1].Y()  = nPosX;
                    aErrorPolygon [0].X()  =
                        aBottomPolygon [0].X() =
                        aBottomPolygon [1].X() = (long) fErrorDown;
                    aErrorPolygon [1].X()  = nPosY;
                    aBottomPolygon [0].Y() = nPosX - 100;
                    aBottomPolygon [1].Y() = nPosX + 100;
                }
                else
                {
                    aErrorPolygon [0].X()  =
                        aErrorPolygon [1].X()  = nPosX;
                    aErrorPolygon [0].Y()  =
                        aBottomPolygon [0].Y() =
                        aBottomPolygon [1].Y() = (long) fErrorDown;
                    aErrorPolygon [1].Y()  = nPosY;
                    aBottomPolygon [0].X() = nPosX - 100;
                    aBottomPolygon [1].X() = nPosX + 100;
                }

                ::std::vector< XPolygon > aPolygons;
                aPolygons.push_back( aErrorPolygon );
                aPolygons.push_back( aBottomPolygon );
                pList->NbcInsertObject( CreateErrorGroup( pModel, aPolygons, rAttr ) );
            }
			break;

		case CHINDICATE_NONE :
		default :
			;
	}
}

/*************************************************************************
|*
|* bestimme lineare regression
|*
\************************************************************************/

void InsertPolygon (SdrObjList *pList,
					XPolygon   &rPolygon,
					SfxItemSet &rAttr)
{
	SdrObject *pObj = new SdrPathObj (OBJ_PLIN, rPolygon);

	if (pObj)
	{
		pObj->InsertUserData (new SchObjectId (CHOBJID_DIAGRAM_ERROR));
		pObj->SetMergedItemSet(rAttr);
		pList->NbcInsertObject (pObj);
	}
}

// --------------------

namespace 
{

class lcl_InsertPolygonInList : public ::std::unary_function< void, XPolygon >
{
public:
    lcl_InsertPolygonInList( SdrObjList * pObjListForInsertion,
                             const SfxItemSet & rItems ) :
            m_pObjList( pObjListForInsertion ),
            m_rItems( rItems )
    {}

    inline void operator() ( const XPolygon & rPoly )
    {
        SdrObject * pObj = new SdrPathObj( OBJ_PLIN, rPoly );
        pObj->SetMergedItemSet( m_rItems );
        m_pObjList->NbcInsertObject( pObj );
    }

private:
    SdrObjList *        m_pObjList;
    const SfxItemSet &  m_rItems;
};
 
}

// --------------------

SdrObject * CreateErrorGroup(
    ChartModel * pModel,
    const ::std::vector< XPolygon > & rPolygons,
    const SfxItemSet & rItems )
{
    SdrObject * pResult = new SchObjGroup( pModel );

    pResult->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_ERROR ));
    SdrObjList * pObjList = pResult->GetSubList();
    ::std::for_each( rPolygons.begin(), rPolygons.end(),
                     lcl_InsertPolygonInList( pObjList, rItems ) );

    return pResult;
}

/*************************************************************************
/*************************************************************************
|*
|* Erstelle Polygone fuer die Scheiben in den Pie-Charts
|*
\************************************************************************/

SdrObject *Create2DPolyObj (SfxItemSet &rAttr,
							Point      aLeftBottom,
							Point      aLeftTop,
							Point      aRightTop,
							Point      aRightBottom)
{
	XPolygon   aSide (5);

	aSide [0] =
	aSide [4] = aLeftBottom;
	aSide [1] = aLeftTop;
	aSide [2] = aRightTop;
	aSide [3] = aRightBottom;

	rAttr.Put(XLineStyleItem(XLINE_NONE));

	return SetObjectAttr (new SdrPathObj(OBJ_POLY, XPolyPolygon(aSide)), 0, TRUE, TRUE, &rAttr);
}

/*************************************************************************
|*
|* Erstelle Sublist fuer Elemente eines 3D-PieCharts
|*
\************************************************************************/

SdrObjList *CreateGroupList (SdrObjList *pList,
							 long       nID)
{
	SchObjGroup *pGroup     = CreateSimpleGroup (USHORT(nID), TRUE, TRUE);
	SdrObjList  *pGroupList = pGroup->GetSubList();

	pGroup->InsertUserData(new SchDataRow(0));
	pList->NbcInsertObject (pGroup);

	return pGroupList;
}

/*************************************************************************
|*
|* Erstelle eine Gruppe und die Sublist fuer ein Chart
|*
\************************************************************************/

void CreateChartGroup( SchObjGroup* &pGroup,
					   SdrObjList*  &pList )
{
	pGroup = new SchObjGroup;
	pList  = pGroup->GetSubList();
	pGroup->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM ));
}



/*************************************************************************
|*
|* Beseitige alle Statistikattrs
|*
\************************************************************************/

void CopySetsFrom40To31(const SfxItemSet &rSourceSet,SfxItemSet &rDestSet)
{
	SfxWhichIter aIter (rSourceSet);
	USHORT       nWhich = aIter.FirstWhich();

	while (nWhich)
	{
		if (((nWhich < SCHATTR_STAT_START) || (nWhich > SCHATTR_STAT_END)) &&
			((nWhich < EE_ITEMS_START) || (nWhich > EE_ITEMS_END)))
		{
			rDestSet.InvalidateItem (nWhich);
			rDestSet.Put (rSourceSet.Get (nWhich));
		}

		nWhich = aIter.NextWhich();
	}
}

//BFS03const long nOffX = SCHATTR_AXIS_AUTO_MIN - SCHATTR_X_AXIS_AUTO_MIN;
//BFS03const long nOffY = SCHATTR_AXIS_AUTO_MIN - SCHATTR_Y_AXIS_AUTO_MIN;
//BFS03const long nOffZ = SCHATTR_AXIS_AUTO_MIN - SCHATTR_Z_AXIS_AUTO_MIN;

//neue in alte Achsenattr konvertieren
//BFS03void AxisAttrNew2Old(SfxItemSet &rDestSet,long nId,BOOL bClear)
//BFS03{
//BFS03	USHORT nOff;
//BFS03	double f;
//BFS03	BOOL b;
//BFS03	SfxItemSet aSet(rDestSet); //Kopie
//BFS03
//BFS03	switch(nId)
//BFS03	{
//BFS03		case CHOBJID_DIAGRAM_X_AXIS:
//BFS03			nOff=nOffX;
//BFS03			rDestSet.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_AUTO_MIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_X_AXIS_MIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_AUTO_MAX, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_X_AXIS_MAX));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_AUTO_STEP_MAIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_X_AXIS_STEP_MAIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_AUTO_STEP_HELP, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_X_AXIS_STEP_HELP));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_LOGARITHM, FALSE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_X_AXIS_AUTO_ORIGIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_X_AXIS_ORIGIN));
//BFS03			break;
//BFS03		case CHOBJID_DIAGRAM_Y_AXIS:
//BFS03			nOff=nOffY;
//BFS03			rDestSet.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_AUTO_MIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Y_AXIS_MIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_AUTO_MAX, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Y_AXIS_MAX));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_AUTO_STEP_MAIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Y_AXIS_STEP_MAIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_AUTO_STEP_HELP, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Y_AXIS_STEP_HELP));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_LOGARITHM, FALSE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Y_AXIS_AUTO_ORIGIN, FALSE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Y_AXIS_ORIGIN));
//BFS03			break;
//BFS03		case CHOBJID_DIAGRAM_Z_AXIS:
//BFS03			nOff=nOffZ;
//BFS03			rDestSet.Put(SvxChartTextOrderItem(CHTXTORDER_SIDEBYSIDE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_AUTO_MIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Z_AXIS_MIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_AUTO_MAX, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Z_AXIS_MAX));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_AUTO_STEP_MAIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Z_AXIS_STEP_MAIN));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_AUTO_STEP_HELP, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Z_AXIS_STEP_HELP));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_LOGARITHM, FALSE));
//BFS03			rDestSet.Put(SfxBoolItem(SCHATTR_Z_AXIS_AUTO_ORIGIN, TRUE));
//BFS03			rDestSet.Put(SvxDoubleItem(0.0, SCHATTR_Z_AXIS_ORIGIN));
//BFS03			break;
//BFS03	}
//BFS03
//BFS03	SfxWhichIter aIter(aSet);
//BFS03	USHORT       nWhich = aIter.FirstWhich();
//BFS03
//BFS03	while(nWhich)
//BFS03	{
//BFS03		switch(nWhich)
//BFS03		{
//BFS03			case SCHATTR_AXIS_AUTO_MIN:
//BFS03			case SCHATTR_AXIS_AUTO_MAX:
//BFS03			case SCHATTR_AXIS_AUTO_STEP_MAIN:
//BFS03			case SCHATTR_AXIS_AUTO_STEP_HELP:
//BFS03			case SCHATTR_AXIS_LOGARITHM:
//BFS03			case SCHATTR_AXIS_AUTO_ORIGIN:
//BFS03
//BFS03				b=((const SfxBoolItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03				rDestSet.Put(SfxBoolItem(nWhich-nOff,b));
//BFS03				if(bClear)
//BFS03					rDestSet.ClearItem(nWhich);
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_AXIS_MIN:
//BFS03			case SCHATTR_AXIS_MAX:
//BFS03			case SCHATTR_AXIS_STEP_MAIN:
//BFS03			case SCHATTR_AXIS_STEP_HELP:
//BFS03			case SCHATTR_AXIS_ORIGIN:
//BFS03
//BFS03				f=((const SvxDoubleItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03				rDestSet.Put(SvxDoubleItem(f,nWhich-nOff));
//BFS03				if(bClear)
//BFS03					rDestSet.ClearItem(nWhich);
//BFS03				break;
//BFS03
//BFS03		}
//BFS03		nWhich = aIter.NextWhich();
//BFS03	}
//BFS03}
//alte in neue Achsenattr konvertieren
//BFS03void AxisAttrOld2New(SfxItemSet &rDestSet,BOOL bClear,long nId)
//BFS03{
//BFS03
//BFS03	double f;
//BFS03	BOOL b;
//BFS03	SfxItemSet aSet(rDestSet); //Kopie
//BFS03
//BFS03	SfxWhichIter aIter (aSet);
//BFS03	USHORT nWhich = aIter.FirstWhich ();
//BFS03
//BFS03	while (nWhich)
//BFS03	{
//BFS03		switch(nWhich)
//BFS03		{
//BFS03			case SCHATTR_X_AXIS_AUTO_MIN:
//BFS03			case SCHATTR_X_AXIS_AUTO_MAX:
//BFS03			case SCHATTR_X_AXIS_AUTO_STEP_MAIN:
//BFS03			case SCHATTR_X_AXIS_AUTO_STEP_HELP:
//BFS03			case SCHATTR_X_AXIS_LOGARITHM:
//BFS03			case SCHATTR_X_AXIS_AUTO_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_X_AXIS)
//BFS03				{
//BFS03					b=((const SfxBoolItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SfxBoolItem(nWhich+USHORT(nOffX),b));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_X_AXIS_MIN:
//BFS03			case SCHATTR_X_AXIS_MAX:
//BFS03			case SCHATTR_X_AXIS_STEP_MAIN:
//BFS03			case SCHATTR_X_AXIS_STEP_HELP:
//BFS03			case SCHATTR_X_AXIS_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_X_AXIS)
//BFS03				{
//BFS03					f=((const SvxDoubleItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SvxDoubleItem(f,nWhich+USHORT(nOffX)));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_Y_AXIS_AUTO_MIN:
//BFS03			case SCHATTR_Y_AXIS_AUTO_MAX:
//BFS03			case SCHATTR_Y_AXIS_AUTO_STEP_MAIN:
//BFS03			case SCHATTR_Y_AXIS_AUTO_STEP_HELP:
//BFS03			case SCHATTR_Y_AXIS_LOGARITHM:
//BFS03			case SCHATTR_Y_AXIS_AUTO_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_Y_AXIS)
//BFS03				{
//BFS03					b=((const SfxBoolItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SfxBoolItem(nWhich+USHORT(nOffY),b));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_Y_AXIS_MIN:
//BFS03			case SCHATTR_Y_AXIS_MAX:
//BFS03			case SCHATTR_Y_AXIS_STEP_MAIN:
//BFS03			case SCHATTR_Y_AXIS_STEP_HELP:
//BFS03			case SCHATTR_Y_AXIS_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_Y_AXIS)
//BFS03				{
//BFS03					f=((const SvxDoubleItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SvxDoubleItem(f,nWhich+USHORT(nOffY)));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_Z_AXIS_AUTO_MIN:
//BFS03			case SCHATTR_Z_AXIS_AUTO_MAX:
//BFS03			case SCHATTR_Z_AXIS_AUTO_STEP_MAIN:
//BFS03			case SCHATTR_Z_AXIS_AUTO_STEP_HELP:
//BFS03			case SCHATTR_Z_AXIS_LOGARITHM:
//BFS03			case SCHATTR_Z_AXIS_AUTO_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_Z_AXIS)
//BFS03				{
//BFS03					b=((const SfxBoolItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SfxBoolItem(nWhich+USHORT(nOffZ),b));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03
//BFS03			case SCHATTR_Z_AXIS_MIN:
//BFS03			case SCHATTR_Z_AXIS_MAX:
//BFS03			case SCHATTR_Z_AXIS_STEP_MAIN:
//BFS03			case SCHATTR_Z_AXIS_STEP_HELP:
//BFS03			case SCHATTR_Z_AXIS_ORIGIN:
//BFS03
//BFS03				if(nId==CHOBJID_DIAGRAM_Z_AXIS)
//BFS03				{
//BFS03					f=((const SvxDoubleItem&)rDestSet.Get(nWhich)).GetValue();
//BFS03					rDestSet.Put(SvxDoubleItem(f,nWhich+USHORT(nOffZ)));
//BFS03					if(bClear)
//BFS03						rDestSet.ClearItem(nWhich);
//BFS03				}
//BFS03				break;
//BFS03		}
//BFS03		nWhich = aIter.NextWhich();
//BFS03	}
//BFS03}

/*************************************************************************
|*
|* Pruefe zwei ItemSets und vernichte paarweise verschiedene Items
|*
\************************************************************************/

void CompareSets (const SfxItemSet &rSourceSet, SfxItemSet  &rDestSet)
{
	SfxWhichIter      aIter (rSourceSet);
	USHORT            nWhich     = aIter.FirstWhich ();
	const SfxPoolItem *pPoolItem = NULL;

	while (nWhich)
	{
		if ((rSourceSet.GetItemState(nWhich, TRUE, &pPoolItem) == SFX_ITEM_SET) &&
			(rDestSet.GetItemState(nWhich, TRUE, &pPoolItem) == SFX_ITEM_SET))
			if (rSourceSet.Get(nWhich) != rDestSet.Get(nWhich))
				rDestSet.InvalidateItem(nWhich);

		nWhich = aIter.NextWhich ();
	}
}
void ClearDblItems(const SfxItemSet &rSourceSet, SfxItemSet  &rDestSet)
{
	SfxWhichIter      aIter (rSourceSet);
	USHORT            nWhich     = aIter.FirstWhich ();
	const SfxPoolItem *pPoolItem = NULL;

	while (nWhich)
	{
		if ((rSourceSet.GetItemState(nWhich, TRUE, &pPoolItem) == SFX_ITEM_SET) &&
			(rDestSet.GetItemState(nWhich, TRUE, &pPoolItem) == SFX_ITEM_SET))
			if (rSourceSet.Get(nWhich) != rDestSet.Get(nWhich))
				rDestSet.ClearItem(nWhich);

		nWhich = aIter.NextWhich ();
	}
}

void IntersectSets( const SfxItemSet &  rSource, SfxItemSet &  rDest )
{
    SfxWhichIter aIter( rSource );
    SfxItemState aSrcState;

    for( USHORT nWhich = aIter.FirstWhich(); nWhich != 0; nWhich = aIter.NextWhich() )
    {
        aSrcState = rSource.GetItemState( nWhich );

        if( // one item is (may be) set but the other one isn't
            ( aSrcState != rDest.GetItemState( nWhich ) )
            ||
            // both items are set, but their content differs
            // (if aSrcState is set it follows that also aDestState is set)
            ( ( aSrcState == SFX_ITEM_SET )
                &&
              ( rSource.Get( nWhich ) != rDest.Get( nWhich ) ) ) )
        {
            rDest.InvalidateItem( nWhich );
        }
    }
}

/*************************************************************************
|*
|* Setze je nach Ausrichtungsinformation den Punkt um den ausgerichtet wird
|*
|* Das wird hauptsaechlich von chtmode4 aufgerufen um zu wissen welche
|* Position des Textes man sich merken muss, um dne wird dann mit moeglicherweise
|* veraenderter Schriftgroesse ausgegeben.
|*
\************************************************************************/

Point SetPointOfRectangle (const Rectangle& rRect, ChartAdjust eAdjust)
{
	switch (eAdjust)
	{
		case CHADJUST_TOP_LEFT:
			 return (rRect.TopLeft());
		case CHADJUST_TOP_RIGHT:
			 return (rRect.TopRight());
		case CHADJUST_TOP_CENTER:
			 return (rRect.TopCenter());
		case CHADJUST_CENTER_LEFT:
			 return (rRect.LeftCenter());
		case CHADJUST_CENTER_RIGHT:
			 return (rRect.RightCenter());
		case CHADJUST_CENTER_CENTER:
			 return (rRect.Center());
		case CHADJUST_BOTTOM_LEFT:
			 return (rRect.BottomLeft());
		case CHADJUST_BOTTOM_CENTER:
			 return (rRect.BottomCenter());
		case CHADJUST_BOTTOM_RIGHT:
			 return (rRect.BottomRight());
		default:
			 ;
	}
	Point aPoint(-1,-1);
	return aPoint;  // Das ist das Default fr die Plazierungsinformation von Chart-Texten
}

//!!! Es werden NICHT ALLE Attr ausgewertet, nur Gren-relevante!
void ItemsToFont(const SfxItemSet& rSet,Font& rFont)
{
	const SfxPoolItem* pItem = NULL;
	if( rSet.GetItemState( EE_CHAR_FONTINFO, TRUE, &pItem ))
	{
		SvxFontItem* pFontItem = (SvxFontItem*)pItem;

		rFont.SetStyleName(pFontItem->GetStyleName() );
		rFont.SetName(	   pFontItem->GetFamilyName());
		rFont.SetCharSet(  pFontItem->GetCharSet());
		rFont.SetFamily(   pFontItem->GetFamily());
		rFont.SetPitch(	   pFontItem->GetPitch());
	}

//	rFont.SetColor( ((const SvxColorItem&)rSet.Get( EE_CHAR_COLOR )).GetValue() );
//	rFont.SetName( ((const SvxFontItem&)rSet.Get( EE_CHAR_FONTINFO )).GetFamilyName() );
//	rFont.SetFamily( ((const SvxFontItem&)rSet.Get( EE_CHAR_FONTINFO )).GetFamily() );
//	rFont.SetPitch( ((const SvxFontItem&)rSet.Get( EE_CHAR_FONTINFO )).GetPitch() );
//	rFont.SetCharSet( ((const SvxFontItem&)rSet.Get( EE_CHAR_FONTINFO )).GetCharSet() );

	//	Scale the font's horizontal size like the vertical size.  Assume that the original size is
	//	7pt.  The scaling is done here because the item EE_CHAR_FONTWIDTH holds a horizontal scaling
	//	factor.  The horizontal size can therefore not be stored there.  But as the font is scaled 
	//	uniformly, the horizontal size depends uniquely on the vertical size.
	long nFontHeight = static_cast<const SvxFontHeightItem&>(rSet.Get(EE_CHAR_FONTHEIGHT)).GetHeight();
	const double fSevenPoint = (1000/*scale*/ * 2.54/*cm per inch*/ / 72/*point per inch*/ * 7 /*pt*/);
	long nFontWidth = 0;	// #89001# use default font width
	rFont.SetSize (Size (nFontWidth, nFontHeight));
	//	Old line.
	//	rFont.SetSize( Size( ((const SvxFontWidthItem&)rSet.Get( EE_CHAR_FONTWIDTH )).GetWidth(),
	//	 ((const SvxFontHeightItem&)rSet.Get( EE_CHAR_FONTHEIGHT )).GetHeight() ) );

	rFont.SetWeight( ((const SvxWeightItem&)rSet.Get( EE_CHAR_WEIGHT )).GetWeight() );
	rFont.SetUnderline( ((const SvxUnderlineItem&)rSet.Get( EE_CHAR_UNDERLINE )).GetUnderline() );
	rFont.SetStrikeout( ((const SvxCrossedOutItem&)rSet.Get( EE_CHAR_STRIKEOUT )).GetStrikeout() );
	rFont.SetItalic( ((const SvxPostureItem&)rSet.Get( EE_CHAR_ITALIC )).GetPosture() );
	rFont.SetOutline( ((const SvxContourItem&)rSet.Get( EE_CHAR_OUTLINE )).GetValue() );
	rFont.SetShadow( ((const SvxShadowedItem&)rSet.Get( EE_CHAR_SHADOW )).GetValue() );
	//rFont.SetEscapement( ((const SvxEscapementItem&)rSet.Get( EE_CHAR_ESCAPEMENT)).GetEsc() );
	//rFont.SetPropr( ((const SvxEscapementItem&)rSet.Get( EE_CHAR_ESCAPEMENT)).GetProp() );
	rFont.SetKerning( ((const SvxAutoKernItem&)rSet.Get( EE_CHAR_PAIRKERNING )).GetValue() );
	//rFont.SetFixKerning( ((const SvxKerningItem&)rSet.Get( EE_CHAR_KERNING )).GetValue() );
	rFont.SetWordLineMode( ((const SvxWordLineModeItem&)rSet.Get( EE_CHAR_WLM )).GetValue() );
//	rFont.SetOrientation( (short)(rDesc.Orientation*10) );
}

void GlobalGenerate3DAttrDefaultItem( INT16 nWID, SfxItemSet& rSet )
{
	E3dDefaultAttributes a3DDefaultAttr;
//-/	SfxItemSet aSet( *rSet.GetPool(), SID_ATTR_3D_START, SID_ATTR_3D_END );
	SfxItemSet aSet( *rSet.GetPool(), SDRATTR_3D_FIRST, SDRATTR_3D_LAST);
//-/	a3DDefaultAttr.TakeDefaultValues( aSet );
	const SfxPoolItem* pItem = 0;
	SfxPoolItem *pNewItem = 0;
	SfxItemState eState = aSet.GetItemState( nWID, TRUE, &pItem );
	if( eState >= SFX_ITEM_DEFAULT && pItem )
	{
		pNewItem = pItem->Clone();
		rSet.Put( *pNewItem, nWID );
		delete pNewItem;
	}
}


#ifdef DBG_UTIL

// ==================== DEBUG SfxItemSets ====================

#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXITEMITER_HXX
#include <svtools/itemiter.hxx>
#endif

#include <cstdio>		// for snprintf
#include <cstring>		// for strncat

void Dbg_DebugItems( SfxItemSet& rSet, ChartModel* pModel, long num )
{
	SfxItemPool *pItemPool=&( pModel->GetItemPool() );

	char pBuf[ 512 ] = "";
	char pSmallBuf[ 128 ] = "";

	const USHORT* pRanges = rSet.GetRanges();
	for( long n = 0; pRanges[ n ] && n<32; n++ )
	{
		snprintf( pSmallBuf, sizeof(pSmallBuf), "[%ld; %ld] ", pRanges[ n ], pRanges[ ++n ] );
		strncat( pBuf, pSmallBuf, sizeof(pBuf) - strlen(pBuf) - 1 );
	}

	DBG_TRACE1( "SCH:ItemDBG - Ranges: %s", pBuf );

	pBuf[ 0 ] = '\0';

	long nInv = 0, nCnt = 0, nCnv = 0, nCns = 0;
	SfxItemIter aIterator( rSet );

	const SfxPoolItem* pItem;
	USHORT nWhich, nNewWhich;

	pItem = aIterator.FirstItem();
	while( pItem )
	{
		if( ! IsInvalidItem( pItem ) )
		{
			nWhich= pItem->Which();

			nCnt++;
			if( nWhich < SCHATTR_END )
				nCns++;
			if( nCnt < 100 )
			{
				snprintf( pSmallBuf, sizeof(pSmallBuf), "%ld, ", nWhich );
				strncat( pBuf, pSmallBuf, sizeof(pBuf) - strlen(pBuf) - 1 );
			}

			nNewWhich = pItemPool->GetWhich( nWhich );
			if( nWhich != nNewWhich )
				nCnv++;
		}
		else
			nInv++;

		pItem = aIterator.NextItem();
	}

	DBG_TRACE1( "SCH:ItemDBG - List: %s", pBuf );

	long nColor = -1;
	long nMat = -1;
	const SfxPoolItem *pPoolItem;

	if( SFX_ITEM_SET == rSet.GetItemState(XATTR_FILLCOLOR,TRUE,&pPoolItem ) )
	{
		Color aColor( ( ( const XFillColorItem* ) pPoolItem )->GetValue() );
		nColor=aColor.GetRGBColor();
	}
//-/	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_3D_MAT_COLOR, TRUE, &pPoolItem ) )
	if( SFX_ITEM_SET == rSet.GetItemState( SDRATTR_3DOBJ_MAT_COLOR, TRUE, &pPoolItem ) )
	{
		Color aNew(  ((const SvxColorItem*) pPoolItem )->GetValue()   );
		nMat=aNew.GetRGBColor();
	}

	
	long r=COLORDATA_RED(nColor),g=COLORDATA_GREEN(nColor),b=COLORDATA_BLUE(nColor);

	DBG_TRACE4( "SCH:ItemDBG - Info: this=%lx, #=%ld, WID-able=%ld, invalid=%ld", (long)pModel, nCnt, nCnv, nInv );
	DBG_TRACE5( "... Chart=%ld, RGB=(%d, %d, %d), Mat=%ld", nCns, r, g, b, nMat );
}

#endif


