/*************************************************************************
 *
 *  $RCSfile: dgrdata.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: kz $ $Date: 2004/10/04 18:52:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "dgrdata.hxx"
#include "dgrdata.hrc"

// for SID_DIAGRAM_DATA_WIN
#include "app.hrc"

#include "schresid.hxx"
#include "strings.hrc"
#include "memchrt.hxx"
#include "docshell.hxx"
#include "undgrdat.hxx"

#include <memory>
#include <sfx2/viewfrm.hxx>

#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_TASKPANELIST_HXX
#include <vcl/taskpanelist.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif


// definition of the ChildWindow class that is passed to the dialog
SFX_IMPL_FLOATINGWINDOW( SchDiagramDataWrapper, SID_DIAGRAM_DATA_WIN );


// ----------------------------------------
// SchDiagramDataWrapper
//
// This child window is passed to the SchDiagramDataWindow.  Its purpose is to
// track and store the window position and size (stored in Views.xml)
// ----------------------------------------

SchDiagramDataWrapper::SchDiagramDataWrapper(Window* _pParent, USHORT nId,
											 SfxBindings* pBindings,
											 SfxChildWinInfo* pInfo) :
	SfxChildWindow(_pParent, nId)
{
    SchDiagramDataWindow * pDlg = new SchDiagramDataWindow( _pParent, pBindings, this );
    // pWindow is a protected member of SfxChildWindow
	pWindow = pDlg;

	eChildAlignment = SFX_ALIGN_NOALIGNMENT;

    pDlg->Initialize( pInfo );
}

// ----------------------------------------
// SchDiagramDataWindow
// ----------------------------------------

SchDiagramDataWindow::SchDiagramDataWindow(Window* pWindow,
										   SfxBindings* pBind,
										   SfxChildWindow *pChild) :
		SfxFloatingWindow(pBind, pChild, pWindow, SchResId(FLTWIN_DIAGRAM_DATA)),

	aBrwData( this, ResId( CTL_DATA )),
	aTbxData( this, ResId( TBX_DATA )),
    pBindings( pBind ),
    maToolboxImageList( ResId( IL_DIAGRAM_DATA )),
    maToolboxImageListHighContrast( ResId( IL_HC_DIAGRAM_DATA )),
    m_pDocShell( 0 )
{
    FreeResource();

    // #b4954952# get the correct doc-shell for exchanging the data.
    if( pBind != 0 )
    {
        SfxDispatcher * pDisp = pBind->GetDispatcher();
        if( pDisp )
        {
            SfxViewFrame * pFrame = pDisp->GetFrame();
            if( pFrame )
            {
                SfxObjectShell * pShell = pFrame->GetObjectShell();
                if (pShell->ISA (SchChartDocShell))
                    m_pDocShell = static_cast< SchChartDocShell * >( pShell );
            }
        }
    }

    // set min size to current size
    SetMinOutputSizePixel( GetOutputSizePixel() );

	ApplyImageList();

	bReadOnly=FALSE;

	aTbxData.SetSizePixel( aTbxData.CalcWindowSizePixel() );
    aTbxData.SetSelectHdl( LINK( this, SchDiagramDataWindow, ToolboxHdl ));

    aBrwData.SetCursorMovedHdl( LINK( this, SchDiagramDataWindow,
                                      BrowserCursorMovedHdl));
    aBrwData.SetCellModifiedHdl( LINK( this, SchDiagramDataWindow,
                                       CellModified ));

	UpdateData();
	StartListening(*pBindings);
	GrabFocus();
    aBrwData.GrabFocus();

	aTbxData.EnableItem( TBI_DATA_TRANSFER, FALSE );

	if( m_pDocShell )
	{
		BOOL bReadOnlyData=FALSE;
		ChartModel* pModel=(ChartModel *)(&m_pDocShell->GetDoc());
		SchMemChart* pMemChart=pModel->GetChartData();
		if(pMemChart)
			bReadOnlyData=pMemChart->IsReadOnly();

		SetReadOnly(m_pDocShell->IsReadOnly()  || bReadOnlyData);
	}

    // #101228# change buttons to flat-look if set so by user
    SvtMiscOptions aMiscOptions;
    const sal_Int16 nStyle( aMiscOptions.GetToolboxStyle() );
    // react on changes
    aMiscOptions.AddListener( LINK( this, SchDiagramDataWindow, MiscHdl ) );
    aTbxData.SetOutStyle( nStyle );

    // allow travelling to toolbar with F6
    notifySystemWindow( this, & aTbxData, ::comphelper::mem_fun( & TaskPaneList::AddWindow ));
}

SchDiagramDataWindow::~SchDiagramDataWindow()
{
	EndListening(*pBindings);
    notifySystemWindow( this, & aTbxData, ::comphelper::mem_fun( & TaskPaneList::RemoveWindow ));

    OSL_TRACE( "SchDiagramDataWindow: DTOR" );
}

// react on click (or keypress) on toolbar icon
IMPL_LINK( SchDiagramDataWindow, ToolboxHdl, void *, EMPTYARG )
{
	switch( aTbxData.GetCurItemId() )
	{
		case TBI_DATA_TRANSFER:
			Transfer ();
			break;
        case TBI_DATA_INSERT_ROW:
			aBrwData.InsertRow();
			break;
        case TBI_DATA_INSERT_COL:
			aBrwData.InsertColumn();
			break;
        case TBI_DATA_DELETE_ROW:
			aBrwData.RemoveRow();
			break;
        case TBI_DATA_DELETE_COL:
			aBrwData.RemoveColumn();
			break;
        case TBI_DATA_SWAP_COL :
			aBrwData.SwapColumn ();
			break;
        case TBI_DATA_SWAP_ROW :
			aBrwData.SwapRow ();
			break;
        case TBI_DATA_SORT_COL :
			aBrwData.QuickSortCol();
            break;
        case TBI_DATA_SORT_ROW :
			aBrwData.QuickSortRow();
            break;
        case TBI_DATA_SORT_TABLE_COL :
			aBrwData.QuickSortTableCols ();
            break;
        case TBI_DATA_SORT_TABLE_ROW :
			aBrwData.QuickSortTableRows ();
            break;
    }

    if( ! bReadOnly )
		aTbxData.EnableItem( TBI_DATA_TRANSFER, aBrwData.IsDirty() );

	return 0;
}

// refresh toolbar icons according to currently selected cell in brwose box
IMPL_LINK( SchDiagramDataWindow, BrowserCursorMovedHdl, void *, EMPTYARG )
{
    if( bReadOnly )
        return 0;

	aTbxData.EnableItem( TBI_DATA_INSERT_ROW, aBrwData.MayInsertRow() );
	aTbxData.EnableItem( TBI_DATA_INSERT_COL, aBrwData.MayInsertColumn() );
	aTbxData.EnableItem( TBI_DATA_DELETE_ROW, aBrwData.MayDeleteRow() );
	aTbxData.EnableItem( TBI_DATA_DELETE_COL, aBrwData.MayDeleteColumn() );

	aTbxData.EnableItem( TBI_DATA_SWAP_COL,   aBrwData.MaySwapColumns() );
	aTbxData.EnableItem( TBI_DATA_SWAP_ROW,   aBrwData.MaySwapRows() );

	aTbxData.EnableItem( TBI_DATA_SORT_COL,       aBrwData.MaySortColumn() );
	aTbxData.EnableItem( TBI_DATA_SORT_ROW,       aBrwData.MaySortRow() );
	aTbxData.EnableItem( TBI_DATA_SORT_TABLE_COL, aBrwData.MaySortColumn() );
	aTbxData.EnableItem( TBI_DATA_SORT_TABLE_ROW, aBrwData.MaySortRow() );

    aTbxData.EnableItem( TBI_DATA_TRANSFER,   aBrwData.IsDirty() );

	return 0;
}

// disable all modifying controls
void SchDiagramDataWindow::SetReadOnly(const BOOL b)
{
	bReadOnly=b;
	if(bReadOnly)
	{
		aTbxData.EnableItem( TBI_DATA_SORT_TABLE_ROW, FALSE );
		aTbxData.EnableItem( TBI_DATA_SORT_TABLE_COL, FALSE );
		aTbxData.EnableItem( TBI_DATA_TRANSFER, FALSE );
		aTbxData.EnableItem( TBI_DATA_INSERT_ROW, FALSE );
		aTbxData.EnableItem( TBI_DATA_INSERT_COL, FALSE );
		aTbxData.EnableItem( TBI_DATA_DELETE_ROW, FALSE );
		aTbxData.EnableItem( TBI_DATA_DELETE_COL, FALSE );
		aTbxData.EnableItem( TBI_DATA_SWAP_COL, FALSE );
		aTbxData.EnableItem( TBI_DATA_SWAP_ROW, FALSE );
		aTbxData.EnableItem( TBI_DATA_SORT_COL, FALSE );
		aTbxData.EnableItem( TBI_DATA_SORT_ROW, FALSE );
	}

    aBrwData.SetReadOnly( bReadOnly );
}

IMPL_LINK( SchDiagramDataWindow, MiscHdl, void*, p )
{
   	SvtMiscOptions aMiscOptions;
    sal_Int16 nStyle( aMiscOptions.GetToolboxStyle() );

    aTbxData.SetOutStyle( nStyle );

    return 0L;
}

IMPL_LINK( SchDiagramDataWindow, CellModified, void*, EMPTYARG )
{
    aTbxData.EnableItem( TBI_DATA_TRANSFER, aBrwData.IsDirty() );
    return 0;
}

void SchDiagramDataWindow::UpdateData()
{
    DBG_ASSERT( m_pDocShell, "Invalid DocShell" );

	if( m_pDocShell )
	{
		ChartModel* pModel = NULL;
		BOOL bReadOnlyData = FALSE;

		if( m_pDocShell )
		{
			pModel = & m_pDocShell->GetDoc();

			SchMemChart* pMemChart=pModel->GetChartData();
			if( pMemChart )
				bReadOnlyData = pMemChart->IsReadOnly();
		}

		aBrwData.SetDataFromModel( pModel );
		SetReadOnly( m_pDocShell->IsReadOnly() || bReadOnlyData );
	}
}

// react on the change of the underlying document by displaying the new data
void SchDiagramDataWindow::SFX_NOTIFY(
    SfxBroadcaster& rBC,
    const TypeId& rBCType,
    const SfxHint& rHint,
    const TypeId& rHintType )
{
	if( rHint.Type() == TYPE(SfxSimpleHint) )
    {
        // note: if dynamic_cast works this should be changed
        switch( static_cast< const SfxSimpleHint & >( rHint ).GetId())
		{
			case SFX_HINT_DOCCHANGED:
				UpdateData();
				break;

			case SFX_HINT_DYING:
				break;
		}
    }
}

BOOL SchDiagramDataWindow::Close()
{
    BOOL bRet = TRUE;

    // confirm changes currently made and not saved
    aBrwData.EndEditing();

	if( aBrwData.IsDirty() )
	{
		QueryBox aSafetyQuery( this, WB_YES_NO_CANCEL | WB_DEF_YES,
							   String( SchResId( STR_DIAGRAM_DATA_SAFETY_QUERY )));
		long nQueryResult = aSafetyQuery.Execute();

		bRet = ( nQueryResult != RET_CANCEL );

		if( nQueryResult == RET_YES )
		{
			// save changes
			Transfer();
		}
	}

	if( bRet )
	{
		// close child window
		SfxBoolItem aItem( SID_DIAGRAM_DATA, FALSE );
		if( pBindings )
		{
			SfxDispatcher* pDisp = pBindings->GetDispatcher();
			if( pDisp )
				pDisp->Execute( SID_DIAGRAM_DATA, SFX_CALLMODE_ASYNCHRON, &aItem, 0L);
			else
				DBG_ERROR( "Couldn't dispatch command" );
		}
	}

	return ( bRet? SfxFloatingWindow::Close(): FALSE );
}

void SchDiagramDataWindow::Resize()
{
    SfxFloatingWindow::Resize();

    Size aSize( PixelToLogic( GetResizeOutputSizePixel(), MAP_APPFONT ));
    Size aDataSize;

    aDataSize.setWidth( aSize.getWidth() - 12 );
    aDataSize.setHeight( aSize.getHeight() - 31 );

    aBrwData.SetSizePixel( LogicToPixel( aDataSize, MAP_APPFONT ));
}

// prevent reopening dialog for a new document
void SchDiagramDataWindow::FillInfo( SfxChildWinInfo& rInfo ) const
{
	SfxFloatingWindow::FillInfo( rInfo );

	rInfo.bVisible = FALSE;
}

void SchDiagramDataWindow::Transfer()
{
    // confirm changes currently made and not saved
    aBrwData.EndEditing();

    DBG_ASSERT( m_pDocShell, "Invalid DocShell" );
    if( m_pDocShell )
	{
		const SchMemChart* pData = aBrwData.GetData();
		if( pData )
		{
            // remember old model
			ChartModel & rDoc = m_pDocShell->GetDoc();
            ::std::auto_ptr< SchModelData > apOldModelData( new SchModelData( rDoc ));

            // modify model
            rDoc.ChangeChartData( * new SchMemChart( *pData ), FALSE);

            // remember new model
            ::std::auto_ptr< SchModelData > apNewModelData( new SchModelData( rDoc ));

            // create undo-action
            SchUndoDiagramData * pUndo =
                new SchUndoDiagramData( rDoc, apOldModelData, apNewModelData );
            pUndo->SetComment( String( SchResId( STR_UNDO_DIAGRAM_DATA )));
            m_pDocShell->GetUndoManager()->AddUndoAction( pUndo );

            aBrwData.SetClean();
		}
	}
}

// sets the correct toolbar icons depending on the current mode (e.g. high contrast)
void SchDiagramDataWindow::ApplyImageList()
{
    bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );

    ImageList& rImgLst = bIsHighContrast
        ? maToolboxImageListHighContrast
        : maToolboxImageList;

    aTbxData.SetImageList( rImgLst );
}

// add/remove a window (the toolbar) to/from the global list, so that F6
// travels/no longer travels over this window.  _rMemFunc may be
// TaskPaneList::AddWindow or TaskPaneList::RemoveWindow
void SchDiagramDataWindow::notifySystemWindow(
    Window* _pWindow, Window* _pToRegister,
    ::comphelper::mem_fun1_t< TaskPaneList, Window* > _rMemFunc )
{
	OSL_ENSURE( _pWindow, "Window can not be null!" );
	Window* pParent = _pWindow->GetParent();
	while( pParent && ! pParent->IsSystemWindow() )
	{
		pParent = pParent->GetParent();
	}
	if ( pParent && pParent->IsSystemWindow())
	{
		SystemWindow* pSystemWindow = static_cast< SystemWindow* >( pParent );
		_rMemFunc( pSystemWindow->GetTaskPaneList(),( _pToRegister ));
	}
}
