/*************************************************************************
 *
 *  $RCSfile: fuarea.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/12 15:38:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include <svx/svxids.hrc>

#ifndef _SVX_TAB_AREA_HXX //autogen
<svx/tabarea.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif

#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "fuarea.hxx"

#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001
/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuArea::SchFuArea(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	BOOL bHasMarked = pView->AreObjectsMarked();

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxBindings& rBind = pViewSh->GetViewFrame()->GetBindings();

	if (!pArgs)
	{
		SfxItemSet* pNewAttr = new SfxItemSet(bHasMarked
												  ? pView->GetAttrFromMarked()
												  : pView->GetDefaultAttr());

		//CHINA001 SvxAreaTabDialog* pDlg = new SvxAreaTabDialog(&(pViewSh->GetViewFrame()->GetWindow()),
		//CHINA001 													  pNewAttr,	pDoc);
		SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
		DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
		AbstractSvxAreaTabDialog * pDlg = pFact->CreateSvxAreaTabDialog( &(pViewSh->GetViewFrame()->GetWindow()),
										pNewAttr, 
										pDoc,
										ResId(RID_SVXDLG_AREA),
										pView);
		DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*(pDlg->GetOutputItemSet()));
			pArgs = rReq.GetArgs();
			delete pDlg;
			delete pNewAttr;
		}
		else
		{
			delete pDlg;
			delete pNewAttr;

			// update object bars because attributes may have changed
			rBind.Invalidate(SID_ATTR_FILL_STYLE);
			rBind.Invalidate(SID_ATTR_FILL_COLOR);
			rBind.Invalidate(SID_ATTR_FILL_GRADIENT);
			rBind.Invalidate(SID_ATTR_FILL_HATCH);
			rBind.Invalidate(SID_ATTR_FILL_BITMAP);
			return; // early RETURN
		}
	}

	if (bHasMarked)	pView->SetAttrToMarked(*pArgs);
	else pView->SetDefaultAttr(*pArgs);

	// update object bars nad list boxes because attributes may have changed
	rBind.Invalidate(SID_ATTR_FILL_STYLE);
	rBind.Invalidate(SID_ATTR_FILL_COLOR);
	rBind.Invalidate(SID_ATTR_FILL_GRADIENT);
	rBind.Invalidate(SID_ATTR_FILL_HATCH);
	rBind.Invalidate(SID_ATTR_FILL_BITMAP);
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuArea::~SchFuArea()
{
}



