/*************************************************************************
 *
 *  $RCSfile: fuline.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/12 15:39:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SVX_TAB_LINE_HXX //autogen
#include <svx/tabline.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif

#include <svx/svxids.hrc>

#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "fuline.hxx"
#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuLine::SchFuLine(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	BOOL bHasMarked = pView->AreObjectsMarked();

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxBindings& rBind = pViewSh->GetViewFrame()->GetBindings();

	if (!pArgs)
	{
		SfxItemSet aNewAttr(pView->GetDefaultAttr());

		if (bHasMarked)	pView->MergeAttrFromMarked(aNewAttr);

		//CHINA001 SvxLineTabDialog* pDlg = new SvxLineTabDialog(&(pViewSh->GetViewFrame()->GetWindow()),
//CHINA001 													  &aNewAttr, pDoc);
		SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
		DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
		SfxAbstractTabDialog * pDlg = pFact->CreateSvxLineTabDialog( &(pViewSh->GetViewFrame()->GetWindow()),
					&aNewAttr, 
				pDoc,
				ResId(RID_SVXDLG_LINE)
				);
		DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*(pDlg->GetOutputItemSet()));
			pArgs = rReq.GetArgs();
		}
		else
		{
			delete pDlg;

			// Attribute wurden geaendert, Listboxes in Objectbars muessen aktualisiert werden
			rBind.Invalidate(SID_ATTR_LINE_STYLE);
			rBind.Invalidate(SID_ATTR_LINE_DASH);
			rBind.Invalidate(SID_ATTR_LINE_WIDTH);
			rBind.Invalidate(SID_ATTR_LINE_COLOR);
			return; // Abbruch
		}
		delete pDlg;
	}
	if (bHasMarked)	pView->SetAttrToMarked(*pArgs);
	else pView->SetDefaultAttr(*pArgs);

	// Attribute wurden geaendert, Listboxes in Objectbars muessen aktualisiert werden
	rBind.Invalidate(SID_ATTR_LINE_STYLE);
	rBind.Invalidate(SID_ATTR_LINE_DASH);
	rBind.Invalidate(SID_ATTR_LINE_WIDTH);
	rBind.Invalidate(SID_ATTR_LINE_COLOR);
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuLine::~SchFuLine()
{
}



