/*************************************************************************
 *
 *  $RCSfile: AccessibleTitledControl.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/07/13 14:29:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "AccessibleTitledControl.hxx"

#include "TitledControl.hxx"
#include "ControlContainer.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif
#include <vcl/window.hxx>
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif

using namespace ::com::sun::star::accessibility;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::rtl;

namespace sd { namespace toolpanel {

AccessibleTitledControl::AccessibleTitledControl (
    TitledControl& rControl)
    : mpControl(&rControl),
      mxStateSet (new ::utl::AccessibleStateSetHelper ())
{
    // Set some states.
    ::utl::AccessibleStateSetHelper* pStateSet = GetStateSetHelper();
    if (pStateSet != NULL)
    {
        pStateSet->AddState (AccessibleStateType::ENABLED);
        pStateSet->AddState (AccessibleStateType::SHOWING);
        pStateSet->AddState (AccessibleStateType::VISIBLE);
        pStateSet->AddState (AccessibleStateType::FOCUSABLE);
        pStateSet->AddState (AccessibleStateType::EXPANDABLE);
        if (mpControl!=NULL && mpControl->IsExpanded())
            pStateSet->AddState (AccessibleStateType::EXPANDED);
    }
}




AccessibleTitledControl::~AccessibleTitledControl (void)
{
}




void AccessibleTitledControl::Init (void)
{
    lateInit (this);
    if (mpControl != NULL)
        mpControl->AddEventListener (
            LINK(this,AccessibleTitledControl,WindowEventListener));
}




// XInterface

IMPLEMENT_FORWARD_XINTERFACE2(
    AccessibleTitledControl,
    ::comphelper::OAccessibleComponentHelper,
    AccessibleTitledControlInterfaceBase);


// XTypeProvider

IMPLEMENT_FORWARD_XTYPEPROVIDER2(
    AccessibleTitledControl,
    ::comphelper::OAccessibleComponentHelper,
    AccessibleTitledControlInterfaceBase);





sal_Int32 SAL_CALL AccessibleTitledControl::getAccessibleActionCount (void) 
    throw (RuntimeException)
{
    if (mpControl != NULL)
        return 1;
    else
        return 0;
}




sal_Bool SAL_CALL AccessibleTitledControl::doAccessibleAction (
    sal_Int32 nIndex)
    throw (IndexOutOfBoundsException, RuntimeException)
{
    if (nIndex<0 || nIndex>=getAccessibleActionCount())
        throw IndexOutOfBoundsException (
            ::rtl::OUString::createFromAscii("No action with index ")
            + ::rtl::OUString::valueOf(nIndex),
            static_cast<XWeak*>(this)
            );

    bool bIsExpanded = mpControl->IsExpanded();
    {
        ::vos::OGuard aGuard (::Application::GetSolarMutex());
        mpControl->GetParentNode()->GetControlContainer().SetExpansionState(
            mpControl, 
            ControlContainer::ES_TOGGLE);
    }
    return (bIsExpanded != mpControl->IsExpanded());
}




::rtl::OUString SAL_CALL 
    AccessibleTitledControl::getAccessibleActionDescription (sal_Int32 nIndex) 
    throw (IndexOutOfBoundsException, RuntimeException)
{
    return String::CreateFromAscii ("Toggle the expansion state");
}




Reference<XAccessibleKeyBinding> SAL_CALL 
    AccessibleTitledControl::getAccessibleActionKeyBinding (sal_Int32 nIndex) 
    throw (IndexOutOfBoundsException, RuntimeException)
{
    return Reference<XAccessibleKeyBinding>();
}




// XAccessible

Reference<XAccessibleContext> SAL_CALL 
    AccessibleTitledControl::getAccessibleContext (void) 
    throw (RuntimeException)
{
    // This class implements both XAccessible and XAccessibleContext.
    return Reference<XAccessibleContext>(this);
}




// XAccessibleContext

sal_Int32 SAL_CALL AccessibleTitledControl::getAccessibleChildCount (void) 
    throw (RuntimeException)
{
    sal_Int32 nCount = 0;
    if (mpControl!=NULL 
        && mpControl->GetControl()!=NULL
        && mpControl->IsExpanded())
        nCount = 1;
    return nCount;
}




Reference<XAccessible> SAL_CALL 
    AccessibleTitledControl::getAccessibleChild (sal_Int32 nIndex)
    throw (IndexOutOfBoundsException, RuntimeException)
{
    if (nIndex<0 || nIndex>=getAccessibleChildCount())
        throw IndexOutOfBoundsException (
            ::rtl::OUString::createFromAscii("No child with index ")
            + ::rtl::OUString::valueOf(nIndex),
            static_cast<XWeak*>(this));
    return mpControl->GetControl()->GetWindow()->GetAccessible();
}




Reference<XAccessible> SAL_CALL 
    AccessibleTitledControl::getAccessibleParent (void) 
    throw (RuntimeException)
{
    Reference<XAccessible> xParent;
    if (mpControl != NULL)
    {
        ::Window* pParent = mpControl->GetParent();
        if (pParent != NULL)
            xParent = pParent->GetAccessible();
    }
    return xParent;
}




sal_Int16 SAL_CALL AccessibleTitledControl::getAccessibleRole (void) 
    throw (RuntimeException)
{
    return AccessibleRole::PANEL;
}




::rtl::OUString SAL_CALL 
    AccessibleTitledControl::getAccessibleDescription (void) 
    throw (RuntimeException)
{
    return getAccessibleName();
}




::rtl::OUString SAL_CALL AccessibleTitledControl::getAccessibleName (void) 
    throw (RuntimeException)
{
    if (mpControl != NULL)
        return mpControl->GetTitle();
    else
        return ::rtl::OUString();
}




Reference<XAccessibleRelationSet> SAL_CALL 
    AccessibleTitledControl::getAccessibleRelationSet (void) 
    throw (RuntimeException)
{
    return Reference<XAccessibleRelationSet>();
}




Reference<XAccessibleStateSet> SAL_CALL 
    AccessibleTitledControl::getAccessibleStateSet (void) 
    throw (RuntimeException)
{
    ::utl::AccessibleStateSetHelper* pStateSet = NULL;

    if (mpControl == NULL)
    {
        pStateSet = new ::utl::AccessibleStateSetHelper ();
        if (pStateSet != NULL)
            pStateSet->AddState (AccessibleStateType::DEFUNC);
    }
    else
    {
        // Create a copy of the state set of the object.
        pStateSet = 
            static_cast< ::utl::AccessibleStateSetHelper*>(mxStateSet.get());
        if (pStateSet != NULL)
            pStateSet = new ::utl::AccessibleStateSetHelper (*pStateSet);
    }

    return Reference<XAccessibleStateSet>(pStateSet);
}




// XAccessibleComponent
Reference<XAccessible> SAL_CALL 
    AccessibleTitledControl::getAccessibleAtPoint (
        const ::com::sun::star::awt::Point& aPoint) 
    throw (RuntimeException)
{
    return Reference<XAccessible>();
}




void SAL_CALL AccessibleTitledControl::grabFocus (void) 
    throw (RuntimeException)
{
}




sal_Int32 SAL_CALL AccessibleTitledControl::getForeground (void) 
    throw (RuntimeException)
{
    if (mpControl!=NULL)
        return mpControl->GetTextColor().GetColor();
    else
        return Color(COL_BLACK).GetColor();
}




sal_Int32 SAL_CALL AccessibleTitledControl::getBackground (void) 
    throw (RuntimeException)
{
    if (mpControl!=NULL)
        return mpControl->GetBackground().GetColor().GetColor();
    else
        return Color(COL_WHITE).GetColor();
}




// XServiceInfo

::rtl::OUString SAL_CALL AccessibleTitledControl::getImplementationName (void)
    throw (RuntimeException)
{
	return ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
        "com.sun.star.comp.drawing.AccessibleTitledControl"));
}




sal_Bool SAL_CALL AccessibleTitledControl::supportsService (
        const ::rtl::OUString& sServiceName)
    throw (RuntimeException)
{
    ThrowIfDisposed ();
    // Iterate over all supported service names and return true if one
    // of them matches the given name.
    Sequence< ::rtl::OUString> aSupportedServices (getSupportedServiceNames());
    for (int i=0; i<aSupportedServices.getLength(); i++)
        if (sServiceName == aSupportedServices[i])
            return sal_True;
    return sal_False;
}




Sequence< ::rtl::OUString> SAL_CALL 
    AccessibleTitledControl::getSupportedServiceNames (void)
    throw (RuntimeException)
{
    ThrowIfDisposed ();

    Sequence<OUString> aServiceNames (2);
    static const OUString sAccessibleServiceName (RTL_CONSTASCII_USTRINGPARAM(
        "com.sun.star.accessibility.Accessible"));
    static const OUString sContextServiceName (RTL_CONSTASCII_USTRINGPARAM(
        "com.sun.star.accessibility.AccessibleContext"));
    aServiceNames[0] = sAccessibleServiceName;
    aServiceNames[1] = sContextServiceName;

    return aServiceNames;
}




::com::sun::star::awt::Rectangle SAL_CALL 
    AccessibleTitledControl::implGetBounds (void) 
    throw (RuntimeException)
{
    Rectangle aBBox;
    // Use single while loop with break statements to avoid deep nesting.
    do
    {
        // Get parent component.
        if (mpControl == NULL)
            break;
        aBBox = Rectangle (
            mpControl->GetPosPixel(), 
            mpControl->GetSizePixel());
        if (mpControl->GetParent() == NULL)
            break;
        Reference<XAccessible> xParent (
            mpControl->GetParent()->GetAccessible());
        if ( ! xParent.is())
            break;
        Reference<XAccessibleComponent> xParentComponent (
            xParent->getAccessibleContext(), UNO_QUERY);
        if ( ! xParentComponent.is())
            break;

        // Clip bounding box of child against that of the parent.
        ::com::sun::star::awt::Size aParentSize = xParentComponent->getSize();
        if (aBBox.Left() < 0)
            aBBox.Left() = 0;
        if (aBBox.Top() < 0)
            aBBox.Top() = 0;
        if (aBBox.GetWidth() > aParentSize.Width)
            aBBox.Right() = aParentSize.Width - aBBox.Left();
        if (aBBox.GetHeight() > aParentSize.Height)
            aBBox.Bottom() = aParentSize.Height - aBBox.Top();
    }
    while (false);

    return ::com::sun::star::awt::Rectangle (
        aBBox.Left(),
        aBBox.Top(),
        aBBox.GetWidth(),
        aBBox.GetHeight());
}




::utl::AccessibleStateSetHelper* 
    AccessibleTitledControl::GetStateSetHelper (void) const
{
    return static_cast< ::utl::AccessibleStateSetHelper*>(mxStateSet.get());
}




void AccessibleTitledControl::UpdateStates (void)
{
    // Determine the current value of the states according to the control.
    bool bVisible = false;
    bool bExpanded = false;
    if (mpControl!=NULL)
    {
        bVisible = mpControl->IsVisible();
        bExpanded = mpControl->IsExpanded();
    }

    // Set the state values at our internal state set.
    ::utl::AccessibleStateSetHelper* pSet = GetStateSetHelper();
    if (pSet!=NULL)
    {
        Any aNewValue;

        if ((pSet->contains(AccessibleStateType::VISIBLE)==TRUE) != bVisible)
        {
            if (bVisible)
                pSet->AddState (AccessibleStateType::VISIBLE);
            else
                pSet->RemoveState (AccessibleStateType::VISIBLE);

            aNewValue <<= AccessibleStateType::VISIBLE;
            NotifyAccessibleEvent(
                AccessibleEventId::STATE_CHANGED,
                aNewValue,
                Any());
        }

        if ((pSet->contains(AccessibleStateType::EXPANDED)==TRUE) != bExpanded)
        {
            if (bExpanded)
                pSet->AddState (AccessibleStateType::EXPANDED);
            else
                pSet->RemoveState (AccessibleStateType::EXPANDED);

            aNewValue <<= AccessibleStateType::EXPANDED;
            NotifyAccessibleEvent(
                AccessibleEventId::STATE_CHANGED,
                aNewValue,
                Any());
            // A change of the expansion state is accompanied by a
            // change of the child count as the actual control is
            // exported as accessible child only when the control is
            // expanded.
            NotifyAccessibleEvent(
                AccessibleEventId::INVALIDATE_ALL_CHILDREN,
                Any(),
                Any());
        }
    }
}




void AccessibleTitledControl::ThrowIfDisposed (void)
    throw (::com::sun::star::lang::DisposedException)
{
	if (rBHelper.bDisposed || rBHelper.bInDispose)
	{
        OSL_TRACE ("Calling disposed object. Throwing exception:");
        throw DisposedException (
            OUString(RTL_CONSTASCII_USTRINGPARAM(
                "object has already been disposed")),
            static_cast<XWeak*>(this));
    }
}




IMPL_LINK(AccessibleTitledControl, WindowEventListener, 
    VclSimpleEvent*, pEvent)
{
    if (pEvent!=NULL && pEvent->ISA(VclWindowEvent))
    {
        VclWindowEvent* pWindowEvent = static_cast<VclWindowEvent*>(pEvent);
        switch (pWindowEvent->GetId())
        {
            case VCLEVENT_WINDOW_CLOSE:
                mpControl = NULL;
                UpdateStates();
                break;

            case VCLEVENT_WINDOW_MOVE:
            case VCLEVENT_WINDOW_RESIZE:
                NotifyAccessibleEvent(
                    AccessibleEventId::BOUNDRECT_CHANGED,
                    Any(),
                    Any());
                // Take a change of the size as a hint that the
                // expansion state may have changed.
                UpdateStates();
				break;
        }
    }
    return 0;
}


} } // end of namespace ::sd::toolpanel
