
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <msiquery.h>
#include <string>
#include <malloc.h>
using namespace std;

/** The intend of this custom action is to determine if a particular version of
    the .NET framework is installed. MSI stops installation when no framework is
    installed and an assembly is to be installed into the global assembly cache.

    According to the document "Redistributing the .NET Framework 1.1" (msdn.microsoft.com)
    the registry key
    HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\NET Framework Setup\NDP\v1.1.4322
    can be used to determine if the version 1.1 is installed.

    Other sources suggest to check the key
    HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\.NETFramework\policy\v1.1
    and the subkey 3705

    Because we only need a framework to install the assemblies the version
    is not important to us. Therefore we will. Because there is no general key we have
    to try several version - specific keys. And the list of keys needs to be maintained.
  
 */


#define MSI_PROPERTY  "NET_FRAMEWORK_INSTALLED"
char *arVersions[] = {
    "SOFTWARE\\Microsoft\\.NETFramework\\policy\\v1.0",
    "3705",
    "SOFTWARE\\Microsoft\\.NETFramework\\policy\\v1.1",
    "4322",
    "SOFTWARE\\Microsoft\\.NETFramework\\policy\\v2.0",
    "40607",
    NULL
};


class KeyHandle
{
    HKEY key;
    KeyHandle(const KeyHandle &);
    void operator = (const KeyHandle &);
public:
    KeyHandle(): key(0) {}

    ~KeyHandle() {
        if (key)
            RegCloseKey(key);
    }

    HKEY* operator & () {
        return & key;
    }

    operator HKEY () {
        return key;
    }
    
};

extern "C" UINT __stdcall IsFrameworkInstalled(MSIHANDLE handle)
{
    bool bAvailable = false;
    int i = 0;
    while (arVersions[i] != NULL)
    {
        KeyHandle hKey;
        if (RegOpenKeyExA(HKEY_LOCAL_MACHINE, arVersions[i],
                              0, KEY_READ, &hKey) != ERROR_SUCCESS)
        {
            i += 2;
            continue;
        }

        i++;
        DWORD   dwType = 0;
        DWORD   dwLen = 0;
        //get the length for the path to office
        if (RegQueryValueExA(hKey, arVersions[i], NULL, &dwType, NULL, 
                                &dwLen) == ERROR_SUCCESS)
        {
            if (dwType == REG_SZ)
            {
                bAvailable = true;
                break;
            }
        }
        i++;
    }
    UINT err = 0;
    if (bAvailable)
    {
       err =  MsiSetProperty(handle, MSI_PROPERTY, "1");
    }
    else
    {
        err = MsiSetProperty(handle, MSI_PROPERTY, "0");
    }
    return ERROR_SUCCESS;    
}


