/*************************************************************************
 *
 *  $RCSfile: intfrm.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/09/08 15:44:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_INTFRM_HXX
#define _SFX_INTFRM_HXX

#include "viewfrm.hxx"
#include "objface.hxx"
#include "objsh.hxx"
#include "viewsh.hxx"

class SfxViewShell;
class SfxInternalWin_Impl;

//=========================================================================

struct SfxInternalFrameData_Impl

{
	Size				aMargin;
	Point				aWinPos;
	SfxScrollingMode	eScrollingMode;
	BOOL				bHasUI;
	USHORT				nViewId;
	BOOL				bHasToolSpace;

						SfxInternalFrameData_Impl( SfxScrollingMode eScroll )
						 : eScrollingMode ( eScroll )
						 , bHasUI( TRUE )
						 , nViewId( 0 )
						 , bHasToolSpace( FALSE )
						{}
};

// -----------------------------------------------------------------------

class SfxInternalFrame: public SfxViewFrame
{
	SfxInternalWin_Impl*	pWin;
	SfxViewShell*			pViewShell;

protected:

	virtual void            Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	virtual void            Activate( BOOL bUI );
	virtual void            Deactivate( BOOL bUI );
	virtual BOOL            Close();
	virtual                 ~SfxInternalFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXINTERNALFRM);

							SfxInternalFrame( Window*, SfxFrame*,
								SfxInternalFrameData_Impl*, SfxObjectShell *pDoc=NULL );

	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY );
	virtual String			UpdateTitle();

	void                    Exec_Impl(SfxRequest &);
	void                    GetState_Impl(SfxItemSet &);
	void					INetExecute_Impl(SfxRequest &);
	void					INetState_Impl(SfxItemSet &);

	virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );
	void					Resize();

#ifndef _SFXDOC_HXX
	SfxViewShell*			CreateView_Impl( USHORT, SfxInternalFrameData_Impl* );
	void					TakeFrameData_Impl( SfxInternalFrameData_Impl* );
#endif
};

#endif


